

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SimGetRCConfiguredSPs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SimGetRCConfiguredSPs.sp,v $ $Id: SimGetRCConfiguredSPs.sp,v 1.1.4.4 2020/11/17 17:43:05 tdontham Exp $";
--  +==================================================================================+
--  | Stored Proc:  SimGetRCConfiguredSPs
--  |
--  | Description: Get All Installed SPs information which has remote cache configured
--  +==================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SimGetRCConfiguredSPs')
BEGIN
	print '>>> Drop Stored Procedure: SimGetRCConfiguredSPs <<<'
	drop procedure SimGetRCConfiguredSPs
END
IF EXISTS (select * from GxQscripts where name='SimGetRCConfiguredSPs')
	delete from GxQscripts where name = 'SimGetRCConfiguredSPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimGetRCConfiguredSPs')
	delete from GXDBVersions where aliasname = 'SimGetRCConfiguredSPs'
GO
print '... Creating Procedure: SimGetRCConfiguredSPs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SimGetRCConfiguredSPs
  @i_UAClientId INTEGER
AS
  DECLARE @o_xmlText XML
IF object_id('tempdb.dbo.#AllSPOSInfo') IS NOT NULL DROP TABLE #AllSPOSInfo
CREATE TABLE #AllSPOSInfo
(
  release		INTEGER,
  build   		INTEGER,
  SPMajor  		INTEGER,
  SPMinor 		INTEGER,
  SPTransId 	INTEGER,
  RevisionId 	INTEGER,
  OSId 			INTEGER
)
DECLARE @isFailOverRCSync INT
SET @isFailOverRCSync= ISNULL((SELECT attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @i_UAClientId and attrName = 'Failover Remote cache sync' and modified = 0 ),0)
IF @isFailOverRCSync = 1
BEGIN
	INSERT INTO #AllSPOSInfo( release, build, SPMajor, SPMinor, SPTransId, RevisionId, OSId )
	SELECT DISTINCT
			psp2.release, psp2.build, psp2.SPMajor, psp2.SPMinor,
			psp2.TransactionID,psp2.RevisionID, pmc.OSId
		FROM PatchMultiCache pmc WITH(NOLOCK)
		JOIN PatchSPVersion psp WITH(NOLOCK) ON pmc.SPVersionID = psp.id
		JOIN PatchSPVersion psp2 WITH(NOLOCK) ON psp.release = psp2.Release AND psp.build = psp2.build AND psp.SPmajor = psp2.SPMajor and
				psp.SPMinor = psp2.SPMinor AND psp.TransactionID = psp2.TransactionID
		WHERE pmc.ClientId =2
	END
ELSE
BEGIN
DECLARE @tmpUAId INTEGER = (SELECT id FROM PatchUpdateAgentInfo WITH(NOLOCK) WHERE clientId = @i_UAClientId and isDeleted = 0)
IF object_id('tempdb.dbo.#tmpclientids') IS NOT NULL DROP TABLE #tmpclientids
CREATE TABLE #tmpclientids (clientId int)
IF object_id('tempdb.dbo.#clientGroupIds') IS NOT NULL DROP TABLE #clientGroupIds
CREATE TABLE #clientGroupIds (clGroupId int)
INSERT INTO #tmpclientids
SELECT DISTINCT componentnameId FROM app_clientProp WITH(NOLOCK) WHERE attrName = 'UPDATE CACHE AGENT ID' and attrVal = CONVERT(VARCHAR(64),@tmpUAId) and modified=0
INSERT INTO #clientGroupIds
SELECT DISTINCT componentId FROM APP_ComponentProp WITH(NOLOCK) WHERE propertyTypeId=1300 and componentType=8 and longVal=@tmpUAId and modified=0
INSERT INTO #tmpclientids
SELECT DISTINCT clientId
FROM APP_ClientGroupAssoc cga WITH(NOLOCK) join #clientGroupIds cg on cga.clientGroupId = cg.clGroupId
WHERE clientId NOT IN(SELECT clientId FROM #tmpclientids)
DELETE FROM  #tmpclientids WHERE clientId NOT IN(SELECT id FROM App_Client)
DELETE FROM  #tmpclientids WHERE clientId NOT IN(SELECT DISTINCT clientId FROM simInstalledPackages)
INSERT INTO #AllSPOSInfo( release, build, SPMajor, SPMinor, SPTransId, RevisionId, OSId )
SELECT DISTINCT
		psp2.release, psp2.build, psp2.SPMajor, psp2.SPMinor, max(psp2.TransactionID),max(psp2.RevisionID), p.NewUpdateOSID
	FROM PatchUpdateOS p WITH(NOLOCK)
	JOIN APP_ClientProp ap WITH(NOLOCK)  ON p.BinarySetID = ap.attrVal
	JOIN simInstalledPackages sip WITH(NOLOCK) on sip.ClientId = ap.componentNameId
	JOIN #tmpclientids cl on sip.ClientId = cl.clientId
	JOIN PatchSPVersion psp WITH(NOLOCK) ON sip.SPVersionID = psp.id
	JOIN PatchSPVersion psp2 WITH(NOLOCK) ON psp.release = psp2.Release AND psp.build = psp2.build AND psp.SPmajor = psp2.SPMajor and
			psp.SPMinor = psp2.SPMinor AND psp.TransactionID = psp2.TransactionID
	WHERE ap.attrName = 'Binary Set Id' AND ap.modified =0 AND psp2.nLTSFlag <> 2
	GROUP BY psp2.Release, psp2.build, psp2.SPMajor, psp2.SPMinor, p.NewUpdateOSID
	ORDER BY  psp2.SPMajor
END
DECLARE @outputXml xml = (
	SELECT
			(SELECT
				release AS 'spVersion/@ReleaseId',
				build AS 'spVersion/@Build',
				SPMajor AS 'spVersion/@Major',
				SPMinor AS 'spVersion/@Minor',
				Max(SPTransId) AS 'spVersion/@TransactionId',
				Max(RevisionId) AS 'spVersion/@RevisionID'
				FOR XML PATH('fullVersion'), TYPE ),
			( SELECT DISTINCT OSId AS updateOSId from #AllSPOSInfo where  SPMajor = aspv1.SPMajor and build = aspv1.build FOR XML RAW('OSId')  , type )
	FROM #AllSPOSInfo aspv1
	GROUP BY  release, build, SPMajor,SPMinor
	FOR XML PATH('verOs'),type)
SELECT @outputXml for xml raw('UpdatePatches_InstalledVerOs')
IF object_id('tempdb.dbo.#AllSPOSInfo') IS NOT NULL DROP TABLE #AllSPOSInfo
IF object_id('tempdb.dbo.#tmpclientids') IS NOT NULL DROP TABLE #tmpclientids
IF object_id('tempdb.dbo.#clientGroupIds') IS NOT NULL DROP TABLE #clientGroupIds

IF EXISTS (select * from GxQscripts where name = 'SimGetRCConfiguredSPs')
	delete from GxQscripts where name = 'SimGetRCConfiguredSPs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimGetRCConfiguredSPs')
	delete from GXDBVersions where aliasname = 'SimGetRCConfiguredSPs'
GO

insert into GXDBVersions values(2, 'SimGetRCConfiguredSPs',  '00010001000400040000', 'SimGetRCConfiguredSPs', '00010001000400040000')
GO

