

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SimGetNewOSId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SimGetNewOSId.sp,v $ $Id: SimGetNewOSId.sp,v 1.8.2.3 2018/03/22 01:40:39 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  SimGetNewOSId()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SimGetNewOSId <<<'

IF EXISTS (select * from sysobjects where name='SimGetNewOSId')
	drop procedure SimGetNewOSId
IF EXISTS (select * from GxQscripts where name='SimGetNewOSId')
	delete from GxQscripts where name = 'SimGetNewOSId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimGetNewOSId')
	delete from GXDBVersions where aliasname = 'SimGetNewOSId'
GO
print '... Creating Procedure: SimGetNewOSId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SimGetNewOSId
  @in_OSName varchar(64)
AS
  DECLARE @r_SystemOSid INTEGER;
  DECLARE @r_HardwareId INTEGER;
  DECLARE @r_OSId INTEGER;
  DECLARE @r_OSName VARCHAR(64);
  DECLARE @r_Release VARCHAR(64);
  DECLARE @r_Version VARCHAR(64);
  DECLARE @r_HardwareName VARCHAR(128);
SET NOCOUNT ON
DECLARE @o_simOSID_Result TABLE(simOSID INT)
DECLARE @OSType 	VARCHAR(64)
DECLARE @OSSubType	varchar(64)
DECLARE @platformType	varchar(64) = 'Any'
DECLARE @searchString	varchar(64)
DECLARE @nStringIndex	INT = 0
DECLARE @nTokenCount	INT = 0
DECLARE @simOSID		INT
SET @OSType = CASE WHEN (CHARINDEX(' ',@in_OSName) <> 0)
				THEN substring(@in_OSName, 0, CHARINDEX(' ',@in_OSName))
				ELSE @in_OSName END
-- Windows specific naming
IF @in_OSName like '%Windows%'
BEGIN
	IF @in_OSName like '%Server%'
		SET @OSSubType = 'Server'
	ELSE
		SET @OSSubType = 'Desktop'
	-- Find the platform type
	SET @nTokenCount	= 1
	SET @searchString	= @in_OSName
	WHILE CHARINDEX(' ',@searchString) > 0
	BEGIN
		SET @nStringIndex = CHARINDEX(' ',@searchString)
		SET @nTokenCount = @nTokenCount + 1
		SET @searchString = substring(@searchString, @nStringIndex+1, LEN(@searchString))
	END
	IF @nTokenCount > 2
	SET @platformType = @searchString
END
ELSE IF NOT EXISTS (SELECT * from simOperatingSystem WHERE Type = @OSType AND Version = 'New')
BEGIN
	-- For all other types, the name of the OS may be stored in the SubType
	SET @OSSubType = @OSType
	-- We will need to look up the parent type, e.g. Linux -> UNIX
	SET @OSType = ISNULL((SELECT TOP 1 Type from simOperatingSystem
						  WHERE SubType = @OSType AND
						  Version = 'New'), @OSType)
END
INSERT INTO @o_simOSID_Result
EXEC	[dbo].[SimGetOperatingSystemID]
		@i_OSType = @OSType,
		@i_OSSubType = @OSSubType,
		@i_OSVersion = N'New',
		@i_OSPlatformType = @platformType,
		@i_bUseApproxLogic = 1
SET @simOSID = ISNULL((SELECT TOP 1 simOSID from @o_simOSID_Result), 116)
IF @simOSID = 0 SET @simOSID = 116
SELECT	0, 0, id, name, version, platformType, ''
FROM	simOperatingSystem
WHERE	Id = @simOSID
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'SimGetNewOSId')
	delete from GxQscripts where name = 'SimGetNewOSId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimGetNewOSId')
	delete from GXDBVersions where aliasname = 'SimGetNewOSId'
GO

insert into GXDBVersions values(2, 'SimGetNewOSId',  '00010008000200030000', 'SimGetNewOSId', '00010008000200030000')
GO

