

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SimGetClientsWithAnalyticsJobs.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SimGetClientsWithAnalyticsJobs')
BEGIN
	print '>>> Drop Stored Procedure: SimGetClientsWithAnalyticsJobs <<<'
	drop procedure SimGetClientsWithAnalyticsJobs
END
IF EXISTS (select * from GxQscripts where name='SimGetClientsWithAnalyticsJobs')
	delete from GxQscripts where name = 'SimGetClientsWithAnalyticsJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimGetClientsWithAnalyticsJobs')
	delete from GXDBVersions where aliasname = 'SimGetClientsWithAnalyticsJobs'
GO
print '... Creating Procedure: SimGetClientsWithAnalyticsJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SimGetClientsWithAnalyticsJobs
  @i_UserId INT,
  @i_filterType integer = 0,
  @i_nameSearch NVARCHAR(MAX)='',
  @i_rowsReturn integer = 0
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF (@i_UserId > 0)
BEGIN
--
-- Table to be used by SP sec_getIDAObjectsForUserWithPrivacy
--
IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
BEGIN
    DROP TABLE #ClientsOutputTable
END
--
CREATE TABLE #ClientsOutputTable
(
	clientID INT,
	appTypeId INT,
	instanceId INT,
	backupsetID INT,
	subclientId INT
)
CREATE INDEX clientID_idx ON #ClientsOutputTable(clientID)
--
-- Fetch any clients even if any sub client is allowed under that client for the logged-in user
-- This behavior of inheriting permission from child also can be changed as per input in future if needed
--
EXEC sec_getIDAObjectsForUserWithPrivacy @i_UserId, 3, 31, 1, '#ClientsOutputTable', 1
-- convert @Clients table to temp table and create index to improve performance
--
-- This table contains distinct client list is used to filter clients which user has view permission
--
IF OBJECT_ID('tempdb.dbo.#AnalyticsClientList') IS NOT NULL
BEGIN
    DROP TABLE #AnalyticsClientList
END
--
-- t_flags: 1 - analytics jobs; 2 - analytics schedules at client group level; 4 - analytics schedule at client level; 8 - archive enabled; 16 - archive jobs;
CREATE TABLE #AnalyticsClientList  (
    t_id INT,
	t_flags INT,
	t_DSCLientID INT,
	t_plan VARCHAR(256),
	t_DSListSubclient VARCHAR(MAX),
	t_DSListBackupSet VARCHAR(MAX),
	t_DSFullList VARCHAR(MAX),
	t_nTurboJobID INT
);
CREATE INDEX clientId_idx ON #AnalyticsClientList(t_id)
INSERT INTO #AnalyticsClientList
SELECT componentNameID, 0, 0, '', '', '', '', -1
FROM APP_ClientProp
WHERE attrName='Indexing datasource id' and modified = 0
UNION
SELECT DIstinct A.clientID, 0, 0, '', '','', '', -1
FROM APP_SubclientProp P JOIN APP_Application A ON A.id = P.componentNameID
WHERE P.attrName='Indexing datasource id' and P.modified = 0
UNION
SELECT DIstinct A.clientID, 0, 0, '', '','', '', -1
FROM APP_BackupSetProp P JOIN APP_Application A ON A.backupset = P.componentNameID
WHERE P.attrName='Indexing datasource id' and P.modified = 0
 -- honor security configuration by removing all clients which are not in the view clients list
--
 DELETE T FROM #AnalyticsClientList T
 LEFT JOIN #ClientsOutputTable C ON C.clientID = T.t_id
 WHERE ISNULL(C.clientID,0) = 0
--get additional info
UPDate #AnalyticsClientList
SET  t_flags = t_flags | 1
FROM #AnalyticsClientList T, JMQinetixUpdateStatus JQ, JMJobStats J
WHERE T.t_id = JQ.clientId and J.subOpType = 112 AND J.jobId = JQ.jobId AND LEN(JQ.InstalledUpdates) > 0 AND JQ.InstalledUpdates <> '0'
UPDate #AnalyticsClientList
SET  t_flags = t_flags | 2
FROM APP_ClientGroupAssoc G, (	SELECT ST.value
				FROM TM_SubTask S JOIN TM_SubTaskOptions ST ON S.subTaskId = ST.subTaskId
				WHERE S.operationType =4022 AND ST.optionId = 1152211801 AND ST.value<> 0) T
WHERE t_id = ClientID and G.clientGroupID = T.value
UPDate #AnalyticsClientList
SET  t_flags = t_flags | 4
FROM TM_SubTask S
INNER JOIN TM_SubTaskOptions ST ON S.subTaskId = ST.subTaskId
CROSS APPLY (select cast(ST.value as xml)) as X(X) CROSS APPLY X.nodes('clients') as P(P)
WHERE t_id = p.value('@clientId', 'int') and S.operationType =4022 AND ST.optionId = 1810277523
-- 2) Update archive info
IF @i_filterType = 0
BEGIN
	INSERT INTO #AnalyticsClientList
	SELECT DISTINCT A.clientID, 8, 0, '', '','', '', MAX(CASE P.attrName WHEN 'First turbo job ID' THEN P.attrVal ELSE -1 END)
	FROM APP_Application A, APP_subclientProp P
	WHERE A.id = P.componentNameID AND (P.attrName = 'Turbo Mode Enable Stubbing' AND P.attrVal = '1' OR P.attrName = 'First turbo job ID') AND P.modified = 0
	GROUP BY A.clientID
	UNION
	SELECT DISTINCT A.clientID, 16, 0, '','','', '', -1
	FROM APP_application A, JMBkpStats J, (select jobID from JMJobStats where optype = 4 and suboptype = 98) T
	WHERE A.id = J.appID AND J.jobID = T.jobId AND status in (1, 3)
END
--MR243763: Exclude laptop clients (CV_STATUS_PERSONAL_WKSTN 0x1000) without valid [first turbo job id]
DELETE #AnalyticsClientList
FROM (select id from APP_Client NOLOCK where (status & 0x1000) > 0) T
WHERE t_nTurboJobID IN (0, -1) AND t_id = T.id
--
IF @i_nameSearch IS NOT NULL AND LEN(@i_nameSearch) > 0
	DELETE #AnalyticsClientList FROM APP_CLient NOLOCK
	WHERE id=t_id and name not like '%' + @i_nameSearch + '%' and net_hostname not like '%' + @i_nameSearch + '%' and displayname not like '%' + @i_nameSearch + '%'
IF @i_rowsReturn > 0 AND @i_filterType = 0
BEGIN
	DECLARE @clientsOrdered TABLE (id INT identity(1,1), t_clientId INT)
	INSERT INTO @clientsOrdered SELECT id FROM APP_Client NOLOCK WHERE id IN (SELECT t_id FROM #AnalyticsClientList) ORDER BY displayName
	DELETE #AnalyticsClientList FROM @clientsOrdered WHERE t_id = t_clientID and id > @i_rowsReturn
END
--Update plan info
UPDATE #AnalyticsClientList SET t_plan = ISNULL((select TOP 1 P.name from APP_Application A, APP_subclientProp S, APP_Plan P
				where t_id = A.clientID AND A.id = S.componentNameID AND S.attrName = 'Associated Plan' AND S.modified = 0 AND S.Attrval = P.id), '')
WHERE	(t_flags & 8) > 0
--Update DS CLientID
UPDATE #AnalyticsClientList SET t_DSCLientID = ISNULL((select attrVal from APP_ClientProp where componentNameID = t_id and attrName = 'Indexing datasource id' and modified = 0), 0)
UPDATE #AnalyticsClientList SET t_DSListSubclient = ISNULL((select distinct attrVal + ',' from APP_SubclientProp (NOLOCK) where componentNameID in (select id from app_application where clientid = t_id) and attrName = 'Indexing datasource id' and modified = 0 FOR XML PATH
('')), '')
UPDATE #AnalyticsClientList SET t_DSListBackupSet = ISNULL((select distinct attrVal + ',' from APP_BackupSetProp (NOLOCK) where componentNameID in (select backupSet from app_application where clientid = t_id)  and attrName = 'Indexing datasource id' and modified = 0 FOR XML PATH
('')), '')
UPDATE #AnalyticsClientList SET t_DSFullList = t_DSListSubclient  + t_DSListBackupSet
UPDATE #AnalyticsClientList SET t_DSFullList = t_DSFullList + cast(t_DSCLientID AS VARCHAR(32)) where t_DSCLientID > 0
-- 3) return results
IF @i_filterType = 0
SELECT (
	SELECT DISTINCT id AS '@clientId',
			name AS '@clientName',
			net_hostname AS '@hostName',
			displayname AS '@displayName',
			clientdescription AS '@description',
			(CASE WHEN t_flags & 1 = 0 THEN 0 ELSE 1 END) AS '@hasAnalyticsJobs',
			(CASE WHEN t_flags & 6 = 0 THEN 0 ELSE 1 END) AS '@hasAnalyticsSchedules',
			(CASE WHEN t_flags & 8 = 0 THEN 0 ELSE 1 END) AS '@IsArchiveEnabled',
			(CASE WHEN t_flags & 16 = 0 THEN 0 ELSE 1 END) AS '@hasArchiveJobs',
			t_DSCLientID AS '@DataSourceId', t_plan AS '@planName',
			t_DSFullList as '@DataSourceList'
	FROM APP_Client C JOIN (SELECT t_Id, t_flags=SUM(t_flags), t_DSCLientID=MAX(t_DSCLientID), t_plan=MAX(t_plan), t_DSFullList=max(t_DSFullList) FROM #AnalyticsClientList GROUP BY t_id) T ON id=T.t_id
	WHERE id > 1 ORDER BY displayname
	FOR XML PATH('archiveclientInfo'), Type
	)
	FOR XML PATH('App_GetArchivingClientsResponse')
ELSE IF @i_filterType = 1
	select (
	SELECT DISTINCT id AS '@clientId',
			name AS '@clientName',
			net_hostname AS '@hostName',
			displayname AS '@displayName',
			clientdescription AS '@description',
			t_DSCLientID AS '@DataSourceId', t_plan AS '@planName', t_DSFullList as '@DataSourceList'
	FROM APP_Client C LEFT OUTER JOIN (SELECT t_Id, t_DSCLientID, t_plan, t_DSFullList FROM #AnalyticsClientList where t_flags & 7 > 0) T ON id=T.t_id
	WHERE id > 1 AND t_Id is NULL AND NOT EXISTS (	SELECT P.id FROM APP_ClientProp P LEFT OUTER JOIN simInstalledPackages S ON  componentNameID = clientID
							WHERE C.id = componentNameID AND P.attrName = 'Virtual Server Discovered Clients' AND AttrVal = '1' AND modified = 0  AND S.id is NULL)
	ORDER BY displayname
	FOR XML PATH('archiveclientInfo'), Type
	)
	FOR XML PATH('App_GetArchivingClientsResponse')
END
IF OBJECT_ID('tempdb.dbo.#AnalyticsClientList') IS NOT NULL
BEGIN
    DROP TABLE #AnalyticsClientList
END
IF OBJECT_ID('tempdb.dbo.#ClientsOutputTable') IS NOT NULL
BEGIN
    DROP TABLE #ClientsOutputTable
END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'SimGetClientsWithAnalyticsJobs')
	delete from GxQscripts where name = 'SimGetClientsWithAnalyticsJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimGetClientsWithAnalyticsJobs')
	delete from GXDBVersions where aliasname = 'SimGetClientsWithAnalyticsJobs'
GO

insert into GXDBVersions values(2, 'SimGetClientsWithAnalyticsJobs',  '00000000000000000000', 'SimGetClientsWithAnalyticsJobs', '00000000000000000000')
GO

