

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SimGetAppTypeLicTypeByPackageId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SimGetAppTypeLicTypeByPackageId.sp,v $ $Id: SimGetAppTypeLicTypeByPackageId.sp,v 1.4.210.2 2018/03/27 09:00:03 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  SimGetAppTypeLicTypeByPackageId()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SimGetAppTypeLicTypeByPackageId <<<'

IF EXISTS (select * from sysobjects where name='SimGetAppTypeLicTypeByPackageId')
	drop procedure SimGetAppTypeLicTypeByPackageId
IF EXISTS (select * from GxQscripts where name='SimGetAppTypeLicTypeByPackageId')
	delete from GxQscripts where name = 'SimGetAppTypeLicTypeByPackageId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimGetAppTypeLicTypeByPackageId')
	delete from GXDBVersions where aliasname = 'SimGetAppTypeLicTypeByPackageId'
GO
print '... Creating Procedure: SimGetAppTypeLicTypeByPackageId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SimGetAppTypeLicTypeByPackageId
  @i_packageId INTEGER,
  @i_OSId INTEGER,
  @i_appVersion INTEGER,
  @i_bGetMultiAppTypes INTEGER
AS
  DECLARE @o_appType INTEGER;
  DECLARE @o_licType INTEGER;
SET NOCOUNT ON
DECLARE @multiAppTypeTbl	TABLE(t_package INT, t_appType INT, t_appVersion INT, t_licType INT)
DECLARE @AppTypeLicTypeTbl	TABLE(t_appType INT, t_licType INT)
DECLARE	@nRows			INT
--populate @multiAppTypeTbl
INSERT INTO @multiAppTypeTbl VALUES (154, 44,	8,	0)
INSERT INTO @multiAppTypeTbl VALUES (154, 55,	0,				0)
INSERT INTO @multiAppTypeTbl VALUES (152,	14,	8,	0)
INSERT INTO @multiAppTypeTbl VALUES (152,	54,		0,				0)
INSERT INTO @multiAppTypeTbl VALUES (151,	15,	8,	0)
INSERT INTO @multiAppTypeTbl VALUES (151,	53,		0,				0)
INSERT INTO @multiAppTypeTbl VALUES (101,		69,		0,				0)
INSERT INTO @multiAppTypeTbl VALUES (101,		78,		0,				0)
INSERT INTO @multiAppTypeTbl VALUES (1,		1001,		0,				0)
INSERT INTO @multiAppTypeTbl VALUES (1,		1045,		0,				0)
INSERT INTO @multiAppTypeTbl VALUES (1,		1084,			0,				0)
UPDATE @multiAppTypeTbl
SET	t_licType = ISNULL((select TOP 1 simLicAppType from simAppTypeLicTypeMap where appTypeId = t_appType), 0)
--query Sim PackageMap table
INSERT INTO @AppTypeLicTypeTbl
SELECT	DISTINCT apptype, licType
FROM	simPackageMap
WHERE	simPackageId = @i_packageId AND (@i_bGetMultiAppTypes > 0 OR simOSID = @i_OSId)
IF @i_bGetMultiAppTypes > 0
BEGIN
--================================
-- get all possible apptypes
INSERT INTO @AppTypeLicTypeTbl
SELECT	DISTINCT t_apptype,
	CASE WHEN t_licType = 0 THEN ISNULL((select licType from simPackageMap where apptype = t_appType AND simPackageId = t_package), 0) ELSE t_licType END
FROM	@multiAppTypeTbl
WHERE	t_package = @i_packageId OR (@i_packageId IN (1002, 1003) AND t_package = 1)
--================================
END
ELSE
BEGIN
--================================
SELECT @nRows = count(*) FROM @AppTypeLicTypeTbl
IF @nRows = 0
BEGIN
	DECLARE	@osType		VARCHAR(256)
	DECLARE	@osSubType	VARCHAR(256)
	DECLARE	@osPlatformType	VARCHAR(256)
	SELECT  @osType = type,
			@osSubType = subType,
			@osPlatformType = PlatformType
	FROM SimOperatingSystem WHERE id = @i_OSId
	INSERT INTO @AppTypeLicTypeTbl
		SELECT	DISTINCT apptype, licType
		FROM	simPackageMap
		WHERE	simPackageId = @i_packageId AND simOSID IN (	select id from simOperatingSystem
									where type = @osType AND subType = @osSubType AND Version in ('new', 'any') AND PlatformType = @osPlatformType)
	SELECT @nRows = count(*) FROM @AppTypeLicTypeTbl
	IF @nRows = 0
		INSERT INTO @AppTypeLicTypeTbl
		SELECT	DISTINCT apptype, licType
		FROM	simPackageMap
		WHERE	simPackageId = @i_packageId AND simOSID IN (	select id from simOperatingSystem
									where type = @osType AND subType = @osSubType AND Version in ('new', 'any') AND PlatformType = 'Any')
	SELECT @nRows = count(*) FROM @AppTypeLicTypeTbl
	IF @nRows = 0
		INSERT INTO @AppTypeLicTypeTbl
		SELECT	DISTINCT apptype, licType
		FROM	simPackageMap
		WHERE	simPackageId = @i_packageId AND simOSID = 0
END
IF @i_appVersion > 0
BEGIN
	UPDATE @AppTypeLicTypeTbl
SET	t_appType = (CASE @i_appVersion	WHEN 8
THEN (	CASE @i_packageId	WHEN 154	THEN 44
WHEN 152	THEN 14
WHEN 151	THEN 15
										ELSE t_appType END	)
						ELSE t_appType END	)
END
--================================
END
SELECT DISTINCT t_appType, t_licType FROM @AppTypeLicTypeTbl
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'SimGetAppTypeLicTypeByPackageId')
	delete from GxQscripts where name = 'SimGetAppTypeLicTypeByPackageId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SimGetAppTypeLicTypeByPackageId')
	delete from GXDBVersions where aliasname = 'SimGetAppTypeLicTypeByPackageId'
GO

insert into GXDBVersions values(2, 'SimGetAppTypeLicTypeByPackageId',  '00010004021000020000', 'SimGetAppTypeLicTypeByPackageId', '00010004021000020000')
GO

