

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetSubclientPruneProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   04/24/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetSubclientPruneProperty.sp,v $ $Id: SetSubclientPruneProperty.sp,v 1.1.2.2 2019/04/22 17:47:16 sbhukar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetSubclientPruneProperty')
BEGIN
	print '>>> Drop Stored Procedure: SetSubclientPruneProperty <<<'
	drop procedure SetSubclientPruneProperty
END
IF EXISTS (select * from GxQscripts where name='SetSubclientPruneProperty')
	delete from GxQscripts where name = 'SetSubclientPruneProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetSubclientPruneProperty')
	delete from GXDBVersions where aliasname = 'SetSubclientPruneProperty'
GO
print '... Creating Procedure: SetSubclientPruneProperty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetSubclientPruneProperty
  @i_xml XML,
  @i_isNewSubClient INT = 0,
  @i_subclientId INT = 0
AS
--input xml will be of IndexServerBackupsetProps
--<App_IndexServerBackupsetProps indexPruningType="0" indexRetCycle="-1" indexRetDays="-1" isPruningEnabled="1" overrideIndexPruning="1"><currentIndexServer clientId="0" clientName=""/></App_IndexServerBackupsetProps>
DECLARE @overrideIndexPruning int;
DECLARE @indexRetCycle int;
DECLARE @indexRetDays int;
DECLARE @indexPruningType int;
DECLARE @curtime INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @enablePruning_name VARCHAR(128) = 'Enable Index Pruning'
DECLARE @retCycle_name VARCHAR(128) = 'IndexPruning_DBRetentionCycle'
DECLARE @retDays_name VARCHAR(128) = 'IndexPruning_DBRetentionDays'
DECLARE @pruningType_name VARCHAR(128) = 'IndexPruning_Type'
DECLARE @isSubClientIndexEnabled INT = 0
DECLARE @bkpSetId INT = (select backupSet from app_application WITH (NOLOCK) where id = @i_subclientId)
SELECT @isSubClientIndexEnabled = dbo.isSubClientIndexEnabled(@bkpSetId)
SELECT @overrideIndexPruning = N.value(N'@overrideIndexPruning', N'int'),
@indexRetCycle = N.value(N'@indexRetCycle', N'int'),
@indexRetDays = N.value(N'@indexRetDays', N'int'),
@indexPruningType = N.value(N'@indexPruningType', N'int')
FROM @i_xml.nodes (N'App_IndexServerBackupsetProps') AS T(N);
DECLARE @temp TABLE(t_Name NVARCHAR(128),t_val INT)
IF @isSubClientIndexEnabled = 1
BEGIN
	DECLARE @insertRows INT = 0
	IF NOT EXISTS(SELECT 1 FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @i_subclientId AND attrName = @enablePruning_name) AND @i_isNewSubClient > 0
	BEGIN
		SET @insertRows = 1
		INSERT INTO @temp
		VALUES
		(@enablePruning_name,1),
		(@retCycle_name,2),
		(@retDays_name,0),
		(@pruningType_name,1)
	END
	ELSE IF @i_isNewSubClient = 0
	BEGIN
		INSERT INTO @temp
		VALUES
		(@enablePruning_name,@overrideIndexPruning),
		(@retCycle_name,@indexRetCycle),
		(@retDays_name,@indexRetDays),
		(@pruningType_name,@indexPruningType)
		DECLARE @PrevValue TABLE(t_Name NVARCHAR(128),t_val INT)
		INSERT INTO @PrevValue
		SELECT attrName, attrVal FROM APP_SubClientProp
		WHERE componentNameId = @i_subclientId AND attrName IN (@enablePruning_name, @retCycle_name, @retDays_name, @pruningType_name) AND modified = 0
		--If values are not changed we don't have to update anything.
		IF EXISTS(SELECT 1 FROM @temp A join @PrevValue B on A.t_Name = B.t_Name WHERE A.t_val <> B.t_val )
		OR NOT EXISTS(SELECT 1 FROM @PrevValue)
		BEGIN
			UPDATE APP_SubClientProp SET modified = @curtime
			WHERE componentNameId = @i_subclientId AND attrName IN (@enablePruning_name, @retCycle_name, @retDays_name, @pruningType_name)
			AND modified = 0
			IF @overrideIndexPruning = 1
				SET @insertRows = 1
		END
	END
	IF @insertRows = 1
		INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT @i_subclientId, t_Name, 7, t_val, @curtime, 0, 0
		FROM @temp
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'SetSubclientPruneProperty')
	delete from GxQscripts where name = 'SetSubclientPruneProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetSubclientPruneProperty')
	delete from GXDBVersions where aliasname = 'SetSubclientPruneProperty'
GO

insert into GXDBVersions values(2, 'SetSubclientPruneProperty',  '00010001000200020000', 'SetSubclientPruneProperty', '00010001000200020000')
GO

