

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetStoreApp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetStoreApp.sp,v $ $Id: SetStoreApp.sp,v 1.1.2.9 2019/04/24 16:46:22 hravula Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		            Procedure   : "SetStoreApp"	         	    	    |
--  |                Creates and edits Apps in App Builder                  |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetStoreApp')
BEGIN
	print '>>> Drop Stored Procedure: SetStoreApp <<<'
	drop procedure SetStoreApp
END
IF EXISTS (select * from GxQscripts where name='SetStoreApp')
	delete from GxQscripts where name = 'SetStoreApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetStoreApp')
	delete from GXDBVersions where aliasname = 'SetStoreApp'
GO
print '... Creating Procedure: SetStoreApp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetStoreApp
  @i_UserId INT = NULL,
  @i_xmlText XML
AS
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET XACT_ABORT ON
DECLARE @errorCode INT = 0
DECLARE @errorMessage NVARCHAR(MAX) = 'App saved successfully.'
DECLARE @storeReqOperation INT
DECLARE @storeUpdateMethod INT
DECLARE @isUserScheduleAdmin INT = 0
--The temp table will contain only one row
DECLARE @app TABLE
(
    id                  INT,
    name                NVARCHAR(MAX),
    description         NVARCHAR(MAX),
    guid                NVARCHAR(MAX),
    revision            NVARCHAR(MAX),
    icon                NVARCHAR(MAX),
    version             INT,
    metaData            XML,
    status              INT,
    flags               INT,
    mainComponentGuid   NVARCHAR(MAX),
    mainComponentId     INT
)
IF OBJECT_ID('tempdb..#Components') IS NOT NULL DROP TABLE #Components
CREATE TABLE #Components
(
    id              INT,
    refId           INT,
    type            INT,
    name            NVARCHAR(MAX),
    guid            NVARCHAR(MAX),
    revision        NVARCHAR(MAX),
    status          INT,
    flags           INT,
    metaData        XML,
    localRevision   NVARCHAR(MAX)
)
IF OBJECT_ID('tempdb..#RemovedComponents') IS NOT NULL DROP  TABLE #RemovedComponents
CREATE TABLE #RemovedComponents ( compId INT )
DECLARE @timeNowUnix BIGINT = dbo.getUnixTimeBig(GETDATE())
DECLARE @isNewApp INT = 0
BEGIN TRY
EXEC sec_checkPermissionOnEntity @i_UserId, '1', @isUserScheduleAdmin OUTPUT, 1, 2
    IF (@isUserScheduleAdmin = 0)
    BEGIN
        SET @errorCode = 7
        SET @errorMessage = 'The user does not have the permissions to create or edit apps.'
        GOTO ERROR_EXIT
    END
    --Request string processing and validation
    IF (SELECT @i_xmlText.exist('/App_StoreAppReq[1]/@updateMethod')) = 1
    BEGIN
        SELECT @storeUpdateMethod = @i_xmlText.value('/App_StoreAppReq[1]/@updateMethod', 'INT')
    END
    ELSE
    BEGIN
        SET @errorCode = 1
        SET @errorMessage = 'Invalid request: Update method absent.'
        GOTO ERROR_EXIT
    END
    INSERT INTO @app
    SELECT
        A.app.value('@id', 'INT'),
        ISNULL(A.app.value('@name', 'NVARCHAR(MAX)'), ''),
        ISNULL(A.app.value('@description', 'NVARCHAR(MAX)'), ''),
        ISNULL(A.app.value('metaData[1]/@guid', 'NVARCHAR(MAX)'), ''),
        ISNULL(A.app.value('metaData[1]/@revision', 'NVARCHAR(MAX)'), ''),
        A.app.value('@icon', 'NVARCHAR(MAX)'),
        ISNULL(A.app.value('@version', 'INT'), 1),
        A.app.query('metaData'),
0,
        ISNULL(A.app.value('@flags', 'INT'),0),
        A.app.value('mainComponent[1]/metaData[1]/@guid', 'NVARCHAR(MAX)'),
        A.app.value('mainComponent[1]/@id', 'INT')
    FROM @i_xmlText.nodes('/App_StoreAppReq/app') AS A(app)
    IF NOT EXISTS (SELECT TOP 1 1 FROM @app)
    BEGIN
        SET @errorCode = 2
        SET @errorMessage = 'Invalid request: App information absent.'
        GOTO ERROR_EXIT
    END
    IF ((SELECT TOP 1 guid FROM @app) = '')
    BEGIN
        SET @errorCode = 3
        SET @errorMessage = 'Invalid request: App GUID absent.'
        GOTO ERROR_EXIT
    END
    IF NOT EXISTS (SELECT TOP 1 1 FROM Store_App WHERE appGuid = (SELECT TOP 1 guid FROM @app))
        SET @isNewApp = 1
    IF EXISTS (SELECT 1 FROM Store_App A INNER JOIN @app t ON t.guid != A.appGuid AND t.name = A.name AND t.flags = A.flags) -- Flags is added to handle importing XMLs from Store which are treated as dummy apps.
    BEGIN
        SET @errorCode = 4
        SET @errorMessage = 'An app with the same name already exists.'
        GOTO ERROR_EXIT
    END
    UPDATE t
    SET version = ISNULL(A.version + 1, 1)
    FROM @app t LEFT OUTER JOIN Store_App A ON A.appGuid = t.guid
    INSERT INTO #Components
    SELECT
        NULL,
        -1,
        A.C.value('@type', 'INT'),
        A.C.value('@name', 'NVARCHAR(MAX)'),
        A.C.value('metaData[1]/@guid', 'NVARCHAR(MAX)'),
        ISNULL(A.C.value('metaData[1]/@revision', 'NVARCHAR(MAX)'), ''),
2,
        0,
        A.C.query('metaData[1]'),
        '' --localRevision
    FROM @i_xmlText.nodes('/App_StoreAppReq/app/components') AS A(C)
    IF EXISTS (SELECT * FROM #Components WHERE ISNULL(guid,'') = '')
    BEGIN
        SET @errorCode = 5
        SET @errorMessage = 'One or more components are missing the GUID.'
        GOTO ERROR_EXIT
    END
IF EXISTS (SELECT TOP 1 1 FROM #Components WHERE ISNULL(type,0) NOT BETWEEN 2 AND 7)
    BEGIN
        SET @errorCode = 6
        SET @errorMessage = 'The type of one or more components is invalid.'
        GOTO ERROR_EXIT
    END
    UPDATE tC
    SET id = C.compId
    FROM #Components tc INNER JOIN Store_Component C
    ON tc.guid = C.compGuid AND tc.type = C.compType
    --Update details of components that are already installed
    --Reports
    UPDATE C
    SET
Status = CASE WHEN R.Revision != C.Revision THEN 4 ELSE 0 END,
        refId = R.reportId,
        localRevision = R.revision
    FROM #Components C INNER JOIN App_Reports R ON R.guid = C.guid
WHERE C.type = 2 AND R.type = 0 --App_Reports.type = 0 => Standard Report
    --Workflows
    UPDATE C
    SET
Status = CASE WHEN W.revision != C.revision THEN 4 ELSE 0 END,
        refId = W.WorkflowId,
        localRevision = W.revision
    FROM #Components C INNER JOIN WF_Definition W ON W.uniqueGuid = C.guid
WHERE C.type = 3
    --Alert
    UPDATE C
    SET
Status = CASE WHEN CAST(A.xmlInfo AS XML).value('/App_AdditionalQueryDetails[1]/scriptDescription[1]/@revision', 'NVARCHAR(MAX)') != C.revision THEN 4 ELSE 0 END,
        refId = A.queryId,
        localRevision = CAST(A.xmlInfo AS XML).value('/App_AdditionalQueryDetails[1]/scriptDescription[1]/@revision', 'NVARCHAR(MAX)')
    FROM #Components C INNER JOIN NTQueryList A ON CAST(A.Guid AS NVARCHAR(MAX)) = C.guid
WHERE C.type = 4
    --QuickRunTools
    UPDATE C
    SET
Status = CASE WHEN Q.commandInfo.value('/App_ToolInfo[1]/customScriptDescription[1]/@revision', 'NVARCHAR(MAX)') != C.revision THEN 4 ELSE 0 END,
        refId = Q.id,
        localRevision = Q.commandInfo.value('/App_ToolInfo[1]/customScriptDescription[1]/@revision', 'NVARCHAR(MAX)')
    FROM #Components C INNER JOIN APP_QuickRunTools Q ON Q.commandInfo.value('/App_ToolInfo[1]/customScriptDescription[1]/@guid', 'NVARCHAR(MAX)') = C.guid
WHERE C.type = 5
    --Custom Dashboard
    UPDATE C
    SET
Status = CASE WHEN D.Revision != C.Revision THEN 4 ELSE 0 END,
        refId = D.reportId,
        localRevision = D.revision
    FROM #Components C INNER JOIN App_Reports D ON D.guid = C.guid
WHERE C.type = 6 AND D.type = 2 --App_Reports.type = 2 => Custom Dashboard
    --Datasets
    UPDATE C
    SET
Status = CASE WHEN D.Revision != C.Revision THEN 4 ELSE 0 END,
        refId = D.datasetId,
        localRevision = D.revision
    FROM #Components C INNER JOIN APP_DataSet D ON D.guid = C.guid
WHERE C.type = 7
    --Smart Client Groups
    UPDATE C
    SET
Status = CASE WHEN ISNULL(P.stringVal, '') != C.Revision THEN 4 ELSE 0 END,
        refId = CG.id,
        localRevision = ISNULL(P.stringVal, '')
    FROM #Components C INNER JOIN APP_ClientGroup CG ON CG.GUID = C.guid
LEFT OUTER JOIN APP_componentProp P ON P.componentType = 8 AND P.componentId = CG.id
WHERE C.type = 8 AND P.propertyTypeId = 3316 AND P.dataType = 1  and P.modified = 0
    --Update component flags
    UPDATE C
    SET Flags = CASE
                    WHEN SC.CompId IS NOT NULL THEN SC.Flags
WHEN C.status = 2 THEN 1
                    ELSE 0
                END
    FROM #Components C LEFT OUTER JOIN Store_Component SC ON C.id = SC.compId
    INSERT INTO #RemovedComponents
    SELECT CA.CompId
    FROM Store_AppComponentAssoc CA
        INNER JOIN @app A ON A.id = CA.appId
        LEFT OUTER JOIN #Components C ON C.id = CA.compId
        LEFT OUTER JOIN Store_AppComponentAssoc sharedComponents
            ON sharedComponents.compId = CA.compId and sharedComponents.appId != CA.appId
    WHERE C.id IS NULL AND sharedComponents.compId IS NULL
    UPDATE @app
    SET status = (SELECT MAX(status) FROM #Components)
    BEGIN TRANSACTION SetStoreAppTran
    --write to store_component table
    MERGE INTO Store_Component C
    USING #Components t
    ON C.compGuid = t.guid
    WHEN MATCHED
        THEN UPDATE SET C.CompRefId = t.refId, C.compType = t.type, revision = t.revision, modifiedTime = @timeNowUnix, compStatus = t.status, flags = t.flags --| $(STORE_APP_FLAGS_MULTIPLE_REFERENCE)
    WHEN NOT MATCHED BY TARGET
        THEN INSERT VALUES(t.refId, t.type, t.guid, t.revision, @timeNowUnix, @timeNowUnix, t.status, t.flags)
    WHEN NOT MATCHED BY SOURCE AND C.compId IN (SELECT compId FROM #RemovedComponents)
        THEN DELETE;
    UPDATE t
    SET id = compId
    FROM #Components t INNER JOIN Store_Component C ON C.compGuid = t.guid
    UPDATE A
    SET mainComponentId = C.id
    FROM @app A INNER JOIN #Components C ON A.mainComponentGuid = C.guid
    IF NOT EXISTS (SElECT top 1 1 FROM @app WHERE mainComponentId IS NOT NULL)
AND (SELECT COUNT(*) FROM #Components WHERE type = 2 AND status = 0) = 1
    UPDATE A
    SET mainComponentId = C.id
FROM @app A INNER JOIN #Components C ON C.type = 2 AND C.status = 0
    DECLARE @newAppId TABLE (newAppId INT) -- Temp table to hold the newly inserted appId
    --write to store_app table
    MERGE INTO Store_App A
    USING  @app t
    ON A.appGuid = t.guid
    WHEN MATCHED
        THEN UPDATE SET name = t.name, description = t.description, revision = t.revision, version = t.version, modifiedTime = @timeNowUnix, appStatus = t.status,
            flags = t.flags, icon = t.icon, definition = @i_xmlText.query('App_StoreAppReq[1]/app'), mainComponentId = t.mainComponentId, userId = @i_UserId
    WHEN NOT MATCHED
        THEN INSERT VALUES (t.name, t.guid, t.description, t.revision, t.version, @timeNowUnix, @timeNowUnix, @i_UserId, t.status, t.flags, t.icon, @i_xmlText.query('App_StoreAppReq[1]/app'), t.mainComponentId)
    OUTPUT inserted.appId INTO @newAppId;
    UPDATE @app
    SET id = (SELECT TOP 1 newAppId FROM @newAppId)
    MERGE INTO Store_AppComponentAssoc C
    USING #Components t
    ON C.appId = (SELECT TOP 1 id FROM @app) AND C.compId = t.id
    WHEN NOT MATCHED BY TARGET THEN
        INSERT VALUES ((SELECT TOP 1 id FROM @app), t.id)
    WHEN NOT MATCHED BY SOURCE AND C.appId = (SELECT TOP 1 id FROM @app) THEN
        DELETE;
    INSERT INTO HistoryDb..Store_AppHistory
    SELECT id, @i_UserId, revision, version, @timeNowUnix, @i_xmlText.query('App_StoreAppReq[1]/app') , @storeUpdateMethod
    FROM @app
    IF @isNewApp = 1 --Set master group as Creator
    BEGIN
DECLARE @CVAppCreatorPermissions NVARCHAR(MAX) = '231,232,233'
        DECLARE @appId INT = (SELECT TOP 1 id from @app)
EXEC sec_setCreatorForEntity @i_UserId, 0, @CVAppCreatorPermissions, @errorCode OUTPUT, @errorMessage OUTPUT, 177, @appId
        IF @errorCode != 0
            GOTO ERROR_EXIT
    END
    IF @@TRANCOUNT > 0
        COMMIT TRANSACTION SetStoreAppTran
    ELSE
    BEGIN
        SET @ErrorCode = 8
        SET @ErrorMessage = 'Something went wrong while commiting the changes to the database.'
    END
    SELECT
        A.appId AS '@id',
        A.name AS '@name',
        A.description AS '@description',
        A.icon AS '@icon',
        A.version AS '@version',
        A.flags AS '@flags',
        A.appStatus AS '@status',
        (
            SELECT C.compId AS '@id', C.compRefId AS '@refId', tc.name AS '@name', C.compType AS '@type', C.compStatus AS '@status', C.flags AS '@flags',
                (SELECT C.compGuid AS '@guid', C.revision AS '@revision', tc.localRevision AS '@format' FOR XML PATH('metaData'), TYPE)
            FROM Store_Component C INNER JOIN Store_AppComponentAssoc AC ON AC.compId = C.compId AND AC.appId = A.appId
                INNER JOIN #Components tc ON tc.id = C.compId
            FOR XML PATH('components'), TYPE
        ),
        A.definition.query('app[1]/metaData'),
        (
            SELECT C.compId AS '@id', C.compRefId AS '@refId', tc.name AS '@name', C.compType AS '@type', C.compStatus AS '@status', C.flags AS '@flags',
                (SELECT C.compGuid AS '@guid', C.revision AS '@revision' FOR XML PATH('metaData'), TYPE)
            FROM Store_Component C INNER JOIN Store_AppComponentAssoc AC ON AC.compId = C.compId AND AC.appId = A.appId
                INNER JOIN #Components tc ON tc.id = C.compId AND C.CompId = t.mainComponentId
            FOR XML PATH('mainComponent'), TYPE
        ),
        (SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage' FOR XML PATH ('msg'), TYPE)
    FROM Store_App A INNER JOIN @app t ON t.id = A.appId
    FOR XML PATH('App_StoreApp')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorMessage = ERROR_MESSAGE()
    GOTO ERROR_EXIT
END CATCH
ERROR_EXIT:
IF @@TRANCOUNT > 0
BEGIN
    IF(@ErrorCode = 0)
    BEGIN
        SET @ErrorCode = 8
        SET @ErrorMessage = 'Something went wrong while commiting the changes to the database.'
    END
    ROLLBACK TRANSACTION SetStoreAppTran
END
IF(@errorCode != 0)
    SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage' FOR XML PATH ('msg'), ROOT ('App_StoreApp')
IF OBJECT_ID('tempdb.dbo.#EditableApps') IS NOT NULL DROP TABLE #EditableApps
IF OBJECT_ID('tempdb..#Components') IS NOT NULL DROP TABLE #Components
IF OBJECT_ID('tempdb..#RemovedComponents') IS NOT NULL DROP  TABLE #RemovedComponents
GO

IF EXISTS (select * from GxQscripts where name = 'SetStoreApp')
	delete from GxQscripts where name = 'SetStoreApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetStoreApp')
	delete from GXDBVersions where aliasname = 'SetStoreApp'
GO

insert into GXDBVersions values(2, 'SetStoreApp',  '00010001000200090000', 'SetStoreApp', '00010001000200090000')
GO

