

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetSPIntegrityFlag.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetSPIntegrityFlag.sp,v $ $Id: SetSPIntegrityFlag.sp,v 1.1.2.9 2019/05/21 23:01:53 xsui Exp $";
--
--  +========================================================================+
--  | Stored Proc:  SetSPIntegrityFlag()
--  |
--  | Description: Set integrity flag for given Service Pack
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetSPIntegrityFlag')
BEGIN
	print '>>> Drop Stored Procedure: SetSPIntegrityFlag <<<'
	drop procedure SetSPIntegrityFlag
END
IF EXISTS (select * from GxQscripts where name='SetSPIntegrityFlag')
	delete from GxQscripts where name = 'SetSPIntegrityFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetSPIntegrityFlag')
	delete from GXDBVersions where aliasname = 'SetSPIntegrityFlag'
GO
print '... Creating Procedure: SetSPIntegrityFlag'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SetSPIntegrityFlag
  @inClientId integer,
  @inReleaseId integer,
  @inOSType integer,
  @inMajorVersion integer,
  @inMinorVersion integer,
  @inTransactionId integer,
  @inRevisionId integer,
  @inFriendlySPName varchar(256),
  @inSPValid integer
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @o_errorCode integer
  DECLARE @o_infoString nvarchar(255)
SET NOCOUNT ON
BEGIN TRY
	SET @o_infoString	=  ''
	SET @o_errorCode    =  0
	IF EXISTS (SELECT 1 from PatchMultiCache WHERE ReleaseID = @inReleaseId AND ClientId = @inClientId AND OSId = @inOSType)
	BEGIN
		UPDATE PatchMultiCache
		SET IsSPValid = 0
		WHERE ReleaseID = @inReleaseId AND
			ClientId = @inClientId AND
			OSId = @inOSType AND
			(@inSPValid = 0 OR HighestSP <>  dbo.GetServicePackStr(@inMajorVersion, @inMinorVersion))
	END
	ELSE
	BEGIN
		IF @inMajorVersion > 0
		BEGIN
			-- Check PatchSPVersion table for entry
			DECLARE @spVersionInfo TABLE ( id int )
			DECLARE @patchSPVersionId integer
			DECLARE @buildNum INTEGER = dbo.GetBuildNum(@inReleaseId)
			INSERT @spVersionInfo EXEC simGetSPVersionId @inReleaseId, @buildNum, @inMajorVersion, @inMinorVersion, @inTransactionId, @inRevisionId, @inFriendlySPName, 0, 0
			SELECT @patchSPVersionId = id FROM @spVersionInfo
			-- Set integrity flag in cache
			INSERT INTO PatchMultiCache (ClientId, ReleaseId, OSId, HighestSP, AddUpdates, IsSPValid, SPVersionId)
			VALUES (@inClientId, @inReleaseId, @inOSType, dbo.GetServicePackStr(@inMajorVersion, @inMinorVersion), '', @inSPValid, @patchSPVersionId)
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		set @o_errorCode = ERROR_NUMBER()
		set @o_infoString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' + 'Error Message ['
		+ERROR_MESSAGE() + '].'
END CATCH
SELECT @o_errorCode, @o_infoString
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'SetSPIntegrityFlag')
	delete from GxQscripts where name = 'SetSPIntegrityFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetSPIntegrityFlag')
	delete from GXDBVersions where aliasname = 'SetSPIntegrityFlag'
GO

insert into GXDBVersions values(2, 'SetSPIntegrityFlag',  '00010001000200090000', 'SetSPIntegrityFlag', '00010001000200090000')
GO

