

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetRetentionForAutomaticSchedule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   01/16/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetRetentionForAutomaticSchedule.sp,v $ $Id: SetRetentionForAutomaticSchedule.sp,v 1.1.2.2 2018/03/27 09:01:48 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetRetentionForAutomaticSchedule <<<'

IF EXISTS (select * from sysobjects where name='SetRetentionForAutomaticSchedule')
	drop procedure SetRetentionForAutomaticSchedule
IF EXISTS (select * from GxQscripts where name='SetRetentionForAutomaticSchedule')
	delete from GxQscripts where name = 'SetRetentionForAutomaticSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetRetentionForAutomaticSchedule')
	delete from GXDBVersions where aliasname = 'SetRetentionForAutomaticSchedule'
GO
print '... Creating Procedure: SetRetentionForAutomaticSchedule'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetRetentionForAutomaticSchedule
AS
DECLARE @attrName NVARCHAR(128) = N'ExtendedRetentionDaysForAutomaticSchedule'
DECLARE @created INT = dbo.GetUnixTime(GETDATE())
IF object_id('tempdb.dbo.#archGroupIdList') is not null
	DROP TABLE #archGroupIdList
CREATE TABLE #archGroupIdList (appId INT, archgroupcopyId INT)
CREATE CLUSTERED INDEX archGroupIdList_archgroupcopyId_Idx ON #archGroupIdList (archgroupcopyId)
INSERT INTO #archGroupIdList
SELECT A.id, C.id
FROM  APP_Application A WITH (NOLOCK)
JOIN archGroupCopy C WITH (NOLOCK) ON A.dataArchGrpID = C.archGroupId AND isSnapCopy = 0
WHERE A.subclientStatus&(2|4)  = 0 AND c.archGroupId > 1 --HIDE_UNINST, HIDE_DELETED
AND A.id NOT IN(SELECT appId FROM JMJobAction WITH(NOLOCK) WHERE action = 1 and opType = 4) --Remove the clients where backup activity is disabled
IF object_id('tempdb.dbo.#spRetentionDays') is not null
	DROP TABLE #spRetentionDays
CREATE TABLE #spRetentionDays (appId INT, retentionDays INT)
CREATE CLUSTERED INDEX spRetentionDays_appId_Idx ON #spRetentionDays (appId)
-----------------------------------
-- RetentionRule		Definition
--		2				AllFull
--		4 				WeeklyFull
--		524288			DailyFull
--		262144			HourlyFull
-----------------------------------
INSERT INTO #spRetentionDays
SELECT appId,
	CASE
		WHEN retentionRule = 262144 OR retentionRule = 524288 OR retentionRule = 4 OR retentionRule = 2 THEN 7 -- Consider minimum 7 days for anything less than 7 days
		WHEN retentionRule = 8 THEN 30
		WHEN retentionRule = 16 THEN 90
		WHEN retentionRule = 32 THEN 180
		WHEN retentionRule = 64 THEN 365
		ELSE 0 END
	FROM #archGroupIdList A LEFT JOIN
	ArchAgingRuleExtended B WITH (NOLOCK) ON A.archgroupcopyId = B.copyId
UNION
SELECT appId,
	CASE
		WHEN type = 1 THEN 30*numPeriod	--Consider cycle as 30 days
		WHEN type = 10 OR type = 3 THEN 7
		WHEN type = 2 THEN 7*numPeriod
		WHEN type = 4 AND numPeriod = 12 THEN 365 --Covers yearly
		WHEN type = 4 THEN 30*numPeriod --Covers Monthly, Quarterly, Half Yearly
		ELSE 0 END
FROM #archGroupIdList A LEFT JOIN
archSelectiveCopy B WITH (NOLOCK) ON A.archgroupcopyId = B.copyId
--If a subclient moved to new storage policy which doesn't have extended retention and previous had, we need to set the modified time
UPDATE sub SET modified = @created
FROM
APP_SubClientProp sub JOIN (SELECT appId, MAX(retentionDays) retentionDays FROM #spRetentionDays GROUP BY appId) tmp
ON tmp.appId = sub.componentNameId
WHERE attrName = @attrName AND cs_attrName = CHECKSUM(@attrName) AND modified = 0 AND retentionDays = 0
DELETE #spRetentionDays WHERE retentionDays = 0
IF object_id('tempdb.dbo.#tmpTableForDeletion') is not null
	DROP TABLE #tmpTableForDeletion
CREATE TABLE #tmpTableForDeletion (t_appId INT)
CREATE CLUSTERED INDEX tmpTableForDeletion_appId_Idx ON #tmpTableForDeletion (t_appId)
INSERT INTO #tmpTableForDeletion
SELECT tmp.appId
FROM (SELECT appId, MIN(retentionDays) retentionDays FROM #spRetentionDays GROUP BY appId) tmp
JOIN APP_SubClientProp sub WITH(NOLOCK)
ON tmp.appId = sub.componentNameId AND attrName = @attrName AND cs_attrName = CHECKSUM(@attrName) AND attrVal = CAST(retentionDays AS NVARCHAR(16)) AND modified = 0
--Remove the entries which have not changed
DELETE #spRetentionDays
FROM #tmpTableForDeletion
WHERE appId = t_appId
DROP TABLE #tmpTableForDeletion
--We should be left with subclients which have changed extended retention in spRetentionDays table
UPDATE sub SET modified = @created
FROM
APP_SubClientProp sub JOIN #spRetentionDays tmp
ON tmp.appId = sub.componentNameId
WHERE attrName = @attrName AND cs_attrName = CHECKSUM(@attrName) AND modified = 0
INSERT INTO APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
SELECT appId, @attrName, 1, retentionDays, @created, 0, 0
FROM (SELECT appId, MIN(retentionDays) retentionDays FROM #spRetentionDays GROUP BY appId) S
IF object_id('tempdb.dbo.#archGroupIdList') is not null
	DROP TABLE #archGroupIdList
IF object_id('tempdb.dbo.#spRetentionDays') is not null
	DROP TABLE #spRetentionDays
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'SetRetentionForAutomaticSchedule')
	delete from GxQscripts where name = 'SetRetentionForAutomaticSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetRetentionForAutomaticSchedule')
	delete from GXDBVersions where aliasname = 'SetRetentionForAutomaticSchedule'
GO

insert into GXDBVersions values(2, 'SetRetentionForAutomaticSchedule',  '00010001000200020000', 'SetRetentionForAutomaticSchedule', '00010001000200020000')
GO

