

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetPatchUpdateAgentInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetPatchUpdateAgentInfo.sp,v $ $Id: SetPatchUpdateAgentInfo.sp,v 1.10.84.2 2020/05/01 18:14:17 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  SetPatchUpdateAgentInfo()
--  |
--  | Description: Add/Modify/Delete  UpdateAgent Info
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetPatchUpdateAgentInfo')
BEGIN
	print '>>> Drop Stored Procedure: SetPatchUpdateAgentInfo <<<'
	drop procedure SetPatchUpdateAgentInfo
END
IF EXISTS (select * from GxQscripts where name='SetPatchUpdateAgentInfo')
	delete from GxQscripts where name = 'SetPatchUpdateAgentInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchUpdateAgentInfo')
	delete from GXDBVersions where aliasname = 'SetPatchUpdateAgentInfo'
GO
print '... Creating Procedure: SetPatchUpdateAgentInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SetPatchUpdateAgentInfo
  @inClientId integer,
  @inLocal integer,
  @inEnabled integer,
  @inAutoSync integer,
  @inCachePath varchar(2000),		
  @inUsername varchar(256),
  @inPassword varchar(256),
  @inClearExisting integer,
  @inSharePath varchar(2000)
AS
  DECLARE @rupdateCount integer;
  DECLARE @oModified integer;
DECLARE @autosync_old integer;
DECLARE @enabled_old integer;
Declare @cPath_old varchar(2000);
SET NOCOUNT ON
set @oModified=0
IF @inClearExisting=1
	Update PatchUpdateAgentInfo set [isDeleted]=1 where ClientId = @inClientId
ELSE
BEGIN
	SELECT  @autosync_old=autoSyncWithCS,@enabled_old=isEnabled,@cPath_old=cachePath FROM PatchUpdateAgentInfo PI WHERE PI.clientId=@inClientId
	IF   NOT EXISTS (SELECT * FROM PatchUpdateAgentInfo PI WHERE PI.clientId=@inClientId )
		insert into PatchUpdateAgentInfo Values(@inClientId,@inLocal,@inCachePath,@inUsername,@inPassword,@inEnabled,@inAutoSync,0,0,0,@inSharePath)
	ELSE
	begin
		UPDATE PatchUpdateAgentInfo
		 SET
		  [isLocalDrive] =@inLocal
		  ,[cachePath] =@inCachePath
		  ,[username] =@inUsername
		  ,[passwd] =@inPassword
		  ,[isEnabled] = @inEnabled
		  ,[autoSyncWithCS] = @inAutoSync
		  ,[isDeleted]=0
		  ,[SWSharePath]=@inSharePath
		   WHERE clientId=@inClientId
		SET @oModified=1
		if ((@enabled_old <> @inEnabled) OR (NOT(@cPath_old like @inCachePath)))
		BEGIN
			UPDATE PatchUpdateAgentInfo  SET inSyncWithCS =0,packageStatus=0  WHERE clientId=@inClientId
			EXEC patchCleanCacheEntries 0, @inClientId, ''
			UPDATE patchApplianceOS SET bExistInCache = 0 WHERE clientId = @inClientId
		END
	end
END
select @@rowcount,@oModified
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetPatchUpdateAgentInfo')
	delete from GxQscripts where name = 'SetPatchUpdateAgentInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchUpdateAgentInfo')
	delete from GXDBVersions where aliasname = 'SetPatchUpdateAgentInfo'
GO

insert into GXDBVersions values(2, 'SetPatchUpdateAgentInfo',  '00010010008400020000', 'SetPatchUpdateAgentInfo', '00010010008400020000')
GO

