

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetPatchUAContentConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetPatchUAContentConfig.sp,v $ $Id: SetPatchUAContentConfig.sp,v 1.6.44.5 2020/06/26 04:15:33 kvankadaru Exp $";
--  +========================================================================+
--  | Stored Proc:  SetPatchUAContentConfig()
--  |
--  | Description: Insert/update Cache content info for a given update agent
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetPatchUAContentConfig')
BEGIN
	print '>>> Drop Stored Procedure: SetPatchUAContentConfig <<<'
	drop procedure SetPatchUAContentConfig
END
IF EXISTS (select * from GxQscripts where name='SetPatchUAContentConfig')
	delete from GxQscripts where name = 'SetPatchUAContentConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchUAContentConfig')
	delete from GXDBVersions where aliasname = 'SetPatchUAContentConfig'
GO
print '... Creating Procedure: SetPatchUAContentConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetPatchUAContentConfig
  @inOperationType integer,
  @inUADetails XML,
  @inOptimalSyncupEnabled INTEGER
AS
  DECLARE @rcount integer
DECLARE @insertcount integer
DECLARE @updatecount integer
SET @rcount=0
SET @insertcount=0
SET @updatecount=0
SET NOCOUNT ON
BEGIN
DECLARE @bUseNewSync INT = 0
SELECT @bUseNewSync = value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'Patch Use New Sync'
IF @inOperationType = 1 OR @inOperationType = 2 OR @inOperationType = 4
BEGIN
	-- delete temporary table for holding xml input UA contents if present
	IF object_id('tempdb.dbo.#UA_Content_Info') IS NOT null
		DROP TABLE #UA_Content_Info
	-- operation type will be 1 for evmgrs call
    -- when this call is made, it should transfer the xml for All UA
    -- update all existing row in table
    -- insert rows newly added in xml input
    -- delete rows present in table but not in xml
	--operation type will be 2 for the syncup call
	-- update PackagesinCache column of all existing rows in the table
	-- create the table now
	CREATE TABLE #UA_Content_Info
	(
		UAClientId	integer	NOT NULL,
		ReleaseId	integer	NOT NULL,
		OSId		integer	NOT NULL,
		SyncPackages	integer	NOT NULL,
		SyncUpdates	integer	NOT NULL,
		SelectedPackageList				nvarchar(MAX)default NULL,
		PackagesInCache				nvarchar(MAX)default NULL,
		Modified	integer default 1
	)
	-- insert input xml data into the temporary table
	insert into #UA_Content_Info
		(UAClientId, ReleaseId, OSId,
		 SyncPackages, SyncUpdates,
		 SelectedPackageList,PackagesInCache)
		select
			C.value('@UAClientId','integer') as UAClientId,
			C.value('@ReleaseId','integer') as ReleaseId,
			C.value('@OSId','integer') as OSId,
			C.value('@SyncPackages','integer') as SyncPackages,
			C.value('@SyncUpdates','integer') as SyncUpdates,
			C.value('@SelectedPackageList','nvarchar(max)') as SelectedPackageList,
			C.value('@PackagesInCache','nvarchar(max)') as PackagesInCache
			from
			   @inUADetails.nodes('/EVGui_PatchUAContentConfigs/uaInfoList') T(C)
	DECLARE @csRelId INT
    SET @csRelId = (SELECT releaseId FROM  APP_Client WHERE id = 2)
IF (@inOperationType = 1 AND @bUseNewSync = 1) OR @inOperationType = 4
	BEGIN
		--only update the oses which have additional packages than packages in cache
IF  @inOperationType = 4
			UPDATE A SET A.Modified = 0
			FROM #UA_Content_Info A, PatchUAContentConfig P
			WHERE P.UAClientId = A.UAClientId AND P.ReleaseId = A.ReleaseId AND	P.OSId = A.OSId AND
				(P.SyncPackages = 1 OR NOT EXISTS(SELECT _ID FROM dbo.SplitIDs(A.SelectedPackageList)
												EXCEPT
												SELECT _ID FROM dbo.SplitIDs(P.PackagesinCache)))
		--only update oses which have additional packages than the packages configured
		ELSE
			UPDATE A SET A.Modified = 0
			FROM #UA_Content_Info A, PatchUAContentConfig P
			WHERE P.UAClientId = A.UAClientId AND P.ReleaseId = A.ReleaseId AND	P.OSId = A.OSId AND
				P.SyncPackages = A.SyncPackages AND
				NOT EXISTS(SELECT _ID FROM dbo.SplitIDs(A.SelectedPackageList)
						EXCEPT
						SELECT simPackageID FROM PatchUAPackageConfig pkgcfg
						WHERE pkgcfg.UAClientId = A.UAClientId AND pkgcfg.OSId = A.OSId)
		--delete PatchMultiCache entries if configuration is changed
		DECLARE @cacheIdList VARCHAR(MAX) = ''
		SELECT @cacheIdList = COALESCE(@cacheIdList + ',' ,'') + CAST(id AS VARCHAR(255))
		FROM PatchMultiCache PMC JOIN #UA_Content_Info UAC ON PMC.ClientId = UAC.UAClientId AND PMC.OSId = UAC.OSId AND PMC.ReleaseId = UAC.ReleaseId
		WHERE UAC.Modified = 1
		EXEC patchCleanCacheEntries 1, 0, @cacheIdList
	END
IF @inOperationType = 1
	BEGIN
		IF @bUseNewSync = 0
		BEGIN
			-- old sync code goest here
			DELETE FROM PatchUAContentConfig WHERE UAClientId in (SELECT UAClientId FROM #UA_Content_Info) and ReleaseId != @csRelId
			IF @inOptimalSyncupEnabled <> 0
			BEGIN
				--set the Modified to 0 if it is same with the present configuration which is in PatchUAContentConfig
				UPDATE A SET
					A.Modified = 0
					FROM #UA_Content_Info A, PatchUAContentConfig P
					WHERE P.UAClientId = A.UAClientId AND P.ReleaseId = A.ReleaseId AND	P.OSId = A.OSId AND
					P.SyncPackages = A.SyncPackages AND P.SelectedPackageList = A.SelectedPackageList
			END
			UPDATE P SET
				P.SyncPackages = A.SyncPackages,P.SelectedPackageList = A.SelectedPackageList
				FROM PatchUAContentConfig P
				JOIN #UA_Content_Info A
				ON P.UAClientId = A.UAClientId AND
				P.ReleaseId = A.ReleaseId AND
				P.OSId = A.OSId
			SET @updatecount=@@rowcount
			INSERT INTO PatchUAContentConfig (UAClientId, ReleaseId, OSId, SyncPackages, SyncUpdates,
							  SelectedPackageList,PackagesInCache)
			SELECT A.UAClientId, A.ReleaseId, A.OSId, A.SyncPackages, A.SyncUpdates,
				   A.SelectedPackageList, A.PackagesInCache
				FROM #UA_Content_Info A
			WHERE NOT EXISTS (SELECT UAClientId FROM PatchUAContentConfig P WHERE P.UAClientId =A.UAClientId AND
								P.ReleaseId = A.ReleaseId AND
								P.OSId = A.OSId)
			SET @insertcount=@@rowcount
			SET @rcount= @insertcount + @updatecount
			IF @inOptimalSyncupEnabled <> 0
			BEGIN
				--set the cache status to invalid if the remote cache configuration is changed
				UPDATE PatchUpdateAgentInfo SET inSyncWithCS =0,packageStatus=0
					WHERE clientId IN(SELECT distinct UAClientId FROM #UA_Content_Info WHERE Modified=1)
			END
		END
		ELSE
		BEGIN
		-- new sync code starts here
		-- Always delete and repopulate entries
		DELETE FROM PatchUAContentConfig WHERE UAClientId in (SELECT UAClientId FROM #UA_Content_Info)
		DELETE FROM PatchUAPackageConfig WHERE UAClientId IN (SELECT UAClientId FROM #UA_Content_Info)
		INSERT INTO PatchUAContentConfig (UAClientId, ReleaseId, OSId, SyncPackages, SyncUpdates,
							  SelectedPackageList,PackagesInCache)
			SELECT DISTINCT A.UAClientId, A.ReleaseId, A.OSId, A.SyncPackages, 0,
				   '', A.PackagesInCache
				FROM #UA_Content_Info A
		SET @insertcount=@@rowcount
		SET @rcount = @insertcount
		-- Twe can add SIM package transition logic here if needed
		INSERT INTO PatchUAPackageConfig (UAClientId, simPackageId, OSId)
			SELECT A.UAClientId, T._ID, A.OSId
			FROM #UA_Content_Info A CROSS APPLY dbo.SplitIDs(A.SelectedPackageList) T JOIN simPackage S WITH(NOLOCK) ON T._ID = S.id
		SET @insertcount=@@rowcount
		SET @rcount = @rcount + @insertcount
		END
	END
ELSE IF @inOperationType = 2
	BEGIN
		--clear the PackagesInCache column of all rows of the given remote caches
		UPDATE P SET
			P.PackagesInCache = ''
			FROM PatchUAContentConfig P
			JOIN #UA_Content_Info A
			ON P.UAClientId = A.UAClientId
		-- update existing rows in the main table
		UPDATE P SET
			P.PackagesInCache = A.PackagesInCache
			FROM PatchUAContentConfig P
			JOIN #UA_Content_Info A
			ON P.UAClientId = A.UAClientId AND
			P.ReleaseId = A.ReleaseId AND
			P.OSId = A.OSId
		SET @updatecount=@@rowcount
		SET @rcount=  @updatecount
	END
	-- delete temporary table for holding xml input UA contents if present
	DROP TABLE #UA_Content_Info
END -- END of EVMGRS call
ELSE IF @inOperationType = 3
BEGIN
	-- delete temporary table for holding xml input
	IF object_id('tempdb.dbo.#UAID_Info') IS NOT null
		DROP TABLE #UAID_Info
	-- delete all rows of existing UA (when UA is deleted from GUI)
        -- create the table now
	CREATE TABLE #UAID_Info
	(
	    UAClientId	integer	NOT NULL
	)
	-- insert input xml data into the temporary table
	insert into #UAID_Info
		(UAClientId)
		select
			C.value('@UAClientId','integer') as UAClientId
			from  @inUADetails.nodes('/EVGui_PatchUAContentConfigs/uaInfoList') T(C)
	-- Delete all the rows from table where client id present in input
	DELETE FROM PatchUAContentConfig WHERE UAClientId in (SELECT UAClientId FROM #UAID_Info)
	IF @bUseNewSync <> 0
		DELETE FROM PatchUAPackageConfig WHERE UAClientId in (SELECT UAClientId FROM #UAID_Info)
	DELETE PatchCachePackageMap WHERE CacheID IN (SELECT id FROM PatchMultiCache pmc JOIN #UAID_Info uaid ON pmc.ClientId = uaid.UAClientId )
	DELETE PatchUpdatePackageMap WHERE UpdateID IN
	(	SELECT pi.id
		FROM PatchINI pi
		JOIN PatchCacheUpdateMap pcu ON pi.id = pcu.UpdateID
		JOIN PatchMultiCache pmc ON pcu.CacheID = pmc.id
		JOIN #UAID_Info uaid ON pmc.ClientId = uaid.UAClientId
	)
	DELETE PatchCacheUpdateMap
	FROM PatchCacheUpdateMap pcu
	JOIN PatchMultiCache pmc ON pcu.CacheID = pmc.id
	JOIN #UAID_Info uaid ON pmc.ClientId = uaid.UAClientId
	DELETE PatchMultiCache
	FROM PatchMultiCache pmc
	JOIN #UAID_Info uaid ON pmc.ClientId = uaid.UAClientId
	-- Delete the temporary table
        DROP TABLE #UAID_Info
END
END
SET NOCOUNT OFF
SELECT @rcount
GO

IF EXISTS (select * from GxQscripts where name = 'SetPatchUAContentConfig')
	delete from GxQscripts where name = 'SetPatchUAContentConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchUAContentConfig')
	delete from GXDBVersions where aliasname = 'SetPatchUAContentConfig'
GO

insert into GXDBVersions values(2, 'SetPatchUAContentConfig',  '00010006004400050000', 'SetPatchUAContentConfig', '00010006004400050000')
GO

