

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetPatchMultiCacheInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetPatchMultiCacheInfo.sp,v $ $Id: SetPatchMultiCacheInfo.sp,v 1.9.72.12 2020/05/01 18:14:17 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  SetPatchMultiCacheInfo()
--  |
--  | Description: Set cache info for each UpdateAgent in PatchMultiCache table
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetPatchMultiCacheInfo')
BEGIN
	print '>>> Drop Stored Procedure: SetPatchMultiCacheInfo <<<'
	drop procedure SetPatchMultiCacheInfo
END
IF EXISTS (select * from GxQscripts where name='SetPatchMultiCacheInfo')
	delete from GxQscripts where name = 'SetPatchMultiCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchMultiCacheInfo')
	delete from GXDBVersions where aliasname = 'SetPatchMultiCacheInfo'
GO
print '... Creating Procedure: SetPatchMultiCacheInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SetPatchMultiCacheInfo
  @inClientId integer,
  @inRelease integer,
  @inOSType integer,
  @inHighestSP varchar(20),
  @inAddUpdates varchar(max),		
  @inClearExisting integer,
  @inTransactionId integer=0,
  @inRevisionId integer=0,
  @inFriendlySPName varchar(256)
AS
  DECLARE @rupdateCount integer
SET NOCOUNT ON
--
	DECLARE @IsSPValid INTEGER
	set @IsSPValid=1
	DECLARE @patchSPVersionId   INTEGER = 0
	DECLARE @majorVersion INTEGER = 0
	DECLARE @minorVersion INTEGER = 0
	SELECT @majorVersion = major, @minorVersion = minor FROM dbo.GetServicePackNumbers(@inHighestSP)
	DECLARE @spVersionInfo 		TABLE (id INTEGER)
	DECLARE @buildNum 			INTEGER = dbo.GetBuildNum(@inRelease)
	IF @inClearExisting<=1
	BEGIN
		DECLARE @cacheIdList VARCHAR(MAX) = ''
		DECLARE @isListBased INTEGER = 0
		IF(@majorVersion != 0 AND @inTransactionId! = 0 AND @inRevisionId != 0 AND @buildNum != 0 )
		BEGIN
			SET @patchSPVersionId = -1
			SELECT @patchSPVersionId = id
			FROM PatchSPVersion WITH(NOLOCK)
			WHERE Release = @inRelease AND
				Build = @buildNum AND
				SPMajor = @majorVersion AND
				SPMinor = @minorVersion AND
				TransactionID = @inTransactionId AND
				RevisionID = @inRevisionId
		END
		ELSE IF(@buildNum != 0 AND @inTransactionId = 0 AND @inRevisionId = 0)
		BEGIN
			SET @isListBased = 1
			SELECT @cacheIdList = COALESCE(@cacheIdList + ',' ,'') + CAST(id AS VARCHAR(255))
			FROM PatchMultiCache PMC
			WHERE PMC.ClientId = @inClientId AND PMC.ReleaseId = @inRelease
			    AND((@majorVersion = 0)
				OR (@majorVersion > 0 AND PMC.HighestSP = @majorVersion))
		END
		EXEC patchCleanCacheEntries @isListBased, @inClientId , @cacheIdList, @inOSType, @patchSPVersionId
	END
	IF @inClearExisting>=1
	BEGIN
		-- Check PatchSPVersion table for entry
		INSERT @spVersionInfo EXEC simGetSPVersionId @inRelease, @buildNum, @majorVersion, @minorVersion, @inTransactionId, @inRevisionId, @inFriendlySPName, 0, 0
		SELECT @patchSPVersionId = id FROM @spVersionInfo
		IF NOT EXISTS (SELECT 1 FROM PatchMultiCache
					   WHERE ReleaseId=@inRelease
					   AND OSId=@inOSType
					   AND ClientId=@inClientId
					   AND SPVersionID=@patchSPVersionId)
		BEGIN
			INSERT INTO PatchMultiCache
			VALUES (@inClientId,
					@inRelease,
					@inOSType,
					@inHighestSP,
					@inAddUpdates,
					@IsSPValid,
					@patchSPVersionId)
		END
		ELSE IF @inClearExisting > 2
		BEGIN
			UPDATE PatchMultiCache
			SET addUpdates 	= 	@inAddUpdates	,
				isSPValid	=	@IsSPValid		,
				SPVersionID	=	@patchSPVersionID
			WHERE ReleaseId	=	@inRelease 	AND
				  OSId		=	@inOSType 	AND
				  ClientId	=	@inClientId
		END
	END
--
select @@rowcount
SET NOCOUNT OFF
GO


IF EXISTS (select * from GxQscripts where name = 'SetPatchMultiCacheInfo')
	delete from GxQscripts where name = 'SetPatchMultiCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchMultiCacheInfo')
	delete from GXDBVersions where aliasname = 'SetPatchMultiCacheInfo'
GO

insert into GXDBVersions values(2, 'SetPatchMultiCacheInfo',  '00010009007200120000', 'SetPatchMultiCacheInfo', '00010009007200120000')
GO

