

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetPatchINIInfoNew.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetPatchINIInfoNew.sp,v $ $Id: SetPatchINIInfoNew.sp,v 1.2.12.2 2018/03/22 03:02:35 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  SetPatchINIInfoNew()
--  |
--  | Description: Set  Update info in PatchINI
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetPatchINIInfoNew <<<'

IF EXISTS (select * from sysobjects where name='SetPatchINIInfoNew')
	drop procedure SetPatchINIInfoNew
IF EXISTS (select * from GxQscripts where name='SetPatchINIInfoNew')
	delete from GxQscripts where name = 'SetPatchINIInfoNew'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchINIInfoNew')
	delete from GXDBVersions where aliasname = 'SetPatchINIInfoNew'
GO
print '... Creating Procedure: SetPatchINIInfoNew'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SetPatchINIInfoNew
  @inRelease integer,
  @inOSType integer,
  @inXml xml
AS
  DECLARE @rows INTEGER	
SET NOCOUNT ON
IF object_id('tempdb.dbo.#TempUpdateINIInfo') IS NOT NULL DROP TABLE  #TempUpdateINIInfo
CREATE TABLE #TempUpdateINIInfo
(
 releaseId INT,
 osId	   INT,
 aliasName varchar(MAX) ,
 appTypeList varchar(MAX) ,
 hasJar int ,
 patchId bigint,
 patchName varchar(MAX),
 rebootPkgsList varchar(MAX),
 spName varchar(MAX),
 spaceReq varchar(MAX),
 flags INT
)
DECLARE @spNumber varchar(20)
DECLARE @handle INT
--From xml populate the table #TempUpdateINIInfo
EXEC sp_xml_preparedocument @handle OUTPUT, @inXml
INSERT INTO #TempUpdateINIInfo
SELECT @inRelease,@inOSType,aliasName,appTypeList,hasJar,patchId,patchName,rebootPkgsList,spName,spaceReq,flags
from OPENXML(@handle,'UpdatePatches_SetUpdateINI/patchInformation')
with
(
	aliasName varchar(MAX) '@aliasName',
	appTypeList varchar(MAX) '@appTypeList',
	hasJar int '@hasJar',
	patchId bigint '@patchId',
	patchName varchar(MAX) '@patchName',
	rebootPkgsList varchar(MAX) '@rebootPkgList',
	spName varchar(MAX) '@spName' ,
	spaceReq varchar(MAX) '@spaceReq',
	flags int '@flags'
)
-- Get the sp name from the table #TempUpdateINIInfo. This table will have two values (0 or sp number). Get the non zero sp number.
SET @spNumber = (SELECT TOP 1 spName from  #TempUpdateINIInfo where  #TempUpdateINIInfo.spName not like '0')
--Remove the duplicate entries, if the same update is present in ServicePack and loose update
delete #TempUpdateINIInfo from #TempUpdateINIInfo T1 where exists(select * from #TempUpdateINIInfo T2 where  T2.spName like @spNumber and T1.releaseId=T2.releaseId and T1.patchId=T2.patchId and T1.osId=T2.osId)
                                    and
                                    exists(select * from #TempUpdateINIInfo T2 where  T2.spName not like @spNumber and T1.releaseId=T2.releaseId and T1.patchId=T2.patchId and T1.osId=T2.osId)
                                    and
                                    spName not like @spNumber
--Step 1: Find existing updates in current SP and update SP version.
--Create distinct service pack entry
-- This table stores distinct servicepack information from PatchINI table
IF object_id('tempdb.dbo.#AU_DistinctServicepack') IS NOT null DROP TABLE #AU_DistinctServicepack
CREATE  TABLE #AU_DistinctServicepack
(
   CurServicePackString [nvarchar](255) NOT NULL,
   NewServicePackString [nvarchar](255)
)
-- select all the distinct servicepack strings which will be modified
INSERT INTO #AU_DistinctServicepack (CurServicePackString)
SELECT DISTINCT(Servicepacks) FROM PatchINI PI WITH (NOLOCK)
WHERE PI.ReleaseId=@inRelease AND PI.OSId =@inOSType
--remove entries from temp table if current SP is already present. No need to update these patches again.
DELETE FROM #AU_DistinctServicepack
WHERE @spNumber IN(SELECT _ID FROM SplitIDString(CurServicePackString))
-- Append servicepack number to the remaining rows
Update #AU_DistinctServicepack set NewServicePackString = (CurServicePackString + ',' + @spNumber)
-- Update UpdateINI table from the table #tempUpdateINIInfo only for existing entry. (ie) releaId ,osId and patchId has the entry
UPDATE patchini
SET patchini.Servicepacks = NewServicePackString
FROM PatchINI patchini inner join  #AU_DistinctServicepack on CurServicePackString = patchini.Servicepacks
where patchini.ReleaseId = @inRelease and patchini.OSId = @inOSType and PatchName in (select PatchName from #TempUpdateINIInfo where spName=@spNumber)
SET @rows = @@rowcount
--Step 2 :Insert new entry. (ie) which is not already there on PatchINI
INSERT INTO PatchINI
SELECT tempUpdate.releaseId,
	   tempUpdate.osId,
	   tempUpdate.patchName,
	   tempUpdate.patchId,
	   tempUpdate.aliasName,
	   tempUpdate.spName,
	   tempUpdate.appTypeList,
	   tempUpdate.rebootPkgsList,
	   'None',
	   'None',
	   tempUpdate.spaceReq,
	   tempUpdate.hasJar,
	   tempUpdate.flags
FROM (SELECT #TempUpdateINIInfo.osId,#TempUpdateINIInfo.releaseId,#TempUpdateINIInfo.patchName
	 FROM #TempUpdateINIInfo
	 EXCEPT
	 SELECT PatchINI.OSId,PatchINI.ReleaseId,PatchINI.PatchName
	 FROM PatchINI WITH (NOLOCK)) as temp,#TempUpdateINIInfo as tempUpdate
where tempUpdate.ReleaseId = temp.releaseId and tempUpdate.OSId = temp.osId and tempUpdate.patchName = temp.patchName
SET @rows = @@rowcount
DROP TABLE #AU_DistinctServicepack
DROP TABLE #TempUpdateINIInfo
SELECT @rows
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetPatchINIInfoNew')
	delete from GxQscripts where name = 'SetPatchINIInfoNew'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchINIInfoNew')
	delete from GXDBVersions where aliasname = 'SetPatchINIInfoNew'
GO

insert into GXDBVersions values(2, 'SetPatchINIInfoNew',  '00010002001200020000', 'SetPatchINIInfoNew', '00010002001200020000')
GO

