

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetPatchINIInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetPatchINIInfo.sp,v $ $Id: SetPatchINIInfo.sp,v 1.18.88.2 2019/02/14 11:03:16 bsingha Exp $";
--  +========================================================================+
--  | Stored Proc:  SetPatchINIInfo()
--  |
--  | Description: Set  Update info in PatchINI
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetPatchINIInfo')
BEGIN
	print '>>> Drop Stored Procedure: SetPatchINIInfo <<<'
	drop procedure SetPatchINIInfo
END
IF EXISTS (select * from GxQscripts where name='SetPatchINIInfo')
	delete from GxQscripts where name = 'SetPatchINIInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchINIInfo')
	delete from GXDBVersions where aliasname = 'SetPatchINIInfo'
GO
print '... Creating Procedure: SetPatchINIInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SetPatchINIInfo
  @inRelease integer,
  @inOSType integer,
  @inUpdateName varchar(256),
  @inPatchId integer,
  @inAliasName varchar(256),	
  @inAppTypelist varchar(2048),
  @inServicePacks varchar(256),
  @inRebootPkg varchar(256),
  @inRequires varchar(MAX),
  @inObsoletes varchar(2048),
  @inSpaceReqd integer,
  @inHasJar integer,
  @inFlags integer,
  @inOverWriteFlag integer
AS
  DECLARE @rupdateCount integer;
SET NOCOUNT ON
-- --------------------------------------------------------------------------------------------------------
-- Change Notes: Geeta, Ajay & Milind
-- We decided NOT to update the PatchINI table unconditionally when we are adding up data to this table
-- in the context of client CVD startup-update syncup thread. In this context we will add up data only if
-- the patch's servicepack info is missing from the current servicepack list for this patch.
-- When this stored procedure is called in the context of DownloadUpates/CopyToCahce then we add/update
-- records unconditionally.
-- The extra argument inOverWriteFlag controls this behavior.
-- --------------------------------------------------------------------------------------------------------
-- Delete the rows with empty patch names
DELETE FROM PatchINI WHERE PatchName=''
DECLARE  @tempSP		VARCHAR(256)
DECLARE  @inSPMajor		INT
DECLARE  @inSPMinor		INT
DECLARE @addSPInfoFlg	INT
SET @addSPInfoFlg = 0
--If it during Cvd Syncup, we should always insert the entry with SP number 0
IF @inOverWriteFlag = 0
BEGIN
	SET @inServicePacks=0
END
-- SPLIT SERVICE PACK INTO MAJOR AND MINOR VERSION
SET @tempSP = LTRIM(RTRIM(@inServicePacks))
IF (ASCII(REVERSE(@tempSP)) BETWEEN 48 AND 57 )
BEGIN
 SET @inSPMinor = 0
 SET @inSPMajor = CONVERT(INT,@tempSP)
END
ELSE
BEGIN
  SET @inSPMinor =   (CASE WHEN  ASCII(REVERSE(@tempSP)) >= 96 THEN ASCII(REVERSE(@tempSP))-96
				WHEN ASCII(REVERSE(@tempSP)) >= 65 THEN ASCII(REVERSE(@tempSP)) -64
				ELSE ASCII(REVERSE(@tempSP))  END)
  SET @inSPMajor = CONVERT(INT,SUBSTRING(@tempSP,1,LEN(@tempSP)-1))
END
IF NOT EXISTS (SELECT * FROM PatchINI PI WHERE PI.ReleaseId=@inRelease and PI.OSId=@inOSType and PI.PatchName = @inUpdateName )
	BEGIN
		insert into PatchINI Values( @inRelease,
		                             @inOSType,
									 @inUpdateName,
									 @inPatchId,
									 @inAliasName,
									 @inServicePacks,
									 @inAppTypeList,
									 @inRebootPkg,
									 @inObsoletes,
									 @inRequires,
									 @inSpaceReqd,
									 @inHasJar,
									 @inFlags)
	END
ELSE
	BEGIN
	--If already exists, update only if overwrite flag set.
	IF @inOverWriteFlag = 1
	BEGIN
	IF object_id('tempdb.dbo.#AU_UpdateInSP') IS NOT null DROP TABLE #AU_UpdateInSP
	 CREATE TABLE #AU_UpdateInSP  (
			AU_SP NVARCHAR(100),
			SPMajor INT,
			SPMinor INT
			)
	INSERT INTO #AU_UpdateInSP
	  SELECT _ID,-1,-1 FROM dbo.SplitIDString((SELECT Servicepacks FROM PatchINI
	   WHERE ReleaseId=@inRelease and OSId=@inOSType and PatchName=@inUpdateName))
	-- Now convert current list of service packs into major and minor versions
	UPDATE #AU_UpdateInSP SET SPMinor = 0, SPMajor = CONVERT(INT,AU_SP) WHERE
		LEN(AU_SP) > 0 AND SPMinor  = -1 AND  ASCII(REVERSE(AU_SP)) BETWEEN 48 AND 57
	UPDATE #AU_UpdateInSP SET
		SPMinor =   (CASE WHEN  ASCII(REVERSE(AU_SP)) >= 96 THEN ASCII(REVERSE(AU_SP))-96
				WHEN ASCII(REVERSE(AU_SP)) >= 65 THEN ASCII(REVERSE(AU_SP)) -64
				ELSE ASCII(REVERSE(AU_SP))  END),
		SPMajor = CONVERT(INT,SUBSTRING(AU_SP,1,LEN(AU_SP)-1)) WHERE LEN(AU_SP) > 0 AND SPMinor  = -1
	-- Check if the incoming SP is present in our table or not.
	IF ( NOT EXISTS (SELECT * FROM #AU_UpdateInSP WHERE SPMajor = @inSPMajor AND SPMinor = @inSPMinor ) AND @inSPMajor > 0)
	BEGIN
	   SET @addSPInfoFlg = 1
	END
	DROP TABLE #AU_UpdateInSP
	--IF (@inOverWriteFlag = 1 OR @addSPInfoFlg = 1)
	--BEGIN
	update PatchINI set PatchName=@inUpdateName,
					    AppTypeList=@inAppTypeList,
						RebootPkgList=@inRebootPkg,
						Requires=@inRequires,
						Obsoletes=@inObsoletes,
						AliasName=@inAliasName,
						SpaceRequired=@inSpaceReqd,
						HasJar=@inHasJar,
						Flags=@inFlags,
                        Servicepacks = Servicepacks +
                        (CASE @addSPInfoFlg WHEN 0 THEN ''
                        ELSE ',' + @tempSP END)
						WHERE ReleaseId=@inRelease and OSId=@inOSType and PatchName = @inUpdateName
	 END
END
	select @@rowcount
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetPatchINIInfo')
	delete from GxQscripts where name = 'SetPatchINIInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchINIInfo')
	delete from GXDBVersions where aliasname = 'SetPatchINIInfo'
GO

insert into GXDBVersions values(2, 'SetPatchINIInfo',  '00010018008800020000', 'SetPatchINIInfo', '00010018008800020000')
GO

