

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetPatchApplianceOS.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetPatchApplianceOS.sp,v $ $Id: SetPatchApplianceOS.sp,v 1.1.4.2 2020/05/01 18:14:17 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  SetPatchApplianceOS()
--  |
--  | Description: Insert/update Appliance validity for remote cache
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetPatchApplianceOS')
BEGIN
	print '>>> Drop Stored Procedure: SetPatchApplianceOS <<<'
	drop procedure SetPatchApplianceOS
END
IF EXISTS (select * from GxQscripts where name='SetPatchApplianceOS')
	delete from GxQscripts where name = 'SetPatchApplianceOS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchApplianceOS')
	delete from GXDBVersions where aliasname = 'SetPatchApplianceOS'
GO
print '... Creating Procedure: SetPatchApplianceOS'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetPatchApplianceOS
  @inClientId INTEGER,
  @inOpType INTEGER,
  @inApplianceXml XML
AS
  DECLARE @rcount integer
SET @rcount=0
SET NOCOUNT ON
IF @inOpType = 1
BEGIN
	CREATE TABLE #ApplianceStatus
	(
		mainOSType	INTEGER	,
		osName	NVARCHAR(max)
	)
	INSERT INTO #ApplianceStatus
	SELECT
		C.value('@mainOSType','integer') AS mainOSType,
		C.value('@osName','varchar(max)') AS osName
	FROM @inApplianceXml.nodes('/UpdatePatches_CVApplianceOSInfoList/ApplianceOSInfo') T(C)
	WHERE C.value('@mainOSType','integer') > 0
	MERGE PatchApplianceOS AS P
	USING #ApplianceStatus AS A
		ON (A.mainOSType = P.type AND A.osName = P.name AND P.clientId = @inClientId )
	WHEN NOT MATCHED
		THEN INSERT(type, name, bExistInCache, clientId) VALUES(A.mainOSType, A.osName, 1, @inClientId)
	WHEN MATCHED
		THEN UPDATE SET bExistInCache = 1;
	SET @rcount = @@ROWCOUNT
	DROP TABLE #ApplianceStatus
END
ELSE IF @inOpType = 2
	DELETE FROM PatchApplianceOS
	WHERE clientId = @inClientId
ELSE IF @inOpType = 3
	UPDATE patchApplianceOS SET bExistInCache = 0
	WHERE clientId = @inClientId
SET NOCOUNT OFF
SELECT @rcount
GO

IF EXISTS (select * from GxQscripts where name = 'SetPatchApplianceOS')
	delete from GxQscripts where name = 'SetPatchApplianceOS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetPatchApplianceOS')
	delete from GXDBVersions where aliasname = 'SetPatchApplianceOS'
GO

insert into GXDBVersions values(2, 'SetPatchApplianceOS',  '00010001000400020000', 'SetPatchApplianceOS', '00010001000400020000')
GO

