

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetIsInfrastructureMachineFlag.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppSetCompanyProperties()
--  | Description:  Allows for GET of company properties for provided ProviderID
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetIsInfrastructureMachineFlag.sp,v $ $Id: SetIsInfrastructureMachineFlag.sp,v 1.1.2.1 2020/12/14 15:27:16 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SetIsInfrastructureMachineFlag')
BEGIN
	print '>>> Drop Stored Procedure: SetIsInfrastructureMachineFlag <<<'
	drop procedure SetIsInfrastructureMachineFlag
END
IF EXISTS (select * from GxQscripts where name='SetIsInfrastructureMachineFlag')
	delete from GxQscripts where name = 'SetIsInfrastructureMachineFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetIsInfrastructureMachineFlag')
	delete from GXDBVersions where aliasname = 'SetIsInfrastructureMachineFlag'
GO
print '... Creating Procedure: SetIsInfrastructureMachineFlag'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SetIsInfrastructureMachineFlag
  @userId INT,
  @localeId INT,
  @clientId INT,
  @setIsInfrastructureMachine INT,
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
--setIsInfrastructureMachine - 0 Unset, 1 Set
	DECLARE @errorCode int = 0 --
	DECLARE @errorString nvarchar(max) = ''
	DECLARE @canManage INT = 0
	DECLARE @timeNow int = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @doAudit int = 0
	-- Create tempTable with permissionIds to be checked. Pass it to the SP.
    CREATE TABLE #permissionIdTbl
    (
        i_permissionId INT
    )
INSERT INTO #permissionIdTbl VALUES (2), (1)
EXEC sec_checkPermissionOnEntity  @userId, '', @canManage OUTPUT, 3, @ClientId
	IF @canManage <> 1
	BEGIN
DECLARE @permissionString varchar(MAX)= dbo.fn_EvFormatEventMsgText(0,@localeId, (SELECT tokenId FROM UMCapability WITH (NOLOCK) WHERE id = 2), 0,2) + ', ' +
dbo.fn_EvFormatEventMsgText(0,@localeId, (SELECT tokenId FROM UMCapability WITH (NOLOCK) WHERE id = 1), 0,2)
SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (2934 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH (NOLOCK) WHERE id = @userId), @userId))
		SET @errorString = REPLACE(@errorString, '^2%s',@permissionString)
		SET @errorString = REPLACE(@errorString, '^3%s', (SELECT displayName FROM app_client WHERE id = @clientId))
		SET @errorString = REPLACE(@errorString, '^4%s', 'client')
		GOTO SCRIPT_EXIT
	END
	 DROP TABLE #permissionIdTbl
	DECLARE @oldFlag nvarchar(MAX)
SELECT @oldFlag=attrVal FROM APP_ClientProp WHERE componentNameId=@clientId AND attrName =  'IsInfrastructureMachine'   AND modified=0
	IF(@oldFlag is null)
		BEGIN
		INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT @clientId, 'IsInfrastructureMachine' , 2, @setIsInfrastructureMachine, @timeNow, 0
			SET @doAudit = 1
		END
	ELSE IF(CAST(@oldFlag AS INT) <> @setIsInfrastructureMachine)
		BEGIN
UPDATE APP_ClientProp set attrVal=@setIsInfrastructureMachine where attrName = 'IsInfrastructureMachine' and modified=0 and componentNameId=@clientId
		SET @doAudit = 1
	END
DO_AUDIT:
	IF(@doAudit=1)
	BEGIN
		DECLARE @oldFlagUserDefined nvarchar(max)
SELECT @oldFlagUserDefined=attrVal FROM APP_ClientProp WHERE componentNameId=@clientId AND attrName =  'IsInfrastructureMachineUserDefined'   AND modified=0
		IF(@oldFlagUserDefined IS NULL)
		BEGIN
			INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified) VALUES
(@clientId, 'IsInfrastructureMachineUserDefined' , 2, @setIsInfrastructureMachine, @timeNow, 0 )
	END
		ELSE
	BEGIN
UPDATE APP_ClientProp set attrVal=@setIsInfrastructureMachine where attrName = 'IsInfrastructureMachineUserDefined' and modified=0 and componentNameId=@clientId
	END
        DECLARE @opMsgId            INTEGER
        DECLARE @opEvMsgId          INTEGER
        DECLARE @opId               INTEGER
        DECLARE @paramMsgId         INTEGER
        DECLARE @paramData          NVARCHAR(1024)
        DECLARE @dataIsEvent        INTEGER = 0
SET @opMsgId = (273 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
		--IsInfrastructureMachine marked or not marked
		--Client marked as infrastructure machine
		--Client marked as non Infrastructure machine
		IF(@setIsInfrastructureMachine =0)
		BEGIN
SET @paramMsgId  = (1868 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		END
		ELSE IF(@setIsInfrastructureMachine = 1)
		BEGIN
SET @paramMsgId  = (1867 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		END
		 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		--User
SET @paramMsgId  = (1189 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		 SET @paramData = (SELECT login FROM UMUsers WHERE id = @userId)
		 EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
		 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		--Client
SET @paramMsgId  = (1436 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		 SET @paramData = (SELECT name FROM App_Client WHERE id = @clientId)
		 EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
		 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = ERROR_NUMBER()
    set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
SET @o_xmlText = (SELECT @errorCode AS '@errorCode',  @errorString AS '@errorMessage'
		FOR XML PATH('Api_GenericResp'),TYPE)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetIsInfrastructureMachineFlag')
	delete from GxQscripts where name = 'SetIsInfrastructureMachineFlag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetIsInfrastructureMachineFlag')
	delete from GXDBVersions where aliasname = 'SetIsInfrastructureMachineFlag'
GO

insert into GXDBVersions values(2, 'SetIsInfrastructureMachineFlag',  '00010001000200010000', 'SetIsInfrastructureMachineFlag', '00010001000200010000')
GO

