

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetInstalledUpdateSummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetInstalledUpdateSummary.sp,v $ $Id: SetInstalledUpdateSummary.sp,v 1.2.88.2 2020/06/25 03:55:59 xsui Exp $";
--
--  +========================================================================+
--  |	Cursor:  SetInstalledUpdateSummary
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |	1.1       anagrale  Set update summary and time for client id
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetInstalledUpdateSummary')
BEGIN
	print '>>> Drop Stored Procedure: SetInstalledUpdateSummary <<<'
	drop procedure SetInstalledUpdateSummary
END
IF EXISTS (select * from GxQscripts where name='SetInstalledUpdateSummary')
	delete from GxQscripts where name = 'SetInstalledUpdateSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetInstalledUpdateSummary')
	delete from GXDBVersions where aliasname = 'SetInstalledUpdateSummary'
GO
print '... Creating Procedure: SetInstalledUpdateSummary'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SetInstalledUpdateSummary
  @i_clientId integer,
  @i_packageId integer,
  @i_opType char(25),
  @i_highestSP integer,
  @i_spMinorVersion integer,
  @i_additionalPatches nvarchar(MAX),
  @i_missingPatches nvarchar(MAX)
AS
-- :PARAM input lines
SET NOCOUNT ON
-- Algorithm
-- 1. Check If there are any rows for this client id and package id
-- 2. If no, insert the new information as it is. Operation time will be time at which information is inserted
-- 3. If yes, get the row with latest timestamp. Check if highestsp, spminorversion, additionalpatches or missingpatches from this row is different from
--    passed arguments. If nothing is changed, do not insert any new row. If at least one parameter is changed, insert new row with all details
DECLARE	@recent_highestSP		INT
DECLARE	@recent_spMinorVersion	INT
DECLARE	@recent_additionalPatches	NVARCHAR(MAX)
DECLARE	@recent_missingPatches	NVARCHAR(MAX)
DECLARE	@flag_insertRow			INT
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
SET @flag_insertRow = 0
IF EXISTS (SELECT * from PatchInstallHistory where ClientId=@i_clientId AND simPackageID=@i_packageId)
BEGIN
	-- At least one row exist, get the row which is most recently modified for this client
	SELECT Top(1) @recent_highestSP = HighestSP,
			@recent_spMinorVersion = SpMinorVersion,
			@recent_additionalPatches = AdditionalPatches,
			@recent_missingPatches = MissingPatches FROM PatchInstallHistory WHERE ClientId=@i_clientId AND simPackageID=@i_packageId order by OpTime desc
	-- Check if any parameter is changed from previous element
    IF @recent_highestSP <> @i_highestSP OR @recent_spMinorVersion < @i_spMinorVersion OR @recent_additionalPatches <> @i_additionalPatches OR @recent_missingPatches <> @i_missingPatches
	BEGIN
	    	SET @flag_insertRow = 1
    END
END
ELSE
BEGIN
	-- row does exist for this client and package id, insert the row as it is
	SET @flag_insertRow = 1
END
-- Check if row has to be inserted. If yes, do it now
IF @flag_insertRow <> 0
BEGIN
   INSERT INTO PatchInstallHistory
		   ([ClientId]
           ,[simPackageID]
           ,[OpTime]
           ,[OpType]
           ,[HighestSP]
           ,[AdditionalPatches]
           ,[MissingPatches]
           ,[SpMinorVersion]
           ,[DummyStr]
           ,[DummyInt])
   VALUES
           (@i_clientId
           ,@i_packageId
           ,GetUTCDate()
           ,@i_opType
           ,@i_highestSP
           ,@i_additionalPatches
           ,@i_missingPatches
           ,@i_spMinorVersion
           ,''
           ,0)
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'SetInstalledUpdateSummary')
	delete from GxQscripts where name = 'SetInstalledUpdateSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetInstalledUpdateSummary')
	delete from GXDBVersions where aliasname = 'SetInstalledUpdateSummary'
GO

insert into GXDBVersions values(2, 'SetInstalledUpdateSummary',  '00010002008800020000', 'SetInstalledUpdateSummary', '00010002008800020000')
GO

