

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetIdxDbStatusForReconInternal.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SetIdxDbStatusForReconInternal')
BEGIN
	print '>>> Drop Stored Procedure: SetIdxDbStatusForReconInternal <<<'
	drop procedure SetIdxDbStatusForReconInternal
END
IF EXISTS (select * from GxQscripts where name='SetIdxDbStatusForReconInternal')
	delete from GxQscripts where name = 'SetIdxDbStatusForReconInternal'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetIdxDbStatusForReconInternal')
	delete from GXDBVersions where aliasname = 'SetIdxDbStatusForReconInternal'
GO
print '... Creating Procedure: SetIdxDbStatusForReconInternal'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SetIdxDbStatusForReconInternal
  @dbName VARCHAR(36)
AS
DECLARE @curtime INT = DBO.GetUnixTime(getdate())
DECLARE @dbId INT = (select ID from App_IndexDBInfo WITH (NOLOCK) where dbName = @dbName)
DECLARE @outdbxml XML = (select properties from IdxDbState WITH (NOLOCK) where dbId = @dbId)
DECLARE @totApps INT = (SELECT COUNT(*) FROM #tempAppIds)
IF(@totApps=0) RETURN
DECLARE @IndexDbUptoDateGracePeriod INT = CAST(ISNULL((SELECT value FROM GxGlobalParam WITH (NOLOCK) WHERE name = 'IndexDbUptoDateGracePeriod'), '86400') AS INT)
DECLARE @lastPlayedBkpTime INT = (SELECT MAX(ISNULL(A1.aFileCtime,0)) FROM #tempAppIds A1)
DECLARE @lastCompletedBkpTime INT = (SELECT (CASE WHEN COUNT(AF.jobId) > 0 THEN MAX(ISNULL(AF.ctime,0)) ELSE MAX(ISNULL(A1.aFileCtime,0)) END) FROM #tempAppIds A1 FULL JOIN #tempAfiles AF ON A1.appId = AF.appId)
DECLARE @uptodate INT = (SELECT (CASE WHEN ((@lastCompletedBkpTime - @lastPlayedBkpTime) > @IndexDbUptoDateGracePeriod) THEN 0 ELSE 1 END))
IF(@outdbxml IS NULL)
BEGIN
	SET @outdbxml =
	(SELECT @lastCompletedBkpTime as '@lastCompletedBkpTime', @lastPlayedBkpTime as '@lastPlayedBkpTime'
	FOR XML PATH('Indexing_DbStats'))
	SET @outdbxml.modify('insert sql:variable("@apps") into (/Indexing_DbStats)[1]')
	IF(@dbId IS NULL)
	BEGIN
		DECLARE @bsId INT = ISNULL((SELECT backupSet FROM APP_Application WITH (NOLOCK) WHERE GUID = @dbName),0)
		IF (dbo.isSubClientIndexEnabled(@bsId) = 0) RETURN
		INSERT INTO App_IndexDBInfo(dbName, type, idxDbEngineType, backupSetId, currentIdxServer, backupSetGUID, properties, isPrimary)
		SELECT TOP 1 @dbName, IDX.type, IDX.idxDbEngineType, IDX.backupSetId, IDX.currentIdxServer,IDX.backupSetGUID, IDX.properties, IDX.isPrimary FROM App_IndexDBInfo IDX WITH (NOLOCK)
		WHERE backupSetId = @bsId
		SELECT @dbId = id FROM App_IndexDBInfo IDX WHERE dbName = @dbName
	END
	INSERT INTO IdxDbState(dbId, dbUptodate, properties, modified) values (@dbId, @uptodate, @outdbxml, @curtime)
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#input_dbstat') is not null
		DROP TABLE #input_dbstat
	CREATE TABLE #input_dbstat (  dbName VARCHAR(40), lastPlayedBkpJobId BIGINT, lastPlayedBkpJobTime BIGINT, lastCompletedBkpJobId BIGINT, lastCompletedBkpJobTime BIGINT)
	INSERT INTO #input_dbstat
	SELECT A2.GUID as '@appGUID', A1.completedJobId as '@lastPlayedBkpJobId',  A1.aFileCtime as '@lastPlayedBkpJobTime',
	(CASE WHEN COUNT(AF.jobId) > 0 THEN MAX(ISNULL(AF.jobId,0)) ELSE A1.completedJobId END) AS '@lastCompletedBkpJobId',
	(CASE WHEN COUNT(AF.jobId) > 0 THEN MAX(ISNULL(AF.ctime,0)) ELSE A1.aFileCtime END) AS '@lastCompletedBkpJobTime'
	FROM #tempAppIds A1 JOIN App_application A2 WITH (NOLOCK) ON A1.appId = A2.id
	LEFT OUTER JOIN #tempAfiles AF ON AF.appId = A2.id
	GROUP BY A2.GUID, A1.completedJobId, A1.aFileCtime
	IF object_id('tempdb.dbo.#original_appstat') is not null
		DROP TABLE #original_appstat
	CREATE TABLE #original_appstat ( appGUID VARCHAR(40), lastCompletedBkpJobId BIGINT, lastCompletedBkpJobTime BIGINT, lastPlayedBkpJobId BIGINT,
    lastPlayedBkpJobTime BIGINT, lastCheckpointedBkpJobId BIGINT, lastCheckpointedBkpJobTime BIGINT, prunedCheckpointStartTime BIGINT,
    prunedCheckpointEndTime  BIGINT, checkpointJobId BIGINT, stat xml)
	INSERT INTO #original_appstat
	SELECT T.N.value('@appGUID', 'VARCHAR(40)')
	, T.N.value('@lastCompletedBkpJobId','BIGINT'), T.N.value('@lastCompletedBkpJobTime','BIGINT')
	, T.N.value('@lastPlayedBkpJobId','BIGINT'), T.N.value('@lastPlayedBkpJobTime','BIGINT')
	, T.N.value('@lastCheckpointedBkpJobId','BIGINT'), T.N.value('@lastCheckpointedBkpJobTime','BIGINT')
	, T.N.value('@prunedCheckpointStartTime','BIGINT'), T.N.value('@prunedCheckpointEndTime','BIGINT'), T.N.value('@checkpointJobId','BIGINT'), T.N.query('./stat')
	FROM IdxDbState DS WITH (NOLOCK)
	CROSS APPLY properties.nodes('(/Indexing_DbStats/apps)') AS T(N)
	where DS.dbId = @dbId
	MERGE #original_appstat T
	USING #input_dbstat temp
	ON T.appGUID = temp.dbName
	WHEN MATCHED THEN
	UPDATE SET T.lastCompletedBkpJobId = temp.lastCompletedBkpJobId,
	T.lastCompletedBkpJobTime = temp.lastCompletedBkpJobTime,
	T.lastPlayedBkpJobId = temp.lastPlayedBkpJobId,
	T.lastPlayedBkpJobTime = temp.lastPlayedBkpJobTime
	WHEN NOT MATCHED BY TARGET THEN
	INSERT( appGUID, lastCompletedBkpJobId, lastCompletedBkpJobTime, lastPlayedBkpJobId, lastPlayedBkpJobTime, lastCheckpointedBkpJobId,
	lastCheckpointedBkpJobTime, prunedCheckpointStartTime, prunedCheckpointEndTime, checkpointJobId, stat)
	VALUES(temp.dbName, temp.lastCompletedBkpJobId, temp.lastCompletedBkpJobTime, temp.lastPlayedBkpJobId, temp.lastPlayedBkpJobTime, 0, 0, 0, 0, 0, '')
	;
	DECLARE @apps XML =
	(
		SELECT org.appGUID AS '@appGUID', org.lastCompletedBkpJobId AS '@lastCompletedBkpJobId'
		, org.lastCompletedBkpJobTime AS '@lastCompletedBkpJobTime', org.lastPlayedBkpJobId AS '@lastPlayedBkpJobId'
		, org.lastPlayedBkpJobTime AS '@lastPlayedBkpJobTime', org.lastCheckpointedBkpJobId AS '@lastCheckpointedBkpJobId'
		, org.lastCheckpointedBkpJobTime AS '@lastCheckpointedBkpJobTime', org.prunedCheckpointStartTime AS '@prunedCheckpointStartTime'
		, org.prunedCheckpointEndTime AS '@prunedCheckpointEndTime', org.checkpointJobId AS '@checkpointJobId'
		,(SELECT org.stat)
		FROM #original_appstat org
		FOR XML PATH('apps')
	)
	IF object_id('tempdb.dbo.#original_dbstat') is not null
		DROP TABLE #original_dbstat
	CREATE TABLE #original_dbstat ( creationId VARCHAR(40), lastCompletedBkpTime BIGINT, lastPlayedBkpTime BIGINT, lastCheckPointBkpTime BIGINT,
	itemsAddedSinceCheckPoint BIGINT, itemsAddedThreadsholdForCheckpoint BIGINT, afilesAgedSinceCheckPoint BIGINT, afilesAgedThresholdForCompaction BIGINT,
	failedCheckPointAttempts  BIGINT, uptodateThresholdSecs BIGINT, daysThresholdForCheckpoint BIGINT, triggerCheckpoint INT, triggerCompaction INT,
	dbSize BIGINT, logsSize BIGINT, reportsSize BIGINT, maintenanceSize BIGINT, lastCompactionTime BIGINT, lastIdxErrorTime BIGINT, lastFailedPlaybackJobId BIGINT)
	INSERT INTO #original_dbstat
	SELECT T.N.value('@creationId', 'VARCHAR(40)')
	, @lastCompletedBkpTime , @lastPlayedBkpTime, T.N.value('@lastCheckPointBkpTime','BIGINT')
	, T.N.value('@itemsAddedSinceCheckPoint','BIGINT'), T.N.value('@itemsAddedThreadsholdForCheckpoint','BIGINT'), T.N.value('@afilesAgedSinceCheckPoint','BIGINT')
	, T.N.value('@afilesAgedThresholdForCompaction','BIGINT'), T.N.value('@failedCheckPointAttempts','BIGINT'), T.N.value('@uptodateThresholdSecs','BIGINT')
	, T.N.value('@daysThresholdForCheckpoint','BIGINT'), T.N.value('@triggerCheckpoint','int'), T.N.value('@triggerCompaction','int')
	, T.N.value('@dbSize','BIGINT'), T.N.value('@logsSize','BIGINT'), T.N.value('@reportsSize','BIGINT'), T.N.value('@maintenanceSize','BIGINT'), T.N.value('@lastCompactionTime','BIGINT')
	, T.N.value('@lastIdxErrorTime','BIGINT'), T.N.value('@lastFailedPlaybackJobId','BIGINT')
	FROM IdxDbState DS WITH (NOLOCK)
	CROSS APPLY properties.nodes('(/Indexing_DbStats)') AS T(N)
	WHERE DS.dbId = @dbId
	SET @outdbxml = (
		SELECT creationId AS '@creationId', lastCompletedBkpTime AS '@lastCompletedBkpTime'
		, lastPlayedBkpTime AS '@lastPlayedBkpTime', lastCheckPointBkpTime AS '@lastCheckPointBkpTime'
		, itemsAddedSinceCheckPoint AS '@itemsAddedSinceCheckPoint', itemsAddedThreadsholdForCheckpoint AS '@itemsAddedThreadsholdForCheckpoint'
		, afilesAgedSinceCheckPoint AS '@afilesAgedSinceCheckPoint', afilesAgedThresholdForCompaction AS '@afilesAgedThresholdForCompaction'
		, failedCheckPointAttempts AS '@failedCheckPointAttempts', uptodateThresholdSecs AS '@uptodateThresholdSecs'
		, daysThresholdForCheckpoint AS '@daysThresholdForCheckpoint', triggerCheckpoint AS '@triggerCheckpoint'
		, ISNULL(dbSize, 0) AS '@dbSize', ISNULL(reportsSize, 0) AS '@reportsSize'
		, ISNULL(maintenanceSize, 0) AS '@maintenanceSize', ISNULL(logsSize, 0) AS '@logsSize'
		, ISNULL(lastCompactionTime, 0) as '@lastCompactionTime', ISNULL(lastIdxErrorTime, -1) as '@lastIdxErrorTime'
		, ISNULL(lastFailedPlaybackJobId, 0) as '@lastFailedPlaybackJobId',	( SELECT @apps )
		FROM #original_dbstat
		FOR XML PATH('Indexing_DbStats')
	)
	UPDATE IdxDbState SET dbuptodate = @uptodate, errorLvl = 0, errorDesc = '', properties = @outdbxml, modified = @curtime where dbid = @dbId
END
IF object_id('tempdb.dbo.#input_dbstat') is not null
	DROP TABLE #input_dbstat
IF object_id('tempdb.dbo.#original_appstat') is not null
    DROP TABLE #original_appstat
IF object_id('tempdb.dbo.#original_dbstat') is not null
	DROP TABLE #original_dbstat
GO

IF EXISTS (select * from GxQscripts where name = 'SetIdxDbStatusForReconInternal')
	delete from GxQscripts where name = 'SetIdxDbStatusForReconInternal'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetIdxDbStatusForReconInternal')
	delete from GXDBVersions where aliasname = 'SetIdxDbStatusForReconInternal'
GO

insert into GXDBVersions values(2, 'SetIdxDbStatusForReconInternal',  '00000000000000000000', 'SetIdxDbStatusForReconInternal', '00000000000000000000')
GO

