

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetFsNodeActivity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : SetFsNodeActivity.sp
--	Author		: Logesh G
--
--  Description : This SP is to add clients file & folder activity
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetFsNodeActivity.sp,v $ $Id: SetFsNodeActivity.sp,v 1.1.2.1 2020/04/13 22:53:08 logeshg Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetFsNodeActivity')
BEGIN
	print '>>> Drop Stored Procedure: SetFsNodeActivity <<<'
	drop procedure SetFsNodeActivity
END
IF EXISTS (select * from GxQscripts where name='SetFsNodeActivity')
	delete from GxQscripts where name = 'SetFsNodeActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetFsNodeActivity')
	delete from GXDBVersions where aliasname = 'SetFsNodeActivity'
GO
print '... Creating Procedure: SetFsNodeActivity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetFsNodeActivity
  @clientId INTEGER,
  @activityInfo XML,
  @status INTEGER,
  @overWrite INT
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorMsg NVARCHAR(MAX)
BEGIN TRY
BEGIN TRAN FS_NODE_ACTIVITY_INSERT
	SET @errorCode = 0
	SET @errorMsg = ''
	DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
	IF @overWrite = 1 AND EXISTS(SELECT 1 FROM HistoryDB.dbo.FsNodeActivityData WITH(NOLOCK) WHERE clientId = @clientId)
	BEGIN
		UPDATE HistoryDB.dbo.FsNodeActivityData
		SET activityInfo = @activityInfo
		WHERE clientId = @clientId
	END
	ELSE
	BEGIN
		IF NOT EXISTS(SELECT 1 FROM APP_Client WITH(NOLOCK) WHERE id = @clientId)
		BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'No such client exits'
			GOTO ERROR_EXIT
		END
		INSERT INTO HistoryDB.dbo.FsNodeActivityData
		SELECT @clientId,@activityInfo,@nowTime,@status
	END
ERROR_EXIT:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorMsg = ERROR_MESSAGE()
END CATCH
IF @errorCode = 0
	COMMIT TRAN FS_NODE_ACTIVITY_INSERT
ELSE
BEGIN
	ROLLBACK TRAN FS_NODE_ACTIVITY_INSERT
END
SELECT @errorCode,@errorMsg
GO

IF EXISTS (select * from GxQscripts where name = 'SetFsNodeActivity')
	delete from GxQscripts where name = 'SetFsNodeActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetFsNodeActivity')
	delete from GXDBVersions where aliasname = 'SetFsNodeActivity'
GO

insert into GXDBVersions values(2, 'SetFsNodeActivity',  '00010001000200010000', 'SetFsNodeActivity', '00010001000200010000')
GO

