

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetFRRepSetMaxConsistPts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetFRRepSetMaxConsistPts.sp,v $ $Id: SetFRRepSetMaxConsistPts.sp,v 1.3.304.2 2020/10/04 01:04:41 abilbrey Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetFRRepSetMaxConsistPts')
BEGIN
	print '>>> Drop Stored Procedure: SetFRRepSetMaxConsistPts <<<'
	drop procedure SetFRRepSetMaxConsistPts
END
IF EXISTS (select * from GxQscripts where name='SetFRRepSetMaxConsistPts')
	delete from GxQscripts where name = 'SetFRRepSetMaxConsistPts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetFRRepSetMaxConsistPts')
	delete from GXDBVersions where aliasname = 'SetFRRepSetMaxConsistPts'
GO
print '... Creating Procedure: SetFRRepSetMaxConsistPts'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SetFRRepSetMaxConsistPts
  @newMaxValue int
AS
  DECLARE @retVal INTEGER;
  DECLARE @errString varchar(256);
--This will turn off message: 'xxx rows affected'.
SET NOCOUNT ON
-- LOCAL VARIABLES AND ASSIGNMENTS-----
DECLARE @nowTime     integer
DECLARE @FLR_APPTYPE integer
DECLARE @CV_FILE_REPL_MAX_CONSIST_POINTS nvarchar(50)
SET @FLR_APPTYPE                     =   84								     -- From AppTypeDefs.h
SET @nowTime 		                 =   dbo.GetUnixTime (GetUTCdate())
SET @CV_FILE_REPL_MAX_CONSIST_POINTS =  'FLR Maximum Consistency Points'     -- From DerivedBackupSets.h
--------------------------------------
--  LOOP THROUGH ALL THE BACKUPSETS --
--------------------------------------
DECLARE RepSets_cursor CURSOR
FOR
   SELECT distinct backupSet from APP_Application
     WHERE appTypeId = @FLR_APPTYPE
     AND  (subClientStatus & 6) = 0              -- UNINSTALLED(2)/DELETED(4)
OPEN RepSets_cursor
DECLARE @thisBackupsetId integer
DECLARE @thisAffinity integer
FETCH NEXT FROM RepSets_cursor INTO @thisBackupsetId
WHILE (@@FETCH_STATUS = 0)
BEGIN
---------------------------------------------------------------------------
-- FOR NOW, THIS BACKUPSET PROPERTY DOES NOT USE PIT, SO WE ONLY HAVE TO --
-- WORRY ABOUT UPDATING/INSERTING One Row                                --
---------------------------------------------------------------------------
IF EXISTS (Select * from APP_BackupSetProp WHERE componentNameId = @thisBackupsetId AND attrName = @CV_FILE_REPL_MAX_CONSIST_POINTS)
	UPDATE APP_BackupSetProp
	  SET attrVal = @newMaxValue
	  WHERE componentNameId = @thisBackupsetId AND attrName = @CV_FILE_REPL_MAX_CONSIST_POINTS
ELSE
	INSERT APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified)
	   VALUES (@thisBackupsetId, @CV_FILE_REPL_MAX_CONSIST_POINTS, 10, @thisBackupsetId, @nowTime, 0)
    FETCH NEXT FROM RepSets_cursor INTO @thisBackupsetId
END
CLOSE RepSets_cursor
DEALLOCATE RepSets_cursor
set @retVal = 0
set @errString = ''
SELECT   @retVal, @errString
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'SetFRRepSetMaxConsistPts')
	delete from GxQscripts where name = 'SetFRRepSetMaxConsistPts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetFRRepSetMaxConsistPts')
	delete from GXDBVersions where aliasname = 'SetFRRepSetMaxConsistPts'
GO

insert into GXDBVersions values(2, 'SetFRRepSetMaxConsistPts',  '00010003030400020000', 'SetFRRepSetMaxConsistPts', '00010003030400020000')
GO

