

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetEntityExtractorInfo.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  SetEntityExtractorInfo
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |                and DM2CloudCoreRole tables based on i_opType
--  |
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetEntityExtractorInfo.sp,v $ $Id: SetEntityExtractorInfo.sp,v 1.3.2.6 2020/06/21 01:34:47 csingh Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SetEntityExtractorInfo')
BEGIN
	print '>>> Drop Stored Procedure: SetEntityExtractorInfo <<<'
	drop procedure SetEntityExtractorInfo
END
IF EXISTS (select * from GxQscripts where name='SetEntityExtractorInfo')
	delete from GxQscripts where name = 'SetEntityExtractorInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetEntityExtractorInfo')
	delete from GXDBVersions where aliasname = 'SetEntityExtractorInfo'
GO
print '... Creating Procedure: SetEntityExtractorInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetEntityExtractorInfo
  @i_reqXML XML    
AS
  DECLARE @o_errorCode integer = 0
  DECLARE @o_errorStr varchar(max) = 'Success'
/* Sample message
EXEC SetEntityExtractorInfo
'<?xml version="1.0" encoding="UTF-8" standalone="no" ?>
<DM2ContentIndexing_EntityDetailsReq opType="2">
<entity backwardRefTime="1900-01-01T00:00:00" entityRulerId="A6234569-D7D3-4593-B253-014F0B363954" forwardRefTime="1900-01-01T00:00:00" numItemsProcessed="10" totalDocsFound="1110" totalEntitiesFound="110" nodeClientId="4" />
<entity backwardRefTime="1900-01-01T00:00:00" entityRulerId="BD456769-D7D3-4593-B253-014F0B363954" forwardRefTime="1900-01-01T00:00:00" numItemsProcessed="10" totalDocsFound="110" totalEntitiesFound="10" nodeClientId="5" />
<instance instanceName="Instance001"/>
</DM2ContentIndexing_EntityDetailsReq>
*/
DECLARE @entityRulerId varchar(64) = ''
SELECT @entityRulerId = ISNULL(T.ref.value('@entityRulerId','VARCHAR(64)'), '') FROM @i_reqXML.nodes('DM2ContentIndexing_EntityDetailsReq/entity') AS T(ref)
IF @entityRulerId = ''
BEGIN
	DECLARE @entityId int = 0
	DECLARE @entityXML xml = ''
	SELECT @entityId = ISNULL(T.ref.value('@entityId', 'int'), 0) FROM @i_reqXML.nodes('DM2ContentIndexing_EntityDetailsReq/entity') AS T(ref)
	IF EXISTS(SELECT 1 FROM EntityAnnotator WHERE EntityID = @entityId)
	BEGIN
		SELECT @entityXML = @i_reqXML.query('/DM2ContentIndexing_EntityDetailsReq/entity/entityXML')
		UPDATE EntityAnnotator SET AnnotatorXML = @entityXML WHERE EntityID=@entityId
	END
	ELSE
	BEGIN
		SELECT @o_errorStr = 'Invalid Entity Id provided.', @o_errorCode=11501 -- INVALID_ENTITY_ID = 11501;
	END
END
ELSE
BEGIN
	IF OBJECT_ID('tempdb..#tmpEntityDetails') IS NOT NULL DROP TABLE #tmpEntityDetails
		CREATE TABLE #tmpEntityDetails (
												t_entityRulerId			VARCHAR(64),
												t_numItemsProcessed   BIGINT,
												t_totalDocsFound       BIGINT,
												t_totalEntitiesFound   BIGINT,
												t_forwardRefTime		varchar(64),
												t_backwardRefTime		varchar(64),
												t_nodeClientId		INT
												)
		INSERT  INTO #tmpEntityDetails
		SELECT
			ref.value('@entityRulerId','VARCHAR(64)') ,
			ref.value('@numItemsProcessed','int') ,
			ref.value('@totalDocsFound','int') ,
			ref.value('@totalEntitiesFound','int'),
			ref.value('@forwardRefTime','varchar(64)'),
			ref.value('@backwardRefTime','varchar(64)'),
			ref.value('@nodeClientId','int')
			FROM    @i_reqXML.nodes('DM2ContentIndexing_EntityDetailsReq/entity') AS R (ref)
	UPDATE ES
		SET numItemsProcessed = numItemsProcessed + t_numItemsProcessed,
			TotalEntitiesFound = TotalEntitiesFound + t_totalEntitiesFound,
			totalDocsFound = totalDocsFound +  t_totalDocsFound,
			ModifiedTime = 	GETUTCDATE()
		FROM EntitySelection ES
		INNER JOIN #tmpEntityDetails T ON ES.EntityRulerId = T.t_entityRulerId
	UPDATE EP
		SET forwardRefTime = t_forwardRefTime,
			backwardRefTime = t_backwardRefTime
		FROM EntityProcessor EP
		INNER JOIN #tmpEntityDetails T ON EP.EntityRulerId = T.t_entityRulerId AND EP.nodeClientId = T.t_nodeClientId
	DROP TABLE #tmpEntityDetails
END
select @o_errorCode, @o_errorStr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetEntityExtractorInfo')
	delete from GxQscripts where name = 'SetEntityExtractorInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetEntityExtractorInfo')
	delete from GXDBVersions where aliasname = 'SetEntityExtractorInfo'
GO

insert into GXDBVersions values(2, 'SetEntityExtractorInfo',  '00010003000200060000', 'SetEntityExtractorInfo', '00010003000200060000')
GO

