

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetBlockReplicationInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetBlockReplicationInfo.sp,v $";
--	+===================================================================+
--	|  					  SetBlockReplicationInfo						|
--	| Procedure for updating block replication information              |
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetBlockReplicationInfo <<<'

IF EXISTS (select * from sysobjects where name='SetBlockReplicationInfo')
	drop procedure SetBlockReplicationInfo
IF EXISTS (select * from GxQscripts where name='SetBlockReplicationInfo')
	delete from GxQscripts where name = 'SetBlockReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBlockReplicationInfo')
	delete from GXDBVersions where aliasname = 'SetBlockReplicationInfo'
GO
print '... Creating Procedure: SetBlockReplicationInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetBlockReplicationInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
--	DECLARE	@o_xml				XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @replicationTable	TABLE( id INT, status INT)
	-- READ THE XML
	INSERT @replicationTable (id, status)
	SELECT	ISNULL((ref.value('@id', 'INT')), 0),
			CASE WHEN ref.value('@status', 'INT') IS NULL OR ref.value('@status', 'INT') = 0 THEN V.statusCode ELSE ref.value('@status', 'INT') END status
			FROM @i_xmlString.nodes ('BlockReplication_SetBlockReplicationInfoReq/siteInfo') R(ref)
    		LEFT OUTER JOIN BlrPair V (NOLOCK) ON ref.value('@id', 'VARCHAR(255)') = V.id
	BEGIN TRAN
		UPDATE BlrPair SET
			BlrPair.statusCode = (CASE WHEN RT.status IS NULL THEN VR.statusCode ELSE RT.status END)
		FROM BlrPair VR
			JOIN @replicationTable RT ON
			(
				RT.id = VR.id
			)
		SET @errorCode = @@ERROR
ERROR:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
-- IF @errorCode <> 0
--    SET @o_xml = (SELECT  1 AS '@errorCode', 'Failed to update status for given pairs' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
-- ELSE
--	SET @o_xml = (SELECT  0 AS '@errorCode', '' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
--SELECT @o_xml
SELECT  @errorCode
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetBlockReplicationInfo')
	delete from GxQscripts where name = 'SetBlockReplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBlockReplicationInfo')
	delete from GXDBVersions where aliasname = 'SetBlockReplicationInfo'
GO

insert into GXDBVersions values(2, 'SetBlockReplicationInfo',  '00000000000000000000', 'SetBlockReplicationInfo', '00000000000000000000')
GO

