

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetBlockReplicationBootInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetBlockReplicationBootInfo.sp,v $";
--	+===================================================================+
--	|  					  SetBlockReplicationBootInfo				|
--	| Procedure for updating block replication boot information    |
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetBlockReplicationBootInfo <<<'

IF EXISTS (select * from sysobjects where name='SetBlockReplicationBootInfo')
	drop procedure SetBlockReplicationBootInfo
IF EXISTS (select * from GxQscripts where name='SetBlockReplicationBootInfo')
	delete from GxQscripts where name = 'SetBlockReplicationBootInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBlockReplicationBootInfo')
	delete from GXDBVersions where aliasname = 'SetBlockReplicationBootInfo'
GO
print '... Creating Procedure: SetBlockReplicationBootInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SetBlockReplicationBootInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xml				XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @bootTable	TABLE( id INT, bootType INT, bestBefore bigint)
	-- READ THE XML
	INSERT @bootTable (id, bestBefore, bootType)
	SELECT	ISNULL((ref.value('@id', 'INT')), 0),
			CASE WHEN ref.value('@bestBefore', 'bigint') IS NULL OR ref.value('@bestBefore', 'bigint') = 0 THEN V.bestBefore ELSE ref.value('@bestBefore', 'bigint') END bestBefore,
			ISNULL((ref.value('@bootType', 'INT')), 0)
			FROM @i_xmlString.nodes ('BlockReplication_SetBlockReplicationBootInfoReq/siteInfo') R(ref)
    		LEFT OUTER JOIN BlrBootVM V (NOLOCK) ON ref.value('@id', 'VARCHAR(255)') = V.id
	BEGIN TRAN
		UPDATE BlrBootVM SET
			BlrBootVM.bestBefore = (CASE WHEN RT.bestBefore IS NULL THEN VR.bestBefore ELSE RT.bestBefore END)
		FROM BlrBootVM VR
			JOIN @bootTable RT ON
			(
				RT.id = VR.id
				AND
				RT.bootType = VR.bootType
			)
		SET @errorCode = @@ERROR
ERROR:
IF @errorCode <> 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
IF @errorCode <> 0
   SET @o_xml = (SELECT  1 AS '@errorCode', 'Failed to update boot status for given pairs' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
 ELSE
   SET @o_xml = (SELECT  0 AS '@errorCode', '' AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
SELECT @o_xml  as o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetBlockReplicationBootInfo')
	delete from GxQscripts where name = 'SetBlockReplicationBootInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetBlockReplicationBootInfo')
	delete from GXDBVersions where aliasname = 'SetBlockReplicationBootInfo'
GO

insert into GXDBVersions values(2, 'SetBlockReplicationBootInfo',  '00000000000000000000', 'SetBlockReplicationBootInfo', '00000000000000000000')
GO

