

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetArchCheckStatusByMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetArchCheckStatusByMedia.sp,v $ $Id: SetArchCheckStatusByMedia.sp,v 1.19.178.1 2018/03/22 00:57:03 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetArchCheckStatusByMedia <<<'

IF EXISTS (select * from sysobjects where name='SetArchCheckStatusByMedia')
	drop procedure SetArchCheckStatusByMedia
IF EXISTS (select * from GxQscripts where name='SetArchCheckStatusByMedia')
	delete from GxQscripts where name = 'SetArchCheckStatusByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetArchCheckStatusByMedia')
	delete from GXDBVersions where aliasname = 'SetArchCheckStatusByMedia'
GO
print '... Creating Procedure: SetArchCheckStatusByMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SetArchCheckStatusByMedia
  @i_mediaId integer,
  @i_flags integer,
  @i_reset integer,
  @i_archGroupId integer = 0,
  @i_archGroupCopyId integer = 0
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_now integer
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
SELECT id, commCellId
INTO   #tempChunk
FROM   archChunk WITH (NOLOCK)
WHERE  volumeId IN (SELECT VolumeId FROM MMVolume WITH (NOLOCK) WHERE MediaId = @i_mediaId)
   AND (flags & 256) = 0
SET @retVal = @@ERROR
IF @retVal <> 0 GOTO FINISH
SELECT A.chunkCommCellId, A.archChunkId, A.commCellId, A.archFileId, A.archCopyId
INTO   #tempChunkAF
FROM   archChunkMapping A WITH (NOLOCK), #tempChunk B, archGroupCopy AGC WITH (NOLOCK)
WHERE  A.archChunkId = B.id AND A.chunkCommCellId = B.commCellId AND (A.flags & 256) = 0
		AND A.archCopyId = AGC.id
		AND (@i_archGroupId = 0 OR @i_archGroupId = AGC.archGroupId)
		AND (@i_archGroupCopyId = 0 OR @i_archGroupCopyId = AGC.id)
SET @retVal = @@ERROR
IF @retVal <> 0 GOTO FINISH
SELECT A.jobId, B.archFileId, B.commCellId, B.archCopyId
INTO   #tempJobAF
FROM   archFile A WITH (NOLOCK), #tempChunkAF B
WHERE  A.id = B.archFileId AND A.commCellId = B.commCellId
SET @retVal = @@ERROR
IF @retVal <> 0 GOTO FINISH
UPDATE archChunkMapping SET flags = ((flags & @i_reset) | @i_flags)
FROM   archChunkMapping A, #tempChunkAF B
WHERE  A.archChunkId = B.archChunkId AND A.archFileId = B.archFileId
   AND A.chunkCommCellId = B.chunkCommCellId AND A.archCopyId = B.archCopyId
   AND A.commCellId = B.commCellId
SET @retVal = @@ERROR
IF @retVal <> 0 GOTO FINISH
UPDATE JMJobDataStats SET archCheckStatus = 3, modifiedTime = @l_now
FROM   JMJobDataStats A, #tempJobAF B
WHERE  A.jobId = B.jobId
   AND A.archGrpCopyId = B.archCopyId
   AND A.commCellId = B.commCellId
   AND A.archCheckStatus <> 3
SET @retVal = @@ERROR
FINISH:
DROP TABLE #tempJobAF
DROP TABLE #tempChunk
DROP TABLE #tempChunkAF
SELECT @retVal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetArchCheckStatusByMedia')
	delete from GxQscripts where name = 'SetArchCheckStatusByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetArchCheckStatusByMedia')
	delete from GXDBVersions where aliasname = 'SetArchCheckStatusByMedia'
GO

insert into GXDBVersions values(2, 'SetArchCheckStatusByMedia',  '00010019017800010000', 'SetArchCheckStatusByMedia', '00010019017800010000')
GO

