

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SetArchCheckStatusByJob.sp] ---------- 

--#include "DBaccess.h"
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SetArchCheckStatusByJob.sp,v $ $Id: SetArchCheckStatusByJob.sp,v 1.13.12.4 2018/03/22 01:03:14 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SetArchCheckStatusByJob <<<'

IF EXISTS (select * from sysobjects where name='SetArchCheckStatusByJob')
	drop procedure SetArchCheckStatusByJob
IF EXISTS (select * from GxQscripts where name='SetArchCheckStatusByJob')
	delete from GxQscripts where name = 'SetArchCheckStatusByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetArchCheckStatusByJob')
	delete from GXDBVersions where aliasname = 'SetArchCheckStatusByJob'
GO
print '... Creating Procedure: SetArchCheckStatusByJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SetArchCheckStatusByJob
  @i_jobId integer,
  @i_commCellId integer,
  @i_copyId integer,
  @i_status integer,
  @i_flags integer,
  @i_reset integer
AS
  DECLARE @o_retVal integer;
  DECLARE @o_opStatus integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_retVal = 0
DECLARE @l_now integer
DECLARE @l_opStatus integer = 0
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
BEGIN TRANSACTION
IF @i_status = 3 /*ACS_TOBECHECKED*/
BEGIN
	IF EXISTS (SELECT * FROM JMJobDataStats WITH (READUNCOMMITTED)
			   WHERE jobId = @i_jobId
			   AND archGrpCopyId = @i_copyId
			   AND commCellId = @i_commCellId
			   AND status IN (100,102,103)
AND (disabled & 256) = 0
AND (disabled & (8192 | 1)) != (8192 | 1))
	BEGIN
UPDATE JMJobDataStats SET archCheckStatus = @i_status, modifiedTime = @l_now, disabled  = (disabled  & ~2048)
		WHERE  jobId = @i_jobId
		   AND archGrpCopyId = @i_copyId
		   AND commCellId = @i_commCellId
		   AND status IN (100,102,103)
AND (disabled & (8192 | 1)) != (8192 | 1)
AND (disabled & 256) = 0
		SET @o_retVal = @@ERROR
		IF @o_retVal != 0 GOTO CX_EXIT
		UPDATE archChunkMapping SET flags = ((flags & @i_reset) | @i_flags)
		WHERE  archCopyId = @i_copyId AND commCellId = @i_commCellId AND archFileId IN (
				SELECT archFileId FROM archFileCopy WITH (READUNCOMMITTED)
				WHERE  archCopyId = @i_copyId AND commCellId = @i_commCellId AND archFileId IN (
						SELECT id
						FROM archFile AF WITH (READUNCOMMITTED) INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED) ON
									AF.JobId = JDS.JobId AND AF.CommCellId = JDS.CommCellId AND AF.FileType = JDS.DataType AND JDS.archGrpCopyId =  @i_copyId
						WHERE AF.jobId = @i_jobId
					AND   AF.commCellId = @i_commCellId AND (AF.isValid = 1 OR AF.appId IN (
							SELECT id FROM APP_Application WHERE appTypeId NOT IN
							(2,3,4,5,9,13,15,16,22,23,26,27,28,30,31,32,37,47,49,50,53,61,62,1000)))
						AND status IN (100,102,103)
AND (JDS.disabled & (8192 | 1)) != (8192 | 1)
AND (JDS.disabled & 256) = 0))
		SET @o_retVal = @@ERROR
		IF @o_retVal != 0 GOTO CX_EXIT
		SET @l_opStatus = 1
	END
END
ELSE
BEGIN
	IF EXISTS (SELECT * FROM JMJobDataStats WITH (READUNCOMMITTED)
			   WHERE jobId = @i_jobId
			   AND archGrpCopyId = @i_copyId
			   AND commCellId = @i_commCellId
			   AND status IN (100,102,103)
AND (disabled & 256) = 0
AND (disabled & (8192 | 1)) != (8192 | 1))
	BEGIN
UPDATE JMJobDataStats SET archCheckStatus = @i_status, modifiedTime = @l_now, disabled  = (disabled  & ~2048)
		WHERE  jobId = @i_jobId
		   AND archGrpCopyId = @i_copyId
		   AND commCellId = @i_commCellId
		SET @o_retVal = @@ERROR
		IF @o_retVal != 0 GOTO CX_EXIT
		UPDATE archChunkMapping SET flags = ((flags & @i_reset) | @i_flags)
		WHERE  archCopyId = @i_copyId AND commCellId = @i_commCellId AND archFileId IN (
				SELECT archFileId FROM archFileCopy WITH (READUNCOMMITTED)
				WHERE  archCopyId = @i_copyId AND commCellId = @i_commCellId AND archFileId IN (
						SELECT id
						FROM archFile AF WITH (READUNCOMMITTED)
						WHERE AF.jobId = @i_jobId
					AND   AF.commCellId = @i_commCellId AND (AF.isValid = 1 OR AF.appId IN (
							SELECT id FROM APP_Application WHERE appTypeId NOT IN
							(2,3,4,5,9,13,15,16,22,23,26,27,28,30,31,32,37,47,49,50,53,61,62,1000))) ))
		SET @o_retVal = @@ERROR
		IF @o_retVal != 0 GOTO CX_EXIT
		SET @l_opStatus = 1
	END
END
CX_EXIT:
IF (@o_retVal = 0)
	COMMIT TRANSACTION
ELSE
	ROLLBACK TRANSACTION
SELECT @o_retVal,@l_opStatus
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SetArchCheckStatusByJob')
	delete from GxQscripts where name = 'SetArchCheckStatusByJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SetArchCheckStatusByJob')
	delete from GXDBVersions where aliasname = 'SetArchCheckStatusByJob'
GO

insert into GXDBVersions values(2, 'SetArchCheckStatusByJob',  '00010013001200040000', 'SetArchCheckStatusByJob', '00010013001200040000')
GO

