

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SelectLinkedJobsForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SelectLinkedJobsForAuxCopy.sp,v $ $Id: SelectLinkedJobsForAuxCopy.sp,v 1.28.2.13 2020/03/04 06:29:06 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SelectLinkedJobsForAuxCopy')
BEGIN
	print '>>> Drop Stored Procedure: SelectLinkedJobsForAuxCopy <<<'
	drop procedure SelectLinkedJobsForAuxCopy
END
IF EXISTS (select * from GxQscripts where name='SelectLinkedJobsForAuxCopy')
	delete from GxQscripts where name = 'SelectLinkedJobsForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SelectLinkedJobsForAuxCopy')
	delete from GXDBVersions where aliasname = 'SelectLinkedJobsForAuxCopy'
GO
print '... Creating Procedure: SelectLinkedJobsForAuxCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SelectLinkedJobsForAuxCopy
  @i_archGroupId integer,
  @i_auxCopyId integer,
  @i_modifyTime integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @retVal = 0
IF	NOT EXISTS (SELECT * FROM archSelectiveCopy WITH (READUNCOMMITTED) WHERE copyId = @i_auxCopyId AND type IN (1,
10, 3, 2, 4, 6, 9))
BEGIN
   SELECT   @retVal
   RETURN   @retVal;
END
BEGIN TRANSACTION
CREATE TABLE #toBeCopiedChildJob (jobId INT,  commCellId INT, appId INT)
CREATE TABLE #toBeCopiedVSAParentJob (jobId INT, commCellId INT, appId INT)
CREATE TABLE #toBeCopiedFull (jobId INT, commCellId INT, appId INT, archGrpId INT, bkpLevle INT, fullCycleNum INT, servStartDate INT)
CREATE TABLE #toBeCopiedNonFullJob (jobId INT,  commCellId INT, appId INT)
DECLARE @SkipTransactionalLogs INT = 0
SET @SkipTransactionalLogs = ISNULL((SELECT VALUE FROM MMConfigs WHERE name = 'MMCONFIG_SKIP_AUXCOPY_TRANSACTIONAL_LOGS'),0)
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
	CREATE TABLE #tblSelectedJobs (jobId INTEGER, commcellId INTEGER, copyId INTEGER, dataType INTEGER)
CREATE INDEX Idx_tmptblSelectedJobs_1 ON #tblSelectedJobs (jobId, commcellId, copyId)
DECLARE @mirrorCopyIds TABLE(copyId integer)
INSERT INTO @mirrorCopyIds
SELECT id
FROM archgroupCopy WITH (READUNCOMMITTED) WHERE isMirrorCopy > 0 AND sourceCopyId = @i_auxCopyId
--This is a new change. JobSelectionType property should be set in the MMEntityProp table and value should correspond to the backuplevel
--FULL = 0x1,INCR = 0x2,DIFFERENTIAL = 0x4,ANYLEVEL = 0x8,SYNTHETIC_FULL = 0x40,INCR_NOTRUNC = 0x100,SYNTHETIC_FULL_AND_INCR = 0x80,ASR = 0x200,SEL_OFFLINE_FULL = 0x400,
--SNAPSHOTBKP = 0x800, CREATEREPLICABKP = 0x1000,SYNTHETIC_FULL_AND_INCR_BEFORE = 0x4000,SEL_ONLINE_FULL = 0x8000
DECLARE @NonFullBkpTypes INTEGER = 0
SELECT @NonFullBkpTypes = ISNULL(intVal, 0) FROM MMEntityProp WHERE propertyName = 'JobSelectionType' AND EntityType = 2 AND propDataType = 1 AND EntityId = @i_auxCopyId AND intVal <> 0
INSERT INTO #toBeCopiedChildJob
SELECT DISTINCT B.childJobId, B.commCellId, B.childAppid
FROM   JMJobDataStats JDS WITH (READUNCOMMITTED) INNER JOIN JMJobDataLinkViewForDA B WITH (READUNCOMMITTED) ON
JDS.jobId = B.parentJobId AND JDS.commCellId = B.commCellId AND JDS.appId = B.parentAppid
WHERE JDS.archGrpCopyId = @i_auxCopyId AND JDS.status IN (101, 102, 103) AND (JDS.disabled & (1 + 256)) = 0 AND (B.childJobId <> B.parentJobId)
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
DECLARE @srcCopy INT  = 0
SELECT @srcCopy = (CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId WHEN AGC.isSnapCopy > 0 THEN AG.defaultSnapCopy ELSE AG.defaultCopy END) FROM archGroup AG WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED) WHERE AG.id = AGC.archGroupId AND AGC.id = @i_auxCopyId
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
DELETE	#toBeCopiedChildJob
FROM	#toBeCopiedChildJob A
		LEFT OUTER JOIN JMJobDataStats J WITH (READUNCOMMITTED)
			ON	A.jobId = J.jobId AND A.commCellId = J.commCellId  AND J.archGrpCopyId = @srcCopy
				AND J.status IN (100, 101, 102, 103) AND (J.disabled & 1) = 0
WHERE J.jobId IS NULL
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
DELETE #toBeCopiedChildJob
FROM   #toBeCopiedChildJob A, JMJobDataStats J WITH (READUNCOMMITTED)
WHERE  A.jobId = J.jobId
AND J.archGrpCopyId = @i_auxCopyId
AND A.commCellId = J.commCellId
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT J.jobId, J.archGrpId, @i_auxCopyId, J.dataType, 13, 0, 101, 0, J.appId, J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM   #toBeCopiedChildJob A, JMJobDataStats J WITH (READUNCOMMITTED),APP_Application APP WITH (READUNCOMMITTED)
WHERE  A.jobId = J.jobId
AND J.archGrpCopyId = @srcCopy
AND A.commCellId = J.commCellId
AND J.status IN (100, 101, 102, 103)
AND J.appId = APP.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR APP.appTypeId != 81)
-- Selecting VSA Parent job
INSERT INTO #toBeCopiedVSAParentJob
SELECT DISTINCT B.parentJobId, B.commCellId, B.parentAppId
FROM   JMVSAAppJobLink B WITH (READUNCOMMITTED), JMJobDataStats JDS WITH (READUNCOMMITTED)
WHERE  (B.childJobId <> B.parentJobId)
		AND B.childJobId = JDS.JobId
		AND B.commCellId = JDS.CommCellId
		AND @i_auxCopyId = JDS.archGrpCopyId
		AND status IN (101, 102, 103) AND (disabled & (1 + 256)) = 0
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
DELETE #toBeCopiedVSAParentJob
FROM   #toBeCopiedVSAParentJob A LEFT OUTER JOIN JMJobDataStats J WITH (READUNCOMMITTED)
ON A.jobId = J.jobId AND A.commCellId = J.commCellId  AND J.archGrpCopyId = @srcCopy
	AND J.status IN (100, 101, 102, 103) AND (J.disabled & 1) = 0
WHERE J.jobId IS NULL
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
DELETE #toBeCopiedVSAParentJob
FROM   #toBeCopiedVSAParentJob A, JMJobDataStats J WITH (READUNCOMMITTED)
WHERE  A.jobId = J.jobId
AND J.archGrpCopyId = @i_auxCopyId
AND A.commCellId = J.commCellId
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT J.jobId, J.archGrpId, @i_auxCopyId, J.dataType, 13, 0, 101, 0, J.appId, J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM   #toBeCopiedVSAParentJob A, JMJobDataStats J WITH (READUNCOMMITTED), APP_Application APP WITH (READUNCOMMITTED)
WHERE  A.jobId = J.jobId
AND J.archGrpCopyId = @srcCopy
AND A.commCellId = J.commCellId
AND A.appId = J.appId
AND J.status IN (100, 101, 102, 103)
AND J.appId = APP.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR APP.appTypeId != 81)
IF @NonFullBkpTypes <> 0
BEGIN
	INSERT INTO #toBeCopiedFull
		SELECT DISTINCT JBS.jobId, JBS.commCellId, JBS.appId, JDS.archGrpId, JBS.bkpLevel, JBS.fullCycleNum, JBS.servStartDate
		FROM   JMJobDataStats JDS WITH (READUNCOMMITTED)
		INNER JOIN JMBkpStats JBS WITH (NOLOCK)
		ON JDS.jobid = JBS.jobId
		AND JDS.commcellId = JBS.commcellId
		WHERE
		JBS.bkpLevel in (1, 64, 128, 16384, 1024, 32768) AND
		JDS.archGrpCopyId = @i_auxCopyId AND JDS.status IN (101, 102, 103) AND (JDS.disabled & (1 + 256)) = 0
	--Figure out the corresponding incrementals for the above full jobs
	INSERT INTO #toBeCopiedNonFullJob
		SELECT JBS.jobid, JBS.commcellId, JBS.appId
		FROM JMBkpStats JBS WITH (NOLOCK)
		INNER JOIN #toBeCopiedFull TCF
		ON TCF.appId = JBS.appId AND
		TCF.commcellId = JBS.commcellId AND
		TCF.fullCycleNum = JBS.fullCycleNum
		WHERE
		( (@NonFullBkpTypes = 1 AND ((JBS.bkpLevel & 4) <> 0 )) OR (@NonFullBkpTypes = 2 and (JBS.bkpLevel not in (1, 64, 128, 16384, 1024, 32768))))
	INSERT INTO JMJobDataStats
	OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
	INTO #tblSelectedJobs
		SELECT J.jobId, J.archGrpId, @i_auxCopyId, J.dataType, 13, 0, 101, 0, J.appId, J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
		FROM   #toBeCopiedNonFullJob A, JMJobDataStats J WITH (READUNCOMMITTED), APP_Application APP WITH (READUNCOMMITTED)
		WHERE  A.jobId = J.jobId
		AND J.archGrpCopyId = @srcCopy
		AND A.commCellId = J.commCellId
		AND A.appId = J.appId
		AND NOT EXISTS (SELECT 1 FROM JMJobDataStats WHERE archGrpCopyId = @i_auxCopyId AND commcellId = A.commCellId AND jobid = A.jobId)
		AND J.status IN (100, 101, 102, 103)
		AND J.appId = APP.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR APP.appTypeId != 81)
END
IF EXISTS (SELECT 1 FROM @mirrorCopyIds)
BEGIN
UPDATE JMJobDataStats SET disabled = (disabled & ~1), modifiedTime = @i_modifyTime
	FROM JMJobDataStats jds, @mirrorCopyIds c, #tblSelectedJobs tjobs
	WHERE tjobs.jobId = jds.jobId  AND jds.commCellId = tjobs.commCellId AND jds.archGrpCopyId = c.copyId
	SET @retVal = @@ERROR
	INSERT INTO JMJobDataStats
		SELECT  DISTINCT jds.jobId, jds.archGrpId, c.copyId, jds.dataType, 13, 0, 101, 0, jds.appId, jds.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
		FROM   JMJobDataStats jds,APP_Application A WITH (READUNCOMMITTED), #tblSelectedJobs tjobs,@mirrorCopyIds c
		WHERE  jds.jobId = tjobs.jobId AND jds.archGrpCopyId = tjobs.copyID AND jds.commCellId = tjobs.commcellId
				AND jds.dataType = tjobs.dataType
				AND NOT EXISTS (SELECT 1 FROM JMJobDataStats dest WHERE dest.jobID = tjobs.jobId AND dest.dataType = tjobs.dataType AND dest.archGrpCopyId = c.CopyId)
				AND J.appId = A.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR A.appTypeId != 81)
	SET @retVal = @@ERROR
END
--Apply job retention option (if applicable)
EXEC archPinJobsBasedOnJobOption 0
RETURN_PROC:
if (OBJECT_ID('tempdb.dbo.#toBeCopiedChildJob') IS NOT NULL) DROP TABLE #toBeCopiedChildJob
if (OBJECT_ID('tempdb.dbo.#toBeCopiedFull') IS NOT NULL) DROP TABLE #toBeCopiedFull
if (OBJECT_ID('tempdb.dbo.#toBeCopiedNonFullJob') IS NOT NULL) DROP TABLE #toBeCopiedNonFullJob
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
IF @retVal = 0
   COMMIT   TRANSACTION
IF @retVal <> 0
   ROLLBACK TRANSACTION
SELECT   @retVal
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'SelectLinkedJobsForAuxCopy')
	delete from GxQscripts where name = 'SelectLinkedJobsForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SelectLinkedJobsForAuxCopy')
	delete from GXDBVersions where aliasname = 'SelectLinkedJobsForAuxCopy'
GO

insert into GXDBVersions values(2, 'SelectLinkedJobsForAuxCopy',  '00010028000200130000', 'SelectLinkedJobsForAuxCopy', '00010028000200130000')
GO

