

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SelectLastFullForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SelectLastFullForAuxCopy.sp,v $ $Id: SelectLastFullForAuxCopy.sp,v 1.80.12.33 2020/12/17 12:13:09 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SelectLastFullForAuxCopy')
BEGIN
	print '>>> Drop Stored Procedure: SelectLastFullForAuxCopy <<<'
	drop procedure SelectLastFullForAuxCopy
END
IF EXISTS (select * from GxQscripts where name='SelectLastFullForAuxCopy')
	delete from GxQscripts where name = 'SelectLastFullForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SelectLastFullForAuxCopy')
	delete from GXDBVersions where aliasname = 'SelectLastFullForAuxCopy'
GO
print '... Creating Procedure: SelectLastFullForAuxCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SelectLastFullForAuxCopy
  @i_auxCopyId integer,
  @i_modifyTime integer
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF NOT EXISTS (SELECT * FROM archSelectiveCopy WITH (NOLOCK) WHERE copyId = @i_auxCopyId AND type = 8)
BEGIN
   SET		@retVal = @@ERROR
   SELECT	@retVal
   RETURN	@retVal;
END
DECLARE	@ORACLE_RMAN_CUSTOMSCRIPT_BKP	BIGINT
SET		@ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0x2000000000000
DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
DECLARE @i_commCellId   INTEGER
DECLARE @t_spId			INTEGER
DECLARE @t_spFlags		INTEGER
DECLARE @t_defCopyId	INTEGER
DECLARE @t_srcCopyId	INTEGER
DECLARE @t_isSnapCopy	INTEGER
DECLARE @t_isMirrorCopy	INTEGER
DECLARE @t_flags		INTEGER
DECLARE @t_extendedFlags	INTEGER
DECLARE @t_startTime	INTEGER
DECLARE @t_endTime	INTEGER
SET		@i_commCellId = 2
IF EXISTS (	SELECT	*
			FROM	MMEntityProp WITH (NOLOCK)
			WHERE	EntityId = @i_auxCopyId AND EntityType = 2 AND propertyName = 'DisablePreviousJobsOnNewFull' AND propDataType = 1 AND CommCellId = 2 AND intVal = 1)
BEGIN
	EXEC @retVal = SelectLastFullForAuxCopyV2 @i_auxCopyId, @i_modifyTime, 1
	RETURN @retVal
END
CREATE TABLE #lastFull (appId INT, jobId INT)
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
	CREATE TABLE #tblSelectedJobs (jobId INTEGER, commcellId INTEGER, copyId INTEGER, dataType INTEGER)
CREATE INDEX Idx_tmptblSelectedJobs_1 ON #tblSelectedJobs (jobId, commcellId, copyId)
IF OBJECT_ID('tempdb.dbo.#archCopyToAppId') IS NOT NULL DROP TABLE #archCopyToAppId
CREATE TABLE #archCopyToAppId (
copyId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
DECLARE @SkipTransactionalLogs INT = 0
SET @SkipTransactionalLogs = ISNULL((SELECT VALUE FROM MMConfigs WHERE name = 'MMCONFIG_SKIP_AUXCOPY_TRANSACTIONAL_LOGS'),0)
DECLARE @mirrorCopyIds TABLE(copyId integer)
INSERT INTO @mirrorCopyIds
SELECT id
FROM archgroupCopy WITH (READUNCOMMITTED) WHERE isMirrorCopy > 0 AND sourceCopyId = @i_auxCopyId
SELECT	@t_defCopyId = (case when AGC.isSnapCopy = 0 then AG.defaultCopy else AG.defaultSnapCopy end),
		@t_spId = AGC.archGroupId, @t_spFlags = AG.flags, @t_flags = AGC.flags, @t_extendedFlags = extendedFlags,
		@t_srcCopyId = (case when AGC.sourceCopyId > 0 then AGC.sourceCopyId
							 when AGC.isSnapCopy = 0 then AG.defaultCopy
							 else AG.defaultSnapCopy end),
		@t_isSnapCopy = AGC.isSnapCopy,
		@t_isMirrorCopy = AGC.isMirrorCopy,
		@t_startTime = AGC.startTime,
		@t_endTime = AGC.endTime
FROM	archGroupCopy AGC WITH (NOLOCK), archGroup AG WITH (NOLOCK)
WHERE	AGC.id = @i_auxCopyId AND AG.id = AGC.archGroupId
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
DECLARE @l_AllowOracleSAPRegularFull INT = 0
SELECT @l_AllowOracleSAPRegularFull = isnull(value, 1)
FROM MMConfigs WITH(NOLOCK)
WHERE name = 'DA_CONFIG_HONOR_EXTENDED_RETENTION_FOR_ORACLE_SAP_REGULAR_FULL_JOBS'
BEGIN TRANSACTION
IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL
	DROP TABLE #tmpAppIdList
CREATE TABLE #tmpAppIdList(appId int, unSupportedAlways int, unSupportedOnSelAlways int, unSupportedDB int, isCWEjobValid int, Primary Key(appId))
INSERT INTO #tmpAppIdList
SELECT DISTINCT JBKP.appId, 0, 0, 0, 0
FROM JMBkpStats JBKP WITH(NOLOCK)
WHERE (JBKP.dataArchGrpId = @t_spId OR JBKP.logArchGrpId = @t_spId) AND JBKP.commCellId = @i_commCellId
--Set unsupported flag
EXEC ArchIsAuxiliaryCopySupportedForSubclient 0
--Jobs of subclients not in this table will be skipped
DELETE #tmpAppIdList WHERE unSupportedAlways > 0 OR unSupportedOnSelAlways > 0
INSERT	INTO #lastFull
SELECT	J.appId, MAX(J.jobId)
FROM	JMBkpStats J WITH (NOLOCK) INNER JOIN JMJobStats JS WITH (NOLOCK) ON J.JobId = JS.JobId AND J.CommCellId = JS.commCellId
		INNER JOIN #tmpAppIdList T ON J.appId = T.appId
WHERE	(J.dataArchGrpId = @t_spId OR J.logArchGrpId = @t_spId) AND J.commCellId = @i_commCellId
	AND (J.status IN (1, 14) OR J.status = 3 AND T.isCWEjobValid = 1)
	AND (J.OpType != 60) -- enum CVOpType { SNAPTOTAPE = 60}
	AND (JS.SubOpType != 96) -- enum CVOpType { DELAYEDCATALOG = 96}
	AND (J.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) OR dbo.GetBkpLevelOfSnapJobs(J.JobId, J.CommCellId, @i_auxCopyId) = 1 )
	AND J.servStartDate >= @t_startTime
	AND J.servStartDate < @t_endTime
	-- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle
	AND (
J.appType NOT IN (2, 22, 23, 80,
61, 79)
		OR J.bkpLevel IN (1024, 32768)
OR (J.openChain = 0 AND (J.bkpAttributes & 0x1000) <> 0 AND @l_AllowOracleSAPRegularFull = 1 AND T.unSupportedDB = 0 /*AND J.bkpAttributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0*/)
		)
	-- Only take FULL with data for SAP, Informix and DB2
AND (J.appType NOT IN (3, 5, 37, 62, 103, 128, 135) OR
J.openChain = 0 AND ((J.bkpAttributes & 0x1000) <> 0 OR J.appType IN (5, 135)))
	AND (@t_isSnapCopy = 0 OR EXISTS (SELECT	*
				FROM	SMVolume V WITH (READUNCOMMITTED), SMVolSnapMap VS WITH (READUNCOMMITTED), SMSnap S WITH (READUNCOMMITTED), SMSnapShotEngine E WITH (READUNCOMMITTED)
				WHERE	V.jobId = J.JobId AND V.commCellId = J.CommCellId
					AND VS.SMVolumeId = V.SMVolumeId AND S.SMSnapId = VS.SMSnapId
					AND S.SnapShotEngineId = E.SnapShotEngineId
AND (((@t_extendedFlags & (256 | 512)) = 0 AND (S.SnapShotEngineId = 3 OR S.SnapShotEngineId = 48))
OR (@t_isMirrorCopy = 0 AND (@t_extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 268435456
AND	(((@t_extendedFlags & 524288) = 524288) OR ((E.Capabilities & CAST(4294967296 AS BIGINT)) = CAST(4294967296 AS BIGINT)))
AND	((@t_srcCopyId = @t_defCopyId) OR ((E.Capabilities & CAST(34359738368 AS BIGINT)) = CAST(34359738368 AS BIGINT))))
OR (@t_isMirrorCopy = 1 AND (@t_extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 1073741824) = 1073741824
AND	(((@t_extendedFlags & 524288) = 524288) OR ((E.Capabilities & CAST(4294967296 AS BIGINT)) = CAST(4294967296 AS BIGINT)))
AND	((@t_srcCopyId = @t_defCopyId) OR ((E.Capabilities & CAST(34359738368 AS BIGINT)) = CAST(34359738368 AS BIGINT))))
						)))
	-- Index copy jobs do not insert into any destination copy for auxcopy
	AND (J.bkpAttributesEx & CAST(0x1000000000000 AS BIGINT)) = 0 --JMBKP_EX_BLR_INDEX_COPY_JOB
	-- Only take FULL with Attribute [JMBKP_EX_FULL_JOB_IN_CYCLE] for app aware app backups
	AND (
				(J.bkpAttributesEx & @EX_APPAWARE_CHILD_JOB = 0)
				OR
				(J.bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE > 0)
			)
GROUP BY J.appId
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
IF (@t_isSnapCopy = 1)
BEGIN
	DELETE	#lastFull
	FROM	#lastFull T,
			JMVSAAppJobLink J WITH (READUNCOMMITTED)
				LEFT OUTER JOIN  SMVolume V WITH (READUNCOMMITTED)
					ON V.jobId = J.parentJobId -- AND V.commCellId = @i_commCellId
				LEFT OUTER JOIN SMVolSnapMap VS WITH (READUNCOMMITTED)
					ON VS.SMVolumeId = V.SMVolumeId
				LEFT OUTER JOIN SMSnap S WITH (READUNCOMMITTED)
					ON S.SMSnapId = VS.SMSnapId
				LEFT OUTER JOIN SMSnapShotEngine E WITH (READUNCOMMITTED)
					ON S.SnapShotEngineId = E.SnapShotEngineId
	WHERE	J.childJobId = T.JobId -- AND J.commCellId = @i_commCellId
			AND NOT EXISTS (SELECT * FROM JMJobDataStats JDS WHERE JDS.JobId = J.ParentJobId AND JDS.CommCellId = @i_commCellId AND JDS.archGrpCopyId = @i_auxCopyId AND JDS.dataType != 6 AND JDS.Status != 100)
			-- AND NOT EXISTS (SELECT TOP 1 SMVolumeID FROM SMVolume V2 WITH (READUNCOMMITTED) WHERE V2.jobId = J.parentJobId AND V2.commCellId = @i_commCellId AND V2.CopyId = @i_auxCopyId)
			AND (V.SMVolumeId IS NULL
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @t_isMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( @t_extendedFlags & (256 | 512 | 524288)) = (256 | 512) AND (E.Capabilities & CAST(4294967296 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @t_srcCopyId != @t_defCopyId AND (E.Capabilities & CAST(34359738368 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = 256)
OR (( @t_extendedFlags & (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3))))
	SET @retVal = @@ERROR
	IF	@retVal <> 0	GOTO RETURN_PROC
END
INSERT	INTO #lastFull
SELECT	J.appId, MAX(J.jobId)
FROM	JMAdminJobStatsTable J WITH (NOLOCK), APP_iDAType I WITH (NOLOCK), APP_Application A WITH (NOLOCK)
WHERE	I.type = A.appTypeId AND A.id = J.appId
	AND J.opType IN (11, 64) AND J.archGrpID = @t_spId AND J.commCellId = @i_commCellId -- enum CVOpType{ INFOMGMT = 64 CSDRBKP = 11
	AND (J.status IN (1, 14) OR J.status = 3 AND I.isCWEjobValid = 1) AND J.ER_BkpLevel = 1
	AND J.servStart >= @t_startTime
	AND J.servStart < @t_endTime
GROUP BY J.appId
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
-- Remove jobs if the subclient is not associated to the selective copy
IF	EXISTS (SELECT 1 FROM archCopyToApp WITH (NOLOCK) WHERE copyId = @i_auxCopyId AND assocType <> 2)
BEGIN
	INSERT INTO #archCopyToAppId
	SELECT DISTINCT @i_auxCopyId , appId
	FROM #lastFull
	EXEC archGetArchCopyToAppAssociations @i_auxCopyId
	DELETE	#lastFull
	FROM	#lastFull LF LEFT JOIN #archCopyToAppId t ON t.appId = LF.appId
	WHERE	t.appId IS NULL
END
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
-- Remove jobs which are not selected to the source copy or disabled or pruned
/* Instead of deleting jobs which has uncopyable datatype delete jobs which does not have at least one copyable data
DELETE	#lastFull
FROM	#lastFull A, JMJobDataStats B WITH (NOLOCK)
WHERE	B.jobId = A.jobId AND B.archGrpCopyId = @t_srcCopyId AND B.commCellId = @i_commCellId
AND (B.status NOT IN (100, 101, 102, 103) OR B.disabled & (1 + 256) <> 0)
*/
DELETE	#lastFull
FROM	#lastFull A LEFT OUTER JOIN JMJobDataStats B WITH (NOLOCK)
ON	B.jobId = A.jobId AND B.commCellId = @i_commCellId AND B.archGrpCopyId = @t_srcCopyId
AND B.status IN (100, 101, 102, 103) AND B.disabled & (1 + 256) = 0
WHERE B.jobId IS NULL
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
INSERT	INTO #lastFull
SELECT	A.childAppid, A.childJobId
FROM	JMJobDataLinkViewForDA A WITH (NOLOCK), #lastFull B
WHERE	A.parentJobId <> A.childJobId AND A.parentJobId = B.jobId AND A.commCellId = @i_commCellId
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
INSERT	INTO #lastFull
SELECT	DISTINCT A.parentAppId, A.parentJobId
FROM	JMVSAAppJobLink A WITH (NOLOCK), #lastFull B
WHERE	A.parentJobId <> A.childJobId AND A.childJobId = B.jobId AND A.commCellId = @i_commCellId
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
DELETE	#lastFull
FROM	#lastFull A, JMJobDataStats B WITH (NOLOCK)
WHERE	B.jobId = A.jobId AND B.archGrpCopyId = @i_auxCopyId AND B.commCellId = @i_commCellId
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
INSERT	INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT	J.jobId, J.archGrpId, @i_auxCopyId, J.dataType, 13, 0, 101, 0, J.appId, J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM	JMJobDataStats J, APP_Application A WITH (READUNCOMMITTED),
		(SELECT DISTINCT JobID
		FROM	#lastFull) T
WHERE	J.jobId = T.jobId AND J.archGrpCopyId = @t_srcCopyId AND J.commCellId = @i_commCellId
AND J.status IN (100, 101, 102, 103)
	AND J.appId = A.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR A.appTypeId != 81)
SET @retVal = @@ERROR
IF	@retVal <> 0	GOTO RETURN_PROC
IF @retVal = 0 AND EXISTS (SELECT 1 FROM @mirrorCopyIds)
BEGIN
UPDATE JMJobDataStats SET disabled = (disabled & ~1), modifiedTime = @i_modifyTime
	FROM JMJobDataStats jds, @mirrorCopyIds c, #tblSelectedJobs tjobs
	WHERE tjobs.jobId = jds.jobId  AND jds.commCellId = tjobs.commCellId AND jds.archGrpCopyId = c.copyId
	SET @retVal = @@ERROR
	INSERT INTO JMJobDataStats
		SELECT  DISTINCT jds.jobId, jds.archGrpId, c.copyId, jds.dataType, 13, 0, 101, 0, jds.appId, jds.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
		FROM   JMJobDataStats jds, APP_Application A WITH (READUNCOMMITTED), #tblSelectedJobs tjobs,@mirrorCopyIds c
		WHERE  jds.jobId = tjobs.jobId AND jds.archGrpCopyId = tjobs.copyID AND jds.commCellId = tjobs.commcellId
				AND jds.dataType = tjobs.dataType
				AND NOT EXISTS (SELECT 1 FROM JMJobDataStats dest WHERE dest.jobID = tjobs.jobId AND dest.dataType = tjobs.dataType AND dest.archGrpCopyId = c.CopyId)
			AND jds.appId = A.id
AND (@SkipTransactionalLogs = 0 OR jds.dataType != 4 OR A.appTypeId != 81)
	SET @retVal = @@ERROR
END
--Apply job retention option (if applicable)
EXEC archPinJobsBasedOnJobOption 0
RETURN_PROC:
if (OBJECT_ID('tempdb.dbo.#lastFull') IS NOT NULL) DROP TABLE #lastFull
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL
	DROP TABLE #tmpAppIdList
IF OBJECT_ID('tempdb.dbo.#archCopyToAppId') IS NOT NULL DROP TABLE #archCopyToAppId
IF @retVal = 0
   COMMIT   TRANSACTION
ELSE
   ROLLBACK TRANSACTION
SELECT   @retVal
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'SelectLastFullForAuxCopy')
	delete from GxQscripts where name = 'SelectLastFullForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SelectLastFullForAuxCopy')
	delete from GXDBVersions where aliasname = 'SelectLastFullForAuxCopy'
GO

insert into GXDBVersions values(2, 'SelectLastFullForAuxCopy',  '00010080001200330000', 'SelectLastFullForAuxCopy', '00010080001200330000')
GO

