

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SelectJobForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SelectJobForAuxCopy.sp,v $ $Id: SelectJobForAuxCopy.sp,v 1.150.2.44 2020/12/17 12:13:12 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SelectJobForAuxCopy')
BEGIN
	print '>>> Drop Stored Procedure: SelectJobForAuxCopy <<<'
	drop procedure SelectJobForAuxCopy
END
IF EXISTS (select * from GxQscripts where name='SelectJobForAuxCopy')
	delete from GxQscripts where name = 'SelectJobForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SelectJobForAuxCopy')
	delete from GXDBVersions where aliasname = 'SelectJobForAuxCopy'
GO
print '... Creating Procedure: SelectJobForAuxCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SelectJobForAuxCopy
  @i_jobId integer,
  @i_appId integer,
  @i_appType integer,
  @i_startDate integer,
  @i_backupLevel integer,
  @i_fullCycleNum integer,
  @i_nextFullTime integer,
  @i_today integer,
  @i_modifyTime integer
AS
  DECLARE @o_retVal INTEGER;
  DECLARE @o_jobId INTEGER;
  DECLARE @o_commcellId INTEGER;
  DECLARE @o_copyId INTEGER;
  DECLARE @o_dataType INTEGER;
  DECLARE @o_isSelectiveCopy INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_retVal = 0
CREATE TABLE #tempCopy(archGroupId int, copyId int, type int, startTime int, flags int, extendedFlags bigint, isSnapCopy int, isMirrorCopy int,
                       sourceCopyId int, defaultCopyId int, defaultSnapCopyId int, archGroupFlags int,
                       selectionType int, numPeriod int, dayNumber int, startPeriod int, nextPeriod int,
                       prevPeriodBegin int, nextPeriodEnd int, TimeZoneType int, nextFullTime int, endTime int)
CREATE TABLE #tempJobDataStats(archGrpId int, archGrpCopyId int, dataType int, status int, disabled int)
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
	CREATE TABLE #tblSelectedJobs (jobId INTEGER, commcellId INTEGER, copyId INTEGER, dataType INTEGER)
CREATE INDEX Idx_tmptblSelectedJobs_1 ON #tblSelectedJobs (jobId, commcellId, copyId)
IF OBJECT_ID('tempdb..#TM_GetNextScheduleRunTimeResultTable') IS NOT NULL DROP TABLE #TM_GetNextScheduleRunTimeResultTable
CREATE TABLE #TM_GetNextScheduleRunTimeResultTable (nextRunTime INTEGER)
if object_id('tempdb.dbo.#copyIdToProcess') is not null DROP TABLE #copyIdToProcess
CREATE TABLE #copyIdToProcess ( copyId  INTEGER,  isExclusionList INTEGER  DEFAULT(0), srcCopyId INTEGER DEFAULT(0) primary key 	(copyId))
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
CREATE TABLE #archCopyToAppId (
copyId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
DECLARE	@ORACLE_RMAN_CUSTOMSCRIPT_BKP	BIGINT
SET		@ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0x2000000000000
DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
DECLARE @i_commCellId   INTEGER
SET		@i_commCellId	= 2
DECLARE	@now INT
SET		@now = dbo.GetUnixTime(GETUTCDATE())
DECLARE @l_TimeZone		VARCHAR(255)
DECLARE @l_csTimeZone	VARCHAR(255)
SET		@l_TimeZone		= ''
SET		@l_csTimeZone	= ''
DECLARE	@l_numOfAF		INT = 0
DECLARE	@l_hasDataAF	INT = 0
DECLARE	@l_isSnapJob	INT = 0
DECLARE @CountPartialSuccess INT
SET		@CountPartialSuccess = 1
SELECT	@CountPartialSuccess = isCWEjobValid
FROM	APP_iDAType WITH (NOLOCK)
WHERE	type = @i_appType
DECLARE	@l_status		 INT = 0
DECLARE	@l_bkpAttributes BIGINT = 0
DECLARE	@l_bkpAttributesEx BIGINT = 0
DECLARE	@l_openChain	 INT = 0
--DECLARE @l_snapJobOfDelayedCatalogJob INT = 0 --For delayed catalog
DECLARE @l_isDeferredCatalogJob INT = 0 --For delayed catalog
DECLARE @l_deferredCatalogFileTypes TABLE(fileType INTEGER)
DECLARE	@l_nextFullTimeForSnap	 INT = 0
DECLARE @SkipTransactionalLogs INT = 0
DECLARE @parentAppID BIGINT = 0
SET @SkipTransactionalLogs = ISNULL((SELECT VALUE FROM MMConfigs WHERE name = 'MMCONFIG_SKIP_AUXCOPY_TRANSACTIONAL_LOGS'),0)
DECLARE @l_opType int = 0
select @i_startDate = servStartDate FROM JMBkpStats WITH (NOLOCK) where jobId = @i_jobId AND commCellId = @i_commCellId
IF @@ROWCOUNT = 0
	select @i_startDate = servStart FROM JMAdminJobStatsTable WITH (NOLOCK) where jobId = @i_jobId AND commCellId = @i_commCellId
IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL
	DROP TABLE #tmpAppIdList
CREATE TABLE #tmpAppIdList(appId int, unSupportedAlways int, unSupportedOnSelAlways int, unSupportedDB int, isCWEjobValid int, Primary Key(appId))
INSERT INTO #tmpAppIdList
SELECT @i_appId, 0, 0, 0, 0
--Set unsupported flag
EXEC ArchIsAuxiliaryCopySupportedForSubclient 0
/*
DECLARE @isEdgeDriveSubClient INT = 0
DECLARE @isCmdLineSubclient INT = 0
DECLARE @isOracleOnDemandSubclient INT = 0
DECLARE @isLogCmdLineSubclient INT = 0
SELECT @isEdgeDriveSubClient = CASE WHEN App.subclientStatus & 0x20000 = 0x20000 THEN 1 ELSE 0 END,
@isCmdLineSubclient = CASE WHEN App.subclientStatus & 0x0040 = 0x0040 THEN 1 ELSE 0 END,
@isOracleOnDemandSubclient = CASE WHEN Ins.Status & 0x0800 = 0x0800 THEN 1 ELSE 0 END,
@isLogCmdLineSubclient = CASE WHEN App.subclientStatus & 0x1000 = 0x1000 THEN 1 ELSE 0 END
FROM App_Application App WITH(NOLOCK) INNER JOIN App_InstanceName Ins WITH(NOLOCK) ON App.instance = Ins.id
WHERE App.id = @i_appId
*/
DECLARE @isIndexSubclient INT = 0
DECLARE @l_checkSumIndexSubclient INT = CHECKSUM(N'Index SubClient')
SELECT @isIndexSubclient = 1 FROM
App_SubclientProp WITH(NOLOCK) WHERE componentNameId = @i_appId AND cs_attrName = @l_checkSumIndexSubclient
AND attrName = 'Index SubClient' AND attrVal = N'1' AND modified = 0
DECLARE @l_AllowOracleSAPRegularFull INT = 0
SELECT @l_AllowOracleSAPRegularFull = isnull(value, 1)
FROM MMConfigs WITH(NOLOCK)
WHERE name = 'DA_CONFIG_HONOR_EXTENDED_RETENTION_FOR_ORACLE_SAP_REGULAR_FULL_JOBS'
SELECT @l_status = status, @l_bkpAttributes = bkpAttributes, @l_openChain = openChain, @l_bkpAttributesEx = bkpAttributesEx
FROM	JMBkpStats WITH (NOLOCK)
WHERE	jobId = @i_jobId AND commCellId = 2
IF(@l_status = 0) --If row not found in JMBkpStats querying JMAdminJobStatsTable for DR backup, Erase data job, Legalhold jobs which doesn't require openChain and bkpAttributes info
BEGIN
	SELECT @l_status = status, @l_opType = opType
	FROM JMAdminJobStatsTable WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = 2
END
--Delayed catalog
--JM Passes actual snap job that is being cataloged. So we need to check JM tables to know if this is deferred catalog job and handle snap job selection accordingly
IF EXISTS (SELECT 1 FROM JMJobInfo rj WITH (NOLOCK) inner join JMJobWF jwf WITH (NOLOCK)
		ON rj.subOpType = 96/*enum CVOpType {DELAYEDCATALOG = 96,};*/ AND rj.jobId = jwf.childJobId AND rj.commCellId = jwf.commcellId AND jwf.processedJobId = @i_jobId AND jwf.processedCommcellId = @i_commCellId)
BEGIN
	SET @l_isDeferredCatalogJob = 1
	/*
	For deferred catalog on V2 indexing we do not have to process the job for selection since the job already has the bcd index archive file processed for auxcopy.
	Only on V1 we need this becuase the bcd index archive file (file type - 6) gets created for the first time.
	In V2 case we just have to mark the file type to be recopied on the existing copies on which it was copied. That is taken care in ArchJobDataStatsCreate.
	*/
	IF(@l_isDeferredCatalogJob = 1 AND dbo.IsIndexingV2Enabled(0, 0, @i_appId) = 1)
		GOTO RETURN_PROC
	INSERT INTO @l_deferredCatalogFileTypes
SELECT 6
END
ELSE IF EXISTS (SELECT 1
				FROM JMJobInfo J WITH (READUNCOMMITTED)
				WHERE	J.JobId IN (SELECT	attributeValueInt
									FROM	JmJobOptions JO WITH (READUNCOMMITTED)
									WHERE	JO.JobId = @i_jobId AND JO.CommCellId = @i_commCellId AND JO.attributeId=92  /*JMCATALOG_JOB_ID_FOR_BKP_JOB*/))
BEGIN
	SET @l_isDeferredCatalogJob = 1
	INSERT INTO @l_deferredCatalogFileTypes
SELECT 9
END
/* --Commenting this out because this was with earlier behavior where JM passed the job Id of deferred catalog instead of actual snap job being cataloged. Now the JM behavior is modified
IF EXISTS (SELECT  * FROM JMJobInfo WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_commCellId AND subOpType = 96) --enum CVOpType {DELAYEDCATALOG = 96,};
OR EXISTS (SELECT * FROM JMJobStats WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_commCellId AND subOpType = 96)
	SELECT @l_snapJobOfDelayedCatalogJob = processedJobId FROM JMJobWF WITH (NOLOCK) WHERE childJobId = @i_jobId AND commcellId = @i_commCellId
--If it is delayed catalog job then we are going to use the actual snap jobid as the jobId and we'll be processing only bcd index AFs
IF @l_snapJobOfDelayedCatalogJob > 0
	SET @i_jobId = @l_snapJobOfDelayedCatalogJob
*/
INSERT INTO #tempJobDataStats
SELECT archGrpId, archGrpCopyId, dataType, status, disabled
FROM   JMJobDataStats WITH (NOLOCK)
WHERE  jobId = @i_jobId AND commCellId = @i_commCellId AND status IN (100, 101, 102, 103) AND (disabled & 1) = 0
AND (@l_isDeferredCatalogJob = 0 OR (@l_isDeferredCatalogJob <> 0 AND dataType IN (SELECT fileType FROM @l_deferredCatalogFileTypes)))
IF @@ROWCOUNT = 0
   GOTO RETURN_PROC
SELECT	@l_numOfAF = COUNT(id), @l_hasDataAF = MIN(fileType), @l_isSnapJob = MAX(flags & 2)
FROM	archFile WITH (NOLOCK)
WHERE	jobId = @i_jobId AND commCellId = @i_commCellId AND isValid = 1
IF	@l_numOfAF = 0
	GOTO RETURN_PROC
IF	@l_hasDataAF <> 1
	SET @l_hasDataAF = 0
DECLARE @l_archGroupId	INTEGER
SELECT TOP 1 @l_archGroupId = archGrpId FROM #tempJobDataStats
DECLARE @l_defCopyId		INTEGER
DECLARE @l_defSnapCopyId	INTEGER
SELECT	@l_defCopyId = defaultCopy, @l_defSnapCopyId = defaultSnapCopy
FROM	archGroup WITH (NOLOCK)
WHERE	id = @l_archGroupId
DECLARE @l_inPrimaryCopy	INTEGER = 0
IF	EXISTS (SELECT * FROM #tempJobDataStats
			WHERE	archGrpCopyId = @l_defCopyId
AND	status = 100 AND disabled & (1 | 256) = 0)
	SET	@l_inPrimaryCopy = 1
BEGIN TRY
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT	DISTINCT J.jobId, J.archGrpId, C.id, J.dataType, 13, 0, 101, 0, J.appId,
		J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM	JMVSAAppJobLink A WITH (NOLOCK), JMJobDataStats J WITH (READUNCOMMITTED), archGroupCopy C WITH (NOLOCK), APP_Application APP WITH (READUNCOMMITTED)
WHERE	(A.childJobId <> A.parentJobId)
	AND A.parentJobId = @i_jobId
	AND J.jobId = @i_jobId
AND J.status IN(100, 101, 102, 103) AND (J.disabled & 1) = 0
	AND A.commCellId = @i_commCellId AND J.commCellId = @i_commCellId
	AND (C.isSnapCopy = 0 AND J.archGrpCopyId = @l_defCopyId AND (@l_isSnapJob = 0 OR @l_inPrimaryCopy <> 0)
	  OR C.isSnapCopy <> 0 AND J.archGrpCopyId = @l_defSnapCopyId AND @l_isSnapJob <> 0)
AND C.type = 2 -- AND (C.flags & CVA_INLINE_AUXCOPY_FLAG) = 0
	AND EXISTS (SELECT * FROM JMJobDataStats JDS WITH (READUNCOMMITTED)
				WHERE JDS.jobId = A.childJobId AND JDS.commCellId = @i_commCellId AND JDS.archGrpCopyId = C.id)
	AND NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) WHERE JDS.jobId = J.jobId AND JDS.commcellId = J.commCellId AND JDS.archGrpCopyId = C.id AND JDS.dataType = J.dataType)
	AND J.appId = APP.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR APP.appTypeId != 81)
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT	DISTINCT J.jobId, J.archGrpId, C.id, J.dataType, 13, 0, 101, 0, J.appId,
		J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM	JMJobDataLinkViewForDA A WITH (NOLOCK), JMJobDataStats J WITH (READUNCOMMITTED), archGroupCopy C WITH (NOLOCK), APP_Application APP WITH (READUNCOMMITTED)
WHERE	(A.childJobId <> A.parentJobId)
	AND A.childJobId = @i_jobId
	AND J.jobId = @i_jobId
AND J.status IN(100, 101, 102, 103) AND (J.disabled & 1) = 0
	AND A.commCellId = @i_commCellId AND J.commCellId = @i_commCellId
	AND (C.isSnapCopy = 0 AND J.archGrpCopyId = @l_defCopyId AND (@l_isSnapJob = 0 OR @l_inPrimaryCopy <> 0)
	  OR C.isSnapCopy <> 0 AND J.archGrpCopyId = @l_defSnapCopyId AND @l_isSnapJob <> 0)
AND (C.type = 2 OR A.linkType IN (7, 8))
AND (C.flags & 1024) = 0
	AND C.archGroupId = J.archGrpId
	AND EXISTS (SELECT * FROM JMJobDataStats JDS
				WHERE JDS.jobId = A.parentJobId AND JDS.commCellId = @i_commCellId AND JDS.archGrpCopyId = C.id)
	AND NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) WHERE JDS.jobId = J.jobId AND JDS.commcellId = J.commCellId AND JDS.archGrpCopyId = C.id AND JDS.dataType = J.dataType)
	AND J.appId = APP.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR APP.appTypeId != 81)
--This is a new change. JobSelectionType property should be set in the MMEntityProp table and value should correspond to the backuplevel
--FULL = 0x1,INCR = 0x2,DIFFERENTIAL = 0x4,ANYLEVEL = 0x8,SYNTHETIC_FULL = 0x40,INCR_NOTRUNC = 0x100,SYNTHETIC_FULL_AND_INCR = 0x80,ASR = 0x200,SEL_OFFLINE_FULL = 0x400,
--SNAPSHOTBKP = 0x800, CREATEREPLICABKP = 0x1000,SYNTHETIC_FULL_AND_INCR_BEFORE = 0x4000,SEL_ONLINE_FULL = 0x8000
IF @i_backupLevel NOT IN (1, 64, 128, 16384, 1024, 32768) AND EXISTS (SELECT 1 FROM MMEntityProp WHERE propertyName = 'JobSelectionType' AND EntityType = 2 AND propDataType = 1 AND intVal <> 0)
BEGIN
	DECLARE @FullJobId INTEGER = 0
	--IF backup is not FULL figure out the corresponding full jobid
	SELECT TOP 1 @FullJobId = max(jobid) from JMBkpStats WITH(READUNCOMMITTED) where fullCycleNum = @i_fullCycleNum and appid = @i_appId and bkpLevel IN (1, 64, 128, 16384, 1024, 32768) AND cycleSequence = 1
	IF @FullJobId = 0 AND @i_appType = 1000
		SELECT @FullJobId = max(jobid) from JMAdminJobStatsTable WITH(READUNCOMMITTED) where fullCycleNum = @i_fullCycleNum and appid = @i_appId and ER_bkpLevel IN (1, 64, 128, 16384, 1024, 32768) AND opType = 11 -- enum CVOpType{ CSDRBKP = 11
	INSERT INTO JMJobDataStats
	OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
	INTO #tblSelectedJobs
		SELECT	DISTINCT J.jobId, J.archGrpId, C.id, J.dataType, 13, 0, 101, 0, J.appId,
				J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
		FROM	JMJobDataStats J WITH (NOLOCK), archGroupCopy C WITH (NOLOCK), MMEntityProp  M WITH (NOLOCK), APP_Application A WITH (READUNCOMMITTED)
		WHERE
			J.jobId = @i_jobId
			AND J.commCellId = @i_commCellId
AND J.status IN (100, 101, 102, 103) AND (J.disabled & (1+256)) = 0
			AND C.archGroupId = J.archGrpId
			AND (C.isSnapCopy = 0 AND J.archGrpCopyId = @l_defCopyId AND (@l_isSnapJob = 0 OR @l_inPrimaryCopy <> 0)
			  OR C.isSnapCopy <> 0 AND J.archGrpCopyId = @l_defSnapCopyId AND @l_isSnapJob <> 0)
AND C.type = 2 AND (C.flags & 1024) = 0
			AND J.appId = A.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR A.appTypeId != 81)
AND M.EntityID = C.id AND M.EntityType = 2 AND M.propertyName = 'JobSelectionType' AND M.propDataType = 1 AND
					( (M.intVal = 1 AND ((@i_backupLevel & 4) <> 0 ))  OR (M.intVal = 2 and (@i_backupLevel NOT IN (1, 64, 128, 16384, 1024, 32768))))
			--Deferred Catalog condition need to be considered
			AND EXISTS (SELECT 1 FROM JMJobDataStats WITH (NOLOCK)
WHERE jobId = @FullJobId AND commCellId = @i_commCellId AND archGrpCopyId = C.id AND (disabled & (1+256)) = 0)
			AND NOT EXISTS (SELECT 1 FROM JMJobDataStats WITH (NOLOCK)
						WHERE jobId = @i_jobId AND commCellId = @i_commCellId AND archGrpCopyId = C.id)
END
-- For DDB Backups do not insert into any destination copy for auxcopy
IF EXISTS (	SELECT	*
			FROM	#tmpAppIdList WITH (NOLOCK)
			WHERE	appId = @i_appId
					AND unSupportedAlways = 1)
	GOTO RETURN_PROC
IF @l_isDeferredCatalogJob <= 0
BEGIN
	--If this is index subclient job treat selective copies as synchronous copy
	INSERT	INTO #tempCopy
	SELECT	A.archGroupId, A.id, A.type, A.startTime, A.flags, A.extendedFlags, A.isSnapCopy, A.isMirrorCopy, A.sourceCopyId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, A.endTime
	FROM	archGroupCopy A WITH (NOLOCK), #tmpAppIdList T --There will be only one subclient
	WHERE	A.archGroupId IN (SELECT archGrpId FROM #tempJobDataStats)
		AND A.id NOT IN (SELECT archGrpCopyId FROM JMJobDataStats WITH(NOLOCK) WHERE jobid = @i_jobId AND commCellId = 2)
		AND A.id <> @l_defSnapCopyId --This is specifically required for deferred catalog since we write backup data into non-primary copy the af should not be wrongly picked up for defaultSnapCopy
		AND A.isActive = 1 AND A.startTime <= @i_today AND A.startTime <= @i_startDate AND A.endTime > @i_startDate
		AND (@l_isSnapJob = 0 AND A.isSnapCopy = 0 OR @l_isSnapJob <> 0 AND (A.isSnapCopy <> 0 OR @l_inPrimaryCopy <> 0))
AND (A.flags & 524288) = 0
AND ((A.type IN (1, 4) OR (@isIndexSubclient = 1 AND A.type = 2))
OR A.type = 2 AND ((@i_backupLevel IN (1, 64, 128, 16384, 1024, 32768) OR dbo.GetBkpLevelOfSnapJobs(@i_jobId, @i_commCellId, A.id) = 1 )
            AND T.unSupportedOnSelAlways = 0
			-- Index copy jobs do not insert into any selective destination copy for auxcopy
			AND (@l_bkpAttributesEx & CAST(0x1000000000000 AS BIGINT)) = 0 --JMBKP_EX_BLR_INDEX_COPY_JOB
			-- Only take FULL with Attribute [JMBKP_EX_FULL_JOB_IN_CYCLE] for app aware app backups
			AND (
						(@l_bkpAttributesEx & @EX_APPAWARE_CHILD_JOB = 0)
						OR
						(@l_bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE > 0)
					)
			-- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle
			AND (
@i_appType NOT IN (2, 22, 23, 80,
61, 79)
				OR @i_backupLevel IN (1024, 32768)
OR (@l_openChain = 0 AND @l_hasDataAF = 1 AND (@l_bkpAttributes & 0x1000) <> 0 AND @l_AllowOracleSAPRegularFull = 1 AND T.unSupportedDB = 0 /*AND @l_bkpAttributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0*/)
				)
			-- Only take FULL with data for SAP, Informix and DB2
AND (@i_appType NOT IN (3, 5, 37, 62, 103, 128, 135)
OR @l_openChain = 0 AND (@l_hasDataAF = 1 AND (@l_bkpAttributes & 0x1000) <> 0 OR @i_appType IN (5, 135)))
			))
END
ELSE
BEGIN
	INSERT	INTO #tempCopy
	SELECT	A.archGroupId, A.id, A.type, A.startTime, A.flags, A.extendedFlags, A.isSnapCopy, A.isMirrorCopy,
			CASE WHEN A.sourceCopyId > 0 THEN A.sourceCopyId WHEN A.isSnapCopy > 0 THEN AG.defaultSnapCopy ELSE AG.defaultCopy END, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, A.endTime
	FROM	archGroupCopy A WITH (NOLOCK) inner join JMJobDataStats JDS WITH (NOLOCK) ON A.id = JDS.archGrpCopyId
AND JDS.jobId = @i_jobId AND JDS.commCellId = @i_commCellId AND JDS.dataType = 1
	inner join ArchGroup AG WITH (NOLOCK) ON AG.id = A.archGroupId
	WHERE	A.archGroupId IN (SELECT archGrpId FROM #tempJobDataStats)
		AND A.id NOT IN (SELECT archGrpCopyId FROM #tempJobDataStats)
		AND A.id <> @l_defSnapCopyId --This is specifically required for deferred catalog since we write backup data into non-primary copy the af should not be wrongly picked up for defaultSnapCopy
		AND A.id <> @l_defCopyId
		--AND A.isSnapCopy <> 0
AND (A.flags & 524288) = 0
END
IF(@isIndexSubclient = 1)
BEGIN
    --If this is index subclient job treat selective copies as synchronous copy. Manual selective still stays as manual selective copy unless a config param is set
	DECLARE @pickIndexBackupToManualSelectiveCopy INT = 0
	SELECT @pickIndexBackupToManualSelectiveCopy = value FROM MMConfigs WITH(NOLOCK) WHERE name = 'AUXCOPY_AUTOPICK_INDEXBACKUPS_ON_MANUAL_SELECTION_COPIES'
	UPDATE #tempCopy
SET		type = CASE WHEN B.type IN (9,8) AND @pickIndexBackupToManualSelectiveCopy = 0 THEN 2 ELSE 1 END
	FROM   #tempCopy A INNER JOIN archSelectiveCopy B WITH (NOLOCK) ON A.copyId = B.copyId
WHERE A.type = 2
END
UPDATE #tempCopy
SET		defaultCopyId = B.defaultCopy, defaultSnapCopyId = B.defaultSnapCopy,
		sourceCopyId = (CASE WHEN A.sourceCopyId > 0 THEN A.sourceCopyId WHEN A.isSnapCopy = 0 THEN B.defaultCopy ELSE B.defaultSnapCopy END),
		archGroupFlags = B.flags, TimeZoneType = B.TimeZoneType
FROM   #tempCopy A, archGroup B WITH (NOLOCK)
WHERE  A.archGroupId = B.id
IF	EXISTS (SELECT * FROM #tempCopy WHERE isSnapCopy = 1)
BEGIN
	DELETE #tempCopy
	FROM	#tempCopy T, SMVolume V WITH (READUNCOMMITTED), SMVolSnapMap VS WITH (READUNCOMMITTED), SMSnap S WITH (READUNCOMMITTED), SMSnapShotEngine E WITH (READUNCOMMITTED)
	WHERE	V.jobId = @i_jobId AND V.commCellId = @i_commCellId
			AND VS.SMVolumeId = V.SMVolumeId AND S.SMSnapId = VS.SMSnapId
			AND S.SnapShotEngineId = E.SnapShotEngineId
AND ((( T.extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND T.isMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( T.extendedFlags & (256 | 512 | 524288)) = (256 | 512) AND (E.Capabilities & CAST(4294967296 AS BIGINT)) = 0)
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND T.sourceCopyId != T.defaultSnapCopyId AND (E.Capabilities & CAST(34359738368 AS BIGINT)) = 0)
OR (( T.extendedFlags & (256 | 512)) = 256)
OR (( T.extendedFlags & (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3, 48))))
			AND T.isSnapCopy = 1
	DELETE #tempCopy
	FROM	#tempCopy T, JMVSAAppJobLink J WITH (READUNCOMMITTED)
				LEFT OUTER JOIN  SMVolume V WITH (READUNCOMMITTED)
					ON V.jobId = J.parentJobId AND V.commCellId = @i_commCellId
				LEFT OUTER JOIN SMVolSnapMap VS WITH (READUNCOMMITTED)
					ON VS.SMVolumeId = V.SMVolumeId
				LEFT OUTER JOIN SMSnap S WITH (READUNCOMMITTED)
					ON S.SMSnapId = VS.SMSnapId
				LEFT OUTER JOIN SMSnapShotEngine E WITH (READUNCOMMITTED)
					ON S.SnapShotEngineId = E.SnapShotEngineId
	WHERE	J.childJobId = @i_jobId AND J.commCellId = @i_commCellId
			-- AND NOT EXISTS (SELECT * FROM JMJobDataStats JDS WHERE JDS.JobId =  J.ParentJobId AND JDS.CommCellId = @i_commCellId AND JDS.archGrpCopyId = T.copyId AND JDS.dataType != 6 AND JDS.Status != 100)
			AND NOT EXISTS (SELECT TOP 1 SMVolumeID FROM SMVolume V2 WITH (READUNCOMMITTED) WHERE V2.jobId = J.parentJobId AND V2.commCellId = @i_commCellId AND V2.CopyId = T.CopyId)
			AND (V.SMVolumeId IS NULL
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND T.isMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( T.extendedFlags & (256 | 512 | 524288)) = (256 | 512) AND (E.Capabilities & CAST(4294967296 AS BIGINT)) = 0)
OR (( T.extendedFlags & (256 | 512)) = (256 | 512) AND T.sourceCopyId != T.defaultSnapCopyId AND (E.Capabilities & CAST(34359738368 AS BIGINT)) = 0)
OR (( T.extendedFlags & (256 | 512)) = 256)
--OR ((( T.extendedFlags & (256 | 512)) = 256) AND EXISTS (SELECT * FROM JMJobDataStats JDS WHERE JDS.JobId =  J.ParentJobId AND JDS.CommCellId = @i_commCellId AND JDS.archGrpCopyId = T.copyId AND JDS.dataType != 6 AND JDS.Status != 100))
OR (( T.extendedFlags & (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3))))
			AND T.isSnapCopy = 1
END
DECLARE @l_siloCopyId	INTEGER = 0
SELECT	@l_siloCopyId = id
FROM	archGroupCopy WITH (NOLOCK)
WHERE	siloAppId = @i_appId AND (flags & 524288) <> 0
IF	@l_siloCopyId > 0
BEGIN
	IF OBJECT_ID('tempdb..#archDestinationCopyListResultTable') IS NOT NULL DROP TABLE #archDestinationCopyListResultTable
	CREATE TABLE #archDestinationCopyListResultTable (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
	EXEC ArchDestinationCopyList @l_siloCopyId
	DELETE	FROM #tempCopy
	WHERE	copyId = @l_siloCopyId OR copyId NOT IN (SELECT copyId FROM #archDestinationCopyListResultTable)
END
IF	@CountPartialSuccess = 0 AND @l_status = 3
DELETE FROM #tempCopy WHERE type = 2
UPDATE #tempCopy
SET		selectionType=B.type, numPeriod=B.numPeriod, dayNumber=B.dayNumber,
		startPeriod=B.startPeriod, nextPeriod=B.nextPeriod, prevPeriodBegin=B.prevPeriodBegin, nextPeriodEnd= B.nextPeriodEnd
FROM   #tempCopy A, archSelectiveCopy B WITH (NOLOCK)
WHERE  A.type = 2 AND A.copyId = B.copyId
--If delayed catalog need not go through other selective copy based filters since the data AF is already picked up
--Erase data jobs are always copied to secondary copies
IF @l_isDeferredCatalogJob > 0 OR @l_opType = 44 -- BROWSEANDDELETE = 44
	GOTO INSERT_JOBCOPY
IF	(@i_backupLevel IN (1, 64, 128, 16384, 1024, 32768)
		AND EXISTS (SELECT * FROM #tempCopy
WHERE selectionType IN (10, 3, 2, 4, 6)))
	OR
	 EXISTS (SELECT * FROM #tempCopy
			WHERE dbo.GetBkpLevelOfSnapJobs(@i_JobId, @i_commCellId, CopyId) = 1
AND selectionType IN (10, 3, 2, 4, 6))
BEGIN
	UPDATE	#tempCopy
	SET		nextFullTime = @i_nextFullTime
WHERE	type = 2
	IF (EXISTS (SELECT * FROM #tempCopy
				WHERE dbo.GetBkpLevelForSnapCopy(@i_appId, 2, CopyId) = 1
AND selectionType IN (10, 3, 2, 4, 6)))
	BEGIN
		DELETE FROM #TM_GetNextScheduleRunTimeResultTable
		EXEC @l_nextFullTimeForSnap = TM_GetNextScheduleRunTime @i_appId, 2, 1, 1, @i_jobId
		IF (@l_nextFullTimeForSnap <> 0 AND (@l_nextFullTimeForSnap < @i_nextFullTime OR @i_nextFullTime = 0))
			SET @i_nextFullTime = @l_nextFullTimeForSnap
		UPDATE	#tempCopy
		SET		nextFullTime = @i_nextFullTime
WHERE	type = 2
				AND isSnapCopy = 1
	END
	IF (EXISTS (SELECT * FROM #tempCopy
WHERE selectionType IN (10, 3, 2, 4, 6)
AND TimeZoneType > 0))
	BEGIN
		DECLARE	@l_clientId		INTEGER
		SET		@l_clientId = 0
IF EXISTS (SELECT * FROM #tempCopy WHERE TimeZoneType = 1)
			SELECT	@l_clientId = clientId FROM APP_Application WITH (NOLOCK) WHERE id = @i_appId
		SET		@l_TimeZone		= dbo.ArchGroupTimeZone(@l_archGroupId, @l_clientId)
		SET		@l_csTimeZone	= dbo.GetClientTimeZone(2)
		IF	@l_TimeZone <> '' AND @l_TimeZone <> @l_csTimeZone
		BEGIN
			SET @now = @now + dbo.GetDiffFromCSTimeZone(@now, @l_TimeZone, @l_csTimeZone)
			SET	@i_startDate = @i_startDate + dbo.GetDiffFromCSTimeZone(@i_startDate, @l_TimeZone, @l_csTimeZone)
			IF	@i_nextFullTime > 0
				SET @i_nextFullTime = @i_nextFullTime + dbo.GetDiffFromCSTimeZone(@i_nextFullTime, @l_TimeZone, @l_csTimeZone)
			UPDATE	#tempCopy
			SET		nextFullTime = @i_nextFullTime
WHERE	type = 2
			--IF (@i_backupLevel NOT IN (1, 64, 128, 16384, 1024, 32768) AND
			--	 EXISTS (SELECT * FROM #tempCopy
			--			WHERE dbo.GetBkpLevelOfSnapJobs(@i_JobId, @i_commCellId, CopyId) = 1
			--				AND selectionType IN (CVA_SELECT_BY_HOURS, CVA_SELECT_BY_DAYS, CVA_SELECT_BY_WEEKDAY, CVA_SELECT_BY_MONTHDAY, CVA_SELECT_MONTHLY_ON_WEEKDAY)
			--				AND TimeZoneType > CVA_AG_TIMEZONE_TYPE_COMMSERV))
			IF (EXISTS (SELECT * FROM #tempCopy
						WHERE dbo.GetBkpLevelForSnapCopy(@i_appId, 2, CopyId) = 1
AND selectionType IN (10, 3, 2, 4, 6)
AND TimeZoneType > 0))
			BEGIN
				DELETE FROM #TM_GetNextScheduleRunTimeResultTable
				EXEC @l_nextFullTimeForSnap = TM_GetNextScheduleRunTime @i_appId, 2, 1, 1, @i_jobId
				IF	@l_nextFullTimeForSnap > 0
					SET @l_nextFullTimeForSnap = @l_nextFullTimeForSnap + dbo.GetDiffFromCSTimeZone(@l_nextFullTimeForSnap, @l_TimeZone, @l_csTimeZone)
				IF (@l_nextFullTimeForSnap <> 0 AND (@l_nextFullTimeForSnap < @i_nextFullTime OR @i_nextFullTime = 0))
					SET @i_nextFullTime = @l_nextFullTimeForSnap
				UPDATE	#tempCopy
				SET		nextFullTime = @i_nextFullTime
WHERE	type = 2
						AND isSnapCopy = 1
			END
		END
	END
END
DELETE	#tempCopy
WHERE	selectionType IN (8, 9)
DELETE	#tempCopy
WHERE	selectionType IN (10, 3, 2, 4, 6)
AND (flags & 4096) > 0 AND (flags & 8192) = 0
	AND (	nextFullTime	>= prevPeriodBegin AND nextFullTime		< startPeriod AND
			@i_startDate    >= prevPeriodBegin AND @i_startDate		< startPeriod
		OR	nextFullTime	>= startPeriod	   AND nextFullTime		< nextPeriod AND
			@i_startDate    >= startPeriod     AND @i_startDate		< nextPeriod
		OR	nextFullTime	>= nextPeriod      AND nextFullTime		< nextPeriodEnd AND
			@i_startDate    >= nextPeriod      AND @i_startDate		< nextPeriodEnd
		OR	@i_startDate    >= nextPeriodEnd	)
DELETE	#tempCopy
WHERE	selectionType IN (10, 3, 2, 4, 6)
AND (flags & 4096) > 0 AND (flags & 8192) > 0
	AND (	@i_startDate >= prevPeriodBegin AND @now < startPeriod
		OR	@i_startDate >= startPeriod     AND @now < nextPeriod
		OR	@i_startDate >= nextPeriod      AND @now < nextPeriodEnd
		OR	@i_startDate >= nextPeriodEnd	)
BEGIN
	INSERT INTO #copyIdToProcess(copyId)
	SELECT DISTINCT copyId
	FROM #tempCopy t
	WHERE EXISTS (SELECT 1 FROM ArchCopyToApp a WITH (READUNCOMMITTED) WHERE a.copyId = t.copyId AND a.assocType <> 2)
	INSERT INTO #archCopyToAppId
	SELECT DISTINCT copyId , @i_appId
	FROM #copyIdToProcess
	exec archGetArchCopyToAppAssociations 0
	DELETE #tempCopy
	FROM   #tempCopy A INNER JOIN #copyIdToProcess c ON c.copyId = A.copyId  LEFT JOIN #archCopyToAppId t ON t.copyId = A.copyId AND t.appID = @i_appId
	WHERE  t.appId IS NULL
END
-- Only take full backups for selective copies
IF (@i_backupLevel NOT IN (1, 64, 128, 16384, 1024, 32768) AND NOT EXISTS (SELECT * FROM #tempCopy WHERE dbo.GetBkpLevelOfSnapJobs(@i_JobId, @i_commCellId, CopyId) = 1))
OR NOT EXISTS (SELECT * FROM #tempCopy WHERE type = 2)
   GOTO INSERT_JOBCOPY
-- Filter out selective copies that this job does not satisfty their selection rules.
--IF	@i_backupLevel IN (1, 64, 128, 16384, 1024, 32768)
BEGIN
	CREATE TABLE #tempFullJob (jobId int, commCellId int, servStartDate int, fullCycleNum int)
	CREATE TABLE #tempLastJob (archGrpCopyId int, servStartDate int)
	--IF @i_appType = 1000
    /* Legal hold and DR jobs */
    IF @l_opType IN (11, 64) -- enum CVOpType{ INFOMGMT = 64 CSDRBKP = 11
	   INSERT INTO #tempFullJob
	   SELECT jobId, commCellId, servStart, fullCycleNum
	   FROM   JMAdminJobStatsTable WITH (NOLOCK)
	   WHERE  appId = @i_appId AND (status IN (1, 14) OR status = 3 AND @CountPartialSuccess = 1) AND ER_BkpLevel = 1
				AND @i_backupLevel IN (1, 64, 128, 16384, 1024, 32768)
	ELSE
	   INSERT INTO #tempFullJob
	   SELECT jobId, commCellId, servStartDate, fullCycleNum
	   FROM   JMBkpStats WITH (NOLOCK), #tmpAppIdList T --There will be only one subclient
	   WHERE  JMBkpStats.appId = @i_appId AND (status IN (1, 14) OR status = 3 AND @CountPartialSuccess = 1)
			AND (bkpLevel IN (1, 64, 128, 16384, 1024, 32768) OR EXISTS (SELECT * FROM #tempCopy WHERE dbo.GetBkpLevelOfSnapJobs(JobId, CommCellId, CopyId) = 1))
			AND T.unSupportedOnSelAlways = 0
			-- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle
			AND (
appType NOT IN (2, 22, 23, 80,
61, 79)
				OR bkpLevel IN (1024, 32768)
OR (openChain = 0 AND (bkpAttributes & 0x1000) <> 0 AND @l_AllowOracleSAPRegularFull = 1 AND T.unSupportedDB = 0 /*AND bkpAttributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0*/)
				)
			-- Only take FULL with data for SAP, Informix and DB2
AND (appType NOT IN (3, 5, 37, 62, 103, 128, 135) OR
openChain = 0 AND ((bkpAttributes & 0x1000) <> 0 OR appType IN (5, 135)))
			-- Only take FULL with Attribute [JMBKP_EX_FULL_JOB_IN_CYCLE] for app aware app backups
			AND (
						(JMBkpStats.bkpAttributesEx & @EX_APPAWARE_CHILD_JOB = 0)
						OR
						(JMBkpStats.bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE > 0)
					)
	INSERT INTO #tempLastJob
	SELECT B.archGrpCopyId, MAX(A.servStartDate)
	FROM   #tempFullJob A, JMJobDataStats B WITH (NOLOCK)
	WHERE  B.jobId = A.jobId AND B.commCellId = A.commCellId-- AND B.archGrpCopyId IN (SELECT copyId FROM #tempCopy)
AND B.status >= 100 AND (B.disabled & (1 + 256)) = 0
	GROUP BY B.archGrpCopyId
	IF	@l_TimeZone <> '' AND @l_TimeZone <> @l_csTimeZone
AND EXISTS (SELECT * FROM #tempCopy WHERE selectionType IN (10, 3, 2, 4, 6))
		UPDATE	#tempLastJob
		SET		servStartDate = servStartDate + dbo.GetDiffFromCSTimeZone(servStartDate, @l_TimeZone, @l_csTimeZone)
	--If option set to avoid duplicates among selective copies do not copy when there is any selective copy which has a job copied in this period already and the copy is for first full
IF EXISTS(SELECT 1 FROM ArchGroup WITH(NOLOCK) WHERE id = @l_archGroupId AND flags & 4194304 > 0)
		DELETE	#tempCopy
		FROM	#tempCopy A, #tempLastJob B	WHERE
A.selectionType IN (10, 3, 2, 4, 6)
		AND (
		    @i_startDate <  A.startPeriod		AND B.servStartDate >= A.prevPeriodBegin
			OR @i_startDate >= A.startPeriod	AND B.servStartDate >= A.startPeriod	AND @i_startDate < A.nextPeriod
			OR @i_startDate >= A.nextPeriod		AND B.servStartDate >= A.nextPeriod		AND @i_startDate < A.nextPeriodEnd
			OR @i_startDate >= A.nextPeriodEnd	AND B.servStartDate >= A.nextPeriodEnd
			OR @i_startDate < A.prevPeriodBegin
			)
			AND
			(A.copyId = B.archGrpCopyId OR
				(
B.archGrpCopyId IN(SELECT copyId FROM archSelectiveCopy WITH(NOLOCK) WHERE type IN (10, 3, 2, 4, 6))
				AND (
(A.flags & 4096 = 0 AND B.servStartDate <= @i_startDate)
						OR
(A.flags & 4096 > 0 AND B.servStartDate >= @i_startDate)
					)
				)
			)
	ELSE
		DELETE	#tempCopy
		FROM	#tempCopy A, #tempLastJob B
		WHERE	A.copyId = B.archGrpCopyId  AND
(A.selectionType IN (10, 3, 2, 4, 6)
				AND (  @i_startDate <  A.startPeriod	AND B.servStartDate >= A.prevPeriodBegin
					OR @i_startDate >= A.startPeriod	AND B.servStartDate >= A.startPeriod	AND @i_startDate < A.nextPeriod
					OR @i_startDate >= A.nextPeriod		AND B.servStartDate >= A.nextPeriod		AND @i_startDate < A.nextPeriodEnd
					OR @i_startDate >= A.nextPeriodEnd	AND B.servStartDate >= A.nextPeriodEnd
					OR @i_startDate < A.prevPeriodBegin	))
	DELETE	#tempCopy
	FROM	#tempCopy A
	WHERE
(A.selectionType = 1 AND A.type = 2 AND @i_appType <> 79 AND (A.numPeriod <> 1) AND
( ((A.flags & 4096) <> 0 AND (@i_fullCycleNum % A.numPeriod) <> 0) OR ((A.flags & 4096) = 0 AND (@i_fullCycleNum % A.numPeriod) <> 1)))
	IF EXISTS (
		SELECT 1
FROM #tempCopy C WHERE C.selectionType IN (10, 3, 2, 4, 6) AND (C.flags & 4096) = 0
			 )
		DELETE #tempCopy
		FROM   #tempCopy C
WHERE  EXISTS ( SELECT 1 FROM JMJobDataStats JDS WITH (READUNCOMMITTED),#tempFullJob F WHERE JDS.archGrpCopyId = C.sourceCopyId AND F.jobId = JDS.jobId AND F.commcellId = JDS.commcellId AND JDS.status >= 100 AND (JDS.disabled & (1 + 256)) = 0 AND JDS.jobID < @i_jobId AND F.servStartDate > C.startPeriod AND @i_startDate >= C.startPeriod AND @i_startDate < C.nextPeriod) -- older jobs from current period exists in source copy
		AND NOT EXISTS ( SELECT 1 FROM JMJobDataStats JDS WITH (READUNCOMMITTED),#tempFullJob F WHERE JDS.archGrpCopyId = C.copyId AND F.jobId = JDS.jobId AND F.commcellId = JDS.commcellId AND JDS.jobID < @i_jobId AND F.servStartDate > C.startPeriod AND @i_startDate >= C.startPeriod AND @i_startDate < C.nextPeriod) -- but no job from current period exists then it is likely that job selection hasn't happened yet for the copy thus indicating a new/updated copy
AND C.selectionType IN (10, 3, 2, 4, 6) AND (C.flags & 4096) = 0
	DROP TABLE #tempFullJob
	DROP TABLE #tempLastJob
END
INSERT_JOBCOPY:
/*
Doing in loop because consider a case where data flow is
P->Sec1->Sec2->Sec3 And lets say Sec1 configuration is such that your backup job cannot be picked up for Sec1.
So #tempCopy will have Sec2 and Sec3 and #tempJobDataStats table will have job in P. And Job can never be copied to Sec2 and Sec3
as the link Sec1 is broken.
Now when you run the below query first iteration of loop will only delete Sec2 as Sec3 will not be deleted due to the presence
of Sec2. Now we need to run the query again to delete Sec3 also from #tempCopy and prevent it from getting the job marked as
to-be-copied
*/
WHILE(1 = 1)
BEGIN
	DELETE #tempCopy
	FROM   #tempCopy C
	WHERE  C.sourceCopyId <> 0
	   AND NOT EXISTS (SELECT * FROM #tempCopy WHERE copyId = C.sourceCopyId)
	   AND NOT EXISTS (SELECT * FROM #tempJobDataStats WHERE archGrpCopyId = C.sourceCopyId
AND status IN (100, 101, 102, 103) AND (disabled & 1) = 0)
	IF @@ROWCOUNT = 0
		BREAK
END
--To avoid duplicates pick the job only for selective copy with highest duration
IF EXISTS(SELECT 1 FROM	#tempCopy
WHERE	selectionType IN (10, 3, 2, 4, 6))
AND EXISTS(SELECT 1 FROM ArchGroup WITH(NOLOCK) WHERE id = @l_archGroupId AND flags & 4194304 > 0)
AND @l_isDeferredCatalogJob = 0
BEGIN
	DECLARE @tmpSelectiveCopyOrder table(copyId int, periodDuration int, sourceCopyId int)
	INSERT INTO @tmpSelectiveCopyOrder
	SELECT copyId, nextPeriod-startPeriod, CASE WHEN sourceCopyId > 0 THEN sourceCopyId WHEN isSnapCopy > 0 THEN defaultSnapCopyId ELSE defaultCopyId END
	FROM #tempCopy
WHERE selectionType IN (10, 3, 2, 4, 6)
	DECLARE @l_higherCopy int
	SELECT top 1 @l_higherCopy = copyId FROM @tmpSelectiveCopyOrder
	ORDER BY periodDuration desc, copyId asc
	--Fetch all the source copies recursively
	;WITH LinkedCopies (copyId, sourceCopyId)
	AS
	(
		SELECT copyId, sourceCopyId FROM @tmpSelectiveCopyOrder WHERE copyId = @l_higherCopy
		UNION ALL
		SELECT A.copyId, A.sourceCopyId FROM @tmpSelectiveCopyOrder A INNER JOIN LinkedCopies B ON A.copyId = B.sourceCopyId
	)
	DELETE #tempCopy WHERE copyId NOT IN (SELECT copyId FROM LinkedCopies)
AND selectionType IN (10, 3, 2, 4, 6)
END
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT	J.jobId, J.archGrpId, C.copyId, J.dataType, 13, 0, 101, 0, J.appId,
		J.commCellId, 0, 0, ISNULL(I.retentionFlags, 0), 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM	JMJobDataLinkViewForDA A WITH (NOLOCK)
		INNER JOIN JMJobDataStats J WITH (READUNCOMMITTED)
	ON	A.childJobID = J.jobId AND A.commCellId = J.commCellId
		INNER JOIN APP_Application APP WITH (READUNCOMMITTED)
	ON	J.appId = APP.id
		INNER JOIN #tempCopy C
	ON	(C.isSnapCopy = 0 AND J.archGrpCopyId = C.defaultCopyId OR C.isSnapCopy <> 0 AND J.archGrpCopyId = C.defaultSnapCopyId)
		LEFT OUTER JOIN JMJobCopyInfo I
	ON	I.jobId = J.jobId AND I.archGrpCopyId = C.copyId AND I.commCellId = J.commCellId
WHERE	(A.childJobId <> A.parentJobId) AND A.parentJobId = @i_jobId
AND J.status IN (100, 101, 102, 103) AND (J.disabled & 1) = 0
AND (C.type = 2 OR A.linkType IN (7, 8))
	AND NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) WHERE JDS.jobId = J.jobId AND JDS.commcellId = J.commCellId AND JDS.archGrpCopyId = C.copyId AND JDS.dataType = J.dataType)
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR APP.appTypeId != 81)
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT	J.jobId, J.archGrpId, C.copyId, J.dataType, 13, 0, 101, 0, J.appId,
		J.commCellId, 0, 0, ISNULL(I.retentionFlags, 0), 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM	JMVSAAppJobLink A WITH (NOLOCK)
		INNER JOIN JMJobDataStats J WITH (READUNCOMMITTED)
	ON	A.parentJobId = J.jobId AND A.commCellId = J.commCellId
		INNER JOIN APP_Application APP WITH (READUNCOMMITTED)
	ON	J.appId = APP.id
		INNER JOIN #tempCopy C
	ON	(C.isSnapCopy = 0 AND J.archGrpCopyId = C.defaultCopyId OR C.isSnapCopy <> 0 AND J.archGrpCopyId = C.defaultSnapCopyId)
		LEFT OUTER JOIN JMJobCopyInfo I
	ON	I.jobId = J.jobId AND I.archGrpCopyId = C.copyId AND I.commCellId = J.commCellId
WHERE	(A.childJobId <> A.parentJobId) AND A.childJobId = @i_jobId
AND J.status IN (100, 101, 102, 103) AND (J.disabled & 1) = 0
AND C.type = 2
	AND NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) WHERE JDS.jobId = J.jobId AND JDS.commcellId = J.commCellId AND JDS.archGrpCopyId = C.copyId AND JDS.dataType = J.dataType)
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR APP.appTypeId != 81)
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT	DISTINCT @i_jobId, J.archGrpId, C.copyId, J.dataType, 13, 0, 101, 0, @i_appId,
		@i_commCellId, 0, 0, ISNULL(I.retentionFlags, 0), 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM	#tempJobDataStats J INNER JOIN #tempCopy C
	ON	J.archGrpId = C.archGroupId
	LEFT OUTER JOIN JMJobCopyInfo I
	ON	I.jobId = @i_jobId AND I.archGrpCopyId = C.copyId AND I.commCellId = @i_commCellId
    INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AGC.id = J.archGrpCopyId,
		APP_Application A WITH (READUNCOMMITTED)
	WHERE C.isSnapCopy = AGC.isSnapCopy
		AND	@i_appId = A.id
-- next AND clause should no longer be needed, but better be safe (= existing code)
	--AND 	(C.isSnapCopy = 0 OR J.archGrpCopyId = C.defaultSnapCopyId) --Commenting this out as during delayed catalog job it will created bcd index on secondary snap copy
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR A.appTypeId != 81)
/*
For delayed catalog we'll pick up the newly created bcd index archive file for the destination copies but
if the data archive file for the job in that copy is disabled/aged we'll mark the bcd index archive file also with same flags
*/
IF @l_isDeferredCatalogJob > 0
BEGIN
UPDATE JMJobDataStats SET disabled = (B.disabled & (1 | 2| 4 | 8 | 16| 64 | 256 )),
	retentionFlags = B.retentionFlags, manualRetentionEndTime = B.manualRetentionEndTime, agedTime = B.agedTime, mediaDeletedTime  = B.mediaDeletedTime, agedBy = B.agedBy
FROM JMJobDataStats A WITH (NOLOCK) inner join (SELECT * FROM JMJobDataStats WITH (NOLOCK) WHERE jobId = @i_jobId AND commCellId = @i_commCellId AND dataType = 1) B
ON A.jobId = B.jobId AND A.commCellId = B.commCellId AND A.dataType = 6 AND A.archGrpCopyId = B.archGrpCopyId
END
IF (@i_backupLevel NOT IN (1, 64, 128, 16384, 1024, 32768) AND EXISTS (SELECT * FROM #tempCopy WHERE isSnapCopy = 1 AND dbo.GetBkpLevelOfSnapJobs(@i_jobId, @i_commCellId, CopyId) = 1))
BEGIN
	DECLARE	@l_fullJobID INT = 0
	SELECT	@l_fullJobID = JobId
	FROM	JMBkpStats WITH(NOLOCK)
	WHERE	appId = @i_appId
		AND fullCycleNum = @i_fullCycleNum
		AND bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
	ORDER BY JobID
	WHILE(1=1) --Pick in loop to handle P->V->M. Job will be picked for V in first iteration and for M in the next iteration
	BEGIN
		INSERT INTO JMJobDataStats
		OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
		INTO #tblSelectedJobs
		SELECT	DISTINCT @l_fullJobID, J.archGrpId, C.copyId, J.dataType, 13, 0, 101, 0, @i_appId,
				@i_commCellId, 0, 0, ISNULL(I.retentionFlags, 0), 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
		FROM	JMJobDataStats J WITH (READUNCOMMITTED)
			INNER JOIN APP_Application A WITH (READUNCOMMITTED)
			ON	J.appId = A.id
			INNER JOIN #tempCopy C
			ON	 J.jobId = @l_fullJobID AND J.commCellId = @i_commCellId AND Status IN (100, 101, 102, 103) AND (J.disabled & 257) = 0 AND J.archGrpId = C.archGroupId
					AND J.archGrpCopyId = (CASE WHEN (C.SourceCopyId <> 0) THEN C.SourceCopyId ELSE C.defaultSnapCopyId END)
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR A.appTypeId != 81)
			LEFT OUTER JOIN JMJobCopyInfo I
				ON	I.jobId = @i_jobId AND I.archGrpCopyId = C.copyId AND I.commCellId = @i_commCellId
			INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON AGC.id = J.archGrpCopyId
			WHERE C.isSnapCopy = AGC.isSnapCopy
		-- -- next AND clause should no longer be needed, but better be safe (= existing code)
		--	AND 	(C.isSnapCopy = 0 OR J.archGrpCopyId = C.defaultSnapCopyId)
			AND NOT EXISTS (SELECT	1
							FROM	JMJobDataStats
							WHERE	jobId = @l_fullJobID AND archGrpCopyId = C.copyId AND commCellId = @i_commCellId)
		IF(@@ROWCOUNT = 0)
			BREAK
	END
END
--If log only part on a storage policy copy, then do not set extended retention flags
UPDATE JMJobDataStats
SET retentionFlags = 0
FROM (SELECT J.archGrpCopyId, MIN(J.dataType) AS dataType
			FROM 	 JMJobDataStats J WITH (READUNCOMMITTED)
			WHERE  J.JobId = @i_jobId
			AND		 J.CommCellId = @i_commCellId
			GROUP  BY J.archGrpCopyId) T
WHERE JMJobDataStats.jobId = @i_jobId
AND  	JMJobDataStats.commCellId = @i_commCellId
AND		JMJobDataStats.archGrpCopyId = T.archGrpCopyId
AND		T.dataType != 1
AND 	JMJobDataStats.retentionFlags > 0
IF EXISTS (SELECT VALUE FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_PICK_ALL_JOBS_IN_CYCLE_TO_SYNC_COPY' AND Value = 1)
BEGIN
	IF (OBJECT_ID('tempdb.dbo.#tblAppIdFullCycle') IS NOT NULL) DROP TABLE #tblAppIdFullCycle
	CREATE TABLE #tblAppIdFullCycle (appId INT, fullCycleNum INT, destCopyId INT, srcCopyId INT)
	INSERT INTO #tblAppIdFullCycle (appId, fullCycleNum, destCopyId, srcCopyId)
	SELECT	DISTINCT JBS.AppId, JBS.fullCycleNum, TJ.copyId, (CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId WHEN AGC.isSnapCopy > 0 THEN AG.defaultSnapCopy ELSE AG.defaultCopy END)
	FROM	#tblSelectedJobs TJ
			INNER JOIN JMBkpStats JBS WITH (READUNCOMMITTED) ON TJ.JobId = JBS.JobID AND TJ.CommCellId = JBS.CommCellId
			INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON TJ.copyId = AGC.id
			INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AGC.archGroupId = AG.id
WHERE	AGC.type = 1
	IF OBJECT_ID('tempdb.dbo.#subclientDaysRetention') IS NOT NULL DROP TABLE #subclientDaysRetention
	CREATE TABLE #subclientDaysRetention (
							appId INT PRIMARY KEY,
							daysOnlyRetention INT NULL
							)
	INSERT INTO #subclientDaysRetention
	SELECT	DISTINCT AppId, 0
	FROM	#tblAppIdFullCycle
	EXEC getDaysOnlyRetentionSubclient
	UPDATE	S
	SET		daysOnlyRetention = 1
	FROM	#subclientDaysRetention S, APP_Application App WITH (READUNCOMMITTED), APP_IDATypeHandlingInfo H WITH (READUNCOMMITTED)
	WHERE	S.AppId = APP.id
			AND S.daysOnlyRetention = 0
			AND APP.AppTypeId = H.AppTypeId
			AND H.IsDMAppType = 1
	DELETE	A
	FROM	#tblAppIdFullCycle A, #subclientDaysRetention S
	WHERE	A.AppId = S.AppId
			AND S.daysOnlyRetention = 1
	INSERT INTO JMJobDataStats
	OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
	INTO #tblSelectedJobs
	SELECT	DISTINCT JDS.jobId, JDS.archGrpId, A.destCopyId, JDS.dataType, 13, 0, 101, 0, JDS.appId,
			JDS.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
	FROM	#tblAppIdFullCycle A
			INNER JOIN JMBkpStats JBS WITH (READUNCOMMITTED) ON A.AppId = JBS.AppId AND A.fullCycleNum = JBS.fullCycleNum
			INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED) ON JBS.JobID = JDS.jobId AND JBS.commCellId = JDS.commCellId AND A.srcCopyId = JDS.archGrpCopyId
			LEFT OUTER JOIN JMJobDataStats JDSD WITH (READUNCOMMITTED) ON JDS.JobID = JDSD.jobId AND JDS.commCellId = JDSD.commCellId AND A.destCopyId = JDSD.archGrpCopyId AND JDS.dataType = JDSD.dataType
	WHERE	JDS.status IN (100, 101, 102, 103)
			AND (JDS.disabled & 257) = 0
			AND JDSD.JobId IS NULL
END
--Apply job retention option (if applicable)
EXEC archPinJobsBasedOnJobOption 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET	@o_retVal = (SELECT ERROR_NUMBER())
END CATCH
RETURN_PROC:
IF (@o_retVal = 0) AND EXISTS(SELECT 1 FROM #tblSelectedJobs)
BEGIN
	IF(OBJECT_ID('tempdb..#tmpSelectedJobsResult') IS NULL)
		SELECT distinct 0, J.jobId, J.commcellId, J.copyId, J.dataType, CASE WHEN ASCP.copyId IS NULL THEN 0 ELSE 1 END
		FROM #tblSelectedJobs J LEFT OUTER JOIN ArchSelectiveCopy ASCP WITH(NOLOCK) ON J.copyId = ASCP.copyId
	ELSE
		INSERT INTO #tmpSelectedJobsResult
		SELECT distinct 0, J.jobId, J.commcellId, J.copyId, J.dataType, CASE WHEN ASCP.copyId IS NULL THEN 0 ELSE 1 END
		FROM #tblSelectedJobs J LEFT OUTER JOIN ArchSelectiveCopy ASCP WITH(NOLOCK) ON J.copyId = ASCP.copyId
END
ELSE
BEGIN
	IF(OBJECT_ID('tempdb..#tmpSelectedJobsResult') IS NULL)
		SELECT   @o_retVal, 0, 0, 0, 0, 0
	ELSE
		INSERT INTO #tmpSelectedJobsResult
		SELECT   @o_retVal, 0, 0, 0, 0, 0
END
if (OBJECT_ID('tempdb.dbo.#tempCopy') IS NOT NULL) DROP TABLE #tempCopy
if (OBJECT_ID('tempdb.dbo.#tempJobDataStats') IS NOT NULL) DROP TABLE #tempJobDataStats
IF (OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL) DROP TABLE #tmpAppIdList
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
if object_id('tempdb.dbo.#copyIdToProcess') is not null DROP TABLE #copyIdToProcess
if object_id('tempdb.dbo.#archCopyToAppId') is not null DROP TABLE #archCopyToAppId
IF OBJECT_ID('tempdb..#archDestinationCopyListResultTable') IS NOT NULL DROP TABLE #archDestinationCopyListResultTable
IF OBJECT_ID('tempdb..#TM_GetNextScheduleRunTimeResultTable') IS NOT NULL DROP TABLE #TM_GetNextScheduleRunTimeResultTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SelectJobForAuxCopy')
	delete from GxQscripts where name = 'SelectJobForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SelectJobForAuxCopy')
	delete from GXDBVersions where aliasname = 'SelectJobForAuxCopy'
GO

insert into GXDBVersions values(2, 'SelectJobForAuxCopy',  '00010150000200440000', 'SelectJobForAuxCopy', '00010150000200440000')
GO

