

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SelectJobForArchCheck.sp] ---------- 

--#include "DBaccess.h"
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SelectJobForArchCheck.sp,v $ $Id: SelectJobForArchCheck.sp,v 1.15.88.2 2020/02/14 21:59:15 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SelectJobForArchCheck')
BEGIN
	print '>>> Drop Stored Procedure: SelectJobForArchCheck <<<'
	drop procedure SelectJobForArchCheck
END
IF EXISTS (select * from GxQscripts where name='SelectJobForArchCheck')
	delete from GxQscripts where name = 'SelectJobForArchCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SelectJobForArchCheck')
	delete from GXDBVersions where aliasname = 'SelectJobForArchCheck'
GO
print '... Creating Procedure: SelectJobForArchCheck'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SelectJobForArchCheck
  @i_commCellId integer,
  @i_jobId integer,
  @i_backupLevel integer,
  @i_now integer
AS
--      returning integer;	--skip for mssql7--
  DECLARE @retVal integer;
--  :RETURN: retVal	--skip for mssql7--
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @tblCopy  TABLE (id INT, archGroupId INT)
DECLARE @tblAFile TABLE (id INT)
INSERT	INTO @tblCopy
SELECT	id, archGroupId
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id IN (SELECT DISTINCT archGrpCopyId FROM JMJobDataStats WITH (NOLOCK)
				WHERE jobId = @i_jobId AND commCellId = @i_commCellId)
    AND archCheckStartTime < @i_now
    AND ((flags & 128) <> 0 OR (flags & 256) <> 0 AND @i_backupLevel IN (1, 64, 128, 1024, 32768))
IF @@ERROR = 0 AND EXISTS (SELECT * FROM @tblCopy)
BEGIN
	INSERT	INTO @tblAFile
    SELECT	id
    FROM	archFile WITH (NOLOCK)
    WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
		AND archGroupId IN (SELECT archGroupId FROM @tblCopy)
		AND isValid = 1
    SET @retVal = @@ERROR
    IF  @retVal <> 0 GOTO FINISH
    BEGIN TRANSACTION
UPDATE	archChunkMapping SET flags = ((flags & (~255)) | 1)
	FROM	archChunkMapping A, @tblAFile B
	WHERE	A.archFileId = B.id AND A.commCellId = @i_commCellId
		AND A.archCopyId IN (SELECT id FROM @tblCopy)
		AND (flags & 1) = 0
    SET @retVal = @@ERROR
    IF  @retVal = 0
    BEGIN
		UPDATE	JMJobDataStats SET archCheckStatus = 3, modifiedTime = @i_now
		WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
			AND archGrpCopyId IN (SELECT id FROM @tblCopy)
			AND archCheckStatus <> 3
		SET @retVal = @@ERROR
		IF  @retVal = 0
			COMMIT   TRANSACTION
	END
	IF  @retVal <> 0
		ROLLBACK TRANSACTION
END
FINISH:
SELECT   @retVal
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'SelectJobForArchCheck')
	delete from GxQscripts where name = 'SelectJobForArchCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SelectJobForArchCheck')
	delete from GXDBVersions where aliasname = 'SelectJobForArchCheck'
GO

insert into GXDBVersions values(2, 'SelectJobForArchCheck',  '00010015008800020000', 'SelectJobForArchCheck', '00010015008800020000')
GO

