

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/Sec_PseudoClientCreation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/Sec_PseudoClientCreation.sp,v $ $Id: Sec_PseudoClientCreation.sp,v 1.6.12.7 2020/03/24 19:26:16 ssivananthan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='Sec_PseudoClientCreation')
BEGIN
	print '>>> Drop Stored Procedure: Sec_PseudoClientCreation <<<'
	drop procedure Sec_PseudoClientCreation
END
IF EXISTS (select * from GxQscripts where name='Sec_PseudoClientCreation')
	delete from GxQscripts where name = 'Sec_PseudoClientCreation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Sec_PseudoClientCreation')
	delete from GXDBVersions where aliasname = 'Sec_PseudoClientCreation'
GO
print '... Creating Procedure: Sec_PseudoClientCreation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure Sec_PseudoClientCreation
  @xmlText XML,
  @userId integer, 
  @localeId integer,
  @clientType integer,
  @clientSubType integer
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @errorCode integer
  DECLARE @errorString NVARCHAR(MAX) 
DECLARE @memberServers TABLE ( entityId INT, isClientGroup INT )
DECLARE @clientList TABLE ( id INT )
DECLARE @commcellId INT =2
DECLARE @objMessType INT
DECLARE @entityNames nvarchar(max)
DECLARE @capabilitiesRequired BIGINT
DECLARE @capability INT
DECLARE @checkCapabilityOnAny INT
DECLARE @objectName nvarchar(100)
DECLARE @userName nvarchar(100)
SET @errorCode = 0
SET @errorString = ''
-- GET ALL MEMBER SERVERS
INSERT  INTO @memberServers
SELECT  ISNULL(ref.value('@clientId', 'int'),0) , 0
FROM    @xmlText.nodes('App_Associations/entity') R ( ref )
INSERT  INTO @memberServers
SELECT  ISNULL(ref.value('@clientGroupId', 'int'),0) , 1
FROM    @xmlText.nodes('App_Associations/entity') R ( ref )
-- CHECK INPUT
IF @userId = 0
BEGIN
	SET @errorCode = 1
	GOTO ENDSP
END
SET @userName  = ISNULL((SELECT login from UMUSERS where id = @userId),'')
-- ClientType_RAC= 3,
-- ClientType_DB2_DPF= 4,
-- ClientType_EXCHANGE_2010_DAG_CLIENT= 8,
-- ClientType_CONTENT_STORE_CLIENT= 9,
-- ClientType_WINDOWS_CLUSTER_CLIENT= 10,
-- ClientType_UNIX_CLUSTER_CLIENT= 11,
-- ClientType_VIRTUAL_SERVER_CLIENT= 12,
-- ClientType_OPEN_VMS_CLIENT= 13,
-- ClientType_REFERENCE_COPY_CLIENT= 14,
-- ClientType_CLOUD_CONNECTOR_CLIENT= 15,
-- ClientType_DISTRIBUTED_DATABASE_CLIENT= 16,
-- ClientType_IBM_ISERIES_CLIENT= 17,
-- ClientType_MSSQL_AG= 20,
-- ClientType_EXCHANGE_ONEPASS= 25,
-- ClientType_NOTES_ONEPASS= 26,
-- ClientType_SHAREPOINT_FARM= 27,
-- ClientType_OFFICE_365_CLIENT= 37,
-- ClientType_AZURE_AD_CLIENT= 38,
-- ClientType_DISTRIBUTED_SYSTEM_CLIENT= 42,
IF @clientType IN (3,4,8,9,10,11,12,13,15,20,25,26,27,37,38,42) -- VIRTUAL_SERVER_CLIENT=12,ClientType_SHAREPOINT_FARM = 27
BEGIN
SET @capability = 2
END
IF @clientType IN (14) AND @clientSubType NOT IN (0) -- REFERENCE_COPY_CLIENT=14; Subtype REFERENCE_COPY,	CASE_MANAGER_INLINE,	CASE_MANAGER_REGULAR
BEGIN
SET @capability = 25
	SET @checkCapabilityOnAny = 1
END
SET @capabilitiesRequired = CAST(POWER(2.0,@capability  - 1) AS BIGINT)
------ Get accessible client group list ------------
IF object_id('tempdb.dbo.#clientListTemp') is not null DROP TABLE #clientListTemp
create table  #clientListTemp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 0, 0, '#clientListTemp'
-- If user has EV_FAST_COMPLIANCE_SEARCH on any of the entities
IF @checkCapabilityOnAny  = 1
BEGIN
	IF EXISTS (SELECT * FROM #clientListTemp WHERE (capabilities & @capabilitiesRequired <> 0))
		GOTO ENDSP
	ELSE
	BEGIN
		-- GUIMSG_SECURITY_USER_CAPABILITY_AT_ANY_LEVEL,CLIENT         User [^1%s] does not have required capability [^2%s] at any level.
set @errorString = (select message from EvLocaleMsgs Where messageId=(1936 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', (SELECT name from UMUSERS where id = @userId))
		SET @errorString = REPLACE(@errorString, '^2%s',
			dbo.fn_EvFormatEventMsgText(0,@localeId,
				IsNull((Select tokenId from UMCapability where id = @capability),
					(Select tokenId from UMCapability where id = 31)),
			0,2))
		SET @errorCode = 2
		GOTO ENDSP
	END
END
delete #clientListTemp
WHERE mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0
		OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0  OR taskId <> 0
		OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
		OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
		OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
		OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
-- ALL ASSOC
IF EXISTS (SELECT * FROM #clientListTemp T WHERE (T.commCellId=2 AND T.clientGroupId=0 AND T.clientId=0 AND T.appTypeId=0 AND T.instanceId=0 AND T.backupsetId=0 AND T.subClientId=0 AND T.mediaAgentId=0 AND T.libraryId=0 AND T.archGroupId=0 AND T.vtContainerId=0 AND T.vtPolicyId=0 AND T.vtShelfId=0 AND T.reviewSetId=0 AND T.querySetId=0 AND T.downloadSetId=0 AND T.ermId=0 AND T.legalHoldId=0 AND T.tagId=0 AND T.cdPolicyId=0 AND T.complianceReportId=0 AND T.taskId=0 AND T.workflowId=0 AND T.logMonitoringPolicyId=0 AND T.arrayId=0 AND T.cloudId=0 AND T.userGroupId=0 AND T.providerId=0 AND T.entityId1=0 AND T.entityId2=0 AND T.entityId3=0 AND T.entityId4=0 AND T.entityId5=0									AND T.entityId6=0 AND T.entityId7=0 AND T.entityId8=0 AND T.entityId9=0)
and  (T.capabilities & @capabilitiesRequired <> 0))
BEGIN
	GOTO ENDSP
END
ELSE
BEGIN
	IF @clientType IN (10,11)
	BEGIN
		-- Check if the client has agent management on atleast one client group
		IF EXISTS (SELECT T.clientGroupId FROM #clientListTemp T
		WHERE T.capabilities & @capabilitiesRequired = @capabilitiesRequired
		and T.clientGroupId > 0 and T.commCellId = 2 )
			GOTO ENDSP
		ELSE
		BEGIN
			-- ERROR
			SET @entityNames = 'any Client group'
		END
	END
	ELSE
	BEGIN
		DELETE @memberServers where entityId = 0
		DECLARE @disableUseProxyCheck INT = 0
SET @disableUseProxyCheck = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'DisableUseProxyCheck'),0)
		IF @disableUseProxyCheck = 0
		BEGIN
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable CREATE TABLE #getPermissionsOnEntities_InputTable ( entityId1 INT, entityId2 INT DEFAULT 0, entityId3 INT DEFAULT 0, entityId4 INT DEFAULT 0, entityId5 INT DEFAULT 0 ) IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable CREATE TABLE #getPermissionsOnEntities_OutputTable ( entityId1 INT, entityId2 INT, entityId3 INT, entityId4 INT, entityId5 INT, permissionsString VARCHAR(512), isChildRow BIT DEFAULT 0	        )
			INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
			SELECT entityId, 0, 0, 0,0 FROM @memberServers WHERE isClientGroup = 0
EXEC sec_getPermissionsOnEntities @userId, 3
			DELETE FROM #getPermissionsOnEntities_OutputTable
WHERE (SUBSTRING(permissionsString,252,1) != CAST(1 AS NVARCHAR(1))) AND
(SUBSTRING(permissionsString,2,1) != CAST(1 AS NVARCHAR(1)))
			INSERT INTO @clientList
			SELECT entityId FROM @memberServers
			WHERE isClientGroup = 0 AND entityId IN(SELECT entityId1 FROM #getPermissionsOnEntities_OutputTable)
			DELETE @memberServers where entityId  in (select id from @clientList) and isClientGroup = 0
			IF(SELECT COUNT(*) FROM @memberServers where isClientGroup = 0) > 0
			BEGIN
				SELECT @entityNames= coalesce(@entityNames + ', ', '') + a.name
				FROM (SELECT DISTINCT name from APP_CLIENT C ,@memberServers tmp where C.id = tmp.entityId and isClientGroup = 0) a
				SET @errorCode = 2
				DELETE @clientList
			END
			IF OBJECT_ID('tempdb.dbo.#sec_GetEntity2') IS NOT NULL     DROP TABLE #sec_GetEntity2
			CREATE  TABLE #sec_GetEntity2 ( entityId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 28 /*CLIENT_GROUP_ENTITY*/ , 252 ,'#sec_GetEntity2'
			INSERT INTO @clientList
			SELECT M.entityId FROM #sec_GetEntity2 E, @memberServers M
			WHERE E.entityId = M.entityId AND isClientGroup = 1
			DELETE @memberServers where entityId  in (select id from @clientList) and isClientGroup = 1
			IF(SELECT COUNT(*) FROM @memberServers where isClientGroup = 1) > 0
			BEGIN
				DECLARE @clientGroupNames nvarchar(MAX)
				SELECT @clientGroupNames= coalesce(@clientGroupNames + ', ', '') + a.name
				FROM (SELECT DISTINCT name from APP_CLIENTGROUP CG ,@memberServers tmp where CG.id = tmp.entityId and isClientGroup = 1) a
				SET @errorCode = 2
				IF @entityNames <> ''
					SET  @entityNames =  @entityNames + ',' + @clientGroupNames
				ELSE
					SET @entityNames = @clientGroupNames
				DELETE @clientList
			END
		END
		ELSE -- fall back to old agent management check
		BEGIN
			-- SELECT clients with Agent managemnet
			INSERT INTO @clientList
			SELECT M.entityId FROM #clientListTemp T,@memberServers M
			WHERE T.capabilities & @capabilitiesRequired = @capabilitiesRequired
			and T.clientId = M.entityId and M.isClientGroup = 0
			DELETE @memberServers where entityId  in (select id from @clientList) and isClientGroup = 0
			IF(SELECT COUNT(*) FROM @memberServers where isClientGroup = 0) > 0
			BEGIN
				SELECT @entityNames= coalesce(@entityNames + ', ', '') + a.name
				FROM (SELECT DISTINCT name from APP_CLIENT C ,@memberServers tmp where C.id = tmp.entityId and isClientGroup = 0) a
				SET @errorCode = 2
				DELETE @clientList
			END
			-- SELECT client groups with Agent managemnet
			INSERT INTO @clientList
			SELECT M.entityId FROM #clientListTemp T,@memberServers M
			WHERE T.capabilities & @capabilitiesRequired = @capabilitiesRequired
			and T.clientGroupId = M.entityId and M.isClientGroup = 1
			DELETE @memberServers where entityId  in (select id from @clientList) and isClientGroup = 1
			IF(SELECT COUNT(*) FROM @memberServers where isClientGroup = 1) > 0
			BEGIN
				SELECT @clientGroupNames= coalesce(@clientGroupNames + ', ', '') + a.name
				FROM (SELECT DISTINCT name from APP_CLIENTGROUP CG ,@memberServers tmp where CG.id = tmp.entityId and isClientGroup = 1) a
				SET @errorCode = 2
				IF @entityNames <> ''
					SET  @entityNames =  @entityNames + ',' + @clientGroupNames
				ELSE
					SET @entityNames = @clientGroupNames
				DELETE @clientList
			END
		END
	END
	IF @entityNames <> ''
	BEGIN
set @objMessType = (1015 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	set @objectName = dbo.fn_EvFormatEventMsgText(0,@localeId, @objMessType, 0,@commcellId)
	--GUIMSG_SECURITY_USER_NO_CAPABILITIES_ON_OBJECT
	--User [^1%s] does not have required capability [^2%s] on ^3%a[^4%s] for this operation.
set @errorString = (select message from EvLocaleMsgs Where messageId=(2246 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
    SET @errorString = REPLACE(@errorString, '^1%s', @userName)
    SET @errorString = REPLACE(@errorString, '^2%s',
        dbo.fn_EvFormatEventMsgText(0,@localeId,
            IsNull((Select tokenId from UMCapability where id = @capability),
                (Select tokenId from UMCapability where id = 31)),
        0,2))
    SET @errorString = REPLACE(@errorString, '^3%a', @objectName)
	SET @errorString = REPLACE(@errorString, '^4%s', @entityNames)
	SET @errorCode = 2
	END
	GOTO ENDSP
END
ENDSP:
DROP TABLE #clientListTemp
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'Sec_PseudoClientCreation')
	delete from GxQscripts where name = 'Sec_PseudoClientCreation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Sec_PseudoClientCreation')
	delete from GXDBVersions where aliasname = 'Sec_PseudoClientCreation'
GO

insert into GXDBVersions values(2, 'Sec_PseudoClientCreation',  '00010006001200070000', 'Sec_PseudoClientCreation', '00010006001200070000')
GO

