

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SearchSecurityCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SearchSecurityCheck.sp,v $ $Id: SearchSecurityCheck.sp,v 1.12.44.2 2018/03/20 00:35:21 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   SearchSecurityCheck   - Finds out the entities on which user has browse capability
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SearchSecurityCheck <<<'

IF EXISTS (select * from sysobjects where name='SearchSecurityCheck')
	drop procedure SearchSecurityCheck
IF EXISTS (select * from GxQscripts where name='SearchSecurityCheck')
	delete from GxQscripts where name = 'SearchSecurityCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SearchSecurityCheck')
	delete from GXDBVersions where aliasname = 'SearchSecurityCheck'
GO
print '... Creating Procedure: SearchSecurityCheck'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SearchSecurityCheck
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @uid int,
  @i_clientGroup VARCHAR(MAX),
  @i_clientList VARCHAR(MAX),
  @i_appTypeList VARCHAR(MAX),
  @i_instanceId int,
  @i_backupsetId int
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
DECLARE @sqlStr VARCHAR(MAX)
EXEC sec_updateUserCredentials @uid
IF object_id('tempdb.dbo.#tempUserIdaObjects') is not null
        DROP TABLE #tempUserIdaObjects
IF object_id('tempdb.dbo.#ClientList') is not null
     DROP TABLE #ClientList
IF object_id('tempdb.dbo.#AppList') is not null
     DROP TABLE #AppList
CREATE TABLE #ClientList
(
  id INTEGER
)
CREATE TABLE #AppList
(
  id INTEGER
)
insert into #appList select _ID from SplitIDs(@i_appTypeList)
insert into #ClientList select _ID from SplitIDs(@i_clientList)
insert into #ClientList select clientId from APP_ClientGroupAssoc where
        clientGroupId in ( select _ID from SplitIDs(@i_clientGroup))
DECLARE  @searchLevel int
SET @searchLevel = (case	when NOT EXISTS (select * from #ClientList) THEN 0		--CommCell level
							when NOT EXISTS (select * from #appList) THEN 1			--client
							when EXISTS (select * from #appList) THEN 2				--apptype
							when @i_instanceId > 0 THEN 3							--instance
							when @i_backupsetId > 0 THEN 4							--backupset
							else 5													--subclient
					end)
CREATE TABLE #tempUserIdaObjects
(
   clientId INTEGER,
   appTypeId INTEGER,
   instanceId integer,
   backupSetId INTEGER,
   subclientId INTEGER
)
IF object_id('tempdb.dbo.#SearchSecurityCheck_userObjects') is not null
	DROP TABLE #SearchSecurityCheck_userObjects
create table  #SearchSecurityCheck_userObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
 EXEC sec_getUserObjects @uid,0,0,'#SearchSecurityCheck_userObjects'
INSERT into #tempUserIdaObjects
	SELECT (case cr.clientGroupId when 0 then cr.clientId ELSE assoc.clientId END),
			cr.appTypeId, cr.InstanceId, cr.backupsetId, cr.subclientId
	FROM #SearchSecurityCheck_userObjects cr
	left outer join APP_ClientGroupAssoc assoc on cr.clientGroupId=assoc.clientGroupId
	WHERE ((POWER(2,12)|POWER(2,24)|POWER(2,19)|POWER(2,21)) & capabilities) <> 0 AND  mediaAgentId = 0 AND libraryID = 0 AND archGroupID = 0
select A.clientId, A.appTypeId, A.instance, A.backupset, A.id
into #tempAppList
from APP_application A
where (A.clientId in (select id from #ClientList) OR NOT EXISTS(select * from  #ClientList))AND
		(A.apptypeId in (select id from #appList) OR NOT EXISTS (select * from #appList)) AND
		@i_instanceId IN (0, A.instance) AND
		@i_backupsetId IN (0, A.backupset)
SELECT	DISTINCT
	clientId	= (CASE WHEN @searchLevel < 1 AND T.clientId = 0 THEN 0 ELSE A.clientId END),
	appTypeId	= (CASE WHEN @searchLevel < 2 AND T.appTypeId = 0 THEN 0 ELSE A.appTypeId END),
	subclientId	= (CASE WHEN @searchLevel < 3 AND (T.instanceId = 0 AND T.backupsetId = 0 AND T.subClientId = 0) THEN 0
						WHEN T.subClientId > 0 THEN T.subClientId ELSE A.id END)
into #temp
FROM	#tempUserIdaObjects T, #tempAppList A
WHERE	(T.clientId = 0 OR T.clientId = A.clientId) AND
	(T.appTypeId = 0 OR T.appTypeId = A.appTypeId) AND
	(T.instanceId = 0 OR T.instanceId = A.instance) AND
	(T.backupsetId = 0 OR T.backupsetId = A.backupset) AND
	(T.subClientId = 0 OR T.subClientId = A.id)
ORDER BY clientId, appTypeId, subclientId
delete from #temp where exists (select * from #temp L1 where L1.clientId=0) and clientId!=0
delete #temp FROM #temp AS L0 where exists (select * from #temp L1 where L0.clientId = L1.clientId and L1.apptypeId = 0) AND appTypeId!=0
delete  #temp FROM #temp AS L0 where exists (select * from #temp L1 where L0.clientId = L1.clientId and L0.apptypeId = L1.apptypeId AND L1.subclientId=0 ) AND subclientId!=0
select * from #temp
drop table #temp
drop table #tempUserIdaObjects
DROP TABLE #ClientList
DROP TABLE #AppList
drop table #tempAppList
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SearchSecurityCheck')
	delete from GxQscripts where name = 'SearchSecurityCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SearchSecurityCheck')
	delete from GXDBVersions where aliasname = 'SearchSecurityCheck'
GO

insert into GXDBVersions values(2, 'SearchSecurityCheck',  '00010012004400020000', 'SearchSecurityCheck', '00010012004400020000')
GO

