

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedUpdateSchePolicyAssoc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedUpdateSchePolicyAssoc.sp,v $ $Id: SchedUpdateSchePolicyAssoc.sp,v 1.4 2008/03/18 19:53:29 g8builder Exp $";
--
--  +========================================================================+
--  |   Procedure:  SchedUpdateSchePolicyAssoc
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:  Fetches detailed information for the specified Notification
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedUpdateSchePolicyAssoc <<<'

IF EXISTS (select * from sysobjects where name='SchedUpdateSchePolicyAssoc')
	drop procedure SchedUpdateSchePolicyAssoc
IF EXISTS (select * from GxQscripts where name='SchedUpdateSchePolicyAssoc')
	delete from GxQscripts where name = 'SchedUpdateSchePolicyAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedUpdateSchePolicyAssoc')
	delete from GXDBVersions where aliasname = 'SchedUpdateSchePolicyAssoc'
GO
print '... Creating Procedure: SchedUpdateSchePolicyAssoc'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SchedUpdateSchePolicyAssoc
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlString nvarchar(MAX)
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
	DECLARE @errorStr nvarchar(1024)
	DECLARE @scheduleId INT
	DECLARE @backupTaskId INT
	DECLARE @id                   integer
	DECLARE @scheduleTemplateId   integer
	DECLARE @scheduleTemplateInstanceId   integer
	DECLARE @dataSourceId         integer
	DECLARE @scId               integer
	DECLARE @type                 integer
	DECLARE @commCellId           integer
	DECLARE @clientId             integer
	DECLARE @appTypeId            integer
	DECLARE @instanceId            integer
	DECLARE @backupSetId           integer
	DECLARE @flags                integer
	DECLARE @serverGroupId		  integer
	DECLARE @retVal               integer
	DECLARE @rowCount	          integer
	DECLARE @policyType			  integer
	declare @iDoc     				int
	SET @retVal = 0
----------------------------------------------------------
--	FETCH PARAMETERS FROM THE XML STRING PASSED IN	--
----------------------------------------------------------
exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @scheduleTemplateId		 = (select * from OPENXML(@iDoc, 'CVGui_UpdateScheduleAssocReq/scheduleAssoc', 0)
				 WITH (schedTemplateId int '@schedTemplateId'))
	set @clientId 		 = (select * from OPENXML(@iDoc, 'CVGui_UpdateScheduleAssocReq/scheduleAssoc', 0)
				 WITH (clientId  int '@clientId'))
	set @appTypeId 		 = (select * from OPENXML(@iDoc, 'CVGui_UpdateScheduleAssocReq/scheduleAssoc', 0)
				 WITH (appTypeId int '@appTypeId'))
	set @instanceId 		 = (select * from OPENXML(@iDoc, 'CVGui_UpdateScheduleAssocReq/scheduleAssoc', 0)
				 WITH (instanceId int '@instanceId'))
	set @backupSetId 		 = (select * from OPENXML(@iDoc, 'CVGui_UpdateScheduleAssocReq/scheduleAssoc', 0)
				 WITH (backupSetNameId int '@backupSetNameId'))
	set @scId 		 = (select * from OPENXML(@iDoc, 'CVGui_UpdateScheduleAssocReq/scheduleAssoc', 0)
				 WITH (subClientNameId int '@subClientNameId'))
	set @serverGroupId 		 = (select * from OPENXML(@iDoc, 'CVGui_UpdateScheduleAssocReq/scheduleAssoc', 0)
				 WITH (serverGroupId int '@serverGroupId'))
	set @flags 		 = (select * from OPENXML(@iDoc, 'CVGui_UpdateScheduleAssocReq/scheduleAssoc', 0)
				 WITH (flag int '@flag'))
--INPUT VALIDATION
--1. Check if schedule template exists or not
SET @policyType = -1
SET @policyType = (SELECT appType FROM schedTemplate WHERE id = @scheduleTemplateId AND (type &2 = 2))
IF @policyType = -1
BEGIN
	SET @retVal = 1
	SET @errorStr = 'Schedule policy does not exists'
	GOTO ERROR_EXIT
END
--2. Check if the input iDA matches with schedule policy
IF (@policyType <> 0) AND (@appTypeId <> 0) AND	(@policyType <> ( SELECT appGroup1 FROM APP_iDAType WHERE type = @appTypeId))
BEGIN
	SET @retVal = 1
	SET @errorStr = 'Schedule policy mismatch for ida type'
	GOTO ERROR_EXIT
END
BEGIN	TRAN
--DISSOCIATE
IF (@flags = 0)
BEGIN
  IF (@serverGroupId =0)
  BEGIN
    DELETE FROM SCHEDULE WHERE Id IN (select scheduleId FROM SchedBackupTask WHERE clientId = @clientId AND  (@appTypeId = 0 OR appTypeId = @appTypeId) AND (@instanceId = 0 OR instance = @instanceId) AND (@backupSetId = 0 OR backupset = @backupSetId) AND (@scId = 0 OR subclient = @scId) AND scheduleId IN ( SELECT id FROM SCHEDULE  where schedTemplateInstanceId IN (SELECT id FROM schedTemplateInstance WHERE schedTemplateId = @scheduleTemplateId) AND tasktype = 1))
  END
  ELSE
  BEGIN
	DELETE FROM SCHEDULE WHERE Id IN (select scheduleId  FROM SchedBackupTask WHERE clientId = 0 AND  appTypeId = 0 AND instance = 0 AND backupset = 0 AND subclient = 0 AND scheduleId IN ( SELECT id FROM SCHEDULE  where schedTemplateInstanceId IN (SELECT id FROM schedTemplateInstance WHERE schedTemplateId = @scheduleTemplateId) AND tasktype = 1) AND id IN ( SELECT backuptaskId FROM SchedBackupTaskOptions WHERE name = 'ClientGroupId' AND value = CAST (@serverGroupId AS varchar(20))))
  END
END
--ASSOCIATE
ELSE
BEGIN
  --Check if schedule association already EXISTS
	IF (@serverGroupId <> 0)
	 SET @rowCOunt = (select count(*)  FROM SchedBackupTask WHERE clientId = 0 AND  appTypeId = 0 AND instance = 0 AND backupset = 0 AND subclient = 0 AND scheduleId IN ( SELECT id FROM SCHEDULE  where schedTemplateInstanceId IN (SELECT id FROM schedTemplateInstance WHERE schedTemplateId = @scheduleTemplateId) AND tasktype = 1) AND id IN ( SELECT backuptaskId FROM SchedBackupTaskOptions WHERE name = 'ClientGroupId' AND value = CAST (@serverGroupId AS varchar(20))))
	ELSE
	 SET @rowCOunt = (select count(*) FROM SchedBackupTask WHERE clientId = @clientId AND  (appTypeId IN ( 0 ,@appTypeId)) AND (instance IN ( 0 ,@instanceId)) AND (backupSet IN ( 0 ,@backupSetId)) AND ( subclient IN (0, @scId)) AND scheduleId IN ( SELECT id FROM SCHEDULE  where schedTemplateInstanceId IN (SELECT id FROM schedTemplateInstance WHERE schedTemplateId = @scheduleTemplateId) AND tasktype = 1))
	IF (@rowCount  <> 0)
	BEGIN
		SET @retVal = 1
		SET @errorStr = 'Association already exist or covered by parent node.'
		GOTO ERROR_EXIT
	END
	--REMOVE EXISTING CHILD ASSOCIATION
	DELETE FROM SCHEDULE WHERE Id IN (select scheduleId FROM SchedBackupTask WHERE clientId = @clientId AND  (@appTypeId = 0 OR appTypeId = @appTypeId) AND (@instanceId = 0 OR instance = @instanceId) AND (@backupSetId = 0 OR backupset = @backupSetId) AND (@scId = 0 OR subclient = @scId) AND scheduleId IN ( SELECT id FROM SCHEDULE  where schedTemplateInstanceId IN (SELECT id FROM schedTemplateInstance WHERE schedTemplateId = @scheduleTemplateId) AND tasktype = 1))
	DECLARE SchedTemplateInstanceCur1 CURSOR LOCAL
	FORWARD_ONLY
	FOR
	SELECT id from SchedTemplateInstance where schedTemplateId = @scheduleTemplateId
	OPEN SchedTemplateInstanceCur1
	FETCH NEXT FROM SchedTemplateInstanceCur1  INTO @scheduleTemplateInstanceId
	WHILE @@FETCH_STATUS = 0
	BEGIN
	--INSERT SCHEDULE
	INSERT INTO schedule
	SELECT  [taskId]
		   ,1
           ,[type]
           ,[counter]
           ,[errors]
           ,[fireIfMissed]
           ,[canBeDeleted]
           ,[inProcess]
           ,[canBeEdited]
           ,[isReported]
           ,[isSingleton]
           ,[sCount]
           ,[mask]
           ,[monthDay]
           ,[occurence]
           ,[dayNumber]
           ,[atTime]
           ,[interval]
           ,[endValue]
           ,[startTime]
           ,[flags]
           ,[ds_flags]
           ,[tz_offset]
           ,[tz_name]
           ,[taskDescription]
           ,[nextEvent]
           ,[firstEvent]
           ,[lastEvent]
           ,[lastAttempt]
           ,[schedTemplateInstanceId]
           ,[endOfDay]
           ,[skipOccurence]
           ,[skipDayNumber]
           ,[calendarId]
			FROM
			SCHEDULE where schedTemplateInstanceId = @scheduleTemplateInstanceId AND tasktype = 8
	SET @scheduleId = @@IDENTITY
	--INSERT THE BACKUP TASK ENTRY
	INSERT INTO [SchedBackupTask]
	SELECT  @scheduleId
           ,0
           ,[userId]
           ,[sequenceNumber_h]
           ,[sequenceNumber_l]
           ,[type]
           ,@clientId
           ,@appTypeId
           ,@instanceId
           ,@backupsetId
           ,@scId
           ,[description]
           ,[flags]
           ,[alertId]
           ,[jobDescription]
			FROM SchedBackupTask
			WHERE scheduleId IN ( SELECT id FROM SCHEDULE  where schedTemplateInstanceId = @scheduleTemplateInstanceId AND tasktype = 8)
	SET @backupTaskId = @@IDENTITY
	UPDATE schedule SET taskId = @backupTaskId WHERE id = @scheduleId
	IF @backupsetId <> 0
		UPDATE [SchedBackupTask] SET dataSourceId = @backupsetId WHERE id = @backupTaskId
	IF @scId  <> 0
		UPDATE [SchedBackupTask] SET dataSourceId = @scId WHERE id = @backupTaskId
	--INSERT THE BACKUP TASK PARAM
	INSERT INTO [SchedBackupTaskOptions]
	SELECT @backupTaskId
           ,[name]
           ,[value]
	FROM SchedBackupTaskOptions WHERE backupTaskId =  ( SELECT ID FROM SchedBackupTask WHERE scheduleId IN ( SELECT id FROM SCHEDULE where schedTemplateInstanceId = @scheduleTemplateInstanceId AND tasktype = 8))
	FETCH NEXT FROM SchedTemplateInstanceCur1  INTO @scheduleTemplateInstanceId
	END
	CLOSE SchedTemplateInstanceCur1
	DEALLOCATE SchedTemplateInstanceCur1
END
ERROR_EXIT:
SELECT	@retVal,@errorStr
if (@retVal = 0)
    COMMIT TRAN
else
    ROLLBACK TRAN
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SchedUpdateSchePolicyAssoc')
	delete from GxQscripts where name = 'SchedUpdateSchePolicyAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedUpdateSchePolicyAssoc')
	delete from GXDBVersions where aliasname = 'SchedUpdateSchePolicyAssoc'
GO

insert into GXDBVersions values(2, 'SchedUpdateSchePolicyAssoc',  '00010004000000000000', 'SchedUpdateSchePolicyAssoc', '00010004000000000000')
GO

