

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedPowerRstSearch.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/31/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedPowerRstSearch.sp,v $ $Id: SchedPowerRstSearch.sp,v 1.20.294.1 2018/03/20 00:49:24 jiechen Exp $";
-- ----------------------------------------------------------------------
-- This Stored Procedure code is shared by the DM2 Web and CommServ
-- Java UI. While creating the update for this stored procedure, submit
-- 2 different Update Request forms.
-- 1. For Java UI update, specify the modified filename as
--    SchedPowerRstSearch.spb and SchedPowerRstSearch.sp and DLL name
-- 2. For Web update, create Install.sql and UnInstall.sql manully.
--	  Install.sql should contain the latest code and UnInstall.sql
--    should contain the code of stored procedure from previous version.
--    Both Install.sql and UnInstall.sql should have ALTER PROCEDURE
--    command instead of CREATE PROCEDURE command and remove the
--    INSERT INTO GxDBVersions line.
-- ----------------------------------------------------------------------
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedPowerRstSearch <<<'

IF EXISTS (select * from sysobjects where name='SchedPowerRstSearch')
	drop procedure SchedPowerRstSearch
IF EXISTS (select * from GxQscripts where name='SchedPowerRstSearch')
	delete from GxQscripts where name = 'SchedPowerRstSearch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedPowerRstSearch')
	delete from GXDBVersions where aliasname = 'SchedPowerRstSearch'
GO
print '... Creating Procedure: SchedPowerRstSearch'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedPowerRstSearch
  @xmlPowerRestore XML
AS
  DECLARE @i_TaskId integer
	DECLARE @i_JobId		int
	DECLARE @i_Found		bit
	DECLARE @i_SourceId		int
	DECLARE @i_UserId		int
	DECLARE @isLegalHold	bit
	DECLARE @skipRstJob		bit
	DECLARE @appId			int
	DECLARE @backupJobId	int
	DECLARE @i_UserName		nvarchar(255)
	DECLARE @i_UserPswd		nvarchar(400)
	DECLARE @i_ExtendOpt	nvarchar(1024)
	DECLARE @t_JobId		TABLE( jobId int )	--Power Restore JobId
	DECLARE @t_lghlJobId	TABLE( jobId int )	--Legal Hold JobId
	DECLARE @destClientId	int
	DECLARE @i_searchId		int
	DECLARE @i_backupSet	int
	DECLARE @i_appType		int
	DECLARE @i_user			nvarchar(255)
	DECLARE @i_JobExpDate	nvarchar(255)
	SET @i_JobId = 0
	SET @backupJobId = 0
	SET @skipRstJob = 0
	SET @isLegalHold = 0
	SET @i_searchId = 0
	SET @i_SourceId = 2
	SET @appId = 0
	SET @i_appType = 0
	SET @i_Found = @xmlPowerRestore.exist('/CVGui_StartPowerRstSearchReq')
	IF @i_Found > 0
	BEGIN
		SET @i_UserId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
		--SET @i_UserPswd = (SELECT TOP(1) password FROM UMUSERS)
		SET @i_UserName = ISNULL (( SELECT ref.value('@netUserName', 'nvarchar(255)')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), '')
		SET @i_UserPswd = ISNULL (( SELECT ref.value('@netUserPswd', 'nvarchar(400)')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), '')
		SET @i_user = ISNULL (( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), '')
		--GET APP ID FOR LEGAL HOLD
		SET @i_backupSet = ISNULL(( SELECT ref.value('@backupSetId', 'INT')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), 0)
		IF 0 = @i_backupSet
			SELECT TOP(1) @appId = id, @i_appType = appTypeId FROM APP_Application WHERE clientId = 2 AND appTypeId < 1000
		ELSE
			SELECT TOP(1) @appId = id, @i_appType = appTypeId FROM APP_Application WHERE backupSet = @i_backupSet
		--GET APP TYPE
		SET @i_appType = ISNULL (( SELECT ref.value('@appType', 'INT')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), @i_appType)
		--GET SOURCE CLIENT ID
		IF 0 != @i_backupSet
			SET @i_SourceId = (SELECT TOP(1) clientId FROM APP_Application WHERE backupSet = @i_backupSet)
		SET @i_SourceId = ISNULL (( SELECT ref.value('@srcClientId', 'INT')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), @i_SourceId)
		--GET EXTENDED OPTIONS
		SET @i_ExtendOpt = ISNULL(( SELECT ref.value('@extendedOpts', 'nvarchar(1024)')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), '')
		--CHECK FOR LEGAL HOLD JOBS
SET @isLegalHold = CAST(SUBSTRING(@i_ExtendOpt, 47+1, 1) AS BIT) --ER_EX_LGL_HLD_RUN_
		--CHECK FOR FOR SKIP RETORE IN LEGAL HOLD JOBS
SET @skipRstJob = CAST(SUBSTRING(@i_ExtendOpt, 48+1, 1) AS BIT) --ER_EX_LGL_HLD_SKIP_RESTORE_
		--GET CLIENT ID
		SET @destClientId = ISNULL(( SELECT ref.value('@destClientId', 'INT')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), 0)
		SET @i_searchId = ISNULL(( SELECT ref.value('@searchId', 'INT')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), 0)
		--EXPIRATION DATE
		SET @i_JobExpDate = ISNULL (( SELECT ref.value('@JobExpirationDate', 'nvarchar(255)')
						FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), '')
		--SchedRestoreTask
		INSERT INTO SchedRestoreTask
			SELECT TOP(1) S.externRestoreTaskId, S.scheduleId, @i_SourceId, S.backupSetId, @destClientId,
					S.toTime, S.fromTime, @i_appType, S.instanceId, @i_UserId, S.sequenceNumber_h, S.sequenceNumber_l, S.preserveOrStripLevel,
					S.archGroupCopyPrecedence, S.flags, S.type_h, S.type_l, S.alertId, S.jobDescription
				FROM SchedRestoreTask AS S  WHERE flags = 9999
				-- WHERE S.id=1
		SET  @i_TaskId = (select @@identity)
		--Insert into temp table to avoid sending it as a response
		IF @skipRstJob = 0
		BEGIN
			SET @i_JobId = @i_searchId
			--INSERT INTO @t_JobId EXEC @i_JobId = JMGetNextJobId
		END
		IF @isLegalHold = 1 OR @skipRstJob = 1
		BEGIN
			INSERT INTO @t_lghlJobId EXEC @backupJobId = JMGetNextJobId
		END
		--SchedRestoreFiles
		INSERT INTO SchedRestoreFiles
			SELECT @i_TaskId, 2, ref.value('@destPath', 'nvarchar(1024)') FROM  @xmlPowerRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)
		INSERT INTO SchedRestoreFiles VALUES(@i_TaskId, 4, @i_UserName)
		INSERT INTO SchedRestoreFiles VALUES(@i_TaskId, 5, @i_UserPswd)
		--SchedRestoreTaskOptions
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'NO_MAPPING_DATA', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'DRIVE_POOL_ID', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'SYB_DEST_INST_ID', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'JobRetryNumbers', -1)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'PREPOSTCMD_USER_OPTS', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'PREPOSTCMD_USER_NAME', '')
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'PREPOSTCMD_USER_PW', 2)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'USE_EXACT_INDEX', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'START_SUSPENDED', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_FROM_MAP_INPUT_FILE', '')
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'ON_DEMAND_INPUT_FILE', '')
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RAW_PARTITION', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'MEDIA_PREDICTION_FILE', '')
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'JobRetryHrs', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'JobId', @i_JobId)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'ExtendedOptions', @i_ExtendOpt)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_INITIATING_USER_NAME', @i_user)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_LH_APP_ID', @appId)	--SAVE APPID FOR LEGAL HOLD
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_LH_BKP_JOB_ID', @backupJobId)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_LH_CLIENT_ID', @destClientId)
		IF @i_JobExpDate != '0' AND @i_JobExpDate != '-1'
			INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_LH_JOB_EXPIRATION_DATE', dbo.GetUnixTime(dbo.ClientLocalToUTCTime(CAST(@i_JobExpDate AS DATETIME), @i_SourceId)))
		ELSE
			INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_LH_JOB_EXPIRATION_DATE', @i_JobExpDate)
		INSERT INTO Schedule
			SELECT TOP(1) @i_TaskId, 2, 1, counter, errors, fireIfMissed, 1, inProcess, 1, isReported, isSingleton, sCount,
					mask, monthDay, occurence, dayNumber, atTime, interval, endValue, dbo.getUnixTime(GetUTCDate()),
					0, ds_flags, tz_offset, tz_name, '', GetDate(), GetDate(), lastEvent, lastAttempt,
					schedTemplateInstanceId, endOfDay, skipOccurence, skipDayNumber, calendarId
					FROM Schedule WHERE id in ( SELECT scheduleId FROM SchedRestoreTask WHERE flags = 9999)
		--SET @i_JobId = (select @@identity)
		IF @i_searchId != 0
		BEGIN
			UPDATE SchedRestoreSearchTask SET restoreTaskId = @i_TaskId WHERE id = @i_searchId
		END
		SELECT @i_JobId as jobId, @backupJobId as lhJobId
	END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'SchedPowerRstSearch')
	delete from GxQscripts where name = 'SchedPowerRstSearch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedPowerRstSearch')
	delete from GXDBVersions where aliasname = 'SchedPowerRstSearch'
GO

insert into GXDBVersions values(2, 'SchedPowerRstSearch',  '00010020029400010000', 'SchedPowerRstSearch', '00010020029400010000')
GO

