

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedLHIndexFreeRestore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   09/13/2007
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedLHIndexFreeRestore.sp,v $ $Id: SchedLHIndexFreeRestore.sp,v 1.8.290.2 2018/03/20 00:44:43 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedLHIndexFreeRestore <<<'

IF EXISTS (select * from sysobjects where name='SchedLHIndexFreeRestore')
	drop procedure SchedLHIndexFreeRestore
IF EXISTS (select * from GxQscripts where name='SchedLHIndexFreeRestore')
	delete from GxQscripts where name = 'SchedLHIndexFreeRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedLHIndexFreeRestore')
	delete from GXDBVersions where aliasname = 'SchedLHIndexFreeRestore'
GO
print '... Creating Procedure: SchedLHIndexFreeRestore'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedLHIndexFreeRestore
  @xmlRestore XML
AS
  DECLARE @i_TaskId integer
	DECLARE @i_JobId		int
	DECLARE @i_Found		bit
	DECLARE @i_SourceId		int
	DECLARE @i_UserId		int
	DECLARE @i_UserName		nvarchar(255)
	DECLARE @i_UserPswd		nvarchar(400)
	DECLARE @i_destPath		nvarchar(1024)
	DECLARE @t_JobId		TABLE( jobId int )	--Temp table
	DECLARE @schedId		int
	DECLARE @i_backupSet	int
	DECLARE @i_appType		int
	DECLARE @i_user			nvarchar(255)
	DECLARE @i_containerId		nvarchar(255)
	SET @i_SourceId = 2
	SET @i_Found = @xmlRestore.exist('/CVGui_StartLegalHoldRestoreReq')
	IF @i_Found > 0
	BEGIN
		SET @i_UserId = (SELECT TOP(1) id FROM UMUSERS ORDER BY id)
		SET @i_UserName = ISNULL(( SELECT ref.value('@netUserName', 'nvarchar(255)')
							FROM @xmlRestore.nodes('CVGui_StartLegalHoldRestoreReq') R ( ref ) ), '')
		SET @i_UserPswd = ISNULL(( SELECT ref.value('@netUserPswd', 'nvarchar(400)')
							FROM @xmlRestore.nodes('CVGui_StartLegalHoldRestoreReq') R ( ref ) ), '')
		SET @i_destPath = ISNULL(( SELECT ref.value('@destPath', 'nvarchar(400)')
							FROM @xmlRestore.nodes('CVGui_StartLegalHoldRestoreReq') R ( ref ) ), '')
		SET @i_user = ISNULL (( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM  @xmlRestore.nodes ('CVGui_StartLegalHoldRestoreReq') R(ref)), '')
		SET @i_containerId = ISNULL(( SELECT ref.value('@containerId', 'nvarchar(255)')
						FROM  @xmlRestore.nodes ('CVGui_StartLegalHoldRestoreReq') R(ref)), 0)
		SET @i_backupSet = ISNULL(( SELECT ref.value('@backupsetId', 'INT')
						FROM  @xmlRestore.nodes ('CVGui_StartLegalHoldRestoreReq') R(ref)), 0)
		IF 0 = @i_backupSet
			SELECT TOP(1) @i_appType = appTypeId FROM APP_Application WHERE clientId = 2 AND appTypeId < 1000
		ELSE
			SELECT TOP(1) @i_appType = appTypeId FROM APP_Application WHERE backupSet = @i_backupSet
		--GET APP TYPE
		SET @i_appType = ISNULL (( SELECT ref.value('@appType', 'INT')
						FROM  @xmlRestore.nodes ('CVGui_StartPowerRstSearchReq') R(ref)), @i_appType)
		--GET SOURCE CLIENT ID
		IF 0 != @i_backupSet
			SET @i_SourceId = (SELECT TOP(1) clientId FROM APP_Application WHERE backupSet = @i_backupSet)
		SET @i_SourceId = ISNULL (( SELECT ref.value('@srcClientId', 'INT')
						FROM  @xmlRestore.nodes ('CVGui_StartLegalHoldRestoreReq') R(ref)), @i_SourceId)
		--SchedRestoreTask
		INSERT INTO SchedRestoreTask
			SELECT TOP(1) S.externRestoreTaskId, S.scheduleId, @i_SourceId, @i_backupSet, ref.value('@destClientId', 'INT'),
					S.toTime, S.fromTime, @i_appType, S.instanceId, @i_UserId, S.sequenceNumber_h, S.sequenceNumber_l, S.preserveOrStripLevel,
					S.archGroupCopyPrecedence, S.flags, 64, S.type_l, S.alertId, S.jobDescription	--ER_INDEX_FREE_RESTORE_
				FROM  @xmlRestore.nodes ('CVGui_StartLegalHoldRestoreReq') R(ref), SchedRestoreTask AS S
				WHERE flags = 9999
		SET  @i_TaskId = (select @@identity)
		--Insert into temp table to avoid sending it as a response
		INSERT INTO @t_JobId EXEC @i_JobId = JMGetNextJobId
		--SchedRestoreFiles
		--JOB IDS
		INSERT INTO SchedRestoreFiles
SELECT @i_TaskId, 1, CAST(commCellId AS VARCHAR(10))+':'+CAST(jobId AS VARCHAR(10))
			FROM JMJobDataStats WHERE appId IN (SELECT id FROM APP_Application WHERE backupSet = @i_backupSet)
		--	SELECT @i_TaskId, RP_LEGALHOLD_JOBID, jobId FROM JMBkpStats WHERE appId IN (SELECT id FROM APP_Application WHERE backupSet = @i_backupSet)
		--	SELECT @i_TaskId, 1, ref.value('@val', 'nvarchar(1024)') FROM  @xmlRestore.nodes ('CVGui_StartLegalHoldRestoreReq/jobIds') R(ref)
		--DESTINATION PATH
		IF @i_destPath != ''
			INSERT INTO SchedRestoreFiles SELECT @i_TaskId, 2, @i_destPath
		--USER NAME/PSWD
		INSERT INTO SchedRestoreFiles VALUES(@i_TaskId, 4, @i_UserName)
		INSERT INTO SchedRestoreFiles VALUES(@i_TaskId, 5, @i_UserPswd)
		--SchedRestoreTaskOptions
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'NO_MAPPING_DATA', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'DRIVE_POOL_ID', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'SYB_DEST_INST_ID', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'JobRetryNumbers', -1)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'PREPOSTCMD_USER_OPTS', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'PREPOSTCMD_USER_NAME', '')
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'PREPOSTCMD_USER_PW', 2)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'USE_EXACT_INDEX', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'START_SUSPENDED', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_FROM_MAP_INPUT_FILE', '')
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'ON_DEMAND_INPUT_FILE', '')
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RAW_PARTITION', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'MEDIA_PREDICTION_FILE', '')
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'JobRetryHrs', 0)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'JobId', @i_JobId)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'NAS_RESTORE_OPTIONS', 128)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_INITIATING_USER_NAME', @i_user)
		INSERT INTO SchedRestoreTaskOptions VALUES(@i_TaskId, 'RST_LH_CONTAINER_ID', @i_containerId)
		INSERT INTO SchedRestoreTaskOptions
			SELECT @i_TaskId, 'ExtendedOptions', ref.value('@extendedOpts', 'nvarchar(1024)')
					FROM  @xmlRestore.nodes ('CVGui_StartLegalHoldRestoreReq') R(ref)
		INSERT INTO Schedule
			SELECT TOP(1) @i_TaskId, 2, 1, counter, errors, fireIfMissed, 1, inProcess, 1, isReported, isSingleton, sCount,
					mask, monthDay, occurence, dayNumber, atTime, interval, endValue, dbo.getUnixTime(GetUTCDate()),
					0, ds_flags, tz_offset, tz_name, '', GetDate(), GetDate(), lastEvent, lastAttempt,
					schedTemplateInstanceId, endOfDay, skipOccurence, skipDayNumber, calendarId
					FROM Schedule WHERE id in ( SELECT scheduleId FROM SchedRestoreTask WHERE flags = 9999)
		SET  @schedId = (select @@identity)
		UPDATE SchedRestoreTask SET scheduleId = @schedId WHERE id = @i_TaskId
		SELECT @i_JobId as jobId
	END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'SchedLHIndexFreeRestore')
	delete from GxQscripts where name = 'SchedLHIndexFreeRestore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedLHIndexFreeRestore')
	delete from GXDBVersions where aliasname = 'SchedLHIndexFreeRestore'
GO

insert into GXDBVersions values(2, 'SchedLHIndexFreeRestore',  '00010008029000020000', 'SchedLHIndexFreeRestore', '00010008029000020000')
GO

