

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedLHGetUGroupsFromBackupSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   09/14/2007
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedLHGetUGroupsFromBackupSet.sp,v $ $Id: SchedLHGetUGroupsFromBackupSet.sp,v 1.3.276.1 2018/03/20 00:44:30 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedLHGetUGroupsFromBackupSet <<<'

IF EXISTS (select * from sysobjects where name='SchedLHGetUGroupsFromBackupSet')
	drop procedure SchedLHGetUGroupsFromBackupSet
IF EXISTS (select * from GxQscripts where name='SchedLHGetUGroupsFromBackupSet')
	delete from GxQscripts where name = 'SchedLHGetUGroupsFromBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedLHGetUGroupsFromBackupSet')
	delete from GXDBVersions where aliasname = 'SchedLHGetUGroupsFromBackupSet'
GO
print '... Creating Procedure: SchedLHGetUGroupsFromBackupSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedLHGetUGroupsFromBackupSet
  @xmlText XML
AS
BEGIN
	DECLARE @appType INT
	DECLARE @jobId INT
	DECLARE @commCellId INT
	DECLARE @clientId INT
	DECLARE @backupSetId INT
	DECLARE @groupName NVARCHAR(1024)
	DECLARE @groups NVARCHAR(MAX)
	DECLARE @groupList	TABLE( t_groupName	NVARCHAR(MAX), t_groupId INT )
	DECLARE @LHInfo	TABLE( GroupNames	NVARCHAR(MAX), ArchGroupId INT, ArchGroupName NVARCHAR(1024), RetentionDays INT, LastAppend DATETIME)
	DECLARE @maxRetention	TABLE (archGroupId int, maxRetention int)
	DECLARE @LastAppendTime INT
	SET @backupSetId = ISNULL(( SELECT ref.value('@backupSetId', 'INT')
							FROM @xmlText.nodes('TMMsg_GetLegalHoldUGroupsFromBackupSetReq') R ( ref ) ), 0)
	SET @groups = ''
	SELECT TOP(1) @clientId = clientId, @appType = appTypeId FROM APP_Application WHERE backupSet = @backupSetId
	--GET GALAXY USERS
	INSERT INTO @groupList
	SELECT UG.name, UG.id FROM UMGroups UG, UMGroupAssociation UA WHERE (
		(UA.id3 = @backupSetId) OR (UA.id1 = @clientId AND UA.id2 = @appType AND UA.id3 = 0)
		OR (UA.id1 = @clientId AND UA.id2 = 0 AND UA.id3 = 0)
		OR (UA.type1 = 2018 AND UA.id1 = 2 AND UA.id2 = 0 AND UA.id3 = 0)
	)
	UNION
	SELECT UG.name, UG.id FROM UMGroups UG WHERE allCapabilities = 1
	--MAP GALAXY USERS TO EXTERNAL USERS
	INSERT INTO @groupList
	SELECT UP.domainName+'/'+UG.name, UG.id FROM UMDSGroups UG, UMDSProviders UP WHERE UP.id = UG.umdsProviderId AND
	UG.id IN (SELECT DISTINCT umDSgroupId FROM UMDSGroupMaps WHERE umgroupId IN (SELECT t_groupId FROM @groupList))
	DECLARE GetGroupName CURSOR
	FOR SELECT t_groupName FROM @groupList
	OPEN GetGroupName
	FETCH GetGroupName INTO @groupName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @groups <> '' SET @groups = @groups + ', '
		SET @groups = @groups + @groupName
		FETCH GetGroupName INTO @groupName
	END
	CLOSE GetGroupName
	DEALLOCATE GetGroupName
	INSERT INTO @LHInfo
	SELECT DISTINCT @groups, AG.id, AG.name, AAR.retentionDays, getDate()
	FROM archGroup AG, archGroupCopy AGC, archAgingRule AAR
	WHERE AG.id = AGC.archGroupId
	AND AG.defaultCopy = AGC.Id AND AGC.id = AAR.copyId
	--AND (AGC.flags & 524288) = 524288 --CVA_LEGAL_HOLD_FLAG_
	AND (AG.id IN (SELECT dataArchGrpID FROM APP_Application WHERE backupSet = @backupSetId))
	INSERT INTO @maxRetention
	SELECT AGC.archGroupId, MAX(AAR.retentionDays)
	FROM archGroupCopy AGC, archAgingRule AAR
	WHERE AGC.id = AAR.copyID
	AND   AGC.isActive > 0
	GROUP BY AGC.archGroupId
	UPDATE @maxRetention
	SET maxRetention = AAR.RetentionDays
	FROM @maxRetention M, archGroupCopy AGC, archAgingRule AAR
	WHERE M.archGroupId = AGC.archGroupId
	AND AGC.id = AAR.copyId
	AND AAR.retentionDays = -1
	UPDATE @LHInfo
	SET RetentionDays = B.maxRetention
	FROM @LHInfo A, @maxRetention B
	WHERE A.ArchGroupId = B.ArchGroupId
	select top 1 @jobId=jobid, @commCellId = commCellId  from archfile
	where appId = (SELECT id FROM APP_Application WHERE backupSet = @backupSetId)
	and isValid = 1 order by cTime desc
	select @LastAppendTime =  servStart from JMAdminJobStatsTable where
	jobId = @jobId and commCellId = @commCellId
	UPDATE @LHInfo
	SET LastAppend = dbo.getDateTime(@LastAppendTime)
	SELECT 	GroupNames, ArchGroupId, ArchGroupName, RetentionDays , LastAppend
	FROM @LHInfo
EXIT_PROC:
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'SchedLHGetUGroupsFromBackupSet')
	delete from GxQscripts where name = 'SchedLHGetUGroupsFromBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedLHGetUGroupsFromBackupSet')
	delete from GXDBVersions where aliasname = 'SchedLHGetUGroupsFromBackupSet'
GO

insert into GXDBVersions values(2, 'SchedLHGetUGroupsFromBackupSet',  '00010003027600010000', 'SchedLHGetUGroupsFromBackupSet', '00010003027600010000')
GO

