

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedInsertSrcRetSearchPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedInsertSrcRetSearchPath.sp,v $ $Id: SchedInsertSrcRetSearchPath.sp,v 1.12.60.1 2017/02/10 21:53:36 sjohnson Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_NTAlertDetail
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:  Fetches detailed information for the specified Notification
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedInsertSrcRetSearchPath <<<'

IF EXISTS (select * from sysobjects where name='SchedInsertSrcRetSearchPath')
	drop procedure SchedInsertSrcRetSearchPath
IF EXISTS (select * from GxQscripts where name='SchedInsertSrcRetSearchPath')
	delete from GxQscripts where name = 'SchedInsertSrcRetSearchPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedInsertSrcRetSearchPath')
	delete from GXDBVersions where aliasname = 'SchedInsertSrcRetSearchPath'
GO
print '... Creating Procedure: SchedInsertSrcRetSearchPath'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedInsertSrcRetSearchPath
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @in_taskId int,
  @in_searchId int,
  @xmlText XML
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
	DECLARE @errorStr nvarchar(1024)
	DECLARE @retVal             integer
	DECLARE @searchId		integer
	DECLARE @t_JobId		TABLE( jobId int )	--Power Restore JobId
	SET @retVal = 0
	SET @searchId = @in_searchId
	IF (@searchId = 0)
	BEGIN
		INSERT INTO @t_JobId EXEC @searchId = JMGetNextJobId
		--SET @searchId = @@IDENTITY
	END
	IF NOT EXISTS(SELECT * FROM SchedRestoreSearchTask WHERE id = @searchId)
	BEGIN
		INSERT INTO SchedRestoreSearchTask (id, restoreTaskId, created ) VALUES (@searchId, @in_taskId, dbo.getunixtime(GETUTCDATE()))
	END
	-- commcell id from XML is in actual fact the commcell number
	--INSERT THE SEARCH FILE PATH
	INSERT INTO SchedRestoreSearchFiles
	                      (searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId)
	SELECT @searchId,  ref.value('@commcellNo', 'INT'),
		ref.value('@aFileId', 'INT') ,  ref.value('@aFileOffset', 'BIGINT'),
		ref.value('@filePath', 'nvarchar(1024)') , ref.value('@appType', 'INT') ,
		ref.value('@appId', 'INT'), isnull(email.value('@links', 'nvarchar(1024)'), ''),
		0, 0, '', 0
		FROM  @xmlText.nodes ('DM2ContentIndexing_SearchResponse/resultItems/resultItem') R(ref)
		OUTER APPLY ref.nodes('./appSpecific/eMail') as T2(email)
COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
    EXECUTE dbo.PrintError;
    SET @retVal = ERROR_NUMBER()
    SET @errorStr = 'Error ' + CONVERT(varchar(50), ERROR_NUMBER()) +
          ', Severity ' + CONVERT(varchar(5), ERROR_SEVERITY()) +
          ', State ' + CONVERT(varchar(5), ERROR_STATE()) +
          ', Procedure ' + ISNULL(ERROR_PROCEDURE(), '-') +
          ', Line ' + CONVERT(varchar(5), ERROR_LINE());
     SET @errorStr = @errorStr + ' Message ' + ERROR_MESSAGE();
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
    IF XACT_STATE() <> 0
    BEGIN
        ROLLBACK TRANSACTION;
    END
END CATCH;
SELECT	@searchId, @retVal,@errorStr
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SchedInsertSrcRetSearchPath')
	delete from GxQscripts where name = 'SchedInsertSrcRetSearchPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedInsertSrcRetSearchPath')
	delete from GXDBVersions where aliasname = 'SchedInsertSrcRetSearchPath'
GO

insert into GXDBVersions values(2, 'SchedInsertSrcRetSearchPath',  '00010012006000010000', 'SchedInsertSrcRetSearchPath', '00010012006000010000')
GO

