

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedInsertPowerRstSearchPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedInsertPowerRstSearchPath.sp,v $ $Id: SchedInsertPowerRstSearchPath.sp,v 1.21.190.2 2019/04/16 16:13:23 sgolla Exp $";
--
--  +========================================================================+
--  |   Procedure:  br_NTAlertDetail
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:  Fetches detailed information for the specified Notification
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SchedInsertPowerRstSearchPath')
BEGIN
	print '>>> Drop Stored Procedure: SchedInsertPowerRstSearchPath <<<'
	drop procedure SchedInsertPowerRstSearchPath
END
IF EXISTS (select * from GxQscripts where name='SchedInsertPowerRstSearchPath')
	delete from GxQscripts where name = 'SchedInsertPowerRstSearchPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedInsertPowerRstSearchPath')
	delete from GXDBVersions where aliasname = 'SchedInsertPowerRstSearchPath'
GO
print '... Creating Procedure: SchedInsertPowerRstSearchPath'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedInsertPowerRstSearchPath
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
	DECLARE @errorStr 		nvarchar(1024)
	DECLARE @errorCode		integer
	DECLARE @searchId		integer
	DECLARE @t_JobId		TABLE( jobId int )	--Power Restore JobId
	DECLARE @defTask	INT
	SET @errorCode = 0
	SET @errorStr = ''
	SET @searchId = (SELECT  ref.value('@searchId', 'INT')
	FROM  @xmlText.nodes ('CVGui_InsertPowerRstSearchPathReq') R(ref))
	SET @defTask = (SELECT TOP(1) id FROM SchedRestoreTask WHERE flags = 9999)
	IF (@searchId = 0)
	BEGIN
		INSERT INTO @t_JobId EXEC @searchId = JMGetNextJobId
	END
	IF NOT EXISTS(SELECT * FROM SchedRestoreSearchTask WHERE id = @searchId)
	BEGIN
		INSERT INTO SchedRestoreSearchTask (id, restoreTaskId, created) VALUES (@searchId, @defTask, dbo.getunixtime(GETUTCDATE()))
		SET @errorCode = @@error
		--SET @searchId = @@IDENTITY
		IF(@errorCode <> 0)
		BEGIN
			SET @errorStr = 'Could not create restore task'
			GOTO ERROR_EXIT
		END
	END
	if object_id('tempdb.dbo.#TmpSchedRestoreSearchFiles') is not null
	begin
		drop table #TmpSchedRestoreSearchFiles
	end
	if object_id('tempdb.dbo.#TmpArchFileInfo') is not null
	begin
		drop table #TmpArchFileInfo
	end
-- CreateSchedRestoreSearchFilesTbl.spb logic start --
	CREATE TABLE #TmpSchedRestoreSearchFiles(
		searchId int not null,
		commcellNumber int not null,
		archiveFileId int not null,
		archiveFileOffset bigint not null,
		fileName nvarchar(1024) not null,
		appType int not null,
		appId int not null,
		exchangeLinkName nvarchar(1024) not null,
		status int not null,
		size bigint not null,
		documentId nvarchar(1024) not null,
		optionId int not null,
		refCopyId int not null
	)
	CREATE TABLE #TmpArchFileInfo (
		archiveFileId int not null,
		AppType int null
	)
-- CreateSchedRestoreSearchFilesTbl.spb logic end --
	-- commcellId from the XML is in actual fact the commcell number
	IF (@searchId is not NULL)
	BEGIN
		--INSERT THE SEARCH FILE PATH
		INSERT INTO #TmpSchedRestoreSearchFiles
	                      (searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId,refCopyId)
	                  -- CommcellId from XML is actually the commcell Number despite the name.
		SELECT  @searchId,
			case
				when
					ref.value('@ccNumber', 'INT') <> 0 then ref.value('@ccNumber', 'INT')
			else
				ref.value('@ccId', 'INT')
			end,
		ref.value('@archiveFileId', 'INT') ,
		ref.value('@archiveFileOffset', 'BIGINT'),
		CASE ref.value('@appType', 'INT')
WHEN 106
				THEN
				CASE WHEN ref.value('@fileName', 'nvarchar(max)') LIKE '|\|#15!vErSiOnS|#15!\%'
				THEN SUBSTRING( ref.value('@fileName', 'nvarchar(max)'), 1, 1024 )
				ELSE SUBSTRING( dbo.DecodeInvalidXMLChar(ISNULL(ref.value('@fileName', 'nvarchar(max)'), '')) , 1, 1024 )
				END
			ELSE SUBSTRING( dbo.DecodeInvalidXMLChar(ISNULL(ref.value('@fileName', 'nvarchar(max)'), '')) , 1, 1024 )
			END,
		ref.value('@appType', 'INT') ,
		ref.value('@appId', 'INT') ,
		SUBSTRING( dbo.DecodeInvalidXMLChar(ref.value('@exchLinkName', 'nvarchar(max)')) , 1, 1024 ),
		0,
		0,
		ISNULL(ref.value('@documentId', 'varchar(256)') , '') AS documentId,
		0,
		ISNULL(ref.value('@refCopyId', 'INT'),0)
		FROM  @xmlText.nodes ('CVGui_InsertPowerRstSearchPathReq/paths') R(ref)
		set @errorCode = @@error
		IF(@errorCode <> 0)
		BEGIN
			SET @errorStr = 'Could not insert file path'
			GOTO ERROR_EXIT
		END
		--include logic to fix app type as needed and then insert into main table SchedRestoreSearchFiles
		-- InsertSchedRestoreSearchFiles.spb logic start --
		--
		-- Though its possible to directly updating table #TmpSchedRestoreSearchFiles by referencing to main table archfile, app_application
		-- Many times same archive file may repeat with-in one batch and often through-out
		-- So capture distinct archive files
		--
		INSERT INTO #TmpArchFileInfo (archiveFileId)
		SELECT DISTINCT archiveFileId FROM #TmpSchedRestoreSearchFiles
		-- determine and capture apptype for each available archive file from main table
		UPDATE I
		SET I.AppType = B.AppTypeId
		FROM #TmpArchFileInfo I
		JOIN ArchFile A WITH (NOLOCK) ON I.archiveFileId = A.Id
		JOIN App_Application B WITH (NOLOCK) ON A.AppId = B.Id
		--
		-- Update back available values of apptype so that we submit correct apptype to scheduler for restore
		--
		UPDATE T
		SET T.AppType = I.AppType
		FROM #TmpSchedRestoreSearchFiles T
		JOIN #TmpArchFileInfo I ON T.archiveFileId = I.archiveFileId
		WHERE I.AppType IS NOT NULL
		--
		-- Insert final data into main table SchedRestoreSearchFiles
		--
		INSERT INTO SchedRestoreSearchFiles (searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId, refCopyId)
		SELECT searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId,refCopyId FROM #TmpSchedRestoreSearchFiles
		-- InsertSchedRestoreSearchFiles.spb logic end --
	END
ERROR_EXIT:
	if object_id('tempdb.dbo.#TmpSchedRestoreSearchFiles') is not null
	begin
		drop table #TmpSchedRestoreSearchFiles
	end
	if object_id('tempdb.dbo.#TmpArchFileInfo') is not null
	begin
		drop table #TmpArchFileInfo
	end
	SELECT	@searchId as searchId, @errorCode as errorCode, @errorStr as errorString
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SchedInsertPowerRstSearchPath')
	delete from GxQscripts where name = 'SchedInsertPowerRstSearchPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedInsertPowerRstSearchPath')
	delete from GXDBVersions where aliasname = 'SchedInsertPowerRstSearchPath'
GO

insert into GXDBVersions values(2, 'SchedInsertPowerRstSearchPath',  '00010021019000020000', 'SchedInsertPowerRstSearchPath', '00010021019000020000')
GO

