

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedInsertComplianceJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedInsertComplianceJobOptions.sp,v $ $Id: SchedInsertComplianceJobOptions.sp,v 1.26.60.2 2019/04/16 16:13:17 sgolla Exp $";
--
--  +========================================================================+
--  |   Procedure:  SchedInsertComplianceJobOptions
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SchedInsertComplianceJobOptions')
BEGIN
	print '>>> Drop Stored Procedure: SchedInsertComplianceJobOptions <<<'
	drop procedure SchedInsertComplianceJobOptions
END
IF EXISTS (select * from GxQscripts where name='SchedInsertComplianceJobOptions')
	delete from GxQscripts where name = 'SchedInsertComplianceJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedInsertComplianceJobOptions')
	delete from GXDBVersions where aliasname = 'SchedInsertComplianceJobOptions'
GO
print '... Creating Procedure: SchedInsertComplianceJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedInsertComplianceJobOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId INT,
  @xmlText XML OUTPUT
AS
  DECLARE @o_ComplianceId integer
  DECLARE @o_searchId integer
  DECLARE @o_ErrorCode integer
  DECLARE @o_ErrorString nvarchar(1024)
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
	DECLARE @defTask		INT
	DECLARE @defRstTask		INT
	DECLARE @xmlOption		XML
	DECLARE @i_Found		bit
	DECLARE @position		INT
	DECLARE @optionId		INT
	DECLARE @i_isTableOut	INT
	DECLARE @t_JobId		TABLE( jobId int )	--Power Restore JobId
	if object_id('tempdb.dbo.#TmpSchedRestoreSearchFiles') is not null
	begin
		drop table #TmpSchedRestoreSearchFiles
	end
	if object_id('tempdb.dbo.#TmpArchFileInfo') is not null
	begin
		drop table #TmpArchFileInfo
	end
-- CreateSchedRestoreSearchFilesTbl.spb logic start --
	CREATE TABLE #TmpSchedRestoreSearchFiles(
		searchId int not null,
		commcellNumber int not null,
		archiveFileId int not null,
		archiveFileOffset bigint not null,
		fileName nvarchar(1024) not null,
		appType int not null,
		appId int not null,
		exchangeLinkName nvarchar(1024) not null,
		status int not null,
		size bigint not null,
		documentId nvarchar(1024) not null,
		optionId int not null,
		refCopyId int not null
	)
	CREATE TABLE #TmpArchFileInfo (
		archiveFileId int not null,
		AppType int null
	)
-- CreateSchedRestoreSearchFilesTbl.spb logic end --
	SET @o_ComplianceId = 0
	SET @o_ErrorString = ''
	SET @i_Found = 0
	SET @o_searchId = 0
	SET @o_ErrorCode = 0
	SET @i_isTableOut = 0
	SET @o_ComplianceId = ISNULL(( SELECT ref.value('@complianceId', 'INT')
						FROM @xmlText.nodes('DM2ContentIndexing_ComplianceOptions') R ( ref ) ), 0)
	SET @o_searchId = ISNULL (( SELECT ref.value('@searchId', 'INT')
					FROM @xmlText.nodes ('DM2ContentIndexing_ComplianceOptions') R(ref)), 0)
	SET @i_isTableOut = ISNULL (( SELECT ref.value('@isTableOutput', 'INT')
					FROM  @xmlText.nodes ('DM2ContentIndexing_ComplianceOptions') R(ref)), 0)
	SET @defTask = (SELECT TOP(1) id FROM SchedAdminTask WHERE flags = 9999)
	IF (@o_ComplianceId = 0)
	BEGIN
		INSERT INTO SchedAdminComplianceTask (taskId, created) VALUES (@defTask, dbo.getunixtime(GETUTCDATE()))
		SET @o_ErrorCode = @@error
		SET @o_ComplianceId = @@IDENTITY
		IF(@o_ErrorCode <> 0)
		BEGIN
			SET @o_ErrorString = 'Could not create admin compliance task'
			GOTO ERROR_EXIT
		END
	END
	IF (@o_ComplianceId IS NOT null)
	BEGIN
		--INSERT OPTIONS FOR JAVA GUI
		--SET @xmlOption = (SELECT ref.query('*') FROM  @xmlText.nodes ('DM2ContentIndexing_ComplianceOptions') R(ref))
		--INSERT INTO SchedAdminComplianceXMLOptions (complianceId, xmlValue, status)
		--		VALUES (@o_ComplianceId, @xmlOption, 0)
		SET @defRstTask = (SELECT TOP(1) id FROM SchedRestoreTask WHERE flags = 9999)
		--CREATE A RESTORE TASK FOR TAGGING AND SEARCH REQUEST
		IF (@xmlText.exist('/DM2ContentIndexing_ComplianceOptions/searchRequest') > 0 OR @xmlText.exist('/DM2ContentIndexing_ComplianceOptions/webUITags') > 0
			OR @xmlText.exist('/DM2ContentIndexing_ComplianceOptions/searchPaths') > 0)
		BEGIN
			---------------------
			--CREATE RESTORE TASK FOR SEARCH OPTION AND WEB TAGING
			---------------------
			IF (@o_searchId = 0)
			BEGIN
				INSERT INTO @t_JobId EXEC @o_searchId = JMGetNextJobId
			END
			IF NOT EXISTS(SELECT * FROM SchedRestoreSearchTask WHERE id = @o_searchId)
			BEGIN
				INSERT INTO SchedRestoreSearchTask (id, restoreTaskId, created ) VALUES (@o_searchId, @defRstTask, dbo.getunixtime(GETUTCDATE()))
				SET @o_ErrorCode = @@error
				--SET @o_searchId = @@IDENTITY
				IF(@o_ErrorCode <> 0)
				BEGIN
					SET @o_ErrorString = 'Could not create restore task'
					GOTO ERROR_EXIT
				END
			END
		END
		---------------------
		--INSERT THE COMPLIANCE OPTIONS
		---------------------
		---------------------
		--SEARCH OPTIONS
		---------------------
		SET @xmlOption = (SELECT @xmlText.query('/DM2ContentIndexing_ComplianceOptions/searchRequest'))
		SET @i_Found = @xmlOption.exist('/searchRequest')
		IF @i_Found > 0
		BEGIN
			SET @xmlOption = (SELECT ref.query('.') FROM  @xmlOption.nodes ('/searchRequest') R(ref)
				FOR XML PATH('DM2ContentIndexing_SearchRequestOption'))
			INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
SELECT @o_ComplianceId, 1, @xmlOption, 0
		END
		---------------------
		--SEARCH PATH OPTIONS
		---------------------
		SET @xmlOption = (SELECT @xmlText.query('/DM2ContentIndexing_ComplianceOptions/searchPaths'))
		SET @i_Found = @xmlOption.exist('/searchPaths')
		IF @i_Found > 0
		BEGIN
			INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
				SELECT @o_ComplianceId, 2, @xmlOption, 0
			SET @o_ErrorCode = @@error
			SET @optionId = @@IDENTITY
			IF(@o_ErrorCode <> 0)
			BEGIN
				SET @o_ErrorString = 'Could not insert tag Ids into compliance options'
				GOTO ERROR_EXIT
			END
			INSERT INTO #TmpSchedRestoreSearchFiles
				(searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId,refCopyId)
				-- CommcellId from XML is actually the commcell Number despite the name.
				SELECT @o_searchId, ref.value('@ccId', 'INT'), ref.value('@archiveFileId', 'INT'),  ref.value('@archiveFileOffset', 'BIGINT'),
					ref.value('@fileName', 'NVARCHAR(1024)'), ref.value('@appType', 'INT'), ref.value('@appId', 'INT'),
					ref.value('@exchLinkName', 'NVARCHAR(1024)'), 0, 0, ISNULL(ref.value('@documentId', 'varchar(36)'), '') AS documentId, @optionId, ISNULL(ref.value('@refCopyId', 'INT'),0)
				FROM  @xmlOption.nodes ('searchPaths') R(ref)
		-- InsertSchedRestoreSearchFiles.spb logic start --
		--
		-- Though its possible to directly updating table #TmpSchedRestoreSearchFiles by referencing to main table archfile, app_application
		-- Many times same archive file may repeat with-in one batch and often through-out
		-- So capture distinct archive files
		--
		INSERT INTO #TmpArchFileInfo (archiveFileId)
		SELECT DISTINCT archiveFileId FROM #TmpSchedRestoreSearchFiles
		-- determine and capture apptype for each available archive file from main table
		UPDATE I
		SET I.AppType = B.AppTypeId
		FROM #TmpArchFileInfo I
		JOIN ArchFile A WITH (NOLOCK) ON I.archiveFileId = A.Id
		JOIN App_Application B WITH (NOLOCK) ON A.AppId = B.Id
		--
		-- Update back available values of apptype so that we submit correct apptype to scheduler for restore
		--
		UPDATE T
		SET T.AppType = I.AppType
		FROM #TmpSchedRestoreSearchFiles T
		JOIN #TmpArchFileInfo I ON T.archiveFileId = I.archiveFileId
		WHERE I.AppType IS NOT NULL
		--
		-- Insert final data into main table SchedRestoreSearchFiles
		--
		INSERT INTO SchedRestoreSearchFiles (searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId, refCopyId)
		SELECT searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId,refCopyId FROM #TmpSchedRestoreSearchFiles
		-- InsertSchedRestoreSearchFiles.spb logic end --
		END
		---------------------
		--SAVE TO FILE OPTIONS
		---------------------
		SET @xmlOption = (SELECT @xmlText.query('/DM2ContentIndexing_ComplianceOptions/saveToFile'))
		SET @i_Found = @xmlOption.exist('/saveToFile')
		IF @i_Found > 0
		BEGIN
			SET @xmlOption = (SELECT ref.query('.') FROM  @xmlOption.nodes ('/saveToFile') R(ref)
				FOR XML PATH('DM2ContentIndexing_SaveToFileOption'))
			INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
SELECT @o_ComplianceId, 3, @xmlOption, 0
		END
		---------------------
		--EMAIL OPTIONS
		---------------------
		SET @xmlOption = (SELECT @xmlText.query('/DM2ContentIndexing_ComplianceOptions/sendMail'))
		SET @i_Found = @xmlOption.exist('/sendMail')
		IF @i_Found > 0
		BEGIN
			SET @xmlOption = (SELECT ref.query('.') FROM  @xmlOption.nodes ('/sendMail') R(ref)
				FOR XML PATH('DM2ContentIndexing_SendMailOption'))
			INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
SELECT @o_ComplianceId, 4, @xmlOption, 0
		END
		---------------------
		--TAG OPTIONS
		---------------------
		SET @xmlOption = (SELECT @xmlText.query('/DM2ContentIndexing_ComplianceOptions/tags'))
		SET @i_Found = @xmlOption.exist('/tags')
		IF @i_Found > 0
		BEGIN
			--SET @xmlOption = (SELECT ref.query('.') FROM  @xmlOption.nodes ('tags') R(ref)
			--	FOR XML PATH('DM2ContentIndexing_TagOption'))
			SET @xmlOption = (SELECT @xmlOption FOR XML PATH('DM2ContentIndexing_TagOption'))
			INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
SELECT @o_ComplianceId, 10, @xmlOption, 0
			--DECLARE @xmlTag XML
			--DECLARE GetTagCur CURSOR
			--FOR SELECT ref.query('.') FROM  @xmlOption.nodes ('tags') R(ref)
			--OPEN GetTagCur
			--FETCH GetTagCur INTO @xmlTag
			--WHILE @@FETCH_STATUS = 0
			--BEGIN
			--	INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
			--		SELECT @o_ComplianceId, TAG_OPTION, @xmlTag, 0
			--	FETCH GetTagCur INTO @xmlTag
			--END
			--CLOSE GetTagCur
			--DEALLOCATE GetTagCur
		END
		---------------------
		--WEB TAG OPTIONS
		---------------------
		SET @xmlOption = (SELECT @xmlText.query('/DM2ContentIndexing_ComplianceOptions/webUITags'))
		SET @i_Found = @xmlOption.exist('/webUITags')
		IF @i_Found > 0
		BEGIN
			DECLARE @document	INT
			DECLARE @xmlPart	XML
			--CURSOR TO ITERATE THRU THE DOCUMENTS
			DECLARE GetDocumentToTagCur CURSOR
			FOR SELECT ref.value('@archiveFileId', 'INT') FROM  @xmlOption.nodes ('webUITags') R(ref)
			SET @position = 1
			OPEN GetDocumentToTagCur
			FETCH GetDocumentToTagCur INTO @document
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @xmlPart = (SELECT ref.query('.') FROM  @xmlOption.nodes ('webUITags[position() = sql:variable("@position")]') R(ref)
				FOR XML PATH('DM2ContentIndexing_TagItemOption'))
				--SET @xmlOption = (SELECT ref.value('@ccId', 'INT') as '@ccId', ref.value('@archiveFileId', 'INT') AS '@archiveFileId',
				--	ref.value('@archiveFileOffset', 'BIGINT') AS '@archiveFileOffset', ref.value('@documentId', 'NVARCHAR(1024)') AS '@documentId',
				--	(SELECT ref.query('*') FROM  @xmlOption.nodes ('webUITags[position() = sql:variable("@position")]') O(ref))
				--	FROM  @xmlOption.nodes ('webUITags[position() = sql:variable("@position")]') R(ref)
				--FOR XML PATH('DM2ContentIndexing_TagItem'))
				INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
SELECT @o_ComplianceId, 5, @xmlPart, 0
				SET @o_ErrorCode = @@error
				SET @optionId = @@IDENTITY
				IF(@o_ErrorCode <> 0)
				BEGIN
					SET @o_ErrorString = 'Could not insert tag Ids into compliance options'
					GOTO ERROR_EXIT
				END
				SET @position = @position + 1
				FETCH GetDocumentToTagCur INTO @document
			END
			CLOSE GetDocumentToTagCur
			DEALLOCATE GetDocumentToTagCur
			--INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
			--	SELECT @o_ComplianceId, TAG_OPTION, ref.query('*'), 0
			--	FROM  @xmlOption.nodes ('webUITags') R(ref)
			DELETE FROM #TmpSchedRestoreSearchFiles
			DELETE FROM #TmpArchFileInfo
			INSERT INTO #TmpSchedRestoreSearchFiles
				(searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId)
				-- CommcellId from XML is actually the commcell Number despite the name.
				SELECT @o_searchId, ref.value('@ccId', 'INT'), ref.value('@archiveFileId', 'INT'),  ref.value('@archiveFileOffset', 'BIGINT'),
					'', 0, 0, '', 0, 0, ref.value('@documentId', 'NVARCHAR(1024)'), @optionId
				FROM  @xmlOption.nodes ('webUITags') R(ref)
		-- InsertSchedRestoreSearchFiles.spb logic start --
		--
		-- Though its possible to directly updating table #TmpSchedRestoreSearchFiles by referencing to main table archfile, app_application
		-- Many times same archive file may repeat with-in one batch and often through-out
		-- So capture distinct archive files
		--
		INSERT INTO #TmpArchFileInfo (archiveFileId)
		SELECT DISTINCT archiveFileId FROM #TmpSchedRestoreSearchFiles
		-- determine and capture apptype for each available archive file from main table
		UPDATE I
		SET I.AppType = B.AppTypeId
		FROM #TmpArchFileInfo I
		JOIN ArchFile A WITH (NOLOCK) ON I.archiveFileId = A.Id
		JOIN App_Application B WITH (NOLOCK) ON A.AppId = B.Id
		--
		-- Update back available values of apptype so that we submit correct apptype to scheduler for restore
		--
		UPDATE T
		SET T.AppType = I.AppType
		FROM #TmpSchedRestoreSearchFiles T
		JOIN #TmpArchFileInfo I ON T.archiveFileId = I.archiveFileId
		WHERE I.AppType IS NOT NULL
		--
		-- Insert final data into main table SchedRestoreSearchFiles
		--
		INSERT INTO SchedRestoreSearchFiles (searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId, refCopyId)
		SELECT searchId,  commcellNumber, archiveFileId, archiveFileOffset, fileName, appType, appId, exchangeLinkName, status, size, documentId, optionId,refCopyId FROM #TmpSchedRestoreSearchFiles
		-- InsertSchedRestoreSearchFiles.spb logic end --
		END
		---------------------
		--LEGAL HOLD OPTIONS
		---------------------
		SET @xmlOption = (SELECT @xmlText.query('/DM2ContentIndexing_ComplianceOptions/legalHold'))
		SET @i_Found = @xmlOption.exist('/legalHold')
		IF @i_Found > 0
		BEGIN
			SET @xmlOption = (SELECT ref.query('.') FROM  @xmlOption.nodes ('/legalHold') R(ref)
				FOR XML PATH('DM2ContentIndexing_LegalHoldOption'))
			INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
SELECT @o_ComplianceId, 6, @xmlOption, 0
		END
		---------------------
		--MOSS OPTIONS
		---------------------
		SET @xmlOption = (SELECT @xmlText.query('/DM2ContentIndexing_ComplianceOptions/moss'))
		SET @i_Found = @xmlOption.exist('/moss')
		IF @i_Found > 0
		BEGIN
			SET @xmlOption = (SELECT ref.query('.') FROM  @xmlOption.nodes ('/moss') R(ref)
				FOR XML PATH('DM2ContentIndexing_MossAction'))
			INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
SELECT @o_ComplianceId, 8, @xmlOption, 0
		END
		---------------------
		--RESULT SET OPTIONS
		---------------------
		SET @xmlOption = (SELECT @xmlText.query('/DM2ContentIndexing_ComplianceOptions/restoreToResultSet'))
		SET @i_Found = @xmlOption.exist('/restoreToResultSet')
		IF @i_Found > 0
		BEGIN
			SET @xmlOption = (SELECT ref.query('.') FROM  @xmlOption.nodes ('/restoreToResultSet') R(ref)
				FOR XML PATH('DM2ContentIndexing_RestoreToResultSetAction'))
			INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
SELECT @o_ComplianceId, 9, @xmlOption, 0
		END
	END
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_ErrorString OUTPUT , @o_ErrorCode OUTPUT
	--Close cursor
	IF ( CURSOR_STATUS('global', 'GetDocumentToTagCur') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetDocumentToTagCur') >= 0 )
		CLOSE GetDocumentToTagCur
	--IF ( CURSOR_STATUS('global', 'GetTagCur') >= 0  /* cursor is open */
	--	OR CURSOR_STATUS('local', 'GetTagCur') >= 0 )
	--	CLOSE GetTagCur
	IF ( CURSOR_STATUS('global','GetDocumentToTagCur') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetDocumentToTagCur') = -1 )
		DEALLOCATE GetDocumentToTagCur
	--IF ( CURSOR_STATUS('global','GetTagCur') = -1  /* cursor is closed */
	--	OR CURSOR_STATUS('local','GetTagCur') = -1 )
	--	DEALLOCATE GetTagCur
END CATCH;
ERROR_EXIT:
	IF (@i_isTableOut = 0)
	BEGIN
		SET @xmlText = (SELECT @o_ComplianceId '@complianceId', @o_searchId '@searchId', @o_ErrorCode '@errorCode', @o_ErrorString '@errorString'
				FOR XML PATH('DM2ContentIndexing_ComplianceOptionsResp'))
	END
	ELSE
	BEGIN
		SELECT	@o_ComplianceId AS complianceId, @o_searchId AS searchId, @o_ErrorCode AS errorCode, @o_ErrorString AS errorString
	END
	if object_id('tempdb.dbo.#TmpSchedRestoreSearchFiles') is not null
	begin
		drop table #TmpSchedRestoreSearchFiles
	end
	if object_id('tempdb.dbo.#TmpArchFileInfo') is not null
	begin
		drop table #TmpArchFileInfo
	end
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SchedInsertComplianceJobOptions')
	delete from GxQscripts where name = 'SchedInsertComplianceJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedInsertComplianceJobOptions')
	delete from GXDBVersions where aliasname = 'SchedInsertComplianceJobOptions'
GO

insert into GXDBVersions values(2, 'SchedInsertComplianceJobOptions',  '00010026006000020000', 'SchedInsertComplianceJobOptions', '00010026006000020000')
GO

