

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedGetRestoreSearchFiles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/31/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedGetRestoreSearchFiles.sp,v $ $Id: SchedGetRestoreSearchFiles.sp,v 1.5.274.1 2018/03/22 03:04:25 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedGetRestoreSearchFiles <<<'

IF EXISTS (select * from sysobjects where name='SchedGetRestoreSearchFiles')
	drop procedure SchedGetRestoreSearchFiles
IF EXISTS (select * from GxQscripts where name='SchedGetRestoreSearchFiles')
	delete from GxQscripts where name = 'SchedGetRestoreSearchFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedGetRestoreSearchFiles')
	delete from GXDBVersions where aliasname = 'SchedGetRestoreSearchFiles'
GO
print '... Creating Procedure: SchedGetRestoreSearchFiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedGetRestoreSearchFiles
  @xmlText XML
AS
  DECLARE @searchId integer
  DECLARE @commcellId integer
  DECLARE @commcellNumber integer
  DECLARE @archiveFileId integer
  DECLARE @archiveFileOffset BIGINT
  DECLARE @fileName nvarchar(1024)
  DECLARE @appType integer
  DECLARE @appId integer
  DECLARE @exchangeLinkName nvarchar(1024)
  DECLARE @status integer
  DECLARE @size BIGINT
  DECLARE @documentId nvarchar(1024)
  DECLARE @optionId integer
BEGIN
	DECLARE @i_searchId BIGINT
    SET @i_searchId = ISNULL(( SELECT  ref.value('@searchId',
                                                  'bigint')
                                FROM    @xmlText . nodes('EVGui_GetRestoreSearchFilesReq ') R ( ref )
                              ), 0)
	SET @xmlText = (SELECT
		(SELECT [searchId] '@searchId', [commcellId] '@commcellId', [commcellNumber] '@commcellNumber', [archiveFileId] '@archiveFileId',
		[archiveFileOffset] '@archiveFileOffset', [fileName] '@fileName', [appType] '@appType', [appId] '@appId', [exchangeLinkName] '@exchangeLinkName',
		[status] '@status', [size] '@size', [documentId] '@documentId', [optionId] '@optionId'
		FROM SchedRestoreSearchFiles WHERE [searchId] = @i_searchId
		FOR XML PATH('searhFiles'), TYPE)
	FOR XML PATH(''), ROOT('EVGui_GetRestoreSearchFilesResp'))
	SELECT @xmlText
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'SchedGetRestoreSearchFiles')
	delete from GxQscripts where name = 'SchedGetRestoreSearchFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedGetRestoreSearchFiles')
	delete from GXDBVersions where aliasname = 'SchedGetRestoreSearchFiles'
GO

insert into GXDBVersions values(2, 'SchedGetRestoreSearchFiles',  '00010005027400010000', 'SchedGetRestoreSearchFiles', '00010005027400010000')
GO

