

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedGetComplianceDirectorList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedGetComplianceDirectorList.sp,v $ $Id: SchedGetComplianceDirectorList.sp,v 1.15.46.2 2018/03/22 02:56:31 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  SchedGetComplianceDirectorList
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedGetComplianceDirectorList <<<'

IF EXISTS (select * from sysobjects where name='SchedGetComplianceDirectorList')
	drop procedure SchedGetComplianceDirectorList
IF EXISTS (select * from GxQscripts where name='SchedGetComplianceDirectorList')
	delete from GxQscripts where name = 'SchedGetComplianceDirectorList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedGetComplianceDirectorList')
	delete from GXDBVersions where aliasname = 'SchedGetComplianceDirectorList'
GO
print '... Creating Procedure: SchedGetComplianceDirectorList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedGetComplianceDirectorList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @i_UserName			NVARCHAR(max)
	DECLARE @i_domainName		NVARCHAR(max)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @userObjects		TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	DECLARE @i_getComplianceDirectorOptions INT = 0 -- 1 - Get owned CD only, 2 - Get Shared CD only, 3 - Get others CD based on view capabilities
	DECLARE @i_viewCD INT = 0
DECLARE @entityType INT = 9507
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	if object_id('tempdb.dbo.#dm2UserObjectsTbl') is not null
				DROP TABLE #dm2UserObjectsTbl
	CREATE TABLE #dm2UserObjectsTbl (	commCellId	integer, clientId	integer, appTypeId	integer,
						instanceId	integer, backupsetId	integer, subClientId	integer, archGroupId	integer )
	IF object_id('tempdb.dbo.#tmpextGroupListTbl') is not null
					DROP TABLE #tmpextGroupListTbl
	CREATE TABLE #tmpextGroupListTbl (  t_groupName	varchar(1024) )
	--USE ADMIN AS DEFAULT ID
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_capability = 31
	SET @i_domainName = ISNULL(( SELECT ref.value('@domain', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetComplianceDirectorsReq') R ( ref ) ), '')
	SET @i_getComplianceDirectorOptions = ISNULL (( SELECT ref.value('@getComplianceDirectorOptions', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetComplianceDirectorsReq') R(ref)), 0)
	--GET USER RIGHTS
	INSERT INTO #tmpextGroupListTbl (t_groupName)
	SELECT ref.value('@val', 'nvarchar(1024)')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetComplianceDirectorsReq/groups') R(ref)
	IF OBJECT_ID('tempdb.dbo.#SchedGetComplianceDirectorList_userObject') IS NOT null
   DROP TABLE #SchedGetComplianceDirectorList_userObject
create table  #SchedGetComplianceDirectorList_userObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 9507, 0, '#SchedGetComplianceDirectorList_userObject'
	EXEC sec_getUserCapabilitiesForDM2 @i_capability, @i_UserName, @i_domainName, #tmpextGroupListTbl, #dm2UserObjectsTbl
	IF NOT EXISTS (SELECT * FROM #dm2UserObjectsTbl WHERE commCellId = 2)
	BEGIN
		SET @i_viewCD = 1
	END
	-- User can view all CD if he has any sharing rights at Commcell level or Tag node level
	IF ( @i_viewCD = 0 )
	BEGIN
		DECLARE	@o_canDeleteEntityType int = 0
		DECLARE @o_canEditEntityType int = 0
		DECLARE @o_canRestoreEntityType int = 0
		EXEC sec_canDeleteDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canDeleteEntityType = @o_canDeleteEntityType OUTPUT
		EXEC sec_canEditDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canEditEntityType = @o_canEditEntityType OUTPUT
		EXEC sec_canRestoreDM2EntityType
		@i_commcellId = null,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canRestoreEntityType = @o_canRestoreEntityType OUTPUT
		IF ( @o_canDeleteEntityType > 0 OR @o_canEditEntityType > 0 OR @o_canRestoreEntityType > 0 )
			SET @i_viewCD = 1
	END
	IF ( @i_getComplianceDirectorOptions = 0 ) -- get all tags based on user capabilities ( owned and shared tags are retrieved irrespective of capabilities )
	BEGIN
		SET @i_xmlText = ( SELECT
		-- get owned cd policies
		(SELECT S.complianceId '@complianceId', ref.value('@compliancePolicyName', 'nvarchar(1024)') '@compliancePolicyName' ,
		ref.value('@description', 'nvarchar(1024)') '@description' , ref.value('@userId', 'nvarchar(1024)') '@userId',
		S.status '@status', ref.value('@stagingClientId', 'INT') '@stagingClientId' ,
		ref.value('@stagingPath', 'nvarchar(1024)') '@stagingPath', ref.value('@dataArchivedAfterTime', 'INT') '@dataArchivedAfterTime',
		ref.value('@numberOfDays', 'INT') '@numberOfDays', ref.value('@refTime', 'INT') '@refTime',
		ref.value('@updateDM2DB', 'INT') '@updateDM2DB', ref.value('@reviewSetOption', 'INT') '@reviewSetOption',
		1 '@complianceDirectorOwnerType',
		(select ref.query('*') FROM S.xmlValue.nodes('director') O(ref))
		FROM  SchedAdminComplianceXMLOptions S
		CROSS APPLY xmlValue.nodes ('director') R(ref)
		WHERE S.status = 0 AND S.ownerUserId = @i_userId
		FOR XML PATH('compliancePolicies'), TYPE),
		-- get shared cd policies
		(SELECT S.complianceId '@complianceId', ref.value('@compliancePolicyName', 'nvarchar(1024)') '@compliancePolicyName' ,
		ref.value('@description', 'nvarchar(1024)') '@description' , ref.value('@userId', 'nvarchar(1024)') '@userId',
		S.status '@status', ref.value('@stagingClientId', 'INT') '@stagingClientId' ,
		ref.value('@stagingPath', 'nvarchar(1024)') '@stagingPath', ref.value('@dataArchivedAfterTime', 'INT') '@dataArchivedAfterTime',
		ref.value('@numberOfDays', 'INT') '@numberOfDays', ref.value('@refTime', 'INT') '@refTime',
		ref.value('@updateDM2DB', 'INT') '@updateDM2DB', ref.value('@reviewSetOption', 'INT') '@reviewSetOption',
		2 '@complianceDirectorOwnerType',
		ref.query('*')
		FROM  SchedAdminComplianceXMLOptions S
		INNER JOIN #SchedGetComplianceDirectorList_userObject UUG ON UUG.cdPolicyId = S.id
		CROSS APPLY xmlValue.nodes ('director') R(ref)
		WHERE S.status = 0
		FOR XML PATH('compliancePolicies'), TYPE),
		-- get other cd policies
		(SELECT S.complianceId '@complianceId', ref.value('@compliancePolicyName', 'nvarchar(1024)') '@compliancePolicyName' ,
		ref.value('@description', 'nvarchar(1024)') '@description' , ref.value('@userId', 'nvarchar(1024)') '@userId',
		S.status '@status', ref.value('@stagingClientId', 'INT') '@stagingClientId' ,
		ref.value('@stagingPath', 'nvarchar(1024)') '@stagingPath', ref.value('@dataArchivedAfterTime', 'INT') '@dataArchivedAfterTime',
		ref.value('@numberOfDays', 'INT') '@numberOfDays', ref.value('@refTime', 'INT') '@refTime',
		ref.value('@updateDM2DB', 'INT') '@updateDM2DB', ref.value('@reviewSetOption', 'INT') '@reviewSetOption',
		3 '@complianceDirectorOwnerType',
		(select ref.query('*') FROM S.xmlValue.nodes('director') O(ref))
		FROM  SchedAdminComplianceXMLOptions S
		CROSS APPLY xmlValue.nodes ('director') R(ref)
		WHERE @i_viewCD = 1 AND S.status = 0 AND S.ownerUserId <> @i_userId
		AND S.id NOT in ( SELECT cdPolicyId FROM #SchedGetComplianceDirectorList_userObject  )
		FOR XML PATH('compliancePolicies'), TYPE)
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GetComplianceDirectorResp'))
	END
	ELSE IF ( @i_getComplianceDirectorOptions = 1 )
	BEGIN
		SET @i_xmlText = ( SELECT
		-- get owned cd policies
		(SELECT S.complianceId '@complianceId', ref.value('@compliancePolicyName', 'nvarchar(1024)') '@compliancePolicyName' ,
		ref.value('@description', 'nvarchar(1024)') '@description' , ref.value('@userId', 'nvarchar(1024)') '@userId',
		S.status '@status', ref.value('@stagingClientId', 'INT') '@stagingClientId' ,
		ref.value('@stagingPath', 'nvarchar(1024)') '@stagingPath', ref.value('@dataArchivedAfterTime', 'INT') '@dataArchivedAfterTime',
		ref.value('@numberOfDays', 'INT') '@numberOfDays', ref.value('@refTime', 'INT') '@refTime',
		ref.value('@updateDM2DB', 'INT') '@updateDM2DB', ref.value('@reviewSetOption', 'INT') '@reviewSetOption',
		1 '@complianceDirectorOwnerType',
		(select ref.query('*') FROM S.xmlValue.nodes('director') O(ref))
		FROM  SchedAdminComplianceXMLOptions S
		CROSS APPLY xmlValue.nodes ('director') R(ref)
		WHERE S.status = 0 AND S.ownerUserId = @i_userId
		FOR XML PATH('compliancePolicies'), TYPE)
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GetComplianceDirectorResp'))
	END
	ELSE IF ( @i_getComplianceDirectorOptions = 2 )
	BEGIN
		SET @i_xmlText = ( SELECT
		-- get shared cd policies
		(SELECT S.complianceId '@complianceId', ref.value('@compliancePolicyName', 'nvarchar(1024)') '@compliancePolicyName' ,
		ref.value('@description', 'nvarchar(1024)') '@description' , ref.value('@userId', 'nvarchar(1024)') '@userId',
		S.status '@status', ref.value('@stagingClientId', 'INT') '@stagingClientId' ,
		ref.value('@stagingPath', 'nvarchar(1024)') '@stagingPath', ref.value('@dataArchivedAfterTime', 'INT') '@dataArchivedAfterTime',
		ref.value('@numberOfDays', 'INT') '@numberOfDays', ref.value('@refTime', 'INT') '@refTime',
		ref.value('@updateDM2DB', 'INT') '@updateDM2DB', ref.value('@reviewSetOption', 'INT') '@reviewSetOption',
		2 '@complianceDirectorOwnerType',
		(select ref.query('*') FROM S.xmlValue.nodes('director') O(ref))
		FROM  SchedAdminComplianceXMLOptions S
		INNER JOIN #SchedGetComplianceDirectorList_userObject UUG ON UUG.cdPolicyId = S.id
		CROSS APPLY xmlValue.nodes ('director') R(ref)
		WHERE S.status = 0
		FOR XML PATH('compliancePolicies'), TYPE)
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GetComplianceDirectorResp'))
	END
	ELSE IF ( @i_getComplianceDirectorOptions = 3 )
	BEGIN
		SET @i_xmlText = ( SELECT
		-- get other cd policies
		(SELECT S.complianceId '@complianceId', ref.value('@compliancePolicyName', 'nvarchar(1024)') '@compliancePolicyName' ,
		ref.value('@description', 'nvarchar(1024)') '@description' , ref.value('@userId', 'nvarchar(1024)') '@userId',
		S.status '@status', ref.value('@stagingClientId', 'INT') '@stagingClientId' ,
		ref.value('@stagingPath', 'nvarchar(1024)') '@stagingPath', ref.value('@dataArchivedAfterTime', 'INT') '@dataArchivedAfterTime',
		ref.value('@numberOfDays', 'INT') '@numberOfDays', ref.value('@refTime', 'INT') '@refTime',
		ref.value('@updateDM2DB', 'INT') '@updateDM2DB', ref.value('@reviewSetOption', 'INT') '@reviewSetOption',
		3 '@complianceDirectorOwnerType',
		(select ref.query('*') FROM S.xmlValue.nodes('director') O(ref))
		FROM  SchedAdminComplianceXMLOptions S
		CROSS APPLY xmlValue.nodes ('director') R(ref)
		WHERE @i_viewCD = 1 AND S.status = 0 AND S.ownerUserId <> @i_userId
		AND S.id NOT in ( SELECT cdPolicyId FROM #SchedGetComplianceDirectorList_userObject )
		FOR XML PATH('compliancePolicies'), TYPE)
		FOR XML PATH(''), ROOT('DM2ContentIndexing_GetComplianceDirectorResp'))
	END
	ELSE
	BEGIN
		GOTO exit_proc
	END
	IF @i_xmlText IS NOT null
		SELECT @i_xmlText
	ELSE
		SELECT '<DM2ContentIndexing_GetComplianceDirectorResp/>'
EXIT_PROC:
	IF OBJECT_ID('tempdb.dbo.#SchedGetComplianceDirectorList_userObject') IS NOT null
   DROP TABLE #SchedGetComplianceDirectorList_userObject
END
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SchedGetComplianceDirectorList')
	delete from GxQscripts where name = 'SchedGetComplianceDirectorList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedGetComplianceDirectorList')
	delete from GXDBVersions where aliasname = 'SchedGetComplianceDirectorList'
GO

insert into GXDBVersions values(2, 'SchedGetComplianceDirectorList',  '00010015004600020000', 'SchedGetComplianceDirectorList', '00010015004600020000')
GO

