

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedGetComplianceDirectorDetail.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedGetComplianceDirectorDetail.sp,v $ $Id: SchedGetComplianceDirectorDetail.sp,v 1.4.286.1 2017/02/10 21:53:36 sjohnson Exp $";
--
--  +========================================================================+
--  |   Procedure:  SchedGetComplianceDirectorDetail
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedGetComplianceDirectorDetail <<<'

IF EXISTS (select * from sysobjects where name='SchedGetComplianceDirectorDetail')
	drop procedure SchedGetComplianceDirectorDetail
IF EXISTS (select * from GxQscripts where name='SchedGetComplianceDirectorDetail')
	delete from GxQscripts where name = 'SchedGetComplianceDirectorDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedGetComplianceDirectorDetail')
	delete from GXDBVersions where aliasname = 'SchedGetComplianceDirectorDetail'
GO
print '... Creating Procedure: SchedGetComplianceDirectorDetail'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedGetComplianceDirectorDetail
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @xmlOption			XML
	DECLARE @complianceId		INT
	DECLARE @status				INT
	DECLARE @t_OptionResp		TABLE( complianceId INT, compliancePolicyName nvarchar(1024), descript nvarchar(1024), complianceSteps XML, status INT, xmlOption XML)
DECLARE @i_UserName			NVARCHAR(255)
DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @userObjects		TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	if object_id('tempdb.dbo.#dm2UserObjectsTbl') is not null
				DROP TABLE #dm2UserObjectsTbl
	CREATE TABLE #dm2UserObjectsTbl (	commCellId	integer, clientId	integer, appTypeId	integer,
						instanceId	integer, backupsetId	integer, subClientId	integer, archGroupId	integer )
	IF object_id('tempdb.dbo.#tmpextGroupListTbl') is not null
					DROP TABLE #tmpextGroupListTbl
	CREATE TABLE #tmpextGroupListTbl (  t_groupName	varchar(1024) )
	SET @complianceId = ISNULL(( SELECT ref.value('@policyId', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetCompliancePolicyDetail') R ( ref ) ), '')
	--USE ADMIN AS DEFAULT ID
	IF @i_userId IS NULL OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
SET @i_capability = 25
	SET @i_domainName = ISNULL(( SELECT ref.value('@domain', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_GetCompliancePolicyDetail') R ( ref ) ), '')
	--GET USER RIGHTS
	INSERT INTO #tmpextGroupListTbl (t_groupName)
	SELECT ref.value('@val', 'nvarchar(1024)')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_GetCompliancePolicyDetail/groups') R(ref)
	EXEC sec_getUserCapabilitiesForDM2 @i_capability, @i_UserName, @i_domainName, #tmpextGroupListTbl, #dm2UserObjectsTbl
	IF NOT EXISTS (SELECT * FROM #dm2UserObjectsTbl WHERE commCellId = 2)
	BEGIN
		SET @i_xmlText = (SELECT 1 '@errorCode', 'User does not have Compliance rights at Commcell level' '@errorString'
					FOR XML PATH('CVGui_GenericResp'))
		GOTO EXIT_PROC
	END
	SELECT @xmlOption = xmlValue, @status = status FROM SchedAdminComplianceXMLOptions WHERE complianceId = @complianceId
	INSERT INTO @t_OptionResp
	SELECT @complianceId, ref.value('@compliancePolicyName', 'nvarchar(1024)'), ref.value('@description', 'nvarchar(1024)'),
	ref.query('complianceSteps'), @status, (SELECT ref.query('*') FROM  @xmlOption.nodes ('director') O(ref))
	FROM  @xmlOption.nodes ('director') R(ref)
	SET @i_xmlText = (
		SELECT TOP(1) O.complianceId '@complianceId', O.compliancePolicyName '@compliancePolicyName', O.descript '@description', O.status '@status',
		O.complianceSteps 'complianceSteps', (SELECT TOP(1) C.xmlOption 'compliancePolicies' FROM @t_OptionResp AS C WHERE C.complianceId = O.complianceId)
		FROM @t_OptionResp AS O
		FOR XML PATH('director'), ROOT('DM2ContentIndexing_GetCompliancePolicyDetailResp'))
EXIT_PROC:
		IF @i_xmlText IS NOT NULL
			SELECT @i_xmlText
		ELSE
			SELECT '<DM2ContentIndexing_GetCompliancePolicyDetailResp/>'
END
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SchedGetComplianceDirectorDetail')
	delete from GxQscripts where name = 'SchedGetComplianceDirectorDetail'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedGetComplianceDirectorDetail')
	delete from GXDBVersions where aliasname = 'SchedGetComplianceDirectorDetail'
GO

insert into GXDBVersions values(2, 'SchedGetComplianceDirectorDetail',  '00010004028600010000', 'SchedGetComplianceDirectorDetail', '00010004028600010000')
GO

