

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedDeleteComplianceDirectorList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedDeleteComplianceDirectorList.sp,v $ $Id: SchedDeleteComplianceDirectorList.sp,v 1.9.286.2 2018/03/22 03:14:48 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  SchedDeleteComplianceDirectorList
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedDeleteComplianceDirectorList <<<'

IF EXISTS (select * from sysobjects where name='SchedDeleteComplianceDirectorList')
	drop procedure SchedDeleteComplianceDirectorList
IF EXISTS (select * from GxQscripts where name='SchedDeleteComplianceDirectorList')
	delete from GxQscripts where name = 'SchedDeleteComplianceDirectorList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedDeleteComplianceDirectorList')
	delete from GXDBVersions where aliasname = 'SchedDeleteComplianceDirectorList'
GO
print '... Creating Procedure: SchedDeleteComplianceDirectorList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedDeleteComplianceDirectorList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN
	DECLARE @i_capability		INT
	DECLARE @ComplianceTable		TABLE( complianceId INT)
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
DECLARE @i_UserName			NVARCHAR(255)
DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @xmlObjects			TABLE(xmlJobInfo XML)
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @opEvMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opMsgId			INT
	DECLARE @userObjects		TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @dataIsEvent = 0
	-------------------------------
	--CREATE TEMP TABLE------------
	-------------------------------
	-- None of these temp tables should ever exist when this procedure is called!
	if object_id('tempdb.dbo.#dm2UserObjectsTbl') is not null
				DROP TABLE #dm2UserObjectsTbl
	CREATE TABLE #dm2UserObjectsTbl (	commCellId	integer, clientId	integer, appTypeId	integer,
						instanceId	integer, backupsetId	integer, subClientId	integer, archGroupId	integer )
	IF object_id('tempdb.dbo.#tmpextGroupListTbl') is not null
					DROP TABLE #tmpextGroupListTbl
	CREATE TABLE #tmpextGroupListTbl (  t_groupName	varchar(1024) )
	--USE ADMIN AS DEFAULT ID
	IF @i_userId IS NULL OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
SET @i_capability = 25
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_CompliancePoliciesDeleteReq') R ( ref ) ), @i_UserName)
	--GET USER RIGHTS
	INSERT INTO #tmpextGroupListTbl (t_groupName)
	SELECT ref.value('@val', 'nvarchar(1024)')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_TagOperationReq/groups') R(ref)
	EXEC sec_getUserCapabilitiesForDM2 @i_capability, @i_UserName, @i_domainName, #tmpextGroupListTbl, #dm2UserObjectsTbl
	IF NOT EXISTS (SELECT * FROM #dm2UserObjectsTbl WHERE commCellId = 2)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'User does not have Compliance rights at Commcell level'
		GOTO EXIT_PROC
	END
	INSERT INTO @ComplianceTable
	SELECT ref.value('@complianceId', 'INT')
	FROM  @i_xmlText.nodes ('DM2ContentIndexing_CompliancePoliciesDeleteReq/policies') R(ref)
	IF (@@ROWCOUNT = 0)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'compliance list is empty'
		GOTO EXIT_PROC
	END
	--INSERT INTO @xmlObjects
	--SELECT xmlJobInfo FROM JMJobInfo
	DECLARE @complianceId	INT
	DECLARE @compPolicyName	NVARCHAR(1024)
	DECLARE	GetComplianceIdCursor	CURSOR FOR
	SELECT complianceId FROM @ComplianceTable
	OPEN GetComplianceIdCursor
	FETCH GetComplianceIdCursor INTO @complianceId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		IF EXISTS (SELECT * FROM JMJobInfo WHERE xmlJobInfo LIKE ('%<compliancePolicyInfo id="'+CAST(@complianceId AS VARCHAR(10))+'"%'))
		BEGIN
			SET @o_errorCode = 2
			SET @o_errorString = 'Cannot delete compliance policy. It is being used by running job'
			GOTO EXIT_PROC
		END
		SELECT @compPolicyName = policyName FROM SchedAdminComplianceXMLOptions WHERE complianceId = @complianceId
		--DELETE COMPLETE XML OPTIONS
		UPDATE SchedAdminComplianceXMLOptions SET status = 1 WHERE complianceId = @complianceId
		UPDATE SchedAdminComplianceOptions SET status = 1 WHERE complianceId = @complianceId
		DELETE FROM JMCompliancePolicyQualifiedJobs WHERE complianceId = @complianceId
UPDATE schedule SET flags=flags|1
			WHERE taskId IN (SELECT adminTaskId FROM SchedAdminParam WHERE type = 9347 AND data = @complianceId)
			AND taskType = 4
		SET @o_errorCode = @@error
		IF (@o_errorCode = 0)
		BEGIN
			-- SET GUI AUDIT OPERATION
SET @opMsgId = (217 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @compPolicyName, @dataIsEvent
SET @paramMsgId = (509 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		END
		FETCH GetComplianceIdCursor INTO @complianceId
	END
	CLOSE GetComplianceIdCursor
	DEALLOCATE GetComplianceIdCursor
EXIT_PROC:
		DROP TABLE #tmpextGroupListTbl
		DROP TABLE #dm2UserObjectsTbl
		SET @i_xmlText = (SELECT @o_errorCode '@errorCode', @o_errorString '@errorMessage'
					FOR XML PATH('CVGui_GenericResp'))
		SELECT @i_xmlText
END
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SchedDeleteComplianceDirectorList')
	delete from GxQscripts where name = 'SchedDeleteComplianceDirectorList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedDeleteComplianceDirectorList')
	delete from GXDBVersions where aliasname = 'SchedDeleteComplianceDirectorList'
GO

insert into GXDBVersions values(2, 'SchedDeleteComplianceDirectorList',  '00010009028600020000', 'SchedDeleteComplianceDirectorList', '00010009028600020000')
GO

