

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedCreateJobForComplinaceDirector.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   04/04/2008
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedCreateJobForComplinaceDirector.sp,v $ $Id: SchedCreateJobForComplinaceDirector.sp,v 1.60.80.10 2020/09/02 04:57:06 vmishra Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SchedCreateJobForComplinaceDirector')
BEGIN
	print '>>> Drop Stored Procedure: SchedCreateJobForComplinaceDirector <<<'
	drop procedure SchedCreateJobForComplinaceDirector
END
IF EXISTS (select * from GxQscripts where name='SchedCreateJobForComplinaceDirector')
	delete from GxQscripts where name = 'SchedCreateJobForComplinaceDirector'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedCreateJobForComplinaceDirector')
	delete from GXDBVersions where aliasname = 'SchedCreateJobForComplinaceDirector'
GO
print '... Creating Procedure: SchedCreateJobForComplinaceDirector'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedCreateJobForComplinaceDirector
  @i_userId INT,
  @i_sequenceNumber varchar(255),
  @xmlText XML,
  @i_localId INT=0,
  @i_usrGuid varchar(255)=''
AS
  DECLARE @o_TaskId integer
  DECLARE @o_JobId bigint
  DECLARE @o_ErrorCode integer
  DECLARE @o_ErrorString nvarchar(1024)
	DECLARE @t_JobId			TABLE( jobId BIGINT )	--Compliance JobId
	DECLARE @t_OptionResp		TABLE( complianceId INT, searchId INT, errorCode INT, errorString NVARCHAR(1024))
	DECLARE @i_ComplianceId		INT = 0
	DECLARE @i_description		NVARCHAR(1024) = ''
	DECLARE @xmlOptions			XML
	DECLARE @i_UserGUID			NVARCHAR(36)
	DECLARE @i_policyName		NVARCHAR(1024)
	DECLARE @i_TagType			INT
	DECLARE @i_CloudId			INT = 0
	DECLARE @i_SearchId			INT = 0
	DECLARE @i_startJob			INT = 1
	DECLARE @i_indexFree		INT
	DECLARE @i_backupSetId		INT = 0
	DECLARE @i_appType			INT
DECLARE @i_UserName			NVARCHAR(255)
DECLARE @i_domainName		NVARCHAR(255) = ''
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @i_commcellId		INT
	DECLARE @position			INT
	DECLARE @createTask			INT
DECLARE @source				VARCHAR(255)
	DECLARE @jobId				BIGINT
	DECLARE @count				INT = 0
	DECLARE @clientId			INT = 2
	DECLARE @subTaskType		INT = 0
	DECLARE @restoreClientId	INT = 0
	DECLARE @restoreBackupSetId	INT = 0
	DECLARE @restoreSubclientId INT = -1
	DECLARE @restoreInstanceId	INT = 0
	DECLARE @folderDownload		INT = 0
	DECLARE @sourcItems			XML
	DECLARE @paramEvMsgId		INT
	 DECLARE @copyPrecedence    INT = 0
	DECLARE @CurrentTime		INT = dbo.getUnixTime(getUTCDate())
DECLARE @drInstanceID		INT =  ISNULL((SELECT TOP 1 instance FROM APP_Application (NOLOCK) WHERE appTypeId= 1000) , 1)
	DECLARE @NextEvIDTable		TABLE (id int)
	SET @o_JobId = 0
	SET @o_TaskId = 0
	SET @o_ErrorCode = 0
	SET @o_ErrorString = ''
	SET @i_TagType = 0
	SET @i_startJob = 1
	SET @position = 1
	SET @createTask = 0
	SET @copyPrecedence = dbo.AppGetAdditionalSettingForClient(@clientId, 'copyPrecedence','WebConsole')
	SET @i_UserGUID = ISNULL (( SELECT ref.value('@userId', 'NVARCHAR(36)')
					FROM @xmlText.nodes ('DM2ContentIndexing_ComplianceDirector') R(ref)), @i_usrGuid)
	SET @i_userId = ISNULL (( SELECT ref.value('@runUserId', 'INT')
					FROM @xmlText.nodes ('TMMsg_CreateTaskReq/taskInfo/task') R(ref)), @i_userId)
	--USE ADMIN AS DEFAULT ID
	IF @i_userId IS NULL OR @i_userId = 0
	BEGIN
		IF (@i_UserGUID <> '')
			SELECT @i_userId = id, @i_UserName = login
				FROM UMUSERS WITH(NOLOCK) WHERE userGuid = @i_UserGUID AND enabled=1
		ELSE
		BEGIN
			Select TOP 1 @i_userId = id, @i_UserGUID = userGuid, @i_UserName = login
				from UMUSERS WITH(NOLOCK) where (flags & 67) = 67 AND Name <> 'ROMS'	--  USERS_VALID | USERS_PERMANENT | USERS_ADMIN = (0x43|67)
			IF ISNULL(@i_userId,0) = 0
				SELECT @i_userId = id, @i_UserName = login, @i_UserGUID = userGuid
					FROM UMUSERS WITH(NOLOCK) WHERE id = 1
		END
	END
	IF ISNULL(@i_UserGUID, '') = ''
	BEGIN
		SET @o_ErrorCode = -1
		SET @o_ErrorString = 'Missing user GUID'
		GOTO EXIT_PROC
	END
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @xmlText.nodes('DM2ContentIndexing_ComplianceDirector') R ( ref ) ), @i_UserName)
	--GET PARAM INPUTS
	SELECT @i_backupSetId = ISNULL(ref.value('@backupsetId', 'INT'), @i_backupSetId),
			   @i_commcellId = ISNULL(ref.value('@commCellId', 'INT'), @i_commcellId)
			FROM  @xmlText.nodes ('TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]') R(ref)
	--CHECK FOR ALL ACTIVITY DISABLED
	IF EXISTS (SELECT 1 FROM JMJobAction WHERE clientId=1 AND appType=0 AND mediaAgentID=1 AND opType=1 AND appId=1 AND action=1 AND instanceID = @drInstanceID)
	BEGIN
SET @o_ErrorCode = (645 | (CAST(POWER(2, 24) AS BIGINT) * 19))
		SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, @o_ErrorCode, 0, @i_commcellId)
		GOTO EXIT_PROC
	END
	SELECT @i_domainName = ISNULL(ref.value('@domainName', 'nvarchar(255)'), @i_domainName),
			@i_description = ISNULL(ref.value('@description', 'nvarchar(1024)'), @i_description),
			@i_CloudId = ISNULL(ref.value('@cloudId', 'INT'), @i_CloudId),
			@i_startJob = ISNULL(ref.value('@startJob', 'INT'), @i_startJob),
			@i_SearchId = ISNULL(ref.value('(options/@searchId)[1]', 'INT'), ref.value('@searchId', 'INT')),
			@i_ComplianceId = ISNULL(ref.value('@complianceId', 'INT'), @i_ComplianceId)
		FROM @xmlText.nodes('DM2ContentIndexing_ComplianceDirector') R ( ref )
	SET @i_SearchId = ISNULL((SELECT ref.value('@powerSearchId', 'INT')
			FROM  @xmlText.nodes ('TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/searchOption') R(ref)), @i_SearchId)
	SET @i_indexFree = @i_SearchId
	SELECT @i_SearchId = ISNULL(ref.value('@jobId', 'INT'), @i_SearchId),
			@i_indexFree = ISNULL(ref.value('@lhIndexFreeRestore', 'INT'), @i_SearchId)
		FROM  @xmlText.nodes ('TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions') R(ref)
	SET @i_ComplianceId = ISNULL((SELECT ref.value('@complianceId', 'INT')
			FROM  @xmlText.nodes ('TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/adminOpts/infoMgmtOption') R(ref)), @i_ComplianceId)
	SET @folderDownload = ISNULL((SELECT ref.value('@zipFolderRestore', 'INT')
			FROM  @xmlText.nodes ('TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/commonOptions') R(ref)), 0)
	SET @subTaskType = ISNULL((SELECT ref.value('@subTaskType', 'INT')
			FROM  @xmlText.nodes ('TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/subTask') R(ref)), 0)
	IF 0 = @i_backupSetId
		SELECT TOP(1) @i_appType = appTypeId FROM APP_Application WHERE clientId = @clientId AND appTypeId < 1000
	ELSE
		SELECT TOP(1) @i_appType = appTypeId FROM APP_Application WHERE backupSet = @i_backupSetId
	SET @i_startJob = @xmlText.exist('/TMMsg_CreateTaskReq')
	--INSERT OPTIONS
	SET @xmlOptions = ( SELECT @i_ComplianceId '@complianceId', @i_SearchId '@searchId', ref.query('*')
			FROM  @xmlText.nodes ('DM2ContentIndexing_ComplianceDirector/options') R(ref)
			FOR XML PATH('DM2ContentIndexing_ComplianceOptions'))
	--CHECK RESTORE ACTIVITY ONLY FOR RESTORE JOBS
	IF (@xmlOptions.exist('/DM2ContentIndexing_ComplianceOptions/searchRequest') > 0 OR @xmlOptions.exist('/DM2ContentIndexing_ComplianceOptions/searchPaths') > 0
OR @subTaskType = 3 OR @xmlText.exist('//infoMgmtOption/@runSearchPhase[.="1"]') > 0)
	BEGIN
		DECLARE @clientName NVARCHAR(248)=''
		DECLARE @appName NVARCHAR(248)=''
		--CHECK RESTORE ACTIVITY AT CS LEVEL
		IF EXISTS (SELECT 1 FROM JMJobAction WHERE clientId=1 AND appType=0 AND mediaAgentID=1 AND opType=5 AND appId=1 AND action=1 AND clientGroupId=0 AND instanceID = @drInstanceID)
		BEGIN
SET @o_ErrorCode = (742 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, @o_ErrorCode, 0, @i_commcellId)
			GOTO EXIT_PROC
		END
		--CHECK RESTORE ACTIVITY AT CLIENT LEVEL
		IF EXISTS (SELECT 1 FROM JMJobAction WHERE clientId=@clientId AND appType=0 AND mediaAgentID=1 AND opType=5 AND appId=1 AND action=1)
		BEGIN
SET @o_ErrorCode = (629 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @clientName = (SELECT name FROM APP_Client WHERE id = @clientId)
			INSERT INTO @NextEvIDTable
				EXECUTE GetNextEventId
			SELECT @paramEvMsgId = id FROM  @NextEvIDTable
			INSERT INTO EvMsg (id, TimeSource, TimeServer, Severity, Ack, Acked, Type,
		 		ParamNum, MessageId, JobId_h, JobId_l, ClientId, CommcellId,
      			UserId, SubSystemId, Client, CommCell, UserName, SubSystem,
      			MsgEnglish, RepeatCount, LastOccurrence, NextPost,
      			mediaId, driveId, libraryId, maClientId)
      		VALUES(@paramEvMsgId, @CurrentTime, @CurrentTime, 0, 0, 0, 2,
      				1, @o_ErrorCode, 0, 0, 0, 2,
      				@i_userId, 0, 0, 0, 0, 'EvMgrS',
      				'', 1, @CurrentTime, 1,
      				0, 0, 0, 0)
			INSERT INTO EvParam(EvMsgId, EventId, Position, Type, Size, Data)
      			values(@paramEvMsgId, @o_ErrorCode, 1, 0, 0, @clientName)
			SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(@paramEvMsgId, @i_localId, @o_ErrorCode, 0, @i_commcellId)
			GOTO EXIT_PROC
		END
		--CHECK RESTORE ACTIVITY AT AGENT LEVEL
		IF EXISTS (SELECT 1 FROM JMJobAction WHERE clientId=@clientId AND appType=@i_appType AND mediaAgentID=1 AND opType=5 AND appId=1 AND action=1)
		BEGIN
SET @o_ErrorCode = (750 | (CAST(POWER(2, 24) AS BIGINT) * 19))
			SET @clientName = (SELECT name FROM APP_Client WHERE id = @clientId)
			SET @appName = (SELECT TOP 1 display_name FROM simAppTypeLicTypeMap WHERE appTypeId=@i_appType)
			INSERT INTO @NextEvIDTable
				EXECUTE GetNextEventId
			SELECT @paramEvMsgId = id FROM  @NextEvIDTable
			INSERT INTO EvMsg (id, TimeSource, TimeServer, Severity, Ack, Acked, Type,
		 		ParamNum, MessageId, JobId_h, JobId_l, ClientId, CommcellId,
      			UserId, SubSystemId, Client, CommCell, UserName, SubSystem,
      			MsgEnglish, RepeatCount, LastOccurrence, NextPost,
      			mediaId, driveId, libraryId, maClientId)
   			VALUES(@paramEvMsgId, @CurrentTime, @CurrentTime, 0, 0, 0, 2,
      			1, @o_ErrorCode, 0, 0, 0, 2,
      			@i_userId, 0, 0, 0, 0, 'EvMgrS',
      			'', 1, @CurrentTime, 1,
      			0, 0, 0, 0)
			INSERT INTO EvParam(EvMsgId, EventId, Position, Type, Size, Data)
      			VALUES(@paramEvMsgId, @o_ErrorCode, 1, 0, 0, @clientName)
			INSERT INTO EvParam(EvMsgId, EventId, Position, Type, Size, Data)
      			VALUES(@paramEvMsgId, @o_ErrorCode, 2, 0, 0, @appName)
			SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(@paramEvMsgId, @i_localId, @o_ErrorCode, 0, @i_commcellId)
			GOTO EXIT_PROC
		END
	END
	EXEC SchedInsertComplianceJobOptions @i_userId, @xmlOptions OUTPUT
	INSERT INTO @t_OptionResp
	SELECT ref.value('@complianceId', 'INT'), ref.value('@searchId', 'INT'), ref.value('@errorCode', 'INT'),
	ref.value('@errorString', 'NVARCHAR(1024)')
	FROM @xmlOptions.nodes('DM2ContentIndexing_ComplianceOptionsResp') R ( ref )
	IF (@i_startJob = 0 AND @i_ComplianceId = 0)
	BEGIN
		SELECT TOP(1) @i_ComplianceId = complianceId, @i_searchId = searchId, @o_ErrorCode = errorCode, @o_ErrorString = errorString FROM @t_OptionResp
		IF @o_ErrorCode <> 0
			GOTO EXIT_PROC
	END
	IF (@i_startJob = 1)
	BEGIN
		IF (@xmlText.exist('//taskInfo/task/@runUserId')) = 1
			SET @xmlText.modify('replace value of (//taskInfo/task/@runUserId)[1] with sql:variable("@i_userId")')
		ELSE
			SET @xmlText.modify('insert (attribute runUserId {sql:variable("@i_userId")}) into (//taskInfo/task)[1]')
		IF (@i_searchId = 0)
		BEGIN
			--Insert into temp table to avoid sending it as a response
			INSERT INTO @t_JobId EXEC @o_JobId = TM_GetNextJobId
			-- Also put it in xml so that scheduler does not increment it once more
			IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions')) <> 1
				SET @xmlText.modify('insert <serverOptions /> into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options)[1]')
			IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions/@jobId')) = 1
				SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions/@jobId)[1] with sql:variable("@o_JobId")')
			ELSE
				SET @xmlText.modify('insert (attribute jobId {sql:variable("@o_JobId")}) into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions)[1]')
		END
		ELSE
		BEGIN
			SET @o_JobId = @i_searchId
		END
		--FOR LEGAL HOLD RESTORE, PASS THE CC:JOBID AS SOURCE ITEM
		IF @i_indexFree = 1
		BEGIN
			IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/fileOption')) <> 1
				SET @xmlText.modify('insert <fileOption /> into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions)[1]')
			IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@applicationId')) = 1
				SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@applicationId)[1] with sql:variable("@i_appType")')
			ELSE
				SET @xmlText.modify('insert (attribute applicationId {sql:variable("@i_appType")}) into (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")])[1]')
			IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions')) <> 1
				SET @xmlText.modify('insert <serverOptions /> into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options)[1]')
			IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions/@jobId')) = 1
				SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions/@jobId)[1] with sql:variable("@o_JobId")')
			ELSE
				SET @xmlText.modify('insert (attribute jobId {sql:variable("@o_JobId")}) into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions)[1]')
			DECLARE GetJobsFromBackupSetId CURSOR
			FOR SELECT DISTINCT jobId FROM JMJobDataStats WHERE appId in (SELECT id FROM APP_Application WHERE backupSet = @i_backupSetId) AND (disabled & 256) = 0
			OPEN GetJobsFromBackupSetId
			FETCH GetJobsFromBackupSetId INTO @jobId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @count = @count + 1
				SET @source = CAST(@i_commcellId AS VARCHAR(10)) + ':' + CAST(@jobId AS VARCHAR(10))
				IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/fileOption')) <> 1
					SET @xmlText.modify('insert <fileOption /> into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options)[1]')
				SET @xmlText.modify('insert <sourceItem />  into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/fileOption)[1]')
				SET @xmlText.modify('insert (attribute val {sql:variable("@source")}) into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/fileOption/sourceItem[position() = sql:variable("@count")])[1]')
				FETCH GetJobsFromBackupSetId INTO @jobId
			END
			CLOSE GetJobsFromBackupSetId
			DEALLOCATE GetJobsFromBackupSetId
		END
		ELSE
		BEGIN
			IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/commonOptions/@restoreDataInsteadOfStub')) = 1
				SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/commonOptions/@restoreDataInsteadOfStub)[1] with "1"')
			ELSE
				SET @xmlText.modify('insert (attribute restoreDataInsteadOfStub {"1"}) into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/commonOptions)[1]')
IF @copyPrecedence > 0 AND @i_appType = 106
	            BEGIN
	            IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption/mediaOption')) <> 1
                    SET @xmlText.modify('insert <mediaOption /> into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption)[1]')
	            IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption/mediaOption/copyPrecedence')) <> 1
	                SET @xmlText.modify('insert <copyPrecedence /> into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption/mediaOption)[1]')
	            IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedence')) = 1
	                SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedence)[1] with sql:variable("@copyPrecedence")')
	            ELSE
	                SET @xmlText.modify('insert (attribute copyPrecedence {sql:variable("@copyPrecedence")}) into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption/mediaOption/copyPrecedence)[1]')
	            IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedenceApplicable')) = 1
                    SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption/mediaOption/copyPrecedence/@copyPrecedenceApplicable)[1] with "1"')
                ELSE
                    SET @xmlText.modify('insert (attribute copyPrecedenceApplicable {"1"}) into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption/mediaOption/copyPrecedence)[1]')
	            END
			IF @folderDownload = 1
			OR
			(
@i_appType = 106	--_CV_APPTYPE_VIRTUAL_SERVER
				AND
				@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/@endUserVMRestore') <> 1
			)
			BEGIN
				SET @count = 1
				SET @sourcItems = (
					SELECT dbo.EncodeInvalidXMLChar(filename) '@val'
					FROM SchedRestoreSearchFiles
					WHERE searchId = @i_SearchId
					FOR XML PATH ('sourceItem')
				)
				DECLARE @tempSubclientId INT
				SELECT TOP 1 @restoreClientId=AP.clientId, @restoreBackupSetId=BS.id, @i_appType=AP.appTypeId, @restoreInstanceId=AP.instance, @tempSubclientId = AP.id
				FROM SchedRestoreSearchFiles SF WITH (NOLOCK)
				JOIN APP_Application AP WITH (NOLOCK) ON AP.id = SF.appId --AND AP.subclientStatus&8=8
				JOIN APP_Client C WITH (NOLOCK) ON C.id = AP.clientId
				JOIN APP_BackupSetName BS WITH (NOLOCK) ON BS.id = AP.backupSet --AND BS.status&8=8
				WHERE searchId = @i_SearchId
				--assign subclientid to task request only if all restore items are from the same subclient
				DECLARE @subclientCount INT
				SELECT @subclientCount = COUNT(DISTINCT appid) FROM SchedRestoreSearchFiles SF WITH (NOLOCK) WHERE  searchId = @i_SearchId
				IF (@subclientCount = 1)
					SET @restoreSubclientId = @tempSubclientId
				IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/commonOptions/@stripLevelType')) = 1
					SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/commonOptions/@stripLevelType)[1] with "0"')
				ELSE
					SET @xmlText.modify('insert (attribute stripLevelType {"0"}) into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/commonOptions)[1]')
				IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/fileOption')) <> 1
					SET @xmlText.modify('insert <fileOption /> into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions)[1]')
				SET @xmlText.modify ('insert sql:variable("@sourcItems") as last into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/fileOption)[1]')
				IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/subTask/@operationType')) = 1
					SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/subTask/@operationType)[1] with "1001"')
				IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@clientId')) = 1
					SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@clientId)[1] with sql:variable("@restoreClientId")')
				IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@backupsetId')) = 1
					SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@backupsetId)[1] with sql:variable("@restoreBackupSetId")')
				IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@subclientId')) = 1
					SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@subclientId)[1] with sql:variable("@restoreSubclientId")')
				ELSE
					SET @xmlText.modify('insert (attribute subclientId {sql:variable("@restoreSubclientId")}) into (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")])[1]')
IF (@i_appType = 106)	--_CV_APPTYPE_VIRTUAL_SERVER)
				BEGIN
					IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@instanceId')) = 1
						SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@instanceId)[1] with sql:variable("@restoreInstanceId")')
					ELSE
						SET @xmlText.modify('insert (attribute instanceId {sql:variable("@restoreInstanceId")}) into (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")])[1]')
				END
				IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions/browseOption')) <> 1
					SET @xmlText.modify('insert <browseOption /> into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/restoreOptions)[1]')
				--APPTYPEID GETS HARDCODED TO 33.  READ APPTYPEID FROM DB AND UPDATE REQUEST
				IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@applicationId')) = 1
					SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@applicationId)[1] with sql:variable("@i_appType")')
				ELSE
					SET @xmlText.modify('insert (attribute applicationId {sql:variable("@i_appType")}) into (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")])[1]')
			END
		END
		IF @i_ComplianceId <> 0
		BEGIN
			UPDATE SchedAdminComplianceTask SET taskId = @o_TaskId WHERE id = @i_ComplianceId
		END
	END
	ELSE
	BEGIN
		--MR39053 - Add missing backupsetId for CommNet reports
		IF @i_backupSetId = 0
		BEGIN
			SET @i_backupSetId = (SELECT TOP 1 id FROM APP_BackupSetName WHERE id in
					(SELECT backupSet FROM APP_Application WHERE appTypeId=@i_appType AND clientId=@clientId) AND status&8=8)
			IF (@xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@backupsetId')) <> 1
				SET @xmlText.modify('insert (attribute backupsetId {sql:variable("@i_backupSetId")}) into (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")])[1]')
			ELSE
				SET @xmlText.modify('replace value of (/TMMsg_CreateTaskReq/taskInfo/associations[position() = sql:variable("@position")]/@backupsetId)[1] with sql:variable("@i_backupSetId")')
		END
		IF (@xmlText.exist('/DM2ContentIndexing_ComplianceDirector/@complianceId')) <> 1
			SET @xmlText.modify('insert (attribute complianceId {sql:variable("@i_ComplianceId")}) into (/DM2ContentIndexing_ComplianceDirector)[1]')
		ELSE
			SET @xmlText.modify('replace value of (/DM2ContentIndexing_ComplianceDirector/@complianceId)[1] with sql:variable("@i_ComplianceId")')
		IF (@xmlText.exist('/DM2ContentIndexing_ComplianceDirector/@searchId')) <> 1
			SET @xmlText.modify('insert (attribute searchId {sql:variable("@i_SearchId")}) into (/DM2ContentIndexing_ComplianceDirector)[1]')
		ELSE
			SET @xmlText.modify('replace value of (/DM2ContentIndexing_ComplianceDirector/@searchId)[1] with sql:variable("@i_SearchId")')
		SET @xmlText.modify('replace value of (/DM2ContentIndexing_ComplianceDirector/options/@searchId)[1] with sql:variable("@i_SearchId")')
		SET @xmlText.modify('replace value of (/DM2ContentIndexing_ComplianceDirector/options/@complianceId)[1] with sql:variable("@i_ComplianceId")')
		--SAVE THE COMPLETE MESSAGE, WILL ONLY BE ACCESSED BY JAVA GUI
		INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
SELECT @i_complianceId, 0, @xmlText, 0
	END
EXIT_PROC:
	IF (@i_startJob = 1 AND @o_ErrorCode = 0)
		SELECT @xmlText
	ELSE
		SELECT @i_ComplianceId '@complianceId', @i_SearchId '@searchId', @o_JobId '@jobId', @o_TaskId '@taskId',
			@o_ErrorCode '@errorCode', @o_ErrorString '@errorString'
			FOR XML PATH('DM2ContentIndexing_ComplianceDirectorResp')
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'SchedCreateJobForComplinaceDirector')
	delete from GxQscripts where name = 'SchedCreateJobForComplinaceDirector'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedCreateJobForComplinaceDirector')
	delete from GXDBVersions where aliasname = 'SchedCreateJobForComplinaceDirector'
GO

insert into GXDBVersions values(2, 'SchedCreateJobForComplinaceDirector',  '00010060008000100000', 'SchedCreateJobForComplinaceDirector', '00010060008000100000')
GO

