

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedCreateEZBackupSchedules.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   7/31/2008
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedCreateEZBackupSchedules.sp,v $ $Id: SchedCreateEZBackupSchedules.sp,v 1.10.60.2 2018/03/22 03:08:09 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedCreateEZBackupSchedules <<<'

IF EXISTS (select * from sysobjects where name='SchedCreateEZBackupSchedules')
	drop procedure SchedCreateEZBackupSchedules
IF EXISTS (select * from GxQscripts where name='SchedCreateEZBackupSchedules')
	delete from GxQscripts where name = 'SchedCreateEZBackupSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedCreateEZBackupSchedules')
	delete from GXDBVersions where aliasname = 'SchedCreateEZBackupSchedules'
GO
print '... Creating Procedure: SchedCreateEZBackupSchedules'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedCreateEZBackupSchedules
  @i_iDAType INT,
  @i_ClientId INT,
  @i_name NVARCHAR(64),
  @i_description NVARCHAR(256)
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorString nvarchar(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN
BEGIN TRY
	DECLARE @PolicyId			INTEGER
	DECLARE @PolicyInstanceId	INTEGER
	DECLARE @ScheduleId			INTEGER
	DECLARE @TaskId				INTEGER
	DECLARE @NextEvent			VARCHAR(64)
	DECLARE @NextWeekDay		INTEGER
	DECLARE @NextDate			DATETIME
	DECLARE @startDate			INTEGER
	DECLARE @defBackupTask		INTEGER
	DECLARE @userId				INTEGER
	DECLARE @bPolicyExists		INTEGER
	DECLARE @subClientId		INTEGER
	DECLARE @instanceId			INTEGER
	DECLARE @backupSet			INTEGER
	DECLARE @bRolledBack		INTEGER
	DECLARE @SPName 			varchar(128)
	DECLARE @BinaryRevision 	varchar(20)
	DECLARE @SPNameToExecute	NVARCHAR(1024)
	DECLARE @ParamInput			VARCHAR(1024)
	DECLARE @t_BinaryResp		TABLE( errorCode INT, AliasName NVARCHAR(1024))
	DECLARE @myPolicy			TABLE (policyId INT)
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @userId = 1
	SET @PolicyId = 0
	SET @PolicyInstanceId = 0
	SET @bPolicyExists = 0
	SET @bRolledBack = 0
	SET @ParamInput = ''
	SET @BinaryRevision = '99999999999999999999'
	SET @defBackupTask = (SELECT id FROM SchedBackupTask WHERE flags = 9999)
	SET @startDate = dbo.getUnixTime(GetDate())
	SELECT @subClientId=id, @instanceId=instance, @backupSet=backupSet FROM APP_Application
	WHERE clientId=@i_ClientId AND appTypeId=@i_iDAType AND subclientStatus&8=8 AND backupSet IN (SELECT id FROM APP_BackupSetName WHERE status&8=8)
	--SEARCH FOR EXISTING MY SCHEDULE POLICY FOR CLIENT
	INSERT INTO @myPolicy
		SELECT CAST(attrVal AS INT) FROM APP_SubclientProp WHERE attrName = 'Associated My Schedule Policy' AND componentNameId IN (SELECT id FROM APP_Application WHERE clientId = @i_ClientId) AND modified = 0
	SET @PolicyId = (SELECT TOP 1 id FROM SchedTemplate WHERE flags&16=16 AND id IN (SELECT policyId FROM @myPolicy ))
	--SEARCH FOR EXISTING MY SCHEDULE FOR CLIENT AND IDA TO AVOID CREATING DUPLICATE SCHEDULES
	IF EXISTS (SELECT * FROM SchedBackupTask WHERE clientId = @i_ClientId AND appTypeId = @i_iDAType AND subClient = @subClientId AND instance = @instanceId AND backupSet = @backupSet
		AND id IN (SELECT TOP(1) taskId FROM Schedule WHERE taskType <> 8 AND schedTemplateInstanceId IN (SELECT id FROM SchedTemplateInstance WHERE SchedTemplateId = @PolicyId))
		) GOTO EXIT_PROC
	INSERT INTO @t_BinaryResp
	EXEC CV_GetSPToExecute @SPName = 'SchedCreateBackupOptions', @BinaryRevision = '99999999999999999999'
	SELECT TOP(1) @o_errorCode = errorCode, @SPNameToExecute = AliasName FROM @t_BinaryResp
	IF @o_errorCode <> 0 GOTO EXIT_PROC
	IF (@PolicyId = 0 OR @PolicyId IS null)
	BEGIN
		INSERT INTO SchedTemplate
		VALUES (20, 0, @i_name, @i_description, 10, 0)
		SET @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 GOTO EXIT_PROC
		SET @policyId = @@IDENTITY
		INSERT INTO APP_SubclientProp
		VALUES (@subClientId, 'Associated My Schedule Policy', 7, @policyId, dbo.getUnixTime(GetUTCDate()), 0, 0)
	END
	ELSE
	BEGIN
		SET @bPolicyExists = 1
	END
	IF (@bPolicyExists = 0)
	BEGIN
		-- CREATE SCHEDULE POLICY FOR - MON TO THUR 8:00 PM
		INSERT INTO schedTemplateinstance
		VALUES  (@policyId)
		SET @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 GOTO EXIT_PROC
		SET @policyInstanceId = @@IDENTITY
		SET @NextDate = getdate()
		SET @startDate = dbo.getUnixTime(GetUTCDate())
		IF (SELECT CONVERT(varchar, datepart(hh, @NextDate), 120)) >= 18  SET @NextDate = getdate()+1
			SET @NextWeekDay = CONVERT(int, datepart(weekday, @NextDate), 120)
		IF @NextWeekDay = 6
			SET @NextDate = @NextDate + 3
		ELSE IF @NextWeekDay = 7
			SET @NextDate = @NextDate + 2
		ELSE IF @NextWeekDay = 1
			SET @NextDate = @NextDate + 1
		SET @NextEvent = CONVERT(varchar(10), @NextDate, 120) + ' ' + '20:00:00.000'
		--CREATE SCHEDULE FOR POLICY
		INSERT INTO Schedule
		SELECT TOP(1) @defBackupTask, 8, 3, counter, errors, fireIfMissed, 1, inProcess, 1, 1, isSingleton, 1,
			30, monthDay, occurence, dayNumber, 72000, interval, -1, @startDate, 0, ds_flags, tz_offset, tz_name,
			'', @nextEvent, 0, lastEvent, lastAttempt, @policyInstanceId, endOfDay, 100, 100, calendarId
			FROM Schedule WHERE id in ( SELECT scheduleId FROM SchedBackupTask WHERE flags = 9999)
		SET @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 GOTO EXIT_PROC
		SET @ScheduleId = @@IDENTITY
		--INCREMENTAL BACKUP
		INSERT INTO SchedBackupTask
		VALUES (@ScheduleId, 0, @userId, 0, 0, 66050, 0, 0, 0, 0, 0, '', 2, 0, '')
		SET @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 GOTO EXIT_PROC
		SET @TaskId = @@IDENTITY
		UPDATE Schedule
		SET taskId = @TaskId
		WHERE id = @ScheduleId
		SET @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 GOTO EXIT_PROC
		SET @ParamInput = CAST(@TaskId AS VARCHAR(10)) + ',' + CAST(@i_iDAType AS VARCHAR(10))
		EXEC CV_ExecuteSP @SPNameToExecute, @ParamInput, @BinaryRevision
	END
	ELSE
	--USE EXISTING POLICY FOR - MON TO THUR 8:00 PM
	BEGIN
		SET @policyInstanceId = (SELECT schedTemplateInstanceId FROM Schedule WHERE taskType = 8 AND type = 3 AND mask=30 AND schedTemplateInstanceId IN (SELECT id FROM SchedTemplateInstance WHERE SchedTemplateId = @policyId))
	END
	--CREATE SCHEDULE FOR DEFAULT SUBCLIENT USING POLICY TEMPLATE
	INSERT INTO Schedule
	SELECT TOP(1) @defBackupTask, 1, type, 0, 0, fireIfMissed, 1, inProcess, 1, isReported, isSingleton, 1,
		mask, monthDay, occurence, dayNumber, atTime, interval, endValue, @startDate, 0, ds_flags, tz_offset, tz_name,
		'', nextEvent, dbo.getDateTime(0), dbo.getDateTime(0), dbo.getDateTime(0), schedTemplateInstanceId, endOfDay, skipOccurence, skipDayNumber, calendarId
		FROM Schedule WHERE taskType = 8 AND schedTemplateInstanceId = @policyInstanceId
	SET @o_errorCode = @@ERROR
	IF @o_errorCode <> 0 GOTO EXIT_PROC
	SET @ScheduleId = @@IDENTITY
	--INCREMENTAL BACKUP
	INSERT INTO SchedBackupTask
	VALUES (@ScheduleId, @i_ClientId, @userId, 0, 0, 6362626, @i_ClientId, @i_iDAType, @instanceId, @backupSet, @subClientId, '', 2, 0, '')
	SET @o_errorCode = @@ERROR
	IF @o_errorCode <> 0 GOTO EXIT_PROC
	SET @TaskId = @@IDENTITY
	UPDATE Schedule
	SET taskId = @TaskId
	WHERE id = @ScheduleId
	SET @o_errorCode = @@ERROR
	IF @o_errorCode <> 0 GOTO EXIT_PROC
	SET @ParamInput = CAST(@TaskId AS VARCHAR(10)) + ',' + CAST(@i_iDAType AS VARCHAR(10))
	EXEC CV_ExecuteSP @SPNameToExecute, @ParamInput, @BinaryRevision
	INSERT INTO SchedBackupTaskOptions VALUES (@TaskId, 'Incremental Level' , '1')
	INSERT INTO SchedBackupTaskOptions VALUES (@TaskId, 'Cumulative' , '0')
	IF (@bPolicyExists = 0)
	BEGIN
		-- CREATE SCHEDULE POLICY FOR - FRIDAY 8:00 PM
		INSERT INTO schedTemplateinstance
		VALUES  (@policyId)
		SET @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 GOTO EXIT_PROC
		SET @policyInstanceId = @@IDENTITY
		SET @NextDate = getdate()
		SET @startDate = dbo.getUnixTime(GetUTCDate())
		IF (SELECT CONVERT(varchar, datepart(hh, @NextDate), 120)) >= 18  SET @NextDate = getdate()+1
			SET @NextWeekDay = CONVERT(int, datepart(weekday, @NextDate), 120)
		IF @NextWeekDay = 1
			SET @NextDate = @NextDate + 5
		ELSE IF @NextWeekDay = 2
			SET @NextDate = @NextDate + 4
		ELSE IF @NextWeekDay = 3
			SET @NextDate = @NextDate + 3
		ELSE IF @NextWeekDay = 4
			SET @NextDate = @NextDate + 2
		ELSE IF @NextWeekDay = 5
			SET @NextDate = @NextDate + 1
		ELSE IF @NextWeekDay = 7
			SET @NextDate = @NextDate + 6
		SET @NextEvent = CONVERT(varchar(10), @NextDate, 120) + ' ' + '20:00:00.000'
		--CREATE SCHEDULE FOR POLICY
		INSERT INTO Schedule
		SELECT TOP(1) @defBackupTask, 8, 3, counter, errors, fireIfMissed, 1, inProcess, 1, 1, isSingleton, 1,
			32, monthDay, occurence, dayNumber, 72000, interval, -1, @startDate, 0, ds_flags, tz_offset, tz_name,
			'', @nextEvent, 0, lastEvent, lastAttempt, @policyInstanceId, endOfDay, 100, 100, calendarId
			FROM Schedule WHERE id in ( SELECT scheduleId FROM SchedBackupTask WHERE flags = 9999)
		SET @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 GOTO EXIT_PROC
		SET @ScheduleId = @@IDENTITY
		--FULL BACKUP
		INSERT INTO SchedBackupTask
		VALUES (@ScheduleId, 0, @userId, 0, 0, 65537, 0, 0, 0, 0, 0, '', 2, 0, '')
		SET @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 GOTO EXIT_PROC
		SET @TaskId = @@IDENTITY
		UPDATE Schedule
		SET taskId = @TaskId
		WHERE id = @ScheduleId
		SET @o_errorCode = @@ERROR
		IF @o_errorCode <> 0 GOTO EXIT_PROC
		SET @ParamInput = CAST(@TaskId AS VARCHAR(10)) + ',' + CAST(@i_iDAType AS VARCHAR(10))
		EXEC CV_ExecuteSP @SPNameToExecute, @ParamInput, @BinaryRevision
	END
	ELSE
		--USE EXISTING POLICY FOR - FRIDAY 8:00 PM
	BEGIN
		SET @policyInstanceId = (SELECT schedTemplateInstanceId FROM Schedule WHERE taskType = 8 AND type = 3 AND mask=32 AND schedTemplateInstanceId IN (SELECT id FROM SchedTemplateInstance WHERE SchedTemplateId = @policyId))
	END
	--CREATE SCHEDULE FOR DEFAULT SUBCLIENT USING POLICY TEMPLATE
	INSERT INTO Schedule
	SELECT TOP(1) @defBackupTask, 1, type, 0, 0, fireIfMissed, 1, inProcess, 1, isReported, isSingleton, 1,
		mask, monthDay, occurence, dayNumber, atTime, interval, endValue, @startDate, 0, ds_flags, tz_offset, tz_name,
		'', nextEvent, dbo.getDateTime(0), dbo.getDateTime(0), dbo.getDateTime(0), schedTemplateInstanceId, endOfDay, skipOccurence, skipDayNumber, calendarId
		FROM Schedule WHERE taskType = 8 AND schedTemplateInstanceId = @policyInstanceId
	SET @o_errorCode = @@ERROR
	IF @o_errorCode <> 0 GOTO EXIT_PROC
	SET @ScheduleId = @@IDENTITY
	--INCREMENTAL BACKUP
	INSERT INTO SchedBackupTask
	VALUES (@ScheduleId, @i_ClientId, @userId, 0, 0, 6362113, @i_ClientId, @i_iDAType, @instanceId, @backupSet, @subClientId, '', 2, 0, '')
	SET @o_errorCode = @@ERROR
	IF @o_errorCode <> 0 GOTO EXIT_PROC
	SET @TaskId = @@IDENTITY
	UPDATE Schedule
	SET taskId = @TaskId
	WHERE id = @ScheduleId
	SET @o_errorCode = @@ERROR
	IF @o_errorCode <> 0 GOTO EXIT_PROC
	SET @ParamInput = CAST(@TaskId AS VARCHAR(10)) + ',' + CAST(@i_iDAType AS VARCHAR(10))
	EXEC CV_ExecuteSP @SPNameToExecute, @ParamInput, @BinaryRevision
	INSERT INTO SchedBackupTaskOptions VALUES (@TaskId, 'Incremental Level' , '1')
	INSERT INTO SchedBackupTaskOptions VALUES (@TaskId, 'Cumulative' , '0')
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
END CATCH;
EXIT_PROC:
	SELECT @o_errorCode, @o_errorString
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'SchedCreateEZBackupSchedules')
	delete from GxQscripts where name = 'SchedCreateEZBackupSchedules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedCreateEZBackupSchedules')
	delete from GXDBVersions where aliasname = 'SchedCreateEZBackupSchedules'
GO

insert into GXDBVersions values(2, 'SchedCreateEZBackupSchedules',  '00010010006000020000', 'SchedCreateEZBackupSchedules', '00010010006000020000')
GO

