

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedComplianceDirector.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedComplianceDirector.sp,v $ $Id: SchedComplianceDirector.sp,v 1.29.60.2 2018/03/22 03:19:06 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  SchedComplianceDirector
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedComplianceDirector <<<'

IF EXISTS (select * from sysobjects where name='SchedComplianceDirector')
	drop procedure SchedComplianceDirector
IF EXISTS (select * from GxQscripts where name='SchedComplianceDirector')
	delete from GxQscripts where name = 'SchedComplianceDirector'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedComplianceDirector')
	delete from GXDBVersions where aliasname = 'SchedComplianceDirector'
GO
print '... Creating Procedure: SchedComplianceDirector'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedComplianceDirector
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT,
  @i_localeId integer,
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN
	DECLARE @xmlOptions			XML
	DECLARE @i_operation		INT
	DECLARE @i_complianceId		INT
	DECLARE @errorCode			INT
	DECLARE @createTime			INT
	DECLARE @modifiedTime		INT
	DECLARE @errorString		NVARCHAR(1024)
	DECLARE @t_OptionResp		TABLE( complianceId INT, searchId INT, errorCode INT, errorString NVARCHAR(1024))
	DECLARE @t_DirectorOption	TABLE( complianceId INT, compliancePolicyName nvarchar(1024), descript nvarchar(1024),
					userId nvarchar(1024), complianceSteps XML, cloudId INT, stagingClientId INT, stagingPath nvarchar(1024),
					dataArchivedAfterTime INT, numberOfDays INT, refTime INT, updateDM2DB INT, reviewSetOption INT, directorOptions XML)
	DECLARE @userGUID			NVARCHAR(255)
	DECLARE @i_UserName			NVARCHAR(255)
	DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_groupList		NVARCHAR(MAX)
	DECLARE @i_PolicyName		NVARCHAR(1024)
	DECLARE @opId				INT
	DECLARE @paramMsgId			INT
	DECLARE @opEvMsgId			INT
	DECLARE @dataIsEvent		INT
	DECLARE @opMsgId			INT
	DECLARE @oldCompPolicyName		NVARCHAR(1024)
	DECLARE @entityType INT = 9507
	DECLARE @cdId		INT
	DECLARE @t_userCaps 		TABLE (caps bigint)
	DECLARE @userCaps 			bigint = 0
BEGIN TRY
	SET @errorCode = 0
	SET @modifiedTime = 0
	SET @errorString = ''
	SET @createTime = dbo.getunixtime(GETUTCDATE())
	SET @dataIsEvent = 0
	--USE ADMIN AS DEFAULT ID
	IF @i_userId IS null OR @i_userId = 0
		SET @i_userId = (SELECT TOP(1) id FROM UMUSERS WHERE id > 0 ORDER BY id)
	--GET USER NAME FOR INPUT FROM JAVA GUI
	SET @i_UserName = (SELECT login FROM UMUsers WHERE id = @i_userId)
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_ComplianceDirectorReq') R ( ref ) ), @i_UserName)
	SET @i_operation = ISNULL(( SELECT ref.value('@operation', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_ComplianceDirectorReq') R(ref)), 0)
	SET @i_complianceId = ISNULL(( SELECT ref.value('@complianceId', 'INT')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_ComplianceDirectorReq/director') R(ref)), 0)
	SET @i_PolicyName = ISNULL(( SELECT ref.value('@compliancePolicyName', 'nvarchar(1024)')
						FROM @i_xmlText.nodes('DM2ContentIndexing_ComplianceDirectorReq/director') R ( ref ) ), @i_UserName)
	SET  @cdId = ISNULL((SELECT id FROM SchedAdminComplianceXMLOptions WHERE complianceId = @i_complianceId), 0)
	--GET USER RIGHTS
	IF ( @i_operation = 1 ) -- add
	BEGIN
		INSERT INTO @t_userCaps
		EXECUTE GetUserCapabilities @i_userId
		SET @userCaps = ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
IF ((@userCaps & CONVERT(bigint, (POWER(2.0, 25-1))) = 0))
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'User does not have Compliance Search capabilities.'
			SET @i_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorString'
			FOR XML PATH('CVGui_GenericResp'))
			GOTO EXIT_PROC
		END
	END
	ELSE IF ( @i_operation = 2 ) -- delete
	BEGIN
		DECLARE @o_canDeleteEntityType  INT = 0
		EXEC sec_canDeleteDM2EntityType
			@i_commcellId = null,
			@i_userId = @i_userId,
			@i_entityType = @entityType,
			@i_entityId = @cdId,
			@o_canDeleteEntityType = @o_canDeleteEntityType OUTPUT
		IF ( @o_canDeleteEntityType <> 1 )
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'User does not have Delete rights for Compliance Directory Policy'
			SET @i_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorString'
			FOR XML PATH('CVGui_GenericResp'))
			GOTO EXIT_PROC
		END
	END
	ELSE IF ( @i_operation = 3 ) -- modify
	BEGIN
		DECLARE	@o_canEditEntityType int = 0
		EXEC sec_canEditDM2EntityType
			@i_commcellId = null,
			@i_userId = @i_userId,
			@i_entityType = @entityType,
			@i_entityId = @cdId,
			@o_canEditEntityType = @o_canEditEntityType OUTPUT
		IF ( @o_canEditEntityType <> 1 )
		BEGIN
			SET @errorCode = -1
			SET @errorString = 'User does not have Edit rights for Compliance Directory Policy'
			SET @i_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorString'
			FOR XML PATH('CVGui_GenericResp'))
			GOTO EXIT_PROC
		END
	END
	INSERT INTO @t_DirectorOption
	SELECT ref.value('@complianceId', 'INT'), ref.value('@compliancePolicyName', 'nvarchar(1024)'), ref.value('@description', 'nvarchar(1024)'),
		ref.value('@userId', 'nvarchar(255)'), ref.query('complianceSteps'), ref.value('@cloudId', 'INT'), ref.value('@stagingClientId', 'INT'),
		ref.value('@stagingPath', 'nvarchar(1024)'), ref.value('@dataArchivedAfterTime', 'INT'), ref.value('@numberOfDays', 'INT'), ref.value('@refTime', 'INT'),
		ref.value('@updateDM2DB', 'INT'), ref.value('@reviewSetOption', 'INT'), ref.query('directorOptions')
		FROM  @i_xmlText.nodes ('/DM2ContentIndexing_ComplianceDirectorReq/director') R(ref)
	SET @userGUID = (SELECT userGuid FROM UMUsers WHERE id = @i_userId)
	IF (@i_operation > 0)
	BEGIN
	--WHEN MODIFYING, DELETE OLD OPTIONS AND ADD NEW OPTIONS
		--DELETE OPERATION
		IF (@i_operation = 2 OR @i_operation = 3)
		BEGIN
			IF (@i_complianceId > 0)
			BEGIN
				--SAVE ORIGINAL CREATED TIME
				SET @modifiedTime = @createTime
				SET @createTime = (SELECT created FROM SchedAdminComplianceXMLOptions WHERE complianceId = @i_complianceId)
				SELECT @oldCompPolicyName = policyName
				FROM SchedAdminComplianceXMLOptions WHERE complianceId = @i_complianceId
				--DELETE COMPLETE XML OPTIONS
				DELETE FROM SchedAdminComplianceXMLOptions WHERE complianceId = @i_complianceId
				DELETE FROM SchedAdminComplianceOptions WHERE complianceId = @i_complianceId
				SET @errorCode = @@error
				IF (@errorCode = 0)
				BEGIN
					IF (@i_operation = 2)
					BEGIN
						-- SET GUI AUDIT OPERATION
						SET @opMsgId = (217 | (CAST(POWER(2, 24) AS BIGINT) * 84))
						EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
						-- SET GUI AUDIT PARAMETER
						EXEC EvGuiAuditSetParamData @opId, @oldCompPolicyName, @dataIsEvent
						SET @paramMsgId = (509 | (CAST(POWER(2, 24) AS BIGINT) * 85))
						EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
					END
				END
			END
			ELSE
			BEGIN
				SET @errorCode = -2
				SET @errorString = 'Invalid compliance Id'
				SET @i_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorString'
					FOR XML PATH('CVGui_GenericResp'))
				GOTO EXIT_PROC
			END
			--ADD COMPLIANCE ID WHEN UPDATING
			SET @xmlOptions = (SELECT @i_complianceId '@complianceId',
				(SELECT ref.query('*')FROM  @i_xmlText.nodes ('DM2ContentIndexing_ComplianceDirectorReq/director/options') R(ref))
				FOR XML PATH('DM2ContentIndexing_ComplianceOptions'))
		END
		ELSE
		BEGIN
			--INSERT OPTIONS
			SET @xmlOptions = ( SELECT ref.query('*') FROM  @i_xmlText.nodes ('DM2ContentIndexing_ComplianceDirectorReq/director/options') R(ref)
					FOR XML PATH(''), ROOT('DM2ContentIndexing_ComplianceOptions'))
		END
		--ADD OPERATION
		IF (@i_operation = 1 OR @i_operation = 3)
		BEGIN
			--CHECK FOR POLICY NAME ALREADY EXISTING
			IF EXISTS(SELECT * FROM SchedAdminComplianceXMLOptions WHERE policyName = @i_PolicyName AND status <> 1)
			BEGIN
				SET @errorCode = -3
				SET @errorString = 'Compliance policy already exists'
				SET @i_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorString'
					FOR XML PATH('CVGui_GenericResp'))
				GOTO EXIT_PROC
			END
			--INSERT INTO @t_OptionResp
			EXECUTE SchedInsertComplianceJobOptions @i_userId, @xmlOptions OUTPUT
			INSERT INTO @t_OptionResp
			SELECT ref.value('@complianceId', 'INT'), ref.value('@searchId', 'INT'), ref.value('@errorCode', 'INT'),
			ref.value('@errorString', 'NVARCHAR(1024)')
			FROM @xmlOptions.nodes('DM2ContentIndexing_ComplianceOptionsResp') R ( ref )
			SET @i_complianceId = (SELECT TOP(1) complianceId FROM @t_OptionResp)
			IF (@i_complianceId <> 0)
			BEGIN
				DECLARE @xmlSteps		XML
				DECLARE @directorOpt	XML
				--INSERT OPTIONS
				SET @xmlOptions = (SELECT ref.query('*') FROM  @i_xmlText.nodes ('DM2ContentIndexing_ComplianceDirectorReq') R(ref))
				--INSERT INTO SchedAdminComplianceXMLOptions (complianceId, xmlValue, status)
				--		VALUES (@i_complianceId, @xmlOptions, 0)
				INSERT INTO SchedAdminComplianceXMLOptions (complianceId, xmlValue, status, policyName, created, modified, ownerUserId)
						VALUES (@i_complianceId, @xmlOptions, 0, @i_PolicyName, @createTime, @modifiedTime, @i_userId)
				SET @userGUID = ISNULL((SELECT userId FROM @t_DirectorOption), @userGUID)
				SET @xmlSteps = (SELECT complianceSteps FROM @t_DirectorOption)
				SET @directorOpt = (SELECT directorOptions FROM @t_DirectorOption)
				--SET DIRECTOR OPTIONS
				SET @xmlOptions = (SELECT @i_complianceId '@complianceId', O.compliancePolicyName '@compliancePolicyName',
				O.descript '@description', @userGUID '@userId', O.cloudId '@cloudId', O.stagingClientId '@stagingClientId',
				O.stagingPath '@stagingPath', O.dataArchivedAfterTime '@dataArchivedAfterTime', O.numberOfDays '@numberOfDays',
				O.refTime '@refTime', O.updateDM2DB '@updateDM2DB', O.reviewSetOption '@reviewSetOption', @xmlSteps, @directorOpt
				FROM @t_DirectorOption AS O
				FOR XML PATH('DM2ContentIndexing_ComplianceDirector'))
				--SAVE THE COMPLETE MESSAGE, WILL ONLY BE ACCESSED BY JAVA GUI
				INSERT INTO SchedAdminComplianceOptions (complianceId, dataType, xmlValue, status)
					SELECT @i_complianceId, 0, @xmlOptions, 0
				IF (@i_operation = 3)
				BEGIN
					-- SET GUI AUDIT OPERATION
					SET @opMsgId = (215 | (CAST(POWER(2, 24) AS BIGINT) * 84))
					EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
					-- SET GUI AUDIT PARAMETER
					EXEC EvGuiAuditSetParamData @opId, @oldCompPolicyName, @dataIsEvent
					SET @paramMsgId = (508 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
				END
				ELSE
				BEGIN
					-- SET GUI AUDIT OPERATION
					SET @opMsgId = (214 | (CAST(POWER(2, 24) AS BIGINT) * 84))
					EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
					-- SET GUI AUDIT PARAMETER
					EXEC EvGuiAuditSetParamData @opId, @i_PolicyName, @dataIsEvent
					SET @paramMsgId = (507 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
				END
			END
			SET @errorCode = (SELECT errorCode FROM @t_OptionResp)
			IF (@errorCode <> 0)
			BEGIN
				SET @errorString = (SELECT errorString FROM @t_OptionResp)
				SET @i_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorString'
					FOR XML PATH('CVGui_GenericResp'))
			END
			ELSE
				SET @i_xmlText = (SELECT TOP(1) complianceId '@complianceId', searchId '@searchId', errorCode '@errorCode', errorString '@errorString' FROM @t_OptionResp
					FOR XML PATH('DM2ContentIndexing_ComplianceDirectorResp'))
		END
	END
	ELSE
	BEGIN
		SET @errorCode = -5
		SET @errorString = 'Invalid operation type'
		SET @i_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorString'
			FOR XML PATH('CVGui_GenericResp'))
	END
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
	SET @i_xmlText = (SELECT @errorCode '@errorCode', @errorString '@errorString'
		FOR XML PATH('CVGui_GenericResp'))
END CATCH;
EXIT_PROC:
	IF @errorCode <> 0
	BEGIN
		SELECT	1					as TAG,
			0					as Parent,
			@errorCode				as [CVGui_GenericResp!1!errorCode],
			@errorString			as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
	END
	ELSE
	BEGIN
		SELECT @i_xmlText
	END
END
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SchedComplianceDirector')
	delete from GxQscripts where name = 'SchedComplianceDirector'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedComplianceDirector')
	delete from GXDBVersions where aliasname = 'SchedComplianceDirector'
GO

insert into GXDBVersions values(2, 'SchedComplianceDirector',  '00010029006000020000', 'SchedComplianceDirector', '00010029006000020000')
GO

