

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedCheckSearchRights.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedCheckSearchRights.sp,v $ $Id: SchedCheckSearchRights.sp,v 1.5.294.2 2018/03/20 00:35:46 jiechen Exp $";
--
--  +========================================================================+
--  |      Procedure:  SchedCheckSearchRights()
--  |
--  | Description:  Check the user rights for schedule policy
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Anand Vibhor     Initial Edit
--  +========================================================================+
-- Cursor Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedCheckSearchRights <<<'

IF EXISTS (select * from sysobjects where name='SchedCheckSearchRights')
	drop procedure SchedCheckSearchRights
IF EXISTS (select * from GxQscripts where name='SchedCheckSearchRights')
	delete from GxQscripts where name = 'SchedCheckSearchRights'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedCheckSearchRights')
	delete from GXDBVersions where aliasname = 'SchedCheckSearchRights'
GO
print '... Creating Procedure: SchedCheckSearchRights'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedCheckSearchRights
-- Cursor Input
  @userId integer,
  @taskId integer,
  @i_clientId integer,
  @i_appTypeId integer,
  @i_instanceId integer,
  @i_backupsetId integer,
  @i_subclientId integer
AS
  DECLARE @retVal integer
SET NOCOUNT ON
DECLARE @instanceId INT
DECLARE @backupsetId INT
DECLARE @rightCounts INT
DECLARE @totalCounts INT
SET @instanceId = 0
SET @backupsetId = 0
SET @rightCounts = 0
SET @totalCounts = 0
DECLARE @xmlText XML
SET @retVal = 0
IF OBJECT_ID('tempdb.dbo.#entitiesWithSearchSchedCapability') IS NOT null
    DROP TABLE #entitiesWithSearchSchedCapability
IF OBJECT_ID('tempdb.dbo.#tempAppList') IS NOT null
    DROP TABLE #tempAppList
IF OBJECT_ID('tempdb.dbo.#Searchentities') IS NOT null
    DROP TABLE #Searchentities
create table  #entitiesWithSearchSchedCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
CREATE TABLE #Searchentities
    (
      entityType INT NOT null,
      entityId INT NOT null
    )
--GET THE SECURITY RIGHTS FOR USER IN TEMP TABLE
EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithSearchSchedCapability'
--GET THE XML FOR RESTORE TASK
SET @xmlText = ( SELECT [criteriaXML] FROM [SchedSearchRestoreXML] WHERE restoreTaskId = @taskId )
--GET CLIENT GROUP
INSERT  INTO #Searchentities ( entityType, entityId )
        SELECT  1, ref.value('@val', 'int')
        FROM    @xmlText . nodes('DM2ContentIndexing_SearchAndRetrieve/searchRequest/cFieldsAllUsers/clientGroup') R ( ref )
--GET CLIENT
INSERT  INTO #Searchentities ( entityType, entityId )
        SELECT  2, ref.value('@val', 'int')
        FROM    @xmlText . nodes('DM2ContentIndexing_SearchAndRetrieve/searchRequest/cFieldsAllUsers/client') R ( ref )
--GET INSTANCE
SET @instanceId = ISNULL(( SELECT   ref.value('@val', 'int')
                           FROM     @xmlText . nodes('DM2ContentIndexing_SearchAndRetrieve/searchRequest/cFieldsAllUsers/instanceId') R ( ref ) ),
                         0)
--GET BACKUPSET
SET @backupsetId = ISNULL(( SELECT  ref.value('@val', 'int')
                            FROM    @xmlText . nodes('DM2ContentIndexing_SearchAndRetrieve/searchRequest/cFieldsAllUsers/backupsetId') R ( ref ) ),
                          0)
--GET THE LIST OF APPLICATION OF SELECTED ENTITY FOR SEARCH
SELECT  A.clientId, A.appTypeId, A.instance, A.backupset, A.id
INTO    #tempAppList
FROM    APP_application A
WHERE   ( A.clientId IN ( SELECT    entityid
                          FROM      #Searchentities
                          WHERE     entitytype = 2 ) OR
          NOT EXISTS ( SELECT   *
                       FROM     #Searchentities
                       WHERE    entitytype = 2 )
        ) AND
        ( A.apptypeId IN ( SELECT   entityid
                           FROM     #Searchentities
                           WHERE    entitytype = 3 ) OR
          NOT EXISTS ( SELECT   *
                       FROM     #Searchentities
                       WHERE    entitytype = 3 )
        ) AND
        @instanceId IN ( 0, A.instance ) AND
        @backupsetId IN ( 0, A.backupset )
SET @totalCounts = ( SELECT COUNT (*) FROM #tempAppList )
--GET USER RIGHTS ON SELECTED ENTITIES
SET @rightCounts = ( SELECT COUNT(DISTINCT id)
                     FROM   #tempAppList TEMP INNER JOIN    #entitiesWithSearchSchedCapability sec ON ( ( ( ( ( capabilities & 524288 ) <> 0 ) OR
                                                                            ( ( capabilities & 2097152 ) <> 0 )
                                                                          ) AND
                                                                          ( ( capabilities & 4 ) <> 0 )
                                                                        ) AND
                                                                        ( ( TEMP.clientId = sec.clientId OR
                                                                            TEMP.clientId = 0 OR
                                                                            sec.clientId = 0
                                                                          ) AND
                                                                          ( TEMP.appTypeId = sec.appTypeId OR
                                                                            TEMP.appTypeId = 0 OR
                                                                            sec.appTypeId = 0
                                                                          ) AND
                                                                          ( TEMP.instance = sec.instanceId OR
                                                                            TEMP.instance = 0 OR
                                                                            sec.instanceId = 0
                                                                          ) AND
                                                                          ( TEMP.backupSet = sec.backupSetId OR
                                                                            TEMP.backupSet = 0 OR
                                                                            sec.backupSetId = 0
                                                                          ) AND
                                                                          ( TEMP.Id = sec.subClientId OR
                                                                            TEMP.Id = 0 OR
                                                                            sec.subClientId = 0
                                                                          )
                                                                        )
                                                                      ) )
--EXIT IF THERE IS NO OR PARTIAL RIGHTS
IF ( @rightCounts = @totalCounts )
 SET  @retVal = 1
ELSE
BEGIN
 SET  @retVal = 0
 RETURN
END
--FILTER IT BASED ON REQUEST LEVEL FROM GUI
SET @totalCounts = (SELECT COUNT(*) FROM    #tempAppList
WHERE  	((clientid   = @i_clientId   OR  @i_clientId = 0   )
		 AND  (appTypeId   = @i_appTypeId   OR  @i_appTypeId = 0   )
         AND  (instance    = @i_instanceId  OR  @i_instanceId  = 0 )
         AND  (backupSet   = @i_backupsetId OR @i_backupsetId = 0   )
         AND  (id   = @i_subclientid OR  @i_subclientid = 0  )
))
IF ( @totalCounts > 0)
 SET  @retVal = 1
ELSE
 SET  @retVal = 0
SELECT @retval
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'SchedCheckSearchRights')
	delete from GxQscripts where name = 'SchedCheckSearchRights'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedCheckSearchRights')
	delete from GXDBVersions where aliasname = 'SchedCheckSearchRights'
GO

insert into GXDBVersions values(2, 'SchedCheckSearchRights',  '00010005029400020000', 'SchedCheckSearchRights', '00010005029400020000')
GO

