

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SchedCheckRestoreRights.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SchedCheckRestoreRights.sp,v $ $Id: SchedCheckRestoreRights.sp,v 1.9.208.2 2018/03/20 00:40:06 jiechen Exp $";
--
--  +========================================================================+
--  |      Procedure:  SchedCheckRestoreRights()
--  |
--  | Description:  Check the user rights for schedule policy
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Anand Vibhor     Initial Edit
--  +========================================================================+
-- Cursor Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SchedCheckRestoreRights <<<'

IF EXISTS (select * from sysobjects where name='SchedCheckRestoreRights')
	drop procedure SchedCheckRestoreRights
IF EXISTS (select * from GxQscripts where name='SchedCheckRestoreRights')
	delete from GxQscripts where name = 'SchedCheckRestoreRights'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedCheckRestoreRights')
	delete from GXDBVersions where aliasname = 'SchedCheckRestoreRights'
GO
print '... Creating Procedure: SchedCheckRestoreRights'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SchedCheckRestoreRights
-- Cursor Input
  @taskId integer,
  @i_jobId integer
AS
  DECLARE @retVal integer
SET NOCOUNT ON
DECLARE @rightCounts INT
DECLARE @totalCounts INT
DECLARE @destClientId INT
DECLARE @capabilityReqd INT
DECLARE @userId INT
SET @rightCounts = 0
SET @totalCounts = 0
SET @destClientId = 0
SET @retVal = 0
IF OBJECT_ID('tempdb.dbo.#entitiesWithRestoreCapability') IS NOT null
    DROP TABLE #entitiesWithRestoreCapability
IF OBJECT_ID('tempdb.dbo.#tempAppList') IS NOT null
    DROP TABLE #tempAppList
create table  #entitiesWithRestoreCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
--GET THE DESTINATION CLIENTID
SET @destClientId = (SELECT [destClientId]  FROM [SchedRestoreTask] WHERE id = @taskId)
SET @userId = (SELECT [userId]  FROM [SchedRestoreTask] WHERE id = @taskId)
--GET THE SECURITY RIGHTS FOR USER IN TEMP TABLE
EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithRestoreCapability'
IF @i_jobId = 0
	SET @i_jobId = (select jobid from jmjobtasklink where rsttaskid=@taskId)
--GET THE LIST OF APPLICATION OF SELECTED ENTITY FOR RESTORE IN TEMP TABLE
SELECT  A.clientId, A.appTypeId, A.instance, A.backupset, A.id
INTO    #tempAppList
FROM    APP_application A
WHERE   A.ID IN (
SELECT appId FROM [SchedRestoreSearchFiles] WHERE [searchId] = @i_jobId)
SET @totalCounts = ( SELECT COUNT (*) FROM #tempAppList )
--IF ALL THE RESULTS ARE FROM SAME CLIENT WE WILL CHECK IN PLACE RESTORE CAPABILITY
IF EXISTS (SELECT clientId FROM #tempAppList WHERE clientId <> @destClientId)
	SET @capabilityReqd = 2097152
ELSE
	SET @capabilityReqd = 524288
--GET USER RIGHTS ON SELECTED ENTITIES
SET @rightCounts = ( SELECT COUNT(DISTINCT id)
                     FROM   #tempAppList TEMP INNER JOIN    #entitiesWithRestoreCapability sec ON ( (
                                                                            ( ( capabilities & @capabilityReqd ) <> 0 )
                                                                        ) AND
                                                                        ( ( TEMP.clientId = sec.clientId OR
                                                                            TEMP.clientId = 0 OR
                                                                            sec.clientId = 0
                                                                          ) AND
                                                                          ( TEMP.appTypeId = sec.appTypeId OR
                                                                            TEMP.appTypeId = 0 OR
                                                                            sec.appTypeId = 0
                                                                          ) AND
                                                                          ( TEMP.instance = sec.instanceId OR
                                                                            TEMP.instance = 0 OR
                                                                            sec.instanceId = 0
                                                                          ) AND
                                                                          ( TEMP.backupSet = sec.backupSetId OR
                                                                            TEMP.backupSet = 0 OR
                                                                            sec.backupSetId = 0
                                                                          ) AND
                                                                          ( TEMP.Id = sec.subClientId OR
                                                                            TEMP.Id = 0 OR
                                                                            sec.subClientId = 0
                                                                          )
                                                                        )
                                                                      ) )
--EXIT IF THERE IS NO OR PARTIAL RIGHTS
IF ( @rightCounts = @totalCounts AND @totalCounts > 0)
 SET  @retVal = 1
ELSE
 SET  @retVal = 0
SET NOCOUNT OFF
SELECT @retVal
GO


IF EXISTS (select * from GxQscripts where name = 'SchedCheckRestoreRights')
	delete from GxQscripts where name = 'SchedCheckRestoreRights'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SchedCheckRestoreRights')
	delete from GXDBVersions where aliasname = 'SchedCheckRestoreRights'
GO

insert into GXDBVersions values(2, 'SchedCheckRestoreRights',  '00010009020800020000', 'SchedCheckRestoreRights', '00010009020800020000')
GO

