

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SRSetStorageReplicationEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SRSetStorageReplicationEntity.sp,v $ $Id: SRSetStorageReplicationEntity.sp,v 1.10.12.6 2018/03/27 08:46:39 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SRSetStorageReplicationEntity <<<'

IF EXISTS (select * from sysobjects where name='SRSetStorageReplicationEntity')
	drop procedure SRSetStorageReplicationEntity
IF EXISTS (select * from GxQscripts where name='SRSetStorageReplicationEntity')
	delete from GxQscripts where name = 'SRSetStorageReplicationEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SRSetStorageReplicationEntity')
	delete from GXDBVersions where aliasname = 'SRSetStorageReplicationEntity'
GO
print '... Creating Procedure: SRSetStorageReplicationEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SRSetStorageReplicationEntity
  @xmlTextInput XML,
  @o_xmlText XML	OUTPUT
AS
SET NOCOUNT ON
	DECLARE @i_srId							INT=0
	DECLARE @i_srOperation					INT=0
	DECLARE @errorCode						INT=0
	DECLARE @errorString					NVARCHAR(MAX)=N''
	DECLARE @i_srcFilerName					NVARCHAR(255)=N''
	DECLARE @i_destFilerName				NVARCHAR(255)=N''
	SET @i_srId = ISNULL(( SELECT ref.value('@srId', 'int')
								FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep') R ( ref ) ),
							0)
	SET @i_srcFilerName = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@filerName', 'nvarchar(255)'))
								FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep/srcFiler') R ( ref ) ),
							N'')
	SET @i_destFilerName = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@filerName', 'nvarchar(255)'))
								FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep/destFiler') R ( ref ) ),
							N'')
	SET @i_srOperation = ISNULL(( SELECT ref.value('@srOperation', 'int')
								FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq') R ( ref ) ),
							0)
	--Check for valid input parameters
	IF(@i_srOperation != 2)
	BEGIN
		DECLARE @i_createdBy					INT=0
		DECLARE @i_createdByGuid				NVARCHAR(255)=N''
		DECLARE @i_replicationName				NVARCHAR(255)=N''
		DECLARE @i_notifyEmailAddress			NVARCHAR(1024)=N''
		DECLARE @i_replicationScheduledAt		NVARCHAR(50)=N''
		DECLARE @i_srcFilerId					INT=0
		DECLARE @i_destFilerId					INT=0
		DECLARE @i_srcMediaAgentId				INT=0
		DECLARE @i_destMediaAgentId				INT=0
		DECLARE @i_srcMediaAgentName			NVARCHAR(255)=N''
		DECLARE @i_destMediaAgentName			NVARCHAR(255)=N''
		DECLARE @i_archGroupId					INT=0
		DECLARE @i_archGroupCopyId				INT=0
		DECLARE @i_chainedRepId					INT=0
		DECLARE @i_forkedRepId					INT=0
		DECLARE @i_description					NVARCHAR(1024)=N''
		DECLARE @i_forceSync					INT=0
		DECLARE @i_srcClientId                  INT=0
		DECLARE @i_destClientId                 INT=0
        SET @i_srcClientId = ISNULL(( SELECT ref.value('@clientId', 'int')
                                FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep/srcClient') R ( ref ) ),
                            0)
        SET @i_destClientId = ISNULL(( SELECT ref.value('@clientId', 'int')
                                FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep/destClient') R ( ref ) ),
                            0)
		SET @i_forceSync = ISNULL(( SELECT ref.value('@forceSync', 'int')
								FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep') R ( ref ) ),
							0)
		SET @i_createdByGuid = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@userGUID', 'nvarchar(255)'))
									FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep/createdBy') R ( ref ) ),
								0)
		SET @i_replicationName = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@replicationName', 'nvarchar(255)'))
									FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep') R ( ref ) ),
								N'')
		SET @i_notifyEmailAddress = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@notifyEmailAddress', 'nvarchar(1024)'))
									FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep') R ( ref ) ),
								N'')
		SET @i_replicationScheduledAt = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@replicationScheduledAt', 'nvarchar(50)'))
									FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep') R ( ref ) ),
								N'')
		SET @i_description = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@description', 'nvarchar(1024)'))
									FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep') R ( ref ) ),
								N'')
		SET @i_srcMediaAgentId = ISNULL(( SELECT ref.value('@mediaAgentId', 'int')
									FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep/srcMediaAgent') R ( ref ) ),
								0)
		SET @i_destMediaAgentId = ISNULL(( SELECT ref.value('@mediaAgentId', 'int')
									FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep/destMediaAgent') R ( ref ) ),
								0)
		SET @i_archGroupId = ISNULL(( SELECT ref.value('@storagePolicyId', 'int')
								FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep/storagePolicy') R ( ref ) ),
							0)
		SET @i_archGroupCopyId = ISNULL(( SELECT ref.value('@copyId', 'int')
								FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep/storagePolicyCopy') R ( ref ) ),
							0)
		SET @i_chainedRepId = ISNULL(( SELECT ref.value('@id', 'int')
								FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep/chainedRep') R ( ref ) ),
							0)
		SET @i_forkedRepId = ISNULL(( SELECT ref.value('@id', 'int')
								FROM @xmlTextInput.nodes('/App_SetStorageReplicationEntityReq/storageRep/forkedRep') R ( ref ) ),
							0)
		SET @i_srcMediaAgentName = (select name from APP_Client where id =@i_srcMediaAgentId)
		SET @i_destMediaAgentName = (select name from APP_Client where id =@i_destMediaAgentId)
		SET @i_createdBy = ISNULL((SELECT id FROM UMUsers WITH (NOLOCK) WHERE userGuid = @i_createdByGuid),0)
		IF (@i_createdBy = 0)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'CreatedBy with the userGuid ' + CONVERT (NVARCHAR,@i_createdByGuid) + ' does not exist'
			GOTO ERROR_EXIT
		END
		SET @i_srcFilerId = ISNULL((SELECT filerId FROM SRFiler WITH (NOLOCK) WHERE filerName = @i_srcFilerName),0)
		SET @i_destFilerId = ISNULL((SELECT filerId FROM SRFiler WITH (NOLOCK) WHERE filerName = @i_destFilerName),0)
		IF EXISTS (SELECT * FROM SRInfo SRI INNER JOIN SRProperties SRP WITH (NOLOCK) ON SRI.srId = SRP.srId WHERE SRI.srId = @i_srId and SRI.destFilerId != @i_destFilerId and SRP.sPropertyName = 'ChainedReplicationId' and ISNULL(SRP.sPropertyValue,'') != '')
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Destination filer ' + @i_destFilerName + ' is used for chaining.'
			GOTO ERROR_EXIT
		END
		IF EXISTS (SELECT * FROM SRInfo SRI INNER JOIN SRProperties SRP WITH (NOLOCK) ON SRI.srId = SRP.srId WHERE SRI.srId = @i_srId and SRI.srcFilerId != @i_srcFilerId and SRP.sPropertyName = 'ForkedReplicationId' and ISNULL(SRP.sPropertyValue,'') != '')
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Source filer ' + @i_srcFilerName + ' is used for forking.'
			GOTO ERROR_EXIT
		END
		IF EXISTS (SELECT * FROM SRInfo SRI INNER JOIN SRProperties SRP WITH (NOLOCK) ON SRI.srId = SRP.srId WHERE SRI.srId = @i_srId and SRI.destMediaAgentId != @i_destMediaAgentId and SRP.sPropertyName = 'ChainedReplicationId' and ISNULL(SRP.sPropertyValue,'') != '')
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Destination MediaAgent ' + @i_destMediaAgentName + ' is used for chaining.'
			GOTO ERROR_EXIT
		END
		IF EXISTS (SELECT * FROM SRInfo SRI INNER JOIN SRProperties SRP WITH (NOLOCK) ON SRI.srId = SRP.srId WHERE SRI.srId = @i_srId and SRI.srcMediaAgentId != @i_srcMediaAgentId and SRP.sPropertyName = 'ForkedReplicationId' and ISNULL(SRP.sPropertyValue,'') != '')
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Source MediaAgent ' + @i_srcMediaAgentName + ' is used for forking.'
			GOTO ERROR_EXIT
		END
		DECLARE @i_srcFilerAccount	NVARCHAR(255)=N''
		DECLARE @i_srcFilerPasswd	NVARCHAR(400)=N''
		SET @i_srcFilerAccount = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@userName', 'nvarchar(255)'))
								FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep/srcFiler/arrayCredentials') R ( ref ) ),
							N'')
		--SET @i_srcFilerPasswd = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@password', 'nvarchar(400)'))
		--						FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep/srcFiler/arrayCredentials') R ( ref ) ),
		--			N'')
		SET @i_srcFilerPasswd = ISNULL( ( SELECT (ref.value('@password', 'nvarchar(400)'))
								FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep/srcFiler/arrayCredentials') R ( ref ) ),
					N'')
		IF((CHARINDEX('|#', @i_srcFilerPasswd, 1)) >0 )
        BEGIN
            SET @i_srcFilerPasswd = (select dbo.DecodeInvalidXMLChar(@i_srcFilerPasswd))
            SET @i_srcFilerPasswd = SUBSTRING(@i_srcFilerPasswd, 2, LEN(@i_srcFilerPasswd))
            SET @i_srcFilerPasswd = dbo.base64decode(@i_srcFilerPasswd)
        END
		IF (@i_srcFilerId = 0 and LEN(@i_srcFilerName)>0)
		BEGIN
			INSERT SRFiler (filerName, filerAccount, filerPasswd)
			VALUES (@i_srcFilerName,@i_srcFilerAccount, @i_srcFilerPasswd)
			SET @errorCode = @@ERROR
			IF @errorCode <> 0
			BEGIN
				SET	@errorString = 'Failed to add source filer info.'
				GOTO ERROR_EXIT
			END
			SET @i_srcFilerId = ISNULL((SELECT filerId FROM SRFiler WITH (NOLOCK) WHERE filerName = @i_srcFilerName),0)
		END
		BEGIN
			IF LEN(@i_srcFilerPasswd)>0
			BEGIN
				UPDATE SRFiler
				SET filerAccount = @i_srcFilerAccount, filerPasswd = @i_srcFilerPasswd
				where filerName = @i_srcFilerName
			END
			ELSE
			BEGIN
				UPDATE SRFiler
				SET filerAccount = @i_srcFilerAccount
				where filerName = @i_srcFilerName
			END
		END
		IF (@i_srcFilerId = 0)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Source filer with the name ' + @i_srcFilerName + ' does not exist'
			GOTO ERROR_EXIT
		END
		DECLARE @i_destFilerAccount	NVARCHAR(255)=N''
		DECLARE @i_destFilerPasswd	NVARCHAR(400)=N''
		SET @i_destFilerAccount = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@userName', 'nvarchar(255)'))
									FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep/destFiler/arrayCredentials') R ( ref ) ),
								N'')
		--SET @i_destFilerPasswd = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@password', 'nvarchar(400)'))
		--							FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep/destFiler/arrayCredentials') R ( ref ) ),
		--						N'')
		SET @i_destFilerPasswd = ISNULL( ( SELECT (ref.value('@password', 'nvarchar(400)'))
								FROM @xmlTextInput.nodes('App_SetStorageReplicationEntityReq/storageRep/destFiler/arrayCredentials') R ( ref ) ),
					N'')
		IF((CHARINDEX('|#', @i_destFilerPasswd, 1)) >0 )
        BEGIN
            SET @i_destFilerPasswd = (select dbo.DecodeInvalidXMLChar(@i_destFilerPasswd))
            SET @i_destFilerPasswd = SUBSTRING(@i_destFilerPasswd, 2, LEN(@i_destFilerPasswd))
            SET @i_destFilerPasswd = dbo.base64decode(@i_destFilerPasswd)
        END
		SET @i_destFilerId = ISNULL((SELECT filerId FROM SRFiler WITH (NOLOCK) WHERE filerName = @i_destFilerName),0)
		IF (@i_destFilerId = 0 and LEN(@i_destFilerName)>0)
		BEGIN
			INSERT SRFiler (filerName, filerAccount, filerPasswd)
			VALUES (@i_destFilerName,@i_destFilerAccount, @i_destFilerPasswd)
			SET @errorCode = @@ERROR
			IF @errorCode <> 0
			BEGIN
				SET	@errorString = 'Failed to add destination filer info.'
				GOTO ERROR_EXIT
			END
			SET @i_destFilerId = ISNULL((SELECT filerId FROM SRFiler WITH (NOLOCK) WHERE filerName = @i_destFilerName),0)
		END
		ELSE
		BEGIN
			IF LEN(@i_destFilerPasswd)>0
			BEGIN
				UPDATE SRFiler
				SET filerAccount = @i_destFilerAccount, filerPasswd = @i_destFilerPasswd
				where filerName = @i_destFilerName
			END
			ELSE
			BEGIN
				UPDATE SRFiler
				SET filerAccount = @i_destFilerAccount
				where filerName = @i_destFilerName
			END
		END
		IF (@i_destFilerId = 0)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Destination filer with the name ' + @i_destFilerName + ' does not exist'
			GOTO ERROR_EXIT
		END
		IF NOT EXISTS (SELECT * FROM MMHost WITH (NOLOCK) WHERE ClientId = @i_srcMediaAgentId)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Source media agent with the id ' + CONVERT (NVARCHAR,@i_srcMediaAgentId) + ' does not exist'
			GOTO ERROR_EXIT
		END
		IF NOT EXISTS (SELECT * FROM MMHost WITH (NOLOCK) WHERE ClientId = @i_destMediaAgentId)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Destination media agent with the id ' + CONVERT (NVARCHAR,@i_destMediaAgentId) + ' does not exist'
			GOTO ERROR_EXIT
		END
		IF NOT EXISTS (SELECT * FROM archGroup WITH (NOLOCK) WHERE id = @i_archGroupId)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Storage Policy with the id ' + CONVERT (NVARCHAR,@i_archGroupId) + ' does not exist'
			GOTO ERROR_EXIT
		END
		IF NOT EXISTS (SELECT * FROM archGroupCopy WITH (NOLOCK) WHERE id = @i_archGroupCopyId)
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Storage Policy Copy with the id ' + CONVERT (NVARCHAR,@i_archGroupCopyId) + ' does not exist'
			GOTO ERROR_EXIT
		END
	END
	IF(@i_srOperation = 0)
	BEGIN
		--insert
		INSERT SRInfo (replicationName, srcFilerId, destFilerId, srcMediaAgentId, destMediaAgentId, createdBy, notifyEmailAddress, replicationScheduledAt, archGroupId, archGroupCopyId, createdTime, description, forceSync,srcClientId,destClientId)
		VALUES (@i_replicationName, @i_srcFilerId, @i_destFilerId, @i_srcMediaAgentId, @i_destMediaAgentId, @i_createdBy, @i_notifyEmailAddress, @i_replicationScheduledAt, @i_archGroupId, @i_archGroupCopyId, GETDATE(), @i_description,@i_forceSync,@i_srcClientId,@i_destClientId)
		SET @i_srId = @@IDENTITY
		IF(@i_chainedRepId >0)
		BEGIN
			INSERT SRProperties (srId, sPropertyName, sPropertyValue)
			VALUES (@i_chainedRepId, 'ChainedReplicationId', @i_srId)
		END
		IF(@i_forkedRepId >0)
		BEGIN
			INSERT SRProperties (srId, sPropertyName, sPropertyValue)
			VALUES (@i_forkedRepId, 'ForkedReplicationId', @i_srId)
		END
	END
	ELSE IF(@i_srOperation = 1)
	BEGIN
		-- update
		UPDATE SRInfo
		SET replicationName = @i_replicationName, archGroupCopyId = @i_archGroupCopyId,
			srcFilerId = @i_srcFilerId, destFilerId = @i_destFilerId,
			srcMediaAgentId = @i_srcMediaAgentId, destMediaAgentId = @i_destMediaAgentId,
			archGroupId = @i_archGroupId, createdBy = @i_createdBy,
			notifyEmailAddress = @i_notifyEmailAddress, replicationScheduledAt = @i_replicationScheduledAt,description = @i_description, forceSync=@i_forceSync,srcClientId = @i_srcClientId, destClientId = @i_destClientId
		WHERE srId = @i_srId
		delete FROM SRProperties WHERE sPropertyName IN ( 'ChainedReplicationId' , 'ForkedReplicationId') and sPropertyValue = @i_srId
		IF(@i_chainedRepId >0)
		BEGIN
			INSERT SRProperties (srId, sPropertyName, sPropertyValue)
			VALUES (@i_chainedRepId, 'ChainedReplicationId', @i_srId)
		END
		IF(@i_forkedRepId >0)
		BEGIN
			INSERT SRProperties (srId, sPropertyName, sPropertyValue)
			VALUES (@i_forkedRepId, 'ForkedReplicationId', @i_srId)
		END
	END
	ELSE IF(@i_srOperation = 2)
	BEGIN
		-- delete
		SELECT @i_srcFilerId=srcFilerId, @i_destFilerId=destFilerId FROM SRInfo WHERE srId = @i_srId
		IF EXISTS (SELECT * FROM SRInfo SRI INNER JOIN SRProperties SRP WITH (NOLOCK) ON SRI.srId = SRP.srId WHERE SRI.srId = @i_srId and SRP.sPropertyName = 'ChainedReplicationId' and ISNULL(SRP.sPropertyValue,'') != '')
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Destination filer ' + @i_destFilerName + ' is used for chaining.'
			GOTO ERROR_EXIT
		END
		IF EXISTS (SELECT * FROM SRInfo SRI INNER JOIN SRProperties SRP WITH (NOLOCK) ON SRI.srId = SRP.srId WHERE SRI.srId = @i_srId and SRP.sPropertyName = 'ForkedReplicationId' and ISNULL(SRP.sPropertyValue,'') != '')
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Source filer ' + @i_srcFilerName + ' is used for forking.'
			GOTO ERROR_EXIT
		END
		DELETE FROM SRProperties WHERE srId = @i_srId
		DELETE SRInfo WHERE srId = @i_srId
		-- delete srcFilerId if it is not referenced
		IF NOT EXISTS (SELECT * FROM SRInfo SRI INNER JOIN SRFiler SRF WITH (NOLOCK) ON SRI.destFilerId = SRF.filerId or SRI.srcFilerId = SRF.filerId WHERE SRF.filerId=@i_srcFilerId)
	    BEGIN
	    DELETE FROM SRFiler WHERE filerId in (@i_srcFilerId)
		END
		-- delete destFilerId if it is referenced
	    IF NOT EXISTS (SELECT * FROM SRInfo SRI INNER JOIN SRFiler SRF WITH (NOLOCK) ON SRI.destFilerId = SRF.filerId or SRI.srcFilerId = SRF.filerId WHERE SRF.filerId=@i_destFilerId)
	    BEGIN
	    DELETE FROM SRFiler WHERE filerId in (@i_destFilerId)
		END
		-- delete ChainedReplicationId
		DELETE FROM SRProperties WHERE sPropertyName = 'ChainedReplicationId' and sPropertyValue = @i_srId
		-- delete ForkedReplicationId
		DELETE FROM SRProperties WHERE sPropertyName = 'ForkedReplicationId' and sPropertyValue = @i_srId
	END
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET	@errorString = 'Failed to set SRInfo.'
		GOTO ERROR_EXIT
	END
	SET	@o_xmlText  =
		(	SELECT
				(   SELECT  @i_srId AS '@srId'
					FOR XML PATH('storageRep'),TYPE
				)
			FOR XML PATH ('App_SetStorageReplicationEntityResp'), TYPE
		)
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xmlText  =
		(	SELECT
				(   SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
					FOR XML PATH('error'),TYPE
				)
			FOR XML PATH ('App_SetStorageReplicationEntityResp'), TYPE
		)
END
GO


IF EXISTS (select * from GxQscripts where name = 'SRSetStorageReplicationEntity')
	delete from GxQscripts where name = 'SRSetStorageReplicationEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SRSetStorageReplicationEntity')
	delete from GXDBVersions where aliasname = 'SRSetStorageReplicationEntity'
GO

insert into GXDBVersions values(2, 'SRSetStorageReplicationEntity',  '00010010001200060000', 'SRSetStorageReplicationEntity', '00010010001200060000')
GO

