

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SRGetStorageReplicationEntityList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SRGetStorageReplicationEntityList.sp,v $ $Id: SRGetStorageReplicationEntityList.sp,v 1.8.12.4 2018/03/27 09:12:46 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SRGetStorageReplicationEntityList <<<'

IF EXISTS (select * from sysobjects where name='SRGetStorageReplicationEntityList')
	drop procedure SRGetStorageReplicationEntityList
IF EXISTS (select * from GxQscripts where name='SRGetStorageReplicationEntityList')
	delete from GxQscripts where name = 'SRGetStorageReplicationEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SRGetStorageReplicationEntityList')
	delete from GXDBVersions where aliasname = 'SRGetStorageReplicationEntityList'
GO
print '... Creating Procedure: SRGetStorageReplicationEntityList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SRGetStorageReplicationEntityList
  @xmlTextInput XML,
  @o_xmlText XML	OUTPUT
AS
	DECLARE @errorCode			INT=0
	DECLARE @errorString		NVARCHAR(MAX)=N''
	DECLARE @i_validateJob		INT=0
	DECLARE @i_srId				INT=0
	DECLARE @i_destFilerId		INT=0
	DECLARE @i_destFilerName	NVARCHAR(255)=N''
	DECLARE @i_srcFilerId		INT=0
	DECLARE @i_srcFilerName		NVARCHAR(255)=N''
	DECLARE @i_srcMediaAgentId	INT=0
	SET @i_validateJob = ISNULL(( SELECT ref.value('@validateJob', 'int')
							FROM @xmlTextInput.nodes('App_GetStorageReplicationEntityListReq') R ( ref ) ),
						0)
	if (@i_validateJob = 1)
	BEGIN
		SET @i_srId = ISNULL(( SELECT ref.value('@srId', 'int')
							FROM @xmlTextInput.nodes('App_GetStorageReplicationEntityListReq/storageRep') R ( ref ) ),
						0)
		SET @i_destFilerName = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@filerName', 'nvarchar(255)'))
									FROM @xmlTextInput.nodes('App_GetStorageReplicationEntityListReq/storageRep/destFiler') R ( ref ) ),
								N'')
		SET @i_destFilerId = ISNULL((SELECT filerId FROM SRFiler WITH (NOLOCK) WHERE filerName = @i_destFilerName),0)
		SET @i_srcFilerName = ISNULL( ( SELECT dbo.DecodeInvalidXMLChar(ref.value('@filerName', 'nvarchar(255)'))
								FROM @xmlTextInput.nodes('App_GetStorageReplicationEntityListReq/storageRep/srcFiler') R ( ref ) ),
							N'')
		SET @i_srcFilerId = ISNULL((SELECT filerId FROM SRFiler WITH (NOLOCK) WHERE filerName = @i_srcFilerName),0)
		SET @i_srcMediaAgentId = ISNULL(( SELECT ref.value('@mediaAgentId', 'int')
								FROM @xmlTextInput.nodes('/App_GetStorageReplicationEntityListReq/storageRep/srcMediaAgent') R ( ref ) ),
							0)
	END
	SET @o_xmlText  =
		(	SELECT
				(	SELECT
						SR.srId as '@srId', SR.replicationName as '@replicationName',
						SR.description as '@description',
						SR.replicationScheduledAt as '@replicationScheduledAt',
						SR.forceSync as '@forceSync',
						ISNULL(( SELECT top 1 taskId FROM TM_SubTask  where subTaskName = SR.replicationName order by subTaskId desc),0) as '@scheduledTaskId',
						( select MAX(wfJobId) from SRProperties where srId = SR.srId) as '@wfJobId',
						( select ISNULL(( select top 1 1 from SRProperties SRP WITH (NOLOCK) where SR.srId = SRP.srId and SRP.sPropertyName IN ('ChainedReplicationId', 'ForkedReplicationId')  and ISNULL(SRP.sPropertyValue,'') != ''),0)) as '@isParent',
						(	SELECT filer.filerName as  '@filerName'
							FROM SRFiler as filer
							WHERE filer.filerId = SR.srcFilerId
							FOR XML PATH('srcFiler'),TYPE
						),
						(
							SELECT filer.filerName as  '@filerName'
							FROM SRFiler filer
							WHERE filer.filerId = SR.destFilerId
							FOR XML PATH('destFiler'),TYPE
						),
						(
							SELECT AG.id as '@storagePolicyId', AG.name as '@storagePolicyName'
							FROM archGroup AG
							WHERE AG.id = SR.archGroupId
							FOR XML PATH('storagePolicy'),TYPE
						),
						(
							SELECT AGC.id as '@copyId', AGC.name as '@copyName'
							FROM archGroupCopy AGC
							WHERE AGC.id > 0 and AGC.id = SR.archGroupCopyId
							FOR XML PATH('storagePolicyCopy'),TYPE
						),
						(
							SELECT SRP2.srId as '@id', SR2.replicationName as '@name'
							FROM SRInfo SR2 INNER JOIN SRProperties SRP2 ON SR2.srId =SRP2.srId and SRP2.sPropertyValue = SR.srId and SRP2.sPropertyName ='ChainedReplicationId'
							FOR XML PATH('chainedRep'),TYPE
						),
						(
							SELECT SR3.srId as '@id', SR3.replicationName as '@name'
							FROM SRInfo SR3 INNER JOIN SRProperties SRP3 ON SR3.srId =SRP3.srId and SRP3.sPropertyValue = SR.srId and SRP3.sPropertyName ='ForkedReplicationId'
							FOR XML PATH('forkedRep'),TYPE
						)
					FROM SRInfo SR
					WHERE (@i_validateJob = 1 and SR.srId != @i_srId
							and (select count(srId) from SRProperties SRP where SRP.srId =@i_srId and SRP.sPropertyName  in ('ChainedReplicationId','ForkedReplicationId'))= 0
 							and ( (@i_destFilerId>0 and SR.destFilerId = @i_destFilerId and @i_srcFilerId = 0  )
									or (@i_srcFilerId>0 and SR.srcFilerId = @i_srcFilerId  and SR.srcMediaAgentId = @i_srcMediaAgentId )
									or (@i_srcFilerId>0 and SR.destFilerId = @i_srcFilerId  and SR.destMediaAgentId = @i_srcMediaAgentId )
								 )
						 )
						 or (@i_validateJob != 1)
					FOR XML PATH('storageRepList'),TYPE
				)
			FOR XML PATH ('App_GetStorageReplicationEntityListResp'), TYPE
		)
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xmlText  =
		(	SELECT
				(   SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
					FOR XML PATH('error'),TYPE
				)
			FOR XML PATH ('App_GetStorageReplicationEntityListResp'), TYPE
		)
END
GO


IF EXISTS (select * from GxQscripts where name = 'SRGetStorageReplicationEntityList')
	delete from GxQscripts where name = 'SRGetStorageReplicationEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SRGetStorageReplicationEntityList')
	delete from GXDBVersions where aliasname = 'SRGetStorageReplicationEntityList'
GO

insert into GXDBVersions values(2, 'SRGetStorageReplicationEntityList',  '00010008001200040000', 'SRGetStorageReplicationEntityList', '00010008001200040000')
GO

