

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SRGetStorageReplicationEntityDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SRGetStorageReplicationEntityDetails.sp,v $ $Id: SRGetStorageReplicationEntityDetails.sp,v 1.8.12.10 2018/03/27 08:46:36 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SRGetStorageReplicationEntityDetails <<<'

IF EXISTS (select * from sysobjects where name='SRGetStorageReplicationEntityDetails')
	drop procedure SRGetStorageReplicationEntityDetails
IF EXISTS (select * from GxQscripts where name='SRGetStorageReplicationEntityDetails')
	delete from GxQscripts where name = 'SRGetStorageReplicationEntityDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SRGetStorageReplicationEntityDetails')
	delete from GXDBVersions where aliasname = 'SRGetStorageReplicationEntityDetails'
GO
print '... Creating Procedure: SRGetStorageReplicationEntityDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SRGetStorageReplicationEntityDetails
  @xmlTextInput XML,
  @o_xmlText XML	OUTPUT
AS
	DECLARE @errorCode		INT=0
	DECLARE @errorString	NVARCHAR(MAX)=N''
	DECLARE @i_srRepId		INT=0
	DECLARE @i_userId		INT=0
	SET @i_srRepId = ISNULL(( SELECT ref.value('@srRepId', 'int')
							FROM @xmlTextInput.nodes('App_GetStorageReplicationEntityDetailsReq') R ( ref ) ),
						0)
	SET @i_userId = ISNULL( ( SELECT ref.value('@userId', 'int')
									FROM @xmlTextInput.nodes('App_GetStorageReplicationEntityDetailsReq/user') R ( ref ) ),
								0)
	IF OBJECT_ID('tempdb.dbo.#clientLst') IS NOT NULL
	DROP TABLE #clientLst
	CREATE TABLE #clientLst
	(
		clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
	)
	EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY */ , 0 /*View*/, 0, '#clientLst'
	SET @o_xmlText  =
				(	SELECT
						( SELECT top 1 WorkflowId FROM WF_Definition WITH (NOLOCK) WHERE Name='StorageReplicationFlow' order by WorkflowId desc) as '@workflowId',
						(
							SELECT distinct host.ClientId as '@mediaAgentId', clients.name as '@mediaAgentName'
							FROM APP_Client as clients
							JOIN MMHost (NOLOCK) AS host ON clients.id = host.ClientId and host.Attribute != 0
							JOIN SimOperatingSystem (NOLOCK) AS sim ON sim.id = clients.simOperatingSystemId AND sim.Type = 'Windows' or sim.Type = 'Unix'
							JOIN LicUsage (NOLOCK) as lic ON lic.CId = host.ClientId AND lic.LicType in (11,127) AND lic.OpType !='UnInstall' /*11: MediaAgent, 127:Cluster Group*/
							JOIN #clientLst as cl ON cl.clientId = host.ClientId
							order by clients.name
							FOR XML PATH('maList'),TYPE
						),
						(
							SELECT distinct clients.Id as '@clientId', clients.name as '@clientName'
							FROM APP_Client as clients
							JOIN SimOperatingSystem (NOLOCK) AS sim ON sim.id = clients.simOperatingSystemId AND sim.Type = 'Windows' or sim.Type = 'Unix'
							JOIN LicUsage (NOLOCK) as lic ON lic.CId = clients.Id AND lic.LicType in (1,127) AND lic.OpType !='UnInstall' /*1: Server File System, 127:Cluster Group*/
							JOIN #clientLst as cl ON cl.clientId = clients.Id
							WHERE
							dbo.IsPseudoClient(clients.Id) = 0
							order by clients.name
							FOR XML PATH('clientList'),TYPE
						),
						(
							SELECT id as '@clientId', name as '@clientName'
							FROM APP_Client
							WHERE id = (select top 1 clientId from WF_Deploy where WorkflowId =(SELECT top 1 WorkflowId FROM WF_Definition WITH (NOLOCK) WHERE Name='StorageReplicationFlow' order by WorkflowId desc ))
							FOR XML PATH('workflowDeployedClient'),TYPE
						),
						(
							SELECT
								SR.srId as '@srId', SR.replicationName as '@replicationName', SR.notifyEmailAddress as '@notifyEmailAddress',
								SR.replicationScheduledAt as '@replicationScheduledAt',
								ISNULL(( SELECT top 1 taskId FROM TM_SubTask  where subTaskName = SR.replicationName order by subTaskId desc),0) as '@scheduledTaskId',
								dbo.GetUnixTime(SR.createdTime) as '@createdTime', ISNULL(dbo.GetUnixTime(SR.modifiedTime),0) as '@modifiedTime',
								SR.description as '@description',
								SR.forceSync as '@forceSync',
								( select MAX(wfJobId) from SRProperties where srId = SR.srId) as '@wfJobId',
								( select copy from archGroupCopy AGC where AGC.id = SR.archGroupCopyId) as '@copyPrecedenceNumber',
								(
									SELECT
										filer.filerName as  '@filerName',
										filer.filerAccount as 'arrayCredentials/@userName', filer.filerPasswd as  'arrayCredentials/@password'
									FROM SRFiler filer
									WHERE filer.filerId = SR.srcFilerId
									FOR XML PATH('srcFiler'),TYPE
								),
								(
									SELECT
										filer.filerName as  '@filerName',
										filer.filerAccount as 'arrayCredentials/@userName', filer.filerPasswd as  'arrayCredentials/@password'
									FROM SRFiler filer
									WHERE filer.filerId = SR.destFilerId
									FOR XML PATH('destFiler'),TYPE
								),
								(
									SELECT host.ClientId as '@mediaAgentId', clients.name as '@mediaAgentName'
									FROM APP_Client as clients, MMHost as host
									WHERE clients.id = host.ClientId and host.ClientId = SR.srcMediaAgentId
									FOR XML PATH('srcMediaAgent'),TYPE
								),
								(
									SELECT host.ClientId as '@mediaAgentId', clients.name as '@mediaAgentName'
									FROM APP_Client as clients, MMHost as host
									WHERE clients.id = host.ClientId and host.ClientId = SR.destMediaAgentId
									FOR XML PATH('destMediaAgent'),TYPE
								),
								(
									SELECT clients.Id as '@clientId', clients.name as '@clientName'
									FROM APP_Client as clients
									WHERE clients.id = SR.srcClientId
									FOR XML PATH('srcClient'),TYPE
								),
								(
									SELECT clients.Id as '@clientId', clients.name as '@clientName'
									FROM APP_Client as clients
									WHERE clients.id =  SR.destClientId
									FOR XML PATH('destClient'),TYPE
								),
								(
									SELECT AG.id as '@storagePolicyId', AG.name as '@storagePolicyName'
									FROM archGroup AG
									WHERE AG.id = SR.archGroupId
									FOR XML PATH('storagePolicy'),TYPE
								),
								(
									SELECT AGC.id as '@copyId', AGC.name as '@copyName'
									FROM archGroupCopy AGC
									WHERE AGC.id = SR.archGroupCopyId
									FOR XML PATH('storagePolicyCopy'),TYPE
								),
								(
									SELECT users.Id as '@userId', users.name as '@userName'
									FROM UMUsers as users
									WHERE users.id = SR.createdBy
									FOR XML PATH('createdBy'),TYPE
								),
								(
									SELECT users.Id as '@userId', users.name as '@userName'
									FROM UMUsers as users
									WHERE users.id = SR.modifiedBy
									FOR XML PATH('modifiedBy'),TYPE
								),
								(
									SELECT SRP2.srId as '@id', SR2.replicationName as '@name'
									FROM SRInfo SR2 INNER JOIN SRProperties SRP2 ON SR2.srId =SRP2.srId and SRP2.sPropertyValue = SR.srId and SRP2.sPropertyName ='ChainedReplicationId'
									FOR XML PATH('chainedRep'),TYPE
								),
								(
									SELECT SR3.srId as '@id', SR3.replicationName as '@name'
									FROM SRInfo SR3 INNER JOIN SRProperties SRP3 ON SR3.srId =SRP3.srId and SRP3.sPropertyValue = SR.srId and SRP3.sPropertyName ='ForkedReplicationId'
									FOR XML PATH('forkedRep'),TYPE
								)
							FROM SRInfo SR
							WHERE SR.srId=@i_srRepId
							FOR XML PATH('storageRep'),TYPE
						)
					FOR XML PATH ('App_GetStorageReplicationEntityDetailsResp'), TYPE
				)
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xmlText  =
		(	SELECT
				(   SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
					FOR XML PATH('error'),TYPE
				)
			FOR XML PATH ('App_GetStorageReplicationEntityDetailsResp'), TYPE
		)
END
GO


IF EXISTS (select * from GxQscripts where name = 'SRGetStorageReplicationEntityDetails')
	delete from GxQscripts where name = 'SRGetStorageReplicationEntityDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SRGetStorageReplicationEntityDetails')
	delete from GXDBVersions where aliasname = 'SRGetStorageReplicationEntityDetails'
GO

insert into GXDBVersions values(2, 'SRGetStorageReplicationEntityDetails',  '00010008001200100000', 'SRGetStorageReplicationEntityDetails', '00010008001200100000')
GO

