

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLUnicodeSupport.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SQLUnicodeSupport.sp,v $ $Id: SQLUnicodeSupport.sp,v 1.2.290.1 2018/03/27 09:04:33 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: SQLUnicodeSupport
--  |
--  | Description:
--  |  Upgrades the sql client from 5.9 to 6.1
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Kiran Nittur   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SqlUnicodeSupport <<<'

IF EXISTS (select * from sysobjects where name='SqlUnicodeSupport')
	drop procedure SqlUnicodeSupport
IF EXISTS (select * from GxQscripts where name='SqlUnicodeSupport')
	delete from GxQscripts where name = 'SqlUnicodeSupport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SqlUnicodeSupport')
	delete from GXDBVersions where aliasname = 'SqlUnicodeSupport'
GO
print '... Creating Procedure: SqlUnicodeSupport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SqlUnicodeSupport
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @newTable int
set @newTable = 0
IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[sqlnames2]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN
	DECLARE @tblRetCode int
	set @newTable = 1
	create table sqlNames2
	(
	id					INTEGER NOT null IDENTITY (1,1),		-- PRIMARY KEY FOR THIS TABLE
	sqlId				integer NOT null,
	name				nvarchar(1024) NOT null,
	type				integer NOT null,
	)
	set @tblRetCode = @@error
	if (@tblRetCode <> 0)
	BEGIN
		set @tblRetCode = @@error;
		print 'RETVAL: 10 Table [sqlNames2]'
	END
	-----------------------------------------------------
	insert into GXDBVersions values(1, 'sqlNames2',  '1.1', 'sqlNames2', '')
	set @tblRetCode = @@error
	if (@tblRetCode <> 0)
	BEGIN
		set @tblRetCode = @@error;
		print 'RETVAL: 10 Table [GXDBVersions]'
	END
	-----------------------------------------------------
	ALTER TABLE sqlNames2 ADD CONSTRAINT sqlNames2_id_PK 	primary key (id)
	set @tblRetCode = @@error
	if (@tblRetCode <> 0)
	BEGIN
		set @tblRetCode = @@error;
		print 'RETVAL: 02 Table [sqlNames2]'
	END
END
BEGIN
	IF (@newTable = 1)
	BEGIN
		insert into sqlNames2
				select SN.sqlid, SN.name, SN.type
				from sqlnames SN
		IF @@ERROR <> 0	GOTO ERROR_EXIT
		update SN
		set SN.sqlid = SN2.id
		from sqlNames SN, SqlNames2 SN2
		where
		SN.name = SN2.name and
		SN.type = SN2.type
	END
	ELSE
	BEGIN
		insert into sqlNames2
					select SN.sqlid, SN.name, SN.type
					from sqlnames SN
					where
					SN.SQLID = 0
					AND NOT EXISTS (SELECT * FROM sqlnames2 SN2 where SN.type = SN2.type AND  SN.name = SN2.name)
		IF @@ERROR <> 0	GOTO ERROR_EXIT
		update SN
		set SN.sqlid = SN2.id
		from sqlNames SN, SqlNames2 SN2
		where
		SN.name = SN2.name and
		SN.type = SN2.type and
		SN.sqlid = 0
	END
	IF @@ERROR <> 0	GOTO ERROR_EXIT
	ERROR_EXIT:
END
SET @retVal = @@ERROR
SELECT @retVal
RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'SQLUnicodeSupport')
	delete from GxQscripts where name = 'SQLUnicodeSupport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLUnicodeSupport')
	delete from GXDBVersions where aliasname = 'SQLUnicodeSupport'
GO

insert into GXDBVersions values(2, 'SQLUnicodeSupport',  '00010002029000010000', 'SQLUnicodeSupport', '00010002029000010000')
GO

